/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.tags;

import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.HTMLTag;
import java.io.IOException;
import java.util.List;

public class WPATag
extends HTMLTag {
    public static final String HREF = "href";
    public static final String ANCHOR = "anchor";
    public static final String WIKILINK = "wikilink";
    public static final String CLASS = "class";
    public static final String TITLE = "title";

    public WPATag() {
        super("a");
    }

    @Override
    public boolean isReduceTokenStack() {
        return false;
    }

    @Override
    public void renderHTML(ITextConverter converter, Appendable buf, IWikiModel model) throws IOException {
        if (converter.renderLinks()) {
            super.renderHTML(converter, buf, model);
        } else {
            List<Object> children = this.getChildren();
            if (children.size() != 0) {
                converter.nodesToText(children, buf, model);
            }
        }
    }

    public String getLink() {
        Object link = this.getObjectAttributes().get(WIKILINK);
        return link == null ? null : link.toString();
    }

    public String getTitle() {
        return this.getAttributes().get(TITLE);
    }

    public String getAnchor() {
        Object anchor = this.getObjectAttributes().get(ANCHOR);
        return anchor == null ? null : anchor.toString();
    }
}

