/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.htmlcleaner.ContentToken;
import info.bliki.htmlcleaner.EndTagToken;
import info.bliki.htmlcleaner.TagNode;
import info.bliki.htmlcleaner.TagToken;
import info.bliki.wiki.filter.AbstractWikipediaParser;
import info.bliki.wiki.filter.InvalidPreWikiTag;
import info.bliki.wiki.filter.Util;
import info.bliki.wiki.model.DefaultEventListener;
import info.bliki.wiki.model.IEventListener;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.HTMLBlockTag;
import info.bliki.wiki.tags.HTMLTag;
import info.bliki.wiki.tags.WPBoldItalicTag;
import info.bliki.wiki.tags.WPTag;
import info.bliki.wiki.tags.util.Attribute;
import info.bliki.wiki.tags.util.IBodyTag;
import info.bliki.wiki.tags.util.INoBodyParsingTag;
import info.bliki.wiki.tags.util.NodeAttribute;
import info.bliki.wiki.tags.util.TagStack;
import info.bliki.wiki.tags.util.WikiTagNode;
import java.util.List;

public class WikipediaPreTagParser
extends AbstractWikipediaParser {
    private boolean fHtmlCodes = true;
    private IEventListener fEventListener;

    public WikipediaPreTagParser(String stringSource) {
        this(stringSource, null);
    }

    public WikipediaPreTagParser(String stringSource, IEventListener wikiListener) {
        super(stringSource);
        this.fEventListener = wikiListener == null ? DefaultEventListener.CONST : wikiListener;
    }

    public int getNextToken() {
        this.fWhiteStart = true;
        this.fWhiteStartPosition = this.fCurrentPosition;
        try {
            block17: while (true) {
                this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
                switch (this.fCurrentCharacter) {
                    case '\n': {
                        this.reduceTokenStackBoldItalic();
                    }
                }
                switch (this.fCurrentCharacter) {
                    case '[': {
                        if (!this.parseWikiLink()) break;
                        continue block17;
                    }
                    case '\'': {
                        if (!this.getNextChar('\'')) break;
                        if (this.getNextChar('\'')) {
                            if (this.getNextChar('\'')) {
                                if (this.getNextChar('\'')) {
                                    this.createContentToken(5);
                                    return 5;
                                }
                                --this.fCurrentPosition;
                                this.fWhiteStart = true;
                                this.createContentToken(3);
                                return 3;
                            }
                            this.createContentToken(3);
                            return 3;
                        }
                        this.createContentToken(2);
                        return 4;
                    }
                    case '<': {
                        if (!this.fHtmlCodes) break;
                        int htmlStartPosition = this.fCurrentPosition;
                        try {
                            switch (this.fStringSource.charAt(this.fCurrentPosition)) {
                                case '!': {
                                    if (this.parseHTMLCommentTags()) {
                                        continue block17;
                                    }
                                    break;
                                }
                                default: {
                                    TagToken tag;
                                    String tagName;
                                    WikiTagNode tagNode;
                                    if (this.fSource[this.fCurrentPosition] != '/') {
                                        tagNode = this.parseTag(this.fCurrentPosition);
                                        if (tagNode != null) {
                                            tagName = tagNode.getTagName();
                                            tag = this.fWikiModel.getTokenMap().get(tagName);
                                            if (tag != null && !(tag instanceof HTMLBlockTag)) {
                                                if ((tag = (TagToken)tag.clone()) instanceof TagNode) {
                                                    TagNode node = (TagNode)tag;
                                                    List<NodeAttribute> attributes = tagNode.getAttributesEx();
                                                    for (int i = 1; i < attributes.size(); ++i) {
                                                        Attribute attr = attributes.get(i);
                                                        node.addAttribute(attr.getName(), attr.getValue(), true);
                                                    }
                                                }
                                                if (tag instanceof HTMLTag) {
                                                    // empty if block
                                                }
                                                this.createContentToken(1);
                                                this.fCurrentPosition = this.fScannerPosition;
                                                String allowedParents = tag.getParents();
                                                if (allowedParents != null) {
                                                    this.reduceTokenStack(tag);
                                                }
                                                this.createTag(tag, tagNode, tagNode.getEndPosition());
                                                return -1;
                                            }
                                        }
                                    } else if ((tagNode = this.parseTag(++this.fCurrentPosition)) != null) {
                                        tagName = tagNode.getTagName();
                                        tag = this.fWikiModel.getTokenMap().get(tagName);
                                        if (tag != null && !(tag instanceof HTMLBlockTag)) {
                                            this.createContentToken(2);
                                            this.fCurrentPosition = this.fScannerPosition;
                                            if (this.fWikiModel.stackSize() > 0) {
                                                TagToken topToken = this.fWikiModel.peekNode();
                                                if (topToken.getName().equals(tag.getName())) {
                                                    this.fWikiModel.popNode();
                                                    return -1;
                                                }
                                                if (tag.isReduceTokenStack()) {
                                                    this.reduceStackUntilToken(tag);
                                                }
                                            }
                                            return -1;
                                        }
                                    }
                                }
                            }
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                        this.fCurrentPosition = htmlStartPosition;
                        break;
                    }
                }
                if (this.fWhiteStart) continue;
                this.fWhiteStart = true;
                this.fWhiteStartPosition = this.fCurrentPosition - 1;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            try {
                this.createContentToken(1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException2) {
                // empty catch block
            }
            return 1;
        }
    }

    private boolean parseWikiLink() {
        int startLinkPosition = this.fCurrentPosition;
        if (this.getNextChar('[')) {
            return this.parseWikiTag();
        }
        this.createContentToken(1);
        this.fWhiteStart = false;
        if (this.readUntilCharOrStopAtEOL(']')) {
            String string = this.fStringSource.substring(startLinkPosition, this.fCurrentPosition - 1);
        }
        this.fCurrentPosition = startLinkPosition;
        return false;
    }

    private boolean parseWikiTag() {
        int startLinkPosition = this.fCurrentPosition;
        this.createContentToken(2);
        int temp = this.fCurrentPosition;
        if (this.findWikiLinkEnd()) {
            int endLinkPosition = this.fCurrentPosition - 2;
            String name = this.fStringSource.substring(startLinkPosition, endLinkPosition);
            temp = this.fCurrentPosition;
            String suffix = "";
            try {
                this.fCurrentCharacter = this.fSource[this.fCurrentPosition];
                if (Character.isLowerCase(this.fCurrentCharacter)) {
                    ++this.fCurrentPosition;
                    StringBuilder suffixBuffer = new StringBuilder(16);
                    suffixBuffer.append(this.fCurrentCharacter);
                    while (true) {
                        this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
                        if (!Character.isLowerCase(this.fCurrentCharacter)) {
                            --this.fCurrentPosition;
                            break;
                        }
                        suffixBuffer.append(this.fCurrentCharacter);
                    }
                    suffix = suffixBuffer.toString();
                }
            }
            catch (IndexOutOfBoundsException e) {
                this.fCurrentPosition = temp;
            }
            this.fEventListener.onWikiLink(this.fSource, startLinkPosition, endLinkPosition, suffix);
            if (!this.fWikiModel.appendRawWikipediaLink(name, suffix)) {
                this.fCurrentPosition = temp;
                throw new InvalidPreWikiTag("parseWikiTag");
            }
            return true;
        }
        this.fWhiteStart = true;
        this.fWhiteStartPosition = startLinkPosition - 2;
        this.fCurrentPosition = temp + 1;
        return false;
    }

    private void createTag(TagToken tag, WikiTagNode tagNode, int startMacroPosition) {
        String macroBodyString;
        String command = tagNode.getTagName();
        if (tag != null && tag instanceof IBodyTag && !tagNode.isEmptyXmlTag()) {
            String endTag = command + '>';
            int index0 = Util.indexOfIgnoreCase(this.fStringSource, "</", endTag, startMacroPosition);
            if (index0 >= 0) {
                macroBodyString = this.fStringSource.substring(startMacroPosition, index0);
                this.fCurrentPosition = index0 + endTag.length() + 2;
            } else {
                macroBodyString = this.fStringSource.substring(startMacroPosition, this.fSource.length);
                this.fCurrentPosition = this.fSource.length;
            }
        } else {
            macroBodyString = null;
            this.fCurrentPosition = startMacroPosition;
        }
        this.handleTag(tag, tagNode, macroBodyString);
    }

    private void handleTag(TagToken tag, WikiTagNode tagNode, String bodyString) {
        String command = tagNode.getTagName();
        try {
            if (tag instanceof EndTagToken) {
                this.fWikiModel.append(tag);
            } else {
                this.fWikiModel.pushNode(tag);
                if (null != bodyString) {
                    if (tag instanceof INoBodyParsingTag) {
                        ((TagNode)tag).addChild(new ContentToken(bodyString));
                    } else {
                        WikipediaPreTagParser.parseRecursive(bodyString.trim(), this.fWikiModel, false, true);
                    }
                }
                if (tag instanceof IBodyTag) {
                    this.fWikiModel.popNode();
                }
            }
        }
        catch (IllegalArgumentException e) {
            TagNode divTagNode = new TagNode("div");
            divTagNode.addAttribute("class", "error", true);
            divTagNode.addChild(new ContentToken("IllegalArgumentException: " + command + " - " + e.getMessage()));
            this.fWikiModel.append(divTagNode);
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
            TagNode divTagNode = new TagNode("div");
            divTagNode.addAttribute("class", "error", true);
            divTagNode.addChild(new ContentToken(command + ": " + e.getMessage()));
            this.fWikiModel.append(divTagNode);
            e.printStackTrace();
        }
    }

    @Override
    public void runParser() {
        int token;
        while ((token = this.getNextToken()) != 1) {
            switch (token) {
                case 5: {
                    if (this.fWikiModel.stackSize() > 0 && this.fWikiModel.peekNode().equals(BOLDITALIC)) {
                        this.fWikiModel.popNode();
                        break;
                    }
                    if (this.fWikiModel.stackSize() > 1 && this.fWikiModel.peekNode().equals(BOLD) && this.fWikiModel.getNode(this.fWikiModel.stackSize() - 2).equals(ITALIC)) {
                        this.fWikiModel.popNode();
                        this.fWikiModel.popNode();
                        break;
                    }
                    if (this.fWikiModel.stackSize() > 1 && this.fWikiModel.peekNode().equals(ITALIC) && this.fWikiModel.getNode(this.fWikiModel.stackSize() - 2).equals(BOLD)) {
                        this.fWikiModel.popNode();
                        this.fWikiModel.popNode();
                        break;
                    }
                    if (this.fWikiModel.stackSize() > 0 && this.fWikiModel.peekNode().equals(BOLD)) {
                        this.fWikiModel.popNode();
                        this.fWikiModel.pushNode(new WPTag("i"));
                        break;
                    }
                    if (this.fWikiModel.stackSize() > 0 && this.fWikiModel.peekNode().equals(ITALIC)) {
                        this.fWikiModel.popNode();
                        this.fWikiModel.pushNode(new WPTag("b"));
                        break;
                    }
                    this.fWikiModel.pushNode(new WPBoldItalicTag());
                    break;
                }
                case 3: {
                    if (this.fWikiModel.stackSize() > 0 && this.fWikiModel.peekNode().equals(BOLDITALIC)) {
                        this.fWikiModel.popNode();
                        this.fWikiModel.pushNode(new WPTag("i"));
                        break;
                    }
                    if (this.fWikiModel.stackSize() > 0 && this.fWikiModel.peekNode().equals(BOLD)) {
                        this.fWikiModel.popNode();
                        break;
                    }
                    this.fWikiModel.pushNode(new WPTag("b"));
                    break;
                }
                case 4: {
                    if (this.fWikiModel.stackSize() > 0 && this.fWikiModel.peekNode().equals(BOLDITALIC)) {
                        this.fWikiModel.popNode();
                        this.fWikiModel.pushNode(new WPTag("b"));
                        break;
                    }
                    if (this.fWikiModel.stackSize() > 0 && this.fWikiModel.peekNode().equals(ITALIC)) {
                        this.fWikiModel.popNode();
                        break;
                    }
                    this.fWikiModel.pushNode(new WPTag("i"));
                }
            }
        }
        this.reduceTokenStack();
    }

    @Override
    protected void setNoToC(boolean noToC) {
    }

    public static void parseRecursive(String rawWikitext, IWikiModel wikiModel) {
        WikipediaPreTagParser.parseRecursive(rawWikitext, wikiModel, false, true);
    }

    public static TagStack parseRecursive(String rawWikitext, IWikiModel wikiModel, boolean createOnlyLocalStack, boolean noTOC) {
        WikipediaPreTagParser parser = new WikipediaPreTagParser(rawWikitext);
        return parser.parseRecursiveInternal(wikiModel, createOnlyLocalStack, noTOC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagStack parseRecursiveInternal(IWikiModel wikiModel, boolean createOnlyLocalStack, boolean noTOC) {
        TagStack localStack = new TagStack();
        TagStack globalWikiModelStack = wikiModel.swapStack(localStack);
        try {
            int level = wikiModel.incrementRecursionLevel();
            if (level > 256) {
                TagNode error = new TagNode("span");
                error.addAttribute("class", "error", true);
                error.addChild(new ContentToken("Error - recursion limit exceeded parsing wiki tags."));
                localStack.append(error);
                TagStack tagStack = localStack;
                return tagStack;
            }
            this.setModel(wikiModel);
            this.runParser();
            TagStack error = localStack;
            return error;
        }
        catch (InvalidPreWikiTag ipwt) {
            createOnlyLocalStack = true;
            throw ipwt;
        }
        catch (Error | Exception e) {
            e.printStackTrace();
            TagNode error = new TagNode("span");
            error.addAttribute("class", "error", true);
            error.addChild(new ContentToken(e.getClass().getSimpleName()));
            localStack.append(error);
        }
        finally {
            wikiModel.decrementRecursionLevel();
            if (!createOnlyLocalStack) {
                globalWikiModelStack.append(localStack);
            }
            wikiModel.swapStack(globalWikiModelStack);
        }
        return localStack;
    }

    private void reduceTokenStack(TagToken node) {
        String allowedParents = node.getParents();
        if (allowedParents != null) {
            while (this.fWikiModel.stackSize() > 0) {
                TagToken tag = this.fWikiModel.peekNode();
                int index = allowedParents.indexOf("|" + tag.getName() + "|");
                if (index >= 0) break;
                this.fWikiModel.popNode();
                if (!tag.getName().equals(node.getName())) continue;
                break;
            }
        } else {
            while (this.fWikiModel.stackSize() > 0) {
                this.fWikiModel.popNode();
            }
        }
    }
}

