/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.opengl.GLContext;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import jogamp.opengl.GLContextImpl;

public class GLWorkerThread {
    private static volatile boolean started;
    private static volatile Thread thread;
    private static Object lock;
    private static volatile boolean shouldTerminate;
    private static volatile Throwable exception;
    private static volatile Runnable work;
    private static List<Runnable> queue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void start() {
        if (started) return;
        Class<GLWorkerThread> clazz = GLWorkerThread.class;
        synchronized (GLWorkerThread.class) {
            if (started) throw new RuntimeException(GLWorkerThread.getThreadName() + ": Should not start GLWorkerThread twice");
            lock = new Object();
            thread = new Thread((Runnable)new WorkerRunnable(), "JOGL-GLWorkerThread-");
            thread.setDaemon(true);
            started = true;
            Object object = lock;
            synchronized (object) {
                thread.start();
                try {
                    lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void invoke(boolean bl, Runnable runnable) throws InvocationTargetException, InterruptedException {
        if (bl) {
            GLWorkerThread.invokeAndWait(runnable);
        } else {
            GLWorkerThread.invokeLater(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeAndWait(Runnable runnable) throws InvocationTargetException, InterruptedException {
        if (!started) {
            throw new RuntimeException(GLWorkerThread.getThreadName() + ": May not invokeAndWait on worker thread without starting it first");
        }
        Object object = lock;
        if (object == null) {
            return;
        }
        Object object2 = object;
        synchronized (object2) {
            if (thread == null) {
                return;
            }
            work = runnable;
            object.notifyAll();
            object.wait();
            if (exception != null) {
                Throwable throwable = exception;
                exception = null;
                throw new InvocationTargetException(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeLater(Runnable runnable) {
        if (!started) {
            throw new RuntimeException(GLWorkerThread.getThreadName() + ": May not invokeLater on worker thread without starting it first");
        }
        Object object = lock;
        if (object == null) {
            return;
        }
        Object object2 = object;
        synchronized (object2) {
            if (thread == null) {
                return;
            }
            queue.add(runnable);
            object.notifyAll();
        }
    }

    public static boolean isStarted() {
        return started;
    }

    public static boolean isWorkerThread() {
        return Thread.currentThread() == thread;
    }

    protected static String getThreadName() {
        return Thread.currentThread().getName();
    }

    static {
        queue = new ArrayList<Runnable>();
    }

    static class WorkerRunnable
    implements Runnable {
        WorkerRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = lock;
            synchronized (object) {
                lock.notifyAll();
            }
            while (!shouldTerminate) {
                object = lock;
                synchronized (object) {
                    GLContextImpl gLContextImpl;
                    Object object2;
                    while (!shouldTerminate && work == null && queue.isEmpty()) {
                        try {
                            lock.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (GLContext.getCurrent() == null) continue;
                    }
                    if (shouldTerminate) {
                        lock.notifyAll();
                        GLWorkerThread.thread = null;
                        lock = null;
                        return;
                    }
                    if (work != null) {
                        try {
                            work.run();
                        }
                        catch (Throwable throwable) {
                            exception = throwable;
                        }
                        finally {
                            work = null;
                            lock.notifyAll();
                        }
                    }
                    while (!queue.isEmpty()) {
                        try {
                            object2 = (Runnable)queue.remove(0);
                            object2.run();
                        }
                        catch (Throwable throwable) {
                            System.err.println(GLWorkerThread.getThreadName() + ": Exception occurred on JOGL OpenGL worker thread:");
                            throwable.printStackTrace();
                        }
                    }
                    object2 = GLContext.getCurrent();
                    if (object2 != null && object2 instanceof GLContextImpl && (gLContextImpl = (GLContextImpl)object2).hasWaiters()) {
                        gLContextImpl.release();
                    }
                }
            }
        }
    }
}

