/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xhtml.wikimodel;

import java.util.Collections;
import org.xwiki.rendering.internal.parser.wikimodel.WikiModelStreamParser;
import org.xwiki.rendering.internal.parser.wikimodel.XWikiGeneratorListener;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiWikiModelHandler;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.renderer.PrintRenderer;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.wikimodel.IWemListener;
import org.xwiki.rendering.wikimodel.WikiParameter;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.WikiReference;
import org.xwiki.rendering.wikimodel.impl.WikiScannerContext;
import org.xwiki.rendering.wikimodel.xhtml.handler.ReferenceTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.impl.TagContext;
import org.xwiki.rendering.wikimodel.xhtml.impl.TagStack;

public class XWikiReferenceTagHandler
extends ReferenceTagHandler
implements XWikiWikiModelHandler {
    private WikiModelStreamParser parser;
    private PrintRendererFactory xwikiSyntaxPrintRendererFactory;

    public XWikiReferenceTagHandler(WikiModelStreamParser parser, PrintRendererFactory xwikiSyntaxPrintRendererFactory) {
        this.parser = parser;
        this.xwikiSyntaxPrintRendererFactory = xwikiSyntaxPrintRendererFactory;
    }

    public void initialize(TagStack stack) {
        stack.setStackParameter("isInLink", (Object)false);
        stack.setStackParameter("isFreeStandingLink", (Object)false);
        stack.setStackParameter("linkParameters", (Object)WikiParameters.EMPTY);
    }

    protected void begin(TagContext context) {
        boolean isInLink = (Boolean)context.getTagStack().getStackParameter("isInLink");
        if (isInLink) {
            XWikiGeneratorListener listener = (XWikiGeneratorListener)context.getTagStack().getStackParameter("linkListener");
            context.getTagStack().pushScannerContext(new WikiScannerContext((IWemListener)listener));
            context.getScannerContext().beginDocument();
            if (this.isFreeStandingReference(context)) {
                context.getTagStack().setStackParameter("isFreeStandingLink", (Object)true);
            } else {
                context.getTagStack().setStackParameter("linkParameters", (Object)this.removeMeaningfulParameters(context.getParams()));
            }
            this.setAccumulateContent(false);
        } else if (!this.isFreeStandingReference(context)) {
            WikiParameter ref = context.getParams().getParameter("href");
            if (ref != null) {
                DefaultWikiPrinter printer = new DefaultWikiPrinter();
                PrintRenderer linkLabelRenderer = this.xwikiSyntaxPrintRendererFactory.createRenderer((WikiPrinter)printer);
                XWikiGeneratorListener xwikiListener = this.parser.createXWikiGeneratorListener((Listener)linkLabelRenderer, null);
                context.getTagStack().pushScannerContext(new WikiScannerContext((IWemListener)xwikiListener));
                context.getScannerContext().beginDocument();
            } else {
                WikiParameter idName = context.getParams().getParameter("id");
                if (idName == null) {
                    idName = context.getParams().getParameter("name");
                }
                if (idName != null) {
                    WikiParameter parameter = new WikiParameter("name", idName.getValue());
                    WikiParameters parameters = new WikiParameters(Collections.singletonList(parameter));
                    context.getScannerContext().onExtensionBlock("xwiki_id", parameters);
                }
            }
        } else {
            super.begin(context);
        }
    }

    protected void end(TagContext context) {
        boolean isInLink = (Boolean)context.getTagStack().getStackParameter("isInLink");
        if (isInLink) {
            context.getScannerContext().endDocument();
            context.getTagStack().popScannerContext();
        } else if (!this.isFreeStandingReference(context)) {
            WikiParameters parameters = context.getParams();
            WikiParameter ref = parameters.getParameter("href");
            if (ref != null) {
                context.getScannerContext().endDocument();
                WikiScannerContext scannerContext = context.getTagStack().popScannerContext();
                XWikiGeneratorListener xwikiListener = (XWikiGeneratorListener)scannerContext.getfListener();
                PrintRenderer linkLabelRenderer = (PrintRenderer)xwikiListener.getListener();
                String label = linkLabelRenderer.getPrinter().toString();
                WikiReference reference = new WikiReference(ref.getValue(), label, this.removeMeaningfulParameters(parameters));
                context.getScannerContext().onReference(reference);
            }
        } else {
            super.end(context);
        }
    }
}

