/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import net.osmand.IProgress;
import net.osmand.data.LatLon;
import net.osmand.impl.ConsoleProgressImplementation;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.OSMSettings;
import net.osmand.osm.edit.OsmMapUtils;
import net.osmand.osm.edit.Way;
import net.osmand.osm.io.OsmBaseStorage;
import net.osmand.osm.io.OsmStorageWriter;
import net.osmand.util.MapUtils;
import org.xmlpull.v1.XmlPullParserException;

public class FixLinkedCoastline {
    private static Map<Long, List<Way>> startWays = new LinkedHashMap<Long, List<Way>>();
    private static Map<Long, List<Way>> endWays = new LinkedHashMap<Long, List<Way>>();
    private static Map<Way, LatLon> duplicatedSimpleIslands = new LinkedHashMap<Way, LatLon>();
    private static int ERRORS = 0;

    public static void main(String[] args) throws IOException, XMLStreamException, XmlPullParserException {
        File write;
        String fileToWrite;
        String fileToRead;
        String string = fileToRead = args != null && args.length > 0 ? args[0] : null;
        if (fileToRead == null) {
            fileToRead = "/home/victor/projects/osmand/data/basemap/ready/10m_coastline.osm";
        }
        File read = new File(fileToRead);
        String string2 = fileToWrite = args != null && args.length > 1 ? args[1] : null;
        if (fileToWrite != null) {
            write = new File(fileToWrite);
        } else {
            Object fileName = read.getName();
            int i = ((String)fileName).lastIndexOf(46);
            fileName = ((String)fileName).substring(0, i) + "_out" + ((String)fileName).substring(i);
            write = new File(read.getParentFile(), (String)fileName);
        }
        write.createNewFile();
        FixLinkedCoastline.process(read, write);
    }

    private static void process(File read, File write) throws IOException, XMLStreamException, XmlPullParserException {
        OsmBaseStorage storage = new OsmBaseStorage();
        storage.parseOSM((InputStream)new FileInputStream(read), (IProgress)new ConsoleProgressImplementation());
        HashMap entities = new HashMap(storage.getRegisteredEntities());
        ArrayList<Entity.EntityId> toWrite = new ArrayList<Entity.EntityId>();
        for (Object e : entities.keySet()) {
            if (e.getType() != Entity.EntityType.WAY) continue;
            Entity entity = (Entity)storage.getRegisteredEntities().remove(e);
            List<Way> result = FixLinkedCoastline.processWay((Way)entity);
            FixLinkedCoastline.alignAndAddtoStorage(storage, toWrite, result);
        }
        System.out.println("ERROR Ways : ");
        int errors = 0;
        for (List list : endWays.values()) {
            LatLon last;
            Way way = (Way)list.get(0);
            Way lway = (Way)list.get(list.size() - 1);
            LatLon first = ((Node)way.getNodes().get(0)).getLatLon();
            double dist = MapUtils.getDistance((LatLon)first, (LatLon)(last = ((Node)lway.getNodes().get(lway.getNodes().size() - 1)).getLatLon()));
            if (dist < 500000.0) {
                FixLinkedCoastline.alignAndAddtoStorage(storage, toWrite, list);
                continue;
            }
            ++errors;
            String val = "First " + String.valueOf(first) + "Last " + String.valueOf(last) + " id " + way.getId() + " dist " + MapUtils.getDistance((LatLon)first, (LatLon)last) + " m";
            System.out.println("Ways in chain - " + list.size() + " - " + val);
        }
        System.out.println("Fixed errors : " + ERRORS + ", errors not fixed : " + errors);
        OsmStorageWriter writer = new OsmStorageWriter();
        writer.saveStorage(new FileOutputStream(write), storage, toWrite, true);
    }

    private static void alignAndAddtoStorage(OsmBaseStorage storage, List<Entity.EntityId> toWrite, List<Way> result) {
        for (int i = 0; i < result.size(); ++i) {
            Node nextStart = i < result.size() - 1 ? (Node)result.get(i + 1).getNodes().get(0) : (Node)result.get(0).getNodes().get(0);
            Way w = result.get(i);
            int sz = w.getNodes().size();
            w.removeNodeByIndex(sz - 1);
            w.addNode(nextStart);
            if ("land_coastline".equals(w.getTag(OSMSettings.OSMTagKey.NATURAL))) {
                w.putTag(OSMSettings.OSMTagKey.NATURAL.getValue(), "coastline");
            }
            Entity.EntityId eId = Entity.EntityId.valueOf((Entity)w);
            storage.getRegisteredEntities().put(eId, w);
            toWrite.add(eId);
        }
    }

    private static long calcCoordinate(Node node) {
        LatLon l = node.getLatLon();
        double lon = l.getLongitude();
        if (180.0 - Math.abs(l.getLongitude()) < 1.0E-4) {
            lon = l.getLongitude() < 0.0 ? -179.9999 : 180.0;
        }
        return ((long)MapUtils.getTileNumberY((float)21.0f, (double)l.getLatitude()) << 32) + (long)MapUtils.getTileNumberX((float)21.0f, (double)lon);
    }

    private static Way revertWay(Way way) {
        ArrayList revNodes = new ArrayList(way.getNodes());
        Collections.reverse(revNodes);
        Way ws = new Way(way.getId());
        for (String key : way.getTagKeySet()) {
            ws.putTag(key, way.getTag(key));
        }
        for (Node n : revNodes) {
            ws.addNode(n);
        }
        return ws;
    }

    private static boolean pointContains(long start, long end) {
        return startWays.containsKey(start) || endWays.containsKey(end) || startWays.containsKey(end) || endWays.containsKey(start);
    }

    private static long lastPoint(Way w) {
        return FixLinkedCoastline.calcCoordinate((Node)w.getNodes().get(w.getNodes().size() - 1));
    }

    private static long lastPoint(List<Way> w) {
        return FixLinkedCoastline.lastPoint(w.get(w.size() - 1));
    }

    private static long firstPoint(List<Way> w) {
        return FixLinkedCoastline.firstPoint(w.get(0));
    }

    private static long firstPoint(Way way) {
        return FixLinkedCoastline.calcCoordinate((Node)way.getNodes().get(0));
    }

    private static List<Way> processWay(Way way) {
        long start = FixLinkedCoastline.firstPoint(way);
        long end = FixLinkedCoastline.lastPoint(way);
        LatLon first = ((Node)way.getNodes().get(0)).getLatLon();
        LatLon last = ((Node)way.getNodes().get(way.getNodes().size() - 1)).getLatLon();
        String val = "F " + String.valueOf(first) + "L " + String.valueOf(last) + " id " + way.getId();
        List<Way> cycle = null;
        if (start == end || MapUtils.getDistance((LatLon)first, (LatLon)last) < 20.0) {
            LatLon c = way.getLatLon();
            cycle = Collections.singletonList(way);
            for (Way w : duplicatedSimpleIslands.keySet()) {
                LatLon center = duplicatedSimpleIslands.get(w);
                if (!(MapUtils.getDistance((LatLon)center, (LatLon)c) < 4000.0)) continue;
                return Collections.emptyList();
            }
            duplicatedSimpleIslands.put(way, c);
        } else {
            List<Way> list = new ArrayList<Way>();
            list.add(way);
            while (FixLinkedCoastline.pointContains(start, end)) {
                if (startWays.containsKey(start) || endWays.containsKey(end)) {
                    ++ERRORS;
                    Collections.reverse(list);
                    for (int i = 0; i < list.size(); ++i) {
                        list.set(i, FixLinkedCoastline.revertWay((Way)list.get(i)));
                    }
                    long t = start;
                    start = end;
                    end = t;
                }
                if (endWays.containsKey(start)) {
                    List<Way> tlist = endWays.remove(start);
                    startWays.remove(FixLinkedCoastline.firstPoint(tlist));
                    tlist.addAll(list);
                    list = tlist;
                } else if (startWays.containsKey(end)) {
                    List<Way> tlist = startWays.remove(end);
                    endWays.remove(FixLinkedCoastline.lastPoint(tlist));
                    list.addAll(tlist);
                }
                if ((start = FixLinkedCoastline.firstPoint(list)) != (end = FixLinkedCoastline.lastPoint(list))) continue;
                cycle = list;
                break;
            }
            if (cycle == null) {
                startWays.put(start, list);
                endWays.put(end, list);
            }
        }
        if (cycle != null) {
            boolean clockwiseWay = OsmMapUtils.isClockwiseWay(cycle);
            if (clockwiseWay) {
                ArrayList<Way> ways = new ArrayList<Way>();
                ++ERRORS;
                for (int i = cycle.size() - 1; i >= 0; --i) {
                    ways.add(FixLinkedCoastline.revertWay(cycle.get(i)));
                }
                return ways;
            }
            return cycle;
        }
        return Collections.emptyList();
    }
}

