/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.File;
import net.osmand.PlatformUtil;
import net.osmand.data.LatLon;
import net.osmand.obf.preparation.DBDialect;
import net.osmand.osm.edit.Entity;
import net.osmand.router.HHRouteDataStructure;
import net.osmand.router.HHRoutePlanner;
import net.osmand.router.HHRoutingDB;
import net.osmand.router.HHRoutingUtilities;
import net.osmand.router.RoutingContext;
import org.apache.commons.logging.Log;

public class TestHHRouting {
    static final Log LOG = PlatformUtil.getLog(TestHHRouting.class);
    static LatLon PROCESS_START = null;
    static LatLon PROCESS_END = null;

    private static File testData() {
        String name = "Montenegro_europe_2.road.obf";
        name = "Netherlands_europe";
        PROCESS_START = new LatLon(52.348, 4.86206);
        PROCESS_END = new LatLon(51.35076, 5.45141);
        return new File(System.getProperty("maps.dir"), name);
    }

    public static void main(String[] args) throws Exception {
        File obfFile = args.length == 0 ? TestHHRouting.testData() : new File(args[0]);
        HHRouteDataStructure.HHRoutingConfig c = null;
        String ROUTING_PROFILE = "car";
        for (String a : args) {
            String[] latLons;
            if (a.startsWith("--start=")) {
                latLons = a.substring("--start=".length()).split(",");
                PROCESS_START = new LatLon(Double.parseDouble(latLons[0]), Double.parseDouble(latLons[1]));
                continue;
            }
            if (a.startsWith("--end=")) {
                latLons = a.substring("--end=".length()).split(",");
                PROCESS_END = new LatLon(Double.parseDouble(latLons[0]), Double.parseDouble(latLons[1]));
                continue;
            }
            if (a.startsWith("--heuristic=")) {
                if (c == null) {
                    c = new HHRouteDataStructure.HHRoutingConfig();
                }
                c.HEURISTIC_COEFFICIENT = (float)Double.parseDouble(a.substring("--heuristic=".length()));
                continue;
            }
            if (a.startsWith("--direction=")) {
                if (c == null) {
                    c = new HHRouteDataStructure.HHRoutingConfig();
                }
                c.DIJKSTRA_DIRECTION = (float)Double.parseDouble(a.substring("--direction=".length()));
                continue;
            }
            if (a.startsWith("--profile")) {
                ROUTING_PROFILE = a.substring("--profile=".length());
                continue;
            }
            if (a.startsWith("--ch")) {
                c = HHRouteDataStructure.HHRoutingConfig.ch();
                continue;
            }
            if (a.startsWith("--preload")) {
                c.preloadSegments();
                continue;
            }
            if (!a.startsWith("--midpoint=")) continue;
            String[] s = a.substring("--midpoint=".length()).split(":");
            if (c == null) {
                c = new HHRouteDataStructure.HHRoutingConfig();
            }
            c.MIDPOINT_MAX_DEPTH = Integer.parseInt(s[0]);
            c.MIDPOINT_ERROR = Integer.parseInt(s[1]);
        }
        if (PROCESS_START == null || PROCESS_END == null) {
            System.err.println("Start / end point is not specified");
            return;
        }
        File folder = obfFile.isDirectory() ? obfFile : obfFile.getParentFile();
        String name = obfFile.getCanonicalFile().getName() + "_" + ROUTING_PROFILE;
        File dbFile = new File(folder, name + ".hhdb");
        HHRoutePlanner planner = HHRoutePlanner.createDB((RoutingContext)HHRoutePlanner.prepareContext((String)ROUTING_PROFILE), (HHRoutingDB)new HHRoutingDB(dbFile, DBDialect.SQLITE.getDatabaseConnection(dbFile.getAbsolutePath(), LOG)));
        HHRouteDataStructure.HHNetworkRouteRes route = planner.runRouting(PROCESS_START, PROCESS_END, c);
        TLongObjectHashMap entities = new TLongObjectHashMap();
        for (HHRouteDataStructure.HHNetworkSegmentRes r : route.segments) {
            if (r.list != null || r.segment == null) continue;
            HHRoutingUtilities.addWay((TLongObjectHashMap<Entity>)entities, r.segment, "highway", "primary");
        }
        HHRoutingUtilities.saveOsmFile(entities.valueCollection(), new File(folder, name + "-rt.osm"));
        planner.close();
    }
}

