/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.util;

public final class GeoPointParserSimpleS2 {
    private static final int MAX_LEVEL = 30;
    private static final int POS_BITS = 61;
    private static final int NUM_FACES = 6;
    private static final int MAX_SIZE = 0x40000000;
    private static final int LOOKUP_BITS = 4;
    private static final int SWAP_MASK = 1;
    private static final int INVERT_MASK = 2;
    private static final int[] LOOKUP_IJ = new int[1024];
    private static final int[] POS_TO_ORIENTATION = new int[]{1, 0, 0, 3};
    private static final int[][] POS_TO_IJ = new int[][]{{0, 1, 3, 2}, {0, 2, 3, 1}, {3, 2, 0, 1}, {3, 1, 0, 2}};
    private static final double RAD_TO_DEG = 57.29577951308232;

    private static double stToUV(double s) {
        if (s >= 0.0) {
            return 0.3333333333333333 * ((1.0 + s) * (1.0 + s) - 1.0);
        }
        return 0.3333333333333333 * (1.0 - (1.0 - s) * (1.0 - s));
    }

    private static Vec3 faceUvToXyz(int face, double u, double v) {
        return switch (face) {
            case 0 -> new Vec3(1.0, u, v);
            case 1 -> new Vec3(-u, 1.0, v);
            case 2 -> new Vec3(-u, -v, 1.0);
            case 3 -> new Vec3(-1.0, -v, -u);
            case 4 -> new Vec3(v, -1.0, -u);
            default -> new Vec3(v, u, -1.0);
        };
    }

    private static Vec3 faceSiTiToXyz(int face, int si, int ti) {
        double kScale = 9.313225746154785E-10;
        double u = GeoPointParserSimpleS2.stToUV(9.313225746154785E-10 * (double)si);
        double v = GeoPointParserSimpleS2.stToUV(9.313225746154785E-10 * (double)ti);
        return GeoPointParserSimpleS2.faceUvToXyz(face, u, v);
    }

    private static int posToOrientation(int position) {
        return POS_TO_ORIENTATION[position & 3];
    }

    private static int posToIJ(int orientation, int position) {
        return POS_TO_IJ[orientation & 3][position & 3];
    }

    private static void initLookupCell(int level, int i, int j, int origOrientation, int pos, int orientation) {
        if (level == 4) {
            int ij = (i << 4) + j;
            GeoPointParserSimpleS2.LOOKUP_IJ[(pos << 2) + origOrientation] = (ij << 2) + orientation;
        } else {
            ++level;
            i <<= 1;
            j <<= 1;
            pos <<= 2;
            for (int subPos = 0; subPos < 4; ++subPos) {
                int ij = GeoPointParserSimpleS2.posToIJ(orientation, subPos);
                int orientationMask = GeoPointParserSimpleS2.posToOrientation(subPos);
                GeoPointParserSimpleS2.initLookupCell(level, i + (ij >>> 1), j + (ij & 1), origOrientation, pos + subPos, orientation ^ orientationMask);
            }
        }
    }

    private GeoPointParserSimpleS2() {
    }

    static {
        GeoPointParserSimpleS2.initLookupCell(0, 0, 0, 0, 0, 0);
        GeoPointParserSimpleS2.initLookupCell(0, 0, 0, 1, 0, 1);
        GeoPointParserSimpleS2.initLookupCell(0, 0, 0, 2, 0, 2);
        GeoPointParserSimpleS2.initLookupCell(0, 0, 0, 3, 0, 3);
    }

    private record Vec3(double x, double y, double z) {
        Vec3 normalize() {
            double n = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
            return new Vec3(this.x / n, this.y / n, this.z / n);
        }
    }

    private static final class MutableInt {
        int v;

        MutableInt(int v) {
            this.v = v;
        }
    }

    public static final class CellId {
        private final long id;

        public CellId(long id) {
            this.id = id;
        }

        public static CellId fromHex(String hex) {
            String h = hex.startsWith("0x") || hex.startsWith("0X") ? hex.substring(2) : hex;
            return new CellId(Long.parseUnsignedLong(h, 16));
        }

        public static CellId fromFtid(String ftid) {
            String first = ftid;
            int colon = ftid.indexOf(58);
            if (colon >= 0) {
                first = ftid.substring(0, colon);
            }
            return CellId.fromHex(first.trim());
        }

        public boolean isValid() {
            return this.face() < 6 && (this.lowestOnBit() & 0x1555555555555555L) != 0L;
        }

        public double[] toLatLon() {
            Vec3 p = this.toPointRaw().normalize();
            double lat = Math.atan2(p.z, Math.sqrt(p.x * p.x + p.y * p.y));
            double lon = Math.atan2(p.y, p.x);
            return new double[]{lat * 57.29577951308232, lon * 57.29577951308232};
        }

        private int face() {
            return (int)(this.id >>> 61);
        }

        private boolean isLeaf() {
            return ((int)this.id & 1) != 0;
        }

        private long lowestOnBit() {
            return this.id & -this.id;
        }

        private Vec3 toPointRaw() {
            MutableInt i = new MutableInt(0);
            MutableInt j = new MutableInt(0);
            int face = this.toFaceIJ(i, j);
            int delta = this.isLeaf() ? 1 : (((i.v ^ (int)this.id >>> 2) & 1) != 0 ? 2 : 0);
            int si = (i.v << 1) + delta - 0x40000000;
            int ti = (j.v << 1) + delta - 0x40000000;
            return GeoPointParserSimpleS2.faceSiTiToXyz(face, si, ti);
        }

        private int toFaceIJ(MutableInt pi, MutableInt pj) {
            int face = this.face();
            int bits = face & 1;
            for (int k = 7; k >= 0; --k) {
                bits = this.getBits1(pi, pj, k, bits);
            }
            return face;
        }

        private int getBits1(MutableInt i, MutableInt j, int k, int bits) {
            int nbits = k == 7 ? 2 : 4;
            bits += ((int)(this.id >>> k * 2 * 4 + 1) & (1 << 2 * nbits) - 1) << 2;
            bits = LOOKUP_IJ[bits];
            i.v += bits >> 6 << k * 4;
            j.v += (bits >> 2 & 0xF) << k * 4;
            return bits & 3;
        }
    }
}

