/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.gpx;

public abstract class GPXInterpolator {
    private final int pointsCount;
    private final double totalLength;
    private double step;
    private double[] calculatedX;
    private double[] calculatedY;
    private int calculatedPointsCount;
    private double minY = Double.MAX_VALUE;
    private double maxY = Double.MIN_VALUE;

    public GPXInterpolator(int pointsCount, double totalLength, double step) {
        this.pointsCount = pointsCount;
        this.totalLength = totalLength;
        this.step = step;
    }

    public int getPointsCount() {
        return this.pointsCount;
    }

    public double getTotalLength() {
        return this.totalLength;
    }

    public double getStep() {
        return this.step;
    }

    public double[] getCalculatedX() {
        return this.calculatedX;
    }

    public double[] getCalculatedY() {
        return this.calculatedY;
    }

    public int getCalculatedPointsCount() {
        return this.calculatedPointsCount;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public abstract double getX(int var1);

    public abstract double getY(int var1);

    public void interpolate() {
        this.calculatedPointsCount = (int)(this.totalLength / this.step) + 1;
        this.calculatedX = new double[this.calculatedPointsCount];
        this.calculatedY = new double[this.calculatedPointsCount];
        int lastIndex = this.pointsCount - 1;
        int nextW = 0;
        for (int k = 0; k < this.calculatedX.length; ++k) {
            if (k > 0) {
                this.calculatedX[k] = this.calculatedX[k - 1] + this.step;
            } else {
                this.calculatedY[k] = this.getY(0);
                this.takeMinMax(this.calculatedY[k]);
                continue;
            }
            while (nextW < lastIndex && this.calculatedX[k] > this.getX(nextW)) {
                ++nextW;
            }
            double px = nextW == 0 ? 0.0 : this.getX(nextW - 1);
            double py = nextW == 0 ? this.getY(0) : this.getY(nextW - 1);
            this.calculatedY[k] = py + (this.getY(nextW) - py) / (this.getX(nextW) - px) * (this.calculatedX[k] - px);
            this.takeMinMax(this.calculatedY[k]);
        }
    }

    private void takeMinMax(double value) {
        if (this.minY > value) {
            this.minY = value;
        }
        if (this.maxY < value) {
            this.maxY = value;
        }
    }
}

