/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx.organization.strategy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.osmand.shared.data.Limits;
import net.osmand.shared.gpx.DataItem;
import net.osmand.shared.gpx.GpxParameter;
import net.osmand.shared.gpx.TrackItem;
import net.osmand.shared.gpx.data.OrganizedTracksGroup;
import net.osmand.shared.gpx.data.TracksGroup;
import net.osmand.shared.gpx.enums.TracksSortScope;
import net.osmand.shared.gpx.organization.OrganizeByParams;
import net.osmand.shared.gpx.organization.OrganizeByRangeParams;
import net.osmand.shared.gpx.organization.enums.OrganizeByType;
import net.osmand.shared.gpx.organization.strategy.OrganizeByStrategy;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J'\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u0014\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016\u00a8\u0006\u0019"}, d2={"Lnet/osmand/shared/gpx/organization/strategy/OrganizeByRangeStrategy;", "Lnet/osmand/shared/gpx/organization/strategy/OrganizeByStrategy;", "<init>", "()V", "apply", "", "Lnet/osmand/shared/gpx/data/OrganizedTracksGroup;", "originalGroup", "Lnet/osmand/shared/gpx/data/TracksGroup;", "params", "Lnet/osmand/shared/gpx/organization/OrganizeByParams;", "getRangeStartIndicator", "", "trackItem", "Lnet/osmand/shared/gpx/TrackItem;", "property", "Lnet/osmand/shared/gpx/GpxParameter;", "step", "", "(Lnet/osmand/shared/gpx/TrackItem;Lnet/osmand/shared/gpx/GpxParameter;D)Ljava/lang/Integer;", "getInt", "value", "", "getTrackSortScope", "Lnet/osmand/shared/gpx/enums/TracksSortScope;", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nOrganizeByRangeStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrganizeByRangeStrategy.kt\nnet/osmand/shared/gpx/organization/strategy/OrganizeByRangeStrategy\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,72:1\n381#2,7:73\n*S KotlinDebug\n*F\n+ 1 OrganizeByRangeStrategy.kt\nnet/osmand/shared/gpx/organization/strategy/OrganizeByRangeStrategy\n*L\n28#1:73,7\n*E\n"})
public final class OrganizeByRangeStrategy
implements OrganizeByStrategy {
    @NotNull
    public static final OrganizeByRangeStrategy INSTANCE = new OrganizeByRangeStrategy();

    private OrganizeByRangeStrategy() {
    }

    @Override
    @NotNull
    public List<OrganizedTracksGroup> apply(@NotNull TracksGroup originalGroup, @NotNull OrganizeByParams params) {
        Intrinsics.checkNotNullParameter((Object)originalGroup, (String)"originalGroup");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        OrganizeByType type = params.getType();
        double step = ((OrganizeByRangeParams)params).getStepSize();
        GpxParameter gpxParameter = type.getGpxParameter();
        if (gpxParameter == null) {
            return CollectionsKt.emptyList();
        }
        GpxParameter property = gpxParameter;
        HashMap groupedTracks = new HashMap();
        List<TrackItem> trackItems = originalGroup.getTrackItems();
        boolean bl = false;
        for (TrackItem trackItem : trackItems) {
            Object object;
            Integer subRangeStart = INSTANCE.getRangeStartIndicator(trackItem, property, step);
            if (subRangeStart == null) continue;
            Map $this$getOrPut$iv = groupedTracks;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(subRangeStart);
            if (value$iv == null) {
                boolean bl2 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(subRangeStart, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(trackItem);
        }
        List result = new ArrayList();
        Iterator iterator = groupedTracks.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Intrinsics.checkNotNullExpressionValue(iterator.next(), (String)"next(...)");
            double startValue = ((Number)entry.getKey()).doubleValue() * step;
            double endValue = startValue + step;
            Limits limits = new Limits(startValue, endValue);
            String valueIdPart = "from_" + startValue + "_to_" + endValue;
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            List trackItems2 = (List)v;
            String id = OrganizedTracksGroup.Companion.createId(originalGroup, type, valueIdPart);
            result.add(new OrganizedTracksGroup(id, this.getName(type, limits), this.getIconName(type, limits), type, startValue, trackItems2, originalGroup));
        }
        return result;
    }

    private final Integer getRangeStartIndicator(TrackItem trackItem, GpxParameter property, double step) {
        Object object = trackItem.getDataItem();
        if (object == null || (object = (Comparable)((DataItem)object).getParameter(property)) == null) {
            return null;
        }
        Object value = object;
        int valueInt = this.getInt(property.getComparableValue(value));
        return (int)Math.floor((double)valueInt / step);
    }

    private final int getInt(Object value) {
        return value instanceof Number ? ((Number)value).intValue() : (int)Double.parseDouble(String.valueOf(value));
    }

    @Override
    @NotNull
    public TracksSortScope getTrackSortScope() {
        return TracksSortScope.ORGANIZED_BY_VALUE;
    }
}

