/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.core.jni;

import java.math.BigInteger;
import net.osmand.core.jni.OsmAndCoreJNI;

public class TileId {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected TileId(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(TileId tileId) {
        return tileId == null ? 0L : tileId.swigCPtr;
    }

    protected static long swigRelease(TileId tileId) {
        long l = 0L;
        if (tileId != null) {
            if (!tileId.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = tileId.swigCPtr;
            tileId.swigCMemOwn = false;
            tileId.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OsmAndCoreJNI.delete_TileId(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void setId(BigInteger bigInteger) {
        OsmAndCoreJNI.TileId_id_set(this.swigCPtr, this, bigInteger);
    }

    public BigInteger getId() {
        return OsmAndCoreJNI.TileId_id_get(this.swigCPtr, this);
    }

    public void setX(int n) {
        OsmAndCoreJNI.TileId_x_set(this.swigCPtr, this, n);
    }

    public int getX() {
        return OsmAndCoreJNI.TileId_x_get(this.swigCPtr, this);
    }

    public void setY(int n) {
        OsmAndCoreJNI.TileId_y_set(this.swigCPtr, this, n);
    }

    public int getY() {
        return OsmAndCoreJNI.TileId_y_get(this.swigCPtr, this);
    }

    public static TileId fromXY(int n, int n2) {
        return new TileId(OsmAndCoreJNI.TileId_fromXY(n, n2), true);
    }

    public static TileId zero() {
        return new TileId(OsmAndCoreJNI.TileId_zero(), true);
    }

    public TileId() {
        this(OsmAndCoreJNI.new_TileId(), true);
    }
}

