/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.xml.internal.input;

import java.io.IOException;
import javanet.staxutils.XMLStreamUtils;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.input.InputFilterStream;
import org.xwiki.filter.input.InputSource;
import org.xwiki.filter.input.InputStreamInputSource;
import org.xwiki.filter.input.ReaderInputSource;
import org.xwiki.filter.xml.input.XMLInputProperties;

public abstract class AbstractXMLInputFilterStream<P extends XMLInputProperties>
implements InputFilterStream {
    protected P parameters;

    public AbstractXMLInputFilterStream(P parameters) {
        this.parameters = parameters;
    }

    public void read(Object listener) throws FilterException {
        try {
            XMLEventReader xmlEventReader;
            InputSource source = ((XMLInputProperties)((Object)this.parameters)).getSource();
            if (source instanceof ReaderInputSource) {
                xmlEventReader = XMLInputFactory.newInstance().createXMLEventReader(((ReaderInputSource)source).getReader());
            } else if (source instanceof InputStreamInputSource) {
                xmlEventReader = XMLInputFactory.newInstance().createXMLEventReader(((InputStreamInputSource)source).getInputStream());
            } else {
                throw new FilterException("Unknown source type [" + source.getClass() + "]");
            }
            XMLStreamUtils.copy((XMLEventReader)xmlEventReader, (XMLEventWriter)this.createXMLEventWriter(listener, this.parameters));
        }
        catch (Exception e) {
            throw new FilterException("Faild to parse XML source", (Throwable)e);
        }
    }

    protected abstract XMLEventWriter createXMLEventWriter(Object var1, P var2);

    public void close() throws IOException {
        ((XMLInputProperties)((Object)this.parameters)).getSource().close();
    }
}

