/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.wiki.commonswiki.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public final class ParserUtils {
    public static final String FIELD_AUTHOR = "author";
    public static final String FIELD_PHOTOGRAPHER = "photographer";
    public static final String FIELD_DATE = "date";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_LICENSE = "license";
    public static final String FIELD_SOURCE = "source";
    public static final String FILE_PREFIX = "File:";

    private ParserUtils() {
    }

    public static String extractFieldValue(String line, String fieldName) {
        if (line == null || fieldName == null) {
            return null;
        }
        line = line.trim();
        String lineLc = line.toLowerCase();
        String fieldNameLc = fieldName.toLowerCase();
        if (line.startsWith("|")) {
            line = line.substring(1).trim();
            lineLc = line.toLowerCase();
        }
        int idx = lineLc.indexOf(fieldNameLc);
        while (idx != -1) {
            int afterName;
            int pos;
            for (pos = afterName = idx + fieldNameLc.length(); pos < lineLc.length() && Character.isWhitespace(lineLc.charAt(pos)); ++pos) {
            }
            if (pos < lineLc.length() && lineLc.charAt(pos) == '=') {
                return line.substring(pos + 1).trim();
            }
            idx = lineLc.indexOf(fieldNameLc, afterName);
        }
        return null;
    }

    public static String removeWikiLinkBrackets(String text) {
        if (text == null) {
            return null;
        }
        return text.replaceAll("[\\[\\]]+", "");
    }

    public static String removeTemplateBrackets(String text) {
        if (text == null) {
            return null;
        }
        return text.replaceAll("\\{\\{|\\}\\}", "");
    }

    public static String removeWikiMarkup(String text) {
        if (text == null) {
            return null;
        }
        String withoutLinks = ParserUtils.removeWikiLinks(text);
        withoutLinks = ParserUtils.removeWikiLinkBrackets(withoutLinks);
        return ParserUtils.removeTemplateBrackets(withoutLinks);
    }

    private static String removeWikiLinks(String text) {
        int startIdx;
        StringBuilder sb = new StringBuilder(text);
        while ((startIdx = sb.indexOf(":")) != -1) {
            int secondIdx = sb.indexOf(":", startIdx + 1);
            int endIdx = sb.indexOf("|", secondIdx + 1);
            if (secondIdx == -1 || endIdx == -1) break;
            sb.delete(startIdx, endIdx + 1);
        }
        return sb.toString();
    }

    public static String normalizeWhitespace(String text) {
        if (text == null) {
            return null;
        }
        return text.replaceAll("\n", " ").replaceAll("\\s{2,}", " ").trim();
    }

    public static String extractTemplateContent(String text) {
        if (text == null || !text.startsWith("{{") || !text.endsWith("}}")) {
            return null;
        }
        return text.substring(2, text.length() - 2).trim();
    }

    public static List<String> splitByPipeOutsideBraces(String input, boolean splitByPipe) {
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder currentPart = new StringBuilder();
        int curlyBraceDepth = 0;
        int squareBraceDepth = 0;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (i < input.length() - 1 && input.charAt(i) == '{' && input.charAt(i + 1) == '{') {
                ++curlyBraceDepth;
                currentPart.append(c);
                currentPart.append(input.charAt(++i));
                continue;
            }
            if (i < input.length() - 1 && input.charAt(i) == '[' && input.charAt(i + 1) == '[') {
                ++squareBraceDepth;
                currentPart.append(c);
                currentPart.append(input.charAt(++i));
                continue;
            }
            if (i < input.length() - 1 && input.charAt(i) == '}' && input.charAt(i + 1) == '}') {
                --curlyBraceDepth;
                currentPart.append(c);
                currentPart.append(input.charAt(++i));
                continue;
            }
            if (i < input.length() - 1 && input.charAt(i) == ']' && input.charAt(i + 1) == ']') {
                --squareBraceDepth;
                currentPart.append(c);
                currentPart.append(input.charAt(++i));
                continue;
            }
            if (c == '|' && curlyBraceDepth == 0 && squareBraceDepth == 0 && splitByPipe) {
                parts.add(currentPart.toString().trim());
                currentPart.setLength(0);
                continue;
            }
            currentPart.append(c);
        }
        if (!currentPart.isEmpty()) {
            parts.add(currentPart.toString().trim());
        }
        return parts;
    }

    public static boolean isInformationLikeTemplate(String vallc) {
        Pattern patternAuthor = Pattern.compile("\\|\\s*author\\s*=");
        Pattern patternPhotographer = Pattern.compile("\\|\\s*photographer\\s*=");
        Pattern patternDate = Pattern.compile("\\|\\s*date\\s*=");
        Pattern patternDescription = Pattern.compile("\\|\\s*description\\s*=");
        Pattern patternLicense = Pattern.compile("\\|\\s*license\\s*=");
        Pattern patternPermission = Pattern.compile("\\|\\s*permission\\s*=");
        return patternAuthor.matcher(vallc).find() || patternPhotographer.matcher(vallc).find() || patternDate.matcher(vallc).find() || patternDescription.matcher(vallc).find() || patternLicense.matcher(vallc).find() || patternPermission.matcher(vallc).find();
    }

    public static String extractImageName(String sourceFile) {
        int idx;
        if (sourceFile == null || (idx = sourceFile.indexOf(FILE_PREFIX)) < 0) {
            return null;
        }
        if ((sourceFile = sourceFile.substring(idx + FILE_PREFIX.length())).contains("]")) {
            sourceFile = sourceFile.substring(0, sourceFile.indexOf(93));
        }
        if (sourceFile.contains("}")) {
            sourceFile = sourceFile.substring(0, sourceFile.indexOf(125));
        }
        if (sourceFile.contains("[[") || sourceFile.contains("|")) {
            return null;
        }
        return sourceFile;
    }
}

