/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.wiki;

import com.google.gson.Gson;
import gnu.trove.map.hash.TIntObjectHashMap;
import info.bliki.wiki.filter.HTMLConverter;
import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.filter.PlainTextConverter;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.osmand.PlatformUtil;
import net.osmand.data.LatLon;
import net.osmand.impl.FileProgressImplementation;
import net.osmand.map.OsmandRegions;
import net.osmand.obf.preparation.DBDialect;
import net.osmand.travel.WikivoyageLangPreparation;
import net.osmand.util.Algorithms;
import net.osmand.util.LocationParser;
import net.osmand.wiki.CustomWikiModel;
import net.osmand.wiki.OsmCoordinatesByTag;
import net.osmand.wiki.PoiFieldCategory;
import net.osmand.wiki.WikiImageUrlStorage;
import net.osmand.wiki.WikidataFilesDownloader;
import net.osmand.wiki.commonswiki.parser.AuthorParser;
import net.osmand.wiki.commonswiki.parser.DateParser;
import net.osmand.wiki.commonswiki.parser.DescriptionParser;
import net.osmand.wiki.commonswiki.parser.LicenseParser;
import net.osmand.wiki.commonswiki.parser.ParserUtils;
import net.osmand.wiki.wikidata.WikiDataHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xmlpull.v1.XmlPullParserException;
import org.xwiki.component.manager.ComponentLookupException;

public class WikiDatabasePreparation {
    private static final Log log = PlatformUtil.getLog(WikiDatabasePreparation.class);
    private static final Set<String> unitsOfDistance = new HashSet<String>(Arrays.asList("mm", "cm", "m", "km", "in", "ft", "yd", "mi", "nmi", "m2"));
    public static final String WIKIPEDIA_SQLITE = "wikipedia.sqlite";
    public static final String WIKIRATING_SQLITE = "wiki_rating.sqlite";
    public static final String WIKIDATA_MAPPING_SQLITE = "wikidata_mapping.sqlitedb";
    public static final String WIKIDATA_ARTICLES_GZ = "wikidatawiki-latest-pages-articles.xml.gz";
    public static final String WIKI_ARTICLES_GZ = "wiki-latest-pages-articles.xml.gz";
    public static final String OSM_WIKI_FILE_PREFIX = "osm_wiki_";
    private static final int OPTIMAL_SHORT_DESCR = 250;
    private static final int OPTIMAL_LONG_DESCR = 500;
    private static final int SHORT_PARAGRAPH = 10;
    public static final String DEFAULT_LANG = "en";
    public static Map<String, Integer> POI_OTHER_TYPES = new HashMap<String, Integer>();

    public static LatLon getLatLonFromGeoBlock(List<String> list, String lang, String title) {
        if (list != null && !list.isEmpty()) {
            String location = list.get(0) + " ";
            String[] parts = location.split("\\|");
            LatLon ll = null;
            if (parts.length >= 3) {
                String lat = null;
                String lon = null;
                if (parts[0].trim().equalsIgnoreCase("geo")) {
                    lat = parts[1];
                    lon = parts[2];
                } else {
                    for (String part : parts) {
                        int eq = part.indexOf(61);
                        if (eq == -1) continue;
                        String key = part.substring(0, eq).trim().toLowerCase();
                        String val = part.substring(eq + 1).trim();
                        if (key.equals("lat") || key.equals("latitude")) {
                            lat = val;
                            continue;
                        }
                        if (!key.equals("long") && !key.equals("longitude")) continue;
                        lon = val;
                    }
                }
                if (WikiDatabasePreparation.isEmpty(lat) || WikiDatabasePreparation.isEmpty(lon)) {
                    return null;
                }
                if (lat != null && lon != null) {
                    ll = WikiDatabasePreparation.parseLocation(lat, lon);
                }
            }
            if (ll == null) {
                System.err.printf("Error structure geo (%s %s): %s \n", lang, title, location.substring(0, Math.min(location.length(), 10)));
            }
            return ll;
        }
        return null;
    }

    public static boolean isEmpty(String lat) {
        return "".equals(lat) || "NA".equals(lat) || "N/A".equals(lat);
    }

    public static LatLon parseLocation(String lat, String lon) {
        Object loc = lat + " " + lon;
        if (!((String)loc).contains(".") && ((String)loc).contains(",")) {
            loc = ((String)loc).replace(',', '.');
        }
        return LocationParser.parseLocation((String)loc);
    }

    public static LatLon parseLatLon(String lat, String lon) {
        if (WikiDatabasePreparation.isEmpty(lat) || WikiDatabasePreparation.isEmpty(lon)) {
            return null;
        }
        try {
            LatLon res = WikiDatabasePreparation.parseLocation(lat, lon);
            if (res != null) {
                return res;
            }
            return new LatLon(Double.parseDouble(lat), Double.parseDouble(lon));
        }
        catch (RuntimeException e) {
            System.err.printf("Error point lat=%s lon=%s (%s)\n", lat, lon, e.getMessage());
            return null;
        }
    }

    public static String removeMacroBlocks(StringBuilder text, @Nullable Map<String, String> webBlockResults, Map<WikivoyageLangPreparation.WikivoyageTemplates, List<String>> blockResults, @Nullable List<Map<PoiFieldType, Object>> pois, String lang, String title, @Nullable WikiDBBrowser browser, @Nullable Boolean allLangs) throws IOException, SQLException {
        return WikiDatabasePreparation.removeMacroBlocks(text, webBlockResults, blockResults, pois, lang, title, browser, allLangs, false);
    }

    public static String removeMacroBlocks(StringBuilder text, @Nullable Map<String, String> webBlockResults, Map<WikivoyageLangPreparation.WikivoyageTemplates, List<String>> blockResults, @Nullable List<Map<PoiFieldType, Object>> pois, String lang, String title, @Nullable WikiDBBrowser browser, @Nullable Boolean allLangs, boolean logContentErrors) throws IOException, SQLException {
        StringBuilder bld = new StringBuilder();
        int openCnt = 0;
        int beginInd = 0;
        int headerCount = 0;
        String TAG_GALLERY = "gallery";
        String TAG_WEATHER_BOX = "weather box";
        String TAG_WIDE_IMAGE = "wide image";
        String TAG_REF = "ref";
        String LICENSE_HEADER = "=={{int:license-header}}==";
        boolean isLicenseBlock = false;
        ArrayList<String> licenseBlock = new ArrayList<String>();
        int i = 0;
        while (i < text.length()) {
            int endI;
            int leftChars = text.length() - i - 1;
            if (WikiDatabasePreparation.isCommentOpen(text, leftChars, i)) {
                endI = WikiDatabasePreparation.skipComment(text, i + 3);
                text.replace(i, endI + 1, "");
                continue;
            }
            if (WikiDatabasePreparation.isNowikiOpen(text, i)) {
                endI = WikiDatabasePreparation.skipNowiki(text, i);
                text.replace(i, endI + 1, "");
                continue;
            }
            ++i;
        }
        TreeSet<Integer> errorBracesCnt = new TreeSet<Integer>();
        String[] tagsRetrieve = new String[]{"gallery", "weather box", "wide image", "ref"};
        int cursor = -1;
        int i2 = 0;
        while (true) {
            block61: {
                int leftChars;
                block60: {
                    if (cursor >= i2) {
                        log.error((Object)String.format("BUG ! %d -> %d content parsing: %s %s", cursor, i2, lang, title));
                        i2 = cursor + 1;
                    }
                    cursor = i2;
                    if (i2 >= text.length()) {
                        if (openCnt <= 0) break;
                        if (logContentErrors) {
                            String contentPreview = text.substring(beginInd, Math.min(text.length() - 1, beginInd + 20));
                            log.error((Object)String.format("Error content braces {{ }}: %s %s ...%s", lang, title, contentPreview));
                        }
                        errorBracesCnt.add(beginInd);
                        i2 = 0;
                        openCnt = 0;
                        beginInd = 0;
                        cursor = -1;
                        blockResults.clear();
                    }
                    leftChars = text.length() - i2 - 1;
                    if (openCnt != 0 || text.charAt(i2) != '<') break block60;
                    boolean found = false;
                    for (String tag : tagsRetrieve) {
                        if (leftChars <= tag.length() || !text.substring(i2 + 1, i2 + 1 + tag.length()).toLowerCase().equals(tag)) continue;
                        found = true;
                        StringBuilder val = new StringBuilder();
                        i2 = WikiDatabasePreparation.parseTag(text, val, tag, i2, lang, title, logContentErrors);
                        if (tag.equals("ref")) {
                            WikiDatabasePreparation.parseAndAppendCitation(val.toString(), bld);
                            break;
                        }
                        if (!tag.equals("gallery")) break;
                        String res = WikiDatabasePreparation.parseGalleryString(val.toString());
                        bld.append(res);
                        break;
                    }
                    if (found) break block61;
                }
                if (leftChars > 0 && text.charAt(i2) == '{' && text.charAt(i2 + 1) == '{') {
                    if (!errorBracesCnt.contains(i2 + 2)) {
                        beginInd = beginInd == 0 ? i2 + 2 : beginInd;
                        ++openCnt;
                    }
                    ++i2;
                } else if (leftChars > 0 && text.charAt(i2) == '}' && text.charAt(i2 + 1) == '}') {
                    if (openCnt == 0) {
                        ++i2;
                    } else if (--openCnt > 0) {
                        ++i2;
                    } else {
                        EnumSet<WikivoyageLangPreparation.WikivoyageTemplates> key;
                        int endInd = i2;
                        String val = text.substring(beginInd, endInd);
                        if (isLicenseBlock) {
                            licenseBlock.add(val);
                        }
                        beginInd = 0;
                        String vallc = val.toLowerCase().trim();
                        if (val.startsWith("gallery")) {
                            bld.append(WikiDatabasePreparation.parseGalleryString(val));
                        } else if (vallc.startsWith("weather box")) {
                            WikiDatabasePreparation.parseAndAppendWeatherTable(val, bld);
                        } else if (vallc.startsWith("wide image") || vallc.startsWith("\u05ea\u05de\u05d5\u05e0\u05d4 \u05e8\u05d7\u05d1\u05d4")) {
                            bld.append(WikiDatabasePreparation.parseWideImageString(val));
                        } else if (ParserUtils.isInformationLikeTemplate(vallc)) {
                            WikiDatabasePreparation.parseInformationBlock(val, lang, webBlockResults, allLangs, title);
                        }
                        PoiFieldCategory pc = WikiDatabasePreparation.isPOIKey(vallc, lang);
                        EnumSet<WikivoyageLangPreparation.WikivoyageTemplates> enumSet = key = pc != null ? EnumSet.of(WikivoyageLangPreparation.WikivoyageTemplates.POI) : WikiDatabasePreparation.getKey(vallc, lang);
                        if (pc != null) {
                            val = val.replaceAll("\\{\\{.*}}", "");
                            HashMap<PoiFieldType, Object> poiFields = new HashMap<PoiFieldType, Object>();
                            poiFields.put(PoiFieldType.CATEGORY, (Object)pc);
                            bld.append((CharSequence)WikiDatabasePreparation.getWikivoyagePoiHtmlDescription(lang, browser, poiFields, val));
                            if (pois != null && !poiFields.isEmpty()) {
                                pois.add(poiFields);
                            }
                        } else if (key.contains((Object)WikivoyageLangPreparation.WikivoyageTemplates.REGION_LIST)) {
                            bld.append(WikiDatabasePreparation.parseRegionList(val));
                        } else if (key.contains((Object)WikivoyageLangPreparation.WikivoyageTemplates.WARNING)) {
                            WikiDatabasePreparation.appendWarning(bld, val);
                        } else if (key.contains((Object)WikivoyageLangPreparation.WikivoyageTemplates.CITATION)) {
                            WikiDatabasePreparation.parseAndAppendCitation(val, bld);
                        } else if (key.contains((Object)WikivoyageLangPreparation.WikivoyageTemplates.TWO_PART)) {
                            WikiDatabasePreparation.parseAndAppendTwoPartFormat(val, bld);
                        } else if (key.contains((Object)WikivoyageLangPreparation.WikivoyageTemplates.STATION)) {
                            WikiDatabasePreparation.parseAndAppendStation(val, bld);
                        } else if (key.contains((Object)WikivoyageLangPreparation.WikivoyageTemplates.METRIC_DATA)) {
                            WikiDatabasePreparation.parseAndAppendMetricData(val, bld);
                        } else if (key.contains((Object)WikivoyageLangPreparation.WikivoyageTemplates.TRANSLATION)) {
                            WikiDatabasePreparation.parseAndAppendTranslation(val, bld);
                        }
                        if (!key.isEmpty() && blockResults != null) {
                            for (WikivoyageLangPreparation.WikivoyageTemplates w : key) {
                                WikiDatabasePreparation.addToMap(blockResults, w, val);
                            }
                        }
                        ++i2;
                    }
                } else if (openCnt == 0) {
                    int headerLvl = 0;
                    int indexCopy = i2;
                    if (isLicenseBlock) {
                        String license = LicenseParser.parse(licenseBlock);
                        if (license != null && webBlockResults != null) {
                            webBlockResults.put("license", license);
                        }
                        isLicenseBlock = false;
                    }
                    if (i2 > 0 && text.charAt(i2 - 1) != '=') {
                        headerLvl = WikiDatabasePreparation.calculateHeaderLevel(text, i2);
                        indexCopy += headerLvl;
                    }
                    if (text.charAt(indexCopy) != '\n' && headerLvl > 1) {
                        int indEnd = text.indexOf("=", indexCopy);
                        if (indEnd != -1) {
                            int nextHeader;
                            char ch;
                            char c = ch = (indEnd += WikiDatabasePreparation.calculateHeaderLevel(text, indEnd)) < text.length() - 2 ? text.charAt(indEnd + 1) : text.charAt(indEnd);
                            if (text.substring(i2, indEnd).replace(" ", "").contains("=={{int:license-header}}==")) {
                                isLicenseBlock = true;
                            }
                            if ((nextHeader = WikiDatabasePreparation.calculateHeaderLevel(text, ch == '\n' ? indEnd + 2 : indEnd + 1)) > 1 && headerLvl >= nextHeader) {
                                i2 = indEnd;
                            } else if (headerLvl == 2) {
                                if (headerCount != 0) {
                                    bld.append("\n/div\n");
                                }
                                bld.append(text, i2, indEnd);
                                bld.append("\ndiv class=\"content\"\n");
                                ++headerCount;
                                i2 = indEnd;
                            } else {
                                bld.append(text.charAt(i2));
                            }
                        }
                    } else {
                        bld.append(text.charAt(i2));
                    }
                }
            }
            ++i2;
        }
        return bld.toString();
    }

    public static void prepareMetaData(Map<String, String> metaData) {
        metaData.computeIfPresent("license", (k, v) -> LicenseParser.process(v));
    }

    private static void parseInformationBlock(String val, String lang, Map<String, String> webBlockResults, Boolean allLangs, String title) {
        if (webBlockResults == null || val == null) {
            return;
        }
        String author = null;
        String date = null;
        String license = null;
        String source = null;
        Map<Object, Object> description = new HashMap();
        val = ParserUtils.normalizeWhitespace(val);
        List<String> parts = ParserUtils.splitByPipeOutsideBraces(val, true);
        for (String string : parts) {
            String sourceValue;
            String string2 = string.trim();
            String lineLc = string2.toLowerCase();
            if (author == null && lineLc.startsWith("author") || lineLc.startsWith("photographer")) {
                author = AuthorParser.parse(string2);
            }
            if (date == null && lineLc.startsWith("date")) {
                date = DateParser.parse(string2);
            }
            if (lineLc.startsWith("description")) {
                description = DescriptionParser.parse(string2, title);
            }
            if (lineLc.startsWith("license") || lineLc.startsWith("permission")) {
                String licenseValue = ParserUtils.extractFieldValue(string2, "license");
                if (licenseValue == null) {
                    licenseValue = ParserUtils.extractFieldValue(string2, "permission");
                }
                if (licenseValue != null) {
                    license = LicenseParser.parseFromInformationBlock(licenseValue);
                }
            }
            if (!lineLc.startsWith("source") || (sourceValue = ParserUtils.extractFieldValue(string2, "source")) == null) continue;
            source = ParserUtils.extractImageName(sourceValue);
        }
        if (author != null) {
            webBlockResults.put("author", author);
        }
        if (date != null) {
            webBlockResults.put("date", date);
        }
        if (license != null) {
            webBlockResults.put("license", license);
        }
        if (source != null) {
            webBlockResults.put("source", source);
        }
        if (!description.isEmpty()) {
            if (Boolean.TRUE.equals(allLangs)) {
                webBlockResults.put("description", new Gson().toJson(description));
            } else {
                for (Map.Entry entry : description.entrySet()) {
                    if (!((String)entry.getKey()).equals(lang)) continue;
                    webBlockResults.put("description", (String)entry.getValue());
                }
                if (!webBlockResults.containsKey("description") && description.containsKey(DEFAULT_LANG)) {
                    webBlockResults.put("description", (String)description.get(DEFAULT_LANG));
                }
                if (!webBlockResults.containsKey("description") && !description.isEmpty()) {
                    webBlockResults.put("description", (String)description.values().iterator().next());
                }
            }
        }
    }

    private static StringBuilder getWikivoyagePoiHtmlDescription(String lang, WikiDBBrowser browser, Map<PoiFieldType, Object> poiFields, String val) throws IOException, SQLException, UnsupportedEncodingException {
        LatLon latLon;
        StringBuilder poiShortDescription = WikiDatabasePreparation.parsePoiWithAddLatLon(val, poiFields);
        String wikiLink = (String)poiFields.get((Object)PoiFieldType.WIKIPEDIA);
        String wikiDataQId = (String)poiFields.get((Object)PoiFieldType.WIKIDATA);
        long wikidataId = 0L;
        if (!Algorithms.isEmpty((CharSequence)wikiDataQId)) {
            try {
                wikidataId = wikiDataQId.indexOf(32) > 0 ? Long.parseLong(wikiDataQId.substring(1, wikiDataQId.indexOf(32))) : Long.parseLong(wikiDataQId.substring(1));
            }
            catch (NumberFormatException e) {
                System.err.println("Error point wid - " + wikiDataQId);
            }
        }
        if (Algorithms.isEmpty((CharSequence)wikiLink) && wikidataId > 0L && browser != null) {
            wikiLink = browser.getWikipediaTitleByWid(lang, wikidataId);
        }
        LatLon latLon2 = latLon = browser == null ? null : browser.getLocation(lang, wikiLink, wikidataId);
        if (!Algorithms.isEmpty((CharSequence)wikiLink) && !Algorithms.stringsEqual((String)((String)poiFields.get((Object)PoiFieldType.WIKIPEDIA)), (String)wikiLink)) {
            poiFields.put(PoiFieldType.WIKIPEDIA, wikiLink);
        }
        if (wikidataId > 0L && !Algorithms.stringsEqual((String)((String)poiFields.get((Object)PoiFieldType.WIKIDATA)), (String)("Q" + wikidataId))) {
            poiFields.put(PoiFieldType.WIKIDATA, "Q" + wikidataId);
        }
        if (latLon == null && poiFields.containsKey((Object)PoiFieldType.LAT) && poiFields.containsKey((Object)PoiFieldType.LON)) {
            latLon = WikiDatabasePreparation.parseLatLon((String)poiFields.get((Object)PoiFieldType.LAT), (String)poiFields.get((Object)PoiFieldType.LON));
        }
        if (!Algorithms.isEmpty((CharSequence)wikiLink)) {
            poiShortDescription.append(WikiDatabasePreparation.addWikiLink(lang, wikiLink, latLon));
            poiShortDescription.append(" ");
        }
        if (latLon != null) {
            poiFields.put(PoiFieldType.LATLON, latLon);
            poiShortDescription.append(String.format(" geo:%.5f,%.5f,", latLon.getLatitude(), latLon.getLongitude()));
        }
        return poiShortDescription;
    }

    private static String addWikiLink(String lang, String value, LatLon latLon) throws UnsupportedEncodingException {
        String attr = "";
        if (latLon != null) {
            attr = String.format("?lat=%.5f&lon=%.5f", latLon.getLatitude(), latLon.getLongitude());
        }
        return "[https://" + lang + ".wikipedia.org/wiki/" + URLEncoder.encode(value.trim().replaceAll(" ", "_"), "UTF-8") + attr + " Wikipedia]";
    }

    private static int skipComment(StringBuilder text, int i) {
        while (i < text.length() && !WikiDatabasePreparation.isCommentClosed(text, i)) {
            ++i;
        }
        return i;
    }

    private static boolean isNowikiOpen(StringBuilder text, int i) {
        int len = text.length();
        if (i + 7 >= len) {
            return false;
        }
        String maybeTag = text.substring(i, i + 8);
        return maybeTag.equalsIgnoreCase("<nowiki>");
    }

    private static int skipNowiki(StringBuilder text, int i) {
        int len = text.length();
        for (int pos = i + 8; pos < len; ++pos) {
            String maybeClose;
            if (pos + 8 >= len || !(maybeClose = text.substring(pos, pos + 9)).equalsIgnoreCase("</nowiki>")) continue;
            return pos + 8;
        }
        return len - 1;
    }

    private static boolean isCommentClosed(StringBuilder text, int i) {
        return i > 1 && text.charAt(i - 2) == '-' && text.charAt(i - 1) == '-' && text.charAt(i) == '>';
    }

    private static boolean isCommentOpen(StringBuilder text, int nt, int i) {
        return nt > 2 && text.charAt(i) == '<' && text.charAt(i + 1) == '!' && text.charAt(i + 2) == '-' && text.charAt(i + 3) == '-';
    }

    private static void parseAndAppendWeatherTable(String val, StringBuilder bld) {
        String[] parts = val.split("\\|");
        HashMap<String, String> headerMappings = new HashMap<String, String>();
        headerMappings.put("record high", "Record high \u00b0C");
        headerMappings.put("high", "Average high \u00b0C");
        headerMappings.put("mean", "Daily mean \u00b0C");
        headerMappings.put("low", "Average low \u00b0C");
        headerMappings.put("record low", "Record low \u00b0C");
        headerMappings.put("precipitation", "Average rainfall mm");
        headerMappings.put("rain", "Average rainy days (\u2265 1.0 mm)");
        bld.append("{| class=\"wikitable sortable\"\n");
        bld.append("!Month\n");
        bld.append("!Jan\n");
        bld.append("!Feb\n");
        bld.append("!Mar\n");
        bld.append("!Apr\n");
        bld.append("!May\n");
        bld.append("!Jun\n");
        bld.append("!Jul\n");
        bld.append("!Aug\n");
        bld.append("!Sep\n");
        bld.append("!Oct\n");
        bld.append("!Nov\n");
        bld.append("!Dec\n");
        bld.append("!Year\n");
        LinkedHashMap<String, TIntObjectHashMap> data = new LinkedHashMap<String, TIntObjectHashMap>();
        for (String part : parts) {
            String header = WikiDatabasePreparation.getHeader(part, headerMappings);
            if (part.contains("colour") || header == null) continue;
            if (data.get(header) == null) {
                TIntObjectHashMap vals = new TIntObjectHashMap();
                vals.put(WikiDatabasePreparation.getIndex(part), (Object)part.substring(part.indexOf("=") + 1));
                data.put(header, vals);
                continue;
            }
            ((TIntObjectHashMap)data.get(header)).put(WikiDatabasePreparation.getIndex(part), (Object)part.substring(part.indexOf("=") + 1));
        }
        for (String header : data.keySet()) {
            bld.append("|-\n");
            bld.append("|").append(header).append("\n");
            TIntObjectHashMap values = (TIntObjectHashMap)data.get(header);
            for (int i = 1; i < 14; ++i) {
                String valueToAppend = (String)values.get(i);
                valueToAppend = valueToAppend == null ? "" : valueToAppend;
                bld.append("|").append(valueToAppend).append("\n");
            }
        }
        bld.append("|}");
    }

    private static void parseAndAppendMetricData(String val, StringBuilder bld) {
        String[] parts = val.split("\\|");
        String value = "";
        String units = "";
        for (String part : parts) {
            if (value.isEmpty() && StringUtils.isNumeric((CharSequence)part)) {
                value = part;
            }
            if (!units.isEmpty() || !WikiDatabasePreparation.stringIsMetricUnit(part)) continue;
            units = part;
        }
        if (!value.isEmpty() && !units.isEmpty()) {
            bld.append(String.format("%s %s", value, units));
        }
    }

    private static boolean stringIsMetricUnit(String part) {
        return unitsOfDistance.contains(part);
    }

    private static int getIndex(String part) {
        if (part.contains("Jan")) {
            return 1;
        }
        if (part.contains("Feb")) {
            return 2;
        }
        if (part.contains("Mar")) {
            return 3;
        }
        if (part.contains("Apr")) {
            return 4;
        }
        if (part.contains("May")) {
            return 5;
        }
        if (part.contains("Jun")) {
            return 6;
        }
        if (part.contains("Jul")) {
            return 7;
        }
        if (part.contains("Aug")) {
            return 8;
        }
        if (part.contains("Sep")) {
            return 9;
        }
        if (part.contains("Oct")) {
            return 10;
        }
        if (part.contains("Nov")) {
            return 11;
        }
        if (part.contains("Dec")) {
            return 12;
        }
        if (part.contains("year")) {
            return 13;
        }
        return -1;
    }

    private static String getHeader(String part, Map<String, String> mapping) {
        if (part.contains("high")) {
            return part.contains("record") ? mapping.get("record high") : mapping.get("high");
        }
        if (part.contains("low")) {
            return part.contains("record") ? mapping.get("record low") : mapping.get("low");
        }
        if (part.contains("mean")) {
            return mapping.get("mean");
        }
        if (part.contains("precipitation")) {
            return mapping.get("precipitation");
        }
        if (part.contains("rain")) {
            return mapping.get("rain");
        }
        return null;
    }

    private static int parseTag(StringBuilder text, StringBuilder bld, String tag, int indOpen, String lang, String title, boolean logContentErrors) {
        int selfClosed = text.indexOf("/>", indOpen);
        int nextTag = text.indexOf("<", indOpen + 1);
        if (selfClosed > 0 && (selfClosed < nextTag || nextTag == -1)) {
            bld.append(text.substring(indOpen + 1, selfClosed));
            return selfClosed + 1;
        }
        int ind = text.indexOf("</" + tag, indOpen);
        int ind2 = text.indexOf("</ " + tag, indOpen);
        if (ind == -1 && ind2 == -1) {
            String lc = text.toString().toLowerCase();
            ind = lc.indexOf("</" + tag, indOpen);
            ind2 = lc.indexOf("</ " + tag, indOpen);
        }
        if (ind2 > 0) {
            ind = ind == -1 ? ind2 : Math.min(ind2, ind);
        }
        int lastChar = text.indexOf(">", ind);
        if (ind == -1 || lastChar == -1) {
            if (logContentErrors) {
                String contentPreview = text.substring(indOpen + 1, Math.min(text.length() - 1, indOpen + 1 + 10));
                log.error((Object)String.format("Error content tag (not closed) %s %s: %s", lang, title, contentPreview));
            }
            return indOpen + 1;
        }
        bld.append(text.substring(indOpen + 1, ind));
        return lastChar;
    }

    private static void parseAndAppendCitation(String ref, StringBuilder bld) {
        String[] parts = ref.split("\\|");
        String url = "";
        for (String part : parts) {
            if (!(part = part.trim().toLowerCase()).startsWith("url=")) continue;
            url = part.substring(part.indexOf("=") + 1);
        }
        if (!url.isEmpty()) {
            bld.append("[").append(url).append("]");
        }
    }

    private static void parseAndAppendTwoPartFormat(String ref, StringBuilder bld) {
        String[] parts = ref.split("\\|+|:");
        if (parts.length > 1) {
            bld.append(parts[1]);
        }
    }

    private static void parseAndAppendStation(String ref, StringBuilder bld) {
        String[] parts = ref.split("\\|");
        if (parts.length <= 2) {
            return;
        }
        String[] stations = Arrays.copyOfRange(parts, 2, parts.length);
        if (stations.length > 0) {
            Object st = "|";
            for (String station : stations) {
                st = (String)st + station + "|";
            }
            bld.append(parts[0]).append(" ").append(parts[1]).append(" ").append((String)st);
        } else {
            bld.append(parts[0]).append(" ").append(parts[1]);
        }
    }

    private static void parseAndAppendTranslation(String ref, StringBuilder bld) {
        String[] parts = ref.split("\\|");
        Object lang = "";
        if (parts.length > 1) {
            for (String part : parts) {
                if (!part.startsWith("lang-")) continue;
                lang = part.split("-")[1] + " = ";
            }
            if (!((String)lang).isEmpty()) {
                bld.append((String)lang).append(parts[1]);
            } else {
                bld.append("[").append(parts[1]).append("]");
            }
        }
    }

    private static int calculateHeaderLevel(StringBuilder s, int index) {
        int res = 0;
        while (index < s.length() - 1 && s.charAt(index) == '=') {
            ++index;
            ++res;
        }
        return res;
    }

    private static void appendWarning(StringBuilder bld, String val) {
        int ind = val.indexOf("|");
        ind = ind == -1 ? 0 : ind + 1;
        bld.append("<p class=\"warning\"><b>Warning: </b>");
        String[] parts = val.split("\\|");
        val = parts.length > 1 ? parts[1] : "";
        val = !val.isEmpty() ? WikiDatabasePreparation.appendSqareBracketsIfNeeded(1, parts, val) : val;
        bld.append(val);
        bld.append("</p>");
    }

    private static String parseWideImageString(String val) {
        String[] parts = val.split("\\|");
        StringBuilder bld = new StringBuilder();
        bld.append("[[");
        for (int i = 1; i < parts.length; ++i) {
            String part = parts[i];
            String toCompare = part.toLowerCase();
            if ((toCompare.contains(".jpg") || toCompare.contains(".jpeg") || toCompare.contains(".png") || toCompare.contains(".gif")) && !toCompare.contains(":")) {
                bld.append("File:");
            }
            bld.append(part);
            if (i >= parts.length - 1) continue;
            bld.append("|");
        }
        bld.append("]]");
        return bld.toString();
    }

    private static String parseGalleryString(String val) {
        String[] parts = val.split("\n");
        StringBuilder bld = new StringBuilder();
        for (String part : parts) {
            String toCompare = part.toLowerCase();
            if (!toCompare.contains(".jpg") && !toCompare.contains(".jpeg") && !toCompare.contains(".png") && !toCompare.contains(".gif")) continue;
            bld.append("[[");
            bld.append(part);
            bld.append("]]");
        }
        return bld.toString();
    }

    private static String parseRegionList(String val) {
        StringBuilder bld = new StringBuilder();
        String[] parts = val.split("\\|");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i].trim();
            int ind = part.indexOf("=");
            if (ind == -1) continue;
            String partname = part.trim().substring(0, ind).trim();
            if (partname.matches("region\\d+name")) {
                String value = WikiDatabasePreparation.appendSqareBracketsIfNeeded(i, parts, part.substring(ind + 1, part.length()));
                bld.append("*");
                bld.append(value);
                bld.append("\n");
                continue;
            }
            if (!partname.matches("region\\d+description")) continue;
            Object desc = part.substring(ind + 1, part.length());
            int startInd = i;
            while (i < parts.length - 1 && !parts[++i].contains("=")) {
                desc = (String)desc + "|" + parts[i];
            }
            i = i == startInd++ ? i : i - 1;
            bld.append((String)desc);
            bld.append("\n");
        }
        return bld.toString();
    }

    private static void addToMap(Map<WikivoyageLangPreparation.WikivoyageTemplates, List<String>> blocksMap, WikivoyageLangPreparation.WikivoyageTemplates key, String val) {
        if (blocksMap.containsKey((Object)key)) {
            blocksMap.get((Object)key).add(val);
        } else {
            ArrayList<String> tmp = new ArrayList<String>();
            tmp.add(val);
            blocksMap.put(key, tmp);
        }
    }

    private static StringBuilder parsePoiWithAddLatLon(String val, Map<PoiFieldType, Object> poiFields) throws IOException, SQLException {
        StringBuilder poiShortDescription = new StringBuilder();
        String[] parts = val.split("\\|");
        for (int i = 1; i < parts.length; ++i) {
            String field = parts[i].trim();
            String value = "";
            int index = field.indexOf("=");
            if (index != -1) {
                value = WikiDatabasePreparation.appendSqareBracketsIfNeeded(i, parts, field.substring(index + 1, field.length()).trim()).replaceAll("\n", " ").trim();
                field = field.substring(0, index).trim();
            }
            if (value.isEmpty() || value.contains("{{")) continue;
            try {
                if (field.equalsIgnoreCase("name") || field.equalsIgnoreCase("nome") || field.equalsIgnoreCase("nom") || field.equalsIgnoreCase("\u05e9\u05dd") || field.equalsIgnoreCase("\u0646\u0627\u0645")) {
                    poiShortDescription.append("'''").append(value).append("'''").append(", ");
                    int l = value.indexOf("[[");
                    int e = value.indexOf("]]");
                    if (l >= 0 && e >= 0) {
                        poiFields.put(PoiFieldType.NAME, value.substring(l + 2, e).trim());
                        continue;
                    }
                    poiFields.put(PoiFieldType.NAME, value);
                    continue;
                }
                if (field.equalsIgnoreCase("url") || field.equalsIgnoreCase("sito") || field.equalsIgnoreCase("\u05d4\u05d0\u05ea\u05e8 \u05d4\u05e8\u05e9\u05de\u05d9") || field.equalsIgnoreCase("\u0646\u0634\u0627\u0646\u06cc \u0627\u06cc\u0646\u062a\u0631\u0646\u062a\u06cc")) {
                    poiShortDescription.append("Website: ").append(value).append(". ");
                    poiFields.put(PoiFieldType.WEBSITE, value);
                    continue;
                }
                if (field.equalsIgnoreCase("intl-area-code")) {
                    poiFields.put(PoiFieldType.AREA_CODE, value);
                    continue;
                }
                if (field.equalsIgnoreCase("address") || field.equalsIgnoreCase("addresse") || field.equalsIgnoreCase("\u05db\u05ea\u05d5\u05d1\u05ea") || field.equalsIgnoreCase("\u0646\u0634\u0627\u0646\u06cc")) {
                    poiShortDescription.append(value).append(", ");
                    poiFields.put(PoiFieldType.ADDRESS, value);
                    continue;
                }
                if (field.equalsIgnoreCase("lat") || field.equalsIgnoreCase("latitude") || field.equalsIgnoreCase("\u0639\u0631\u0636 \u062c\u063a\u0631\u0627\u0641\u06cc\u0627\u06cc\u06cc")) {
                    poiFields.put(PoiFieldType.LAT, value);
                    continue;
                }
                if (field.equalsIgnoreCase("long") || field.equalsIgnoreCase("longitude") || field.equalsIgnoreCase("\u0637\u0648\u0644 \u062c\u063a\u0631\u0627\u0641\u06cc\u0627\u06cc\u06cc")) {
                    poiFields.put(PoiFieldType.LON, value);
                    continue;
                }
                if (field.equalsIgnoreCase("content") || field.equalsIgnoreCase("descrizione") || field.equalsIgnoreCase("description") || field.equalsIgnoreCase("sobre") || field.equalsIgnoreCase("\u05ea\u05d9\u05d0\u05d5\u05e8") || field.equalsIgnoreCase("\u0645\u062a\u0646")) {
                    poiShortDescription.append(value).append(" ");
                    poiFields.put(PoiFieldType.DESCRIPTION, value);
                    continue;
                }
                if (field.equalsIgnoreCase("email") || field.equalsIgnoreCase("\u05de\u05d9\u05d9\u05dc") || field.equalsIgnoreCase("\u067e\u0633\u062a \u0627\u0644\u06a9\u062a\u0631\u0648\u0646\u06cc\u06a9\u06cc")) {
                    poiShortDescription.append("e-mail: mailto:").append(value).append(", ");
                    poiFields.put(PoiFieldType.EMAIL, value);
                    continue;
                }
                if (field.equalsIgnoreCase("fax") || field.equalsIgnoreCase("\u05e4\u05e7\u05e1") || field.equalsIgnoreCase("\u062f\u0648\u0631\u0646\u06af\u0627\u0631")) {
                    poiFields.put(PoiFieldType.FAX, value);
                    poiShortDescription.append("fax: ").append(value).append(", ");
                    continue;
                }
                if (field.equalsIgnoreCase("wdid") || field.equalsIgnoreCase("wikidata") || field.equalsIgnoreCase("\u05d5\u05d9\u05e7\u05d9\u05e0\u05ea\u05d5\u05e0\u05d9\u05dd")) {
                    poiFields.put(PoiFieldType.WIKIDATA, value);
                    continue;
                }
                if (field.equalsIgnoreCase("phone") || field.equalsIgnoreCase("tel") || field.equalsIgnoreCase("t\u00e9l\u00e9phone") || field.equalsIgnoreCase("\u05d8\u05dc\u05e4\u05d5\u05df") || field.equalsIgnoreCase("\u062a\u0644\u0641\u0646")) {
                    poiFields.put(PoiFieldType.PHONE, value);
                    poiShortDescription.append("\u260e tel:").append(value).append(". ");
                    continue;
                }
                if (field.equalsIgnoreCase("price") || field.equalsIgnoreCase("prezzo") || field.equalsIgnoreCase("\u05de\u05d7\u05d9\u05e8") || field.equalsIgnoreCase("prix") || field.equalsIgnoreCase("\u0628\u0647\u0627")) {
                    poiFields.put(PoiFieldType.PRICE, value);
                    poiShortDescription.append(value).append(". ");
                    continue;
                }
                if (field.equalsIgnoreCase("hours") || field.equalsIgnoreCase("\u05e9\u05e2\u05d5\u05ea") || field.equalsIgnoreCase("\u0633\u0627\u0639\u062a\u200c\u0647\u0627")) {
                    poiFields.put(PoiFieldType.WORK_HOURS, value);
                    poiShortDescription.append("Working hours: ").append(value).append(". ");
                    continue;
                }
                if (field.equalsIgnoreCase("directions") || field.equalsIgnoreCase("direction") || field.equalsIgnoreCase("\u05d4\u05d5\u05e8\u05d0\u05d5\u05ea") || field.equalsIgnoreCase("\u0645\u0633\u06cc\u0631\u0647\u0627")) {
                    poiFields.put(PoiFieldType.DIRECTIONS, value);
                    poiShortDescription.append(value).append(". ");
                    continue;
                }
                if (field.equalsIgnoreCase("indicazioni")) {
                    poiFields.put(PoiFieldType.DIRECTIONS, value);
                    poiShortDescription.append("Indicazioni: ").append(value).append(". ");
                    continue;
                }
                if (field.equalsIgnoreCase("orari")) {
                    poiFields.put(PoiFieldType.WORK_HOURS, value);
                    poiShortDescription.append("Orari: ").append(value).append(". ");
                    continue;
                }
                if (field.equalsIgnoreCase("horaire")) {
                    poiFields.put(PoiFieldType.WORK_HOURS, value);
                    poiShortDescription.append("Horaire: ").append(value).append(". ");
                    continue;
                }
                if (field.equalsIgnoreCase("funcionamento")) {
                    poiFields.put(PoiFieldType.WORK_HOURS, value);
                    poiShortDescription.append("Funcionamento: ").append(value).append(". ");
                    continue;
                }
                if (!field.equalsIgnoreCase("wikipedia") || value.equals("undefined") || value.isEmpty()) continue;
                poiFields.put(PoiFieldType.WIKIPEDIA, value);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return poiShortDescription;
    }

    public static String appendSqareBracketsIfNeeded(int i, String[] parts, String value) {
        while (StringUtils.countMatches((CharSequence)value, (CharSequence)"[[") > StringUtils.countMatches((CharSequence)value, (CharSequence)"]]") && i + 1 < parts.length) {
            value = (String)value + "|" + parts[++i];
        }
        return value;
    }

    private static PoiFieldCategory transformCategory(String[] info) {
        PoiFieldCategory res = PoiFieldCategory.OTHER;
        for (int i = 0; i < info.length; ++i) {
            String key;
            int ind = info[i].indexOf(61);
            if (ind < 0 || !(key = info[i].substring(0, ind).trim()).equals("type") && !key.equals("tipo") && !key.equals("group")) continue;
            String val = info[i].substring(ind + 1).toLowerCase().trim();
            block1: for (PoiFieldCategory p : PoiFieldCategory.values()) {
                for (String s : p.names) {
                    if (!val.contains(s)) continue;
                    res = p;
                    break;
                }
                for (String s : p.types) {
                    if (!val.contains(s)) continue;
                    res = p;
                    continue block1;
                }
            }
            if (res != PoiFieldCategory.OTHER) {
                return res;
            }
            Integer it = POI_OTHER_TYPES.get(val);
            POI_OTHER_TYPES.put(val, it == null ? 1 : it + 1);
        }
        return res;
    }

    private static PoiFieldCategory isPOIKey(String str, String lang) {
        if (str.startsWith("listing") || str.startsWith("vcard")) {
            return WikiDatabasePreparation.transformCategory(str.split("\\|"));
        }
        for (PoiFieldCategory p : PoiFieldCategory.values()) {
            for (String s : p.names) {
                if (!str.startsWith(s)) continue;
                return p;
            }
        }
        return null;
    }

    private static EnumSet<WikivoyageLangPreparation.WikivoyageTemplates> getKey(String str, String lang) {
        if (str.startsWith("geo|") || str.startsWith("geo ") || str.startsWith("geodata")) {
            return EnumSet.of(WikivoyageLangPreparation.WikivoyageTemplates.LOCATION);
        }
        if (str.startsWith("ispartof") || str.startsWith("partofitinerary") || str.startsWith("isin") || str.startsWith("dans") || str.startsWith("footer|") || str.startsWith("istinkat") || str.startsWith("istin|") || str.startsWith("istin ") || str.startsWith("estaen") || str.startsWith("est\u00e1en") || str.startsWith("sijainti|") || str.startsWith("sijainti ") || str.startsWith("th\u00e8me|") || str.startsWith("th\u00e8me ") || str.startsWith("fica em") || str.startsWith("est\u00e1en") || str.startsWith("\u05e7\u05d8\u05d2\u05d5\u05e8\u05d9\u05d4") || str.startsWith("\u03b5\u03af\u03bd\u03b1\u03b9\u03c4\u03bc\u03ae\u03bc\u03b1\u03c4\u03bf\u03c5") || str.startsWith("\u03b5\u03af\u03bd\u03b1\u03b9\u03c4\u03bc\u03ae\u03bc\u03b1\u03c4\u03b7\u03c2") || str.startsWith("jest w") || str.startsWith("itiner\u00e1rio em") || str.startsWith("partoftopic") || str.startsWith("theme ") || str.startsWith("theme|") || str.startsWith("categor\u00eda") || str.startsWith("\u0628\u062e\u0634\u06cc") || str.startsWith("\u4f4d\u4e8e|") || str.startsWith("\u4f4d\u4e8e ")) {
            return EnumSet.of(WikivoyageLangPreparation.WikivoyageTemplates.PART_OF);
        }
        if (str.startsWith("quickfooter")) {
            return EnumSet.of(WikivoyageLangPreparation.WikivoyageTemplates.QUICK_FOOTER);
        }
        if (str.startsWith("navigation ") && lang.equals("de")) {
            return EnumSet.noneOf(WikivoyageLangPreparation.WikivoyageTemplates.class);
        }
        if (str.startsWith("info guide linguistique") || str.startsWith("conversa\u00e7\u00e3o") || str.startsWith("frasario")) {
            return EnumSet.of(WikivoyageLangPreparation.WikivoyageTemplates.PHRASEBOOK);
        }
        if (str.startsWith("info maladie")) {
            return EnumSet.noneOf(WikivoyageLangPreparation.WikivoyageTemplates.class);
        }
        if (str.startsWith("info ")) {
            return EnumSet.of(WikivoyageLangPreparation.WikivoyageTemplates.LOCATION, WikivoyageLangPreparation.WikivoyageTemplates.BANNER);
        }
        if (str.startsWith("quickbar") && (str.contains("lat=") || str.contains("lon=") || str.contains("long=") || str.contains("longitude="))) {
            return EnumSet.of(WikivoyageLangPreparation.WikivoyageTemplates.LOCATION, WikivoyageLangPreparation.WikivoyageTemplates.BANNER);
        }
        if (str.startsWith("pagebanner") || str.startsWith("citybar") || str.startsWith("quickbar ") || str.startsWith("banner") || str.startsWith("\u05d1\u05d0\u05e0\u05e8") || str.startsWith("\u0633\u0631\u0635\u0641\u062d\u0647")) {
            return EnumSet.of(WikivoyageLangPreparation.WikivoyageTemplates.BANNER);
        }
        if (str.startsWith("regionlist")) {
            return EnumSet.of(WikivoyageLangPreparation.WikivoyageTemplates.REGION_LIST);
        }
        if (str.startsWith("warningbox")) {
            return EnumSet.of(WikivoyageLangPreparation.WikivoyageTemplates.WARNING);
        }
        if (str.startsWith("cite")) {
            return EnumSet.of(WikivoyageLangPreparation.WikivoyageTemplates.CITATION);
        }
        if (str.startsWith("iata") || str.startsWith("formatnum")) {
            return EnumSet.of(WikivoyageLangPreparation.WikivoyageTemplates.TWO_PART);
        }
        if (str.startsWith("station") || str.startsWith("rint")) {
            return EnumSet.of(WikivoyageLangPreparation.WikivoyageTemplates.STATION);
        }
        if (str.startsWith("ipa") || str.startsWith("lang-")) {
            return EnumSet.of(WikivoyageLangPreparation.WikivoyageTemplates.TRANSLATION);
        }
        if (str.startsWith("disamb") || str.startsWith("disambiguation") || str.trim().equals("dp") || str.startsWith("\u043d\u0435\u043e\u0434\u043d\u043e\u0437\u043d\u0430\u0447\u043d\u043e\u0441\u0442\u044c") || str.startsWith("desambiguaci\u00f3n") || str.startsWith("ujednoznacznienie") || str.startsWith("homonymie") || str.startsWith("desamb") || str.startsWith("\u0627\u0628\u0647\u0627\u0645 \u0632\u062f\u0627\u06cc\u06cc") || str.startsWith("\u6d88\u6b67\u4e49") || str.startsWith("\u6d88\u6b67\u7fa9") || str.startsWith("t\u00e4smennys") || str.startsWith("f\u00f6rgrening") || str.startsWith("msg:disamb") || str.startsWith("wegweiser") || str.startsWith("begriffskl\u00e4rung")) {
            return EnumSet.of(WikivoyageLangPreparation.WikivoyageTemplates.DISAMB);
        }
        if (str.startsWith("guidephrasebook") || str.startsWith("partofphrasebook") || str.startsWith("phrasebookguide")) {
            return EnumSet.of(WikivoyageLangPreparation.WikivoyageTemplates.PHRASEBOOK);
        }
        if (str.startsWith("monument-title")) {
            return EnumSet.of(WikivoyageLangPreparation.WikivoyageTemplates.MONUMENT_TITLE);
        }
        HashSet<String> parts = new HashSet<String>(Arrays.asList(str.split("\\|")));
        if (parts.contains("convert") || parts.contains("unit\u00e9")) {
            return EnumSet.of(WikivoyageLangPreparation.WikivoyageTemplates.METRIC_DATA);
        }
        parts.retainAll(unitsOfDistance);
        if (!parts.isEmpty()) {
            return EnumSet.of(WikivoyageLangPreparation.WikivoyageTemplates.METRIC_DATA);
        }
        return EnumSet.noneOf(WikivoyageLangPreparation.WikivoyageTemplates.class);
    }

    public static String getRedirect(StringBuilder ctext) {
        String textStr = ctext.toString().trim().toLowerCase();
        if (textStr.startsWith("#redirect") || textStr.startsWith("#weiterleitung") || textStr.startsWith("#\u043f\u0435\u0440\u0435\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435") || textStr.startsWith("#patrz") || textStr.startsWith("#\u043f\u0435\u0440\u0435\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u044f") || textStr.startsWith("#doorverwijzing") || textStr.startsWith("__disambig_") || textStr.startsWith("#redirecionamento") || textStr.startsWith("#rinvia") || textStr.startsWith("#uudelleenohjaus") || textStr.startsWith("#redirecci\u00f3n") || textStr.startsWith("#omdirigering") || textStr.startsWith("#ohjaus") || textStr.startsWith("#\u03b1\u03bd\u03b1\u03ba\u03b1\u03c4\u03b5\u03c5\u03b8\u03c5\u03bd\u03c3\u03b7") || textStr.startsWith("#\u062a\u063a\u06cc\u06cc\u0631_\u0645\u0633\u06cc\u0631") || textStr.startsWith("#\u05d4\u05e4\u05e0\u05d9\u05d4") || textStr.startsWith("#\u062a\u063a\u06cc\u06cc\u0631\u0645\u0633\u06cc\u0631") || textStr.startsWith("#\u0111\u1ed5i") || textStr.startsWith("#\u91cd\u5b9a\u5411") || textStr.startsWith("#\u092a\u0941\u0928\u0930\u094d\u092a\u094d\u0930\u0947\u0937\u093f\u0924") || textStr.startsWith("#\u0905\u0928\u0941\u092a\u094d\u0930\u0947\u0937\u093f\u0924")) {
            int l = textStr.indexOf("[[");
            int e = textStr.indexOf("]]");
            if (l > 0 && e > 0) {
                return ctext.substring(l + 2, e).trim();
            }
        }
        return null;
    }

    public static void mainTestPage(String[] args) throws IOException, SQLException {
        StringBuilder input = Algorithms.readFromInputStream((InputStream)WikiDatabasePreparation.class.getResourceAsStream("/page.txt"));
        TreeMap<WikivoyageLangPreparation.WikivoyageTemplates, List<String>> macros = new TreeMap<WikivoyageLangPreparation.WikivoyageTemplates, List<String>>();
        ArrayList<Map<PoiFieldType, Object>> pois = new ArrayList<Map<PoiFieldType, Object>>();
        String lang = "de";
        String title = "page";
        CustomWikiModel wikiModel = new CustomWikiModel("https://" + lang + ".wikipedia.org/wiki/${image}", "https://" + lang + ".wikipedia.org/wiki/${title}", null, true);
        String rawWikiText = WikiDatabasePreparation.removeMacroBlocks(input, null, macros, pois, lang, title, null, null);
        System.out.println(WikiDatabasePreparation.getShortDescr(rawWikiText, wikiModel));
        List<String> lst = macros.get((Object)WikivoyageLangPreparation.WikivoyageTemplates.POI);
        if (lst != null) {
            // empty if block
        }
    }

    public static void main(String[] args) throws IOException, ParserConfigurationException, SAXException, SQLException, ComponentLookupException, XmlPullParserException, InterruptedException {
        if (args.length == 1 && args[0].equals("testRun")) {
            WikiDatabasePreparation.mainTestPage(args);
            return;
        }
        String lang = "";
        String wikipediaFolder = "";
        String wikidataFolder = "";
        String mode = "";
        long testArticleID = 0L;
        String resultDB = "";
        Object wikipediaSqliteName = "";
        String wikidataSqliteName = "";
        for (String arg : args) {
            String val = arg.substring(arg.indexOf("=") + 1);
            if (arg.startsWith("--lang=")) {
                lang = val;
                continue;
            }
            if (arg.startsWith("--dir=")) {
                wikipediaFolder = val;
                wikidataFolder = val;
                continue;
            }
            if (arg.startsWith("--mode=")) {
                mode = val;
                continue;
            }
            if (arg.startsWith("--testID=")) {
                testArticleID = Long.parseLong(val);
                continue;
            }
            if (!arg.startsWith("--result_db=")) continue;
            resultDB = val;
        }
        if (mode.isEmpty()) {
            throw new RuntimeException("Correct arguments weren't supplied. --mode= is not set");
        }
        if (mode.equals("process-wikipedia") || mode.equals("test-wikipedia")) {
            if (wikipediaFolder.isEmpty()) {
                throw new RuntimeException("Correct arguments weren't supplied. --dir= is not set");
            }
            if (lang.isEmpty()) {
                throw new RuntimeException("Correct arguments weren't supplied. --lang= is not set");
            }
            Object object = wikipediaSqliteName = resultDB.isEmpty() ? wikipediaFolder + WIKIPEDIA_SQLITE : resultDB;
        }
        if (mode.equals("create-wikidata") || mode.equals("test-wikidata") || mode.equals("update-wikidata") || mode.equals("create-osm-wikidata")) {
            if (resultDB.isEmpty()) {
                throw new RuntimeException("Correct arguments weren't supplied. --result_db= is not set");
            }
            if (wikidataFolder.isEmpty()) {
                throw new RuntimeException("Correct arguments weren't supplied. --dir= is not set");
            }
            wikidataSqliteName = resultDB;
        }
        if (mode.equals("create-wikidata-mapping")) {
            if (wikidataFolder.isEmpty()) {
                throw new RuntimeException("Correct arguments weren't supplied. --dir= is not set");
            }
            if (resultDB.isEmpty()) {
                throw new RuntimeException("Correct arguments weren't supplied. --result_db= is not set");
            }
            wikidataSqliteName = resultDB;
        }
        String pathToWikiData = wikidataFolder + WIKIDATA_ARTICLES_GZ;
        OsmCoordinatesByTag osmCoordinates = new OsmCoordinatesByTag(new String[]{"wikipedia", "wikidata"}, new String[]{"wikipedia:"});
        switch (mode) {
            case "process-wikidata-regions": {
                WikiDatabasePreparation.processWikidataRegions(wikidataSqliteName);
                break;
            }
            case "create-wikidata": {
                File wikiDB = new File(wikidataSqliteName);
                if (!new File(pathToWikiData).exists()) {
                    throw new RuntimeException("Wikidata dump doesn't exist:" + pathToWikiData);
                }
                if (wikiDB.exists()) {
                    wikiDB.delete();
                }
                String wikidataFile = wikidataFolder + WIKIDATA_ARTICLES_GZ;
                File wikidataDB = new File(wikidataSqliteName);
                log.info((Object)"Process OSM coordinates...");
                osmCoordinates.parse(wikidataDB.getParentFile());
                log.info((Object)"Create wikidata...");
                WikiDatabasePreparation.processWikidata(wikidataDB, wikidataFile, osmCoordinates, 0L, -1L);
                WikiDatabasePreparation.createOSMWikidataTable(wikidataDB, osmCoordinates);
                break;
            }
            case "create-osm-wikidata": {
                File wikidataDB = new File(wikidataSqliteName);
                log.info((Object)"Process OSM coordinates...");
                osmCoordinates.parse(wikidataDB.getParentFile());
                log.info((Object)"Create table mapping osm to wikidata...");
                WikiDatabasePreparation.createOSMWikidataTable(wikidataDB, osmCoordinates);
                break;
            }
            case "update-wikidata": {
                File wikidataDB = new File(wikidataSqliteName);
                WikiDatabasePreparation.updateWikidata(osmCoordinates, wikidataDB, false);
                break;
            }
            case "update-wikidata-daily": {
                File wikidataDB = new File(wikidataSqliteName);
                WikiDatabasePreparation.updateWikidata(osmCoordinates, wikidataDB, true);
                break;
            }
            case "process-wikipedia": {
                log.info((Object)"Processing wikipedia...");
                WikiDatabasePreparation.processWikipedia(wikipediaFolder, (String)wikipediaSqliteName, lang, 0L);
                break;
            }
            case "test-wikipedia": {
                WikiDatabasePreparation.processWikipedia(wikipediaFolder, (String)wikipediaSqliteName, lang, testArticleID);
                break;
            }
            case "test-wikidata": {
                File wikidataDB = new File(wikidataSqliteName + ".test");
                log.info((Object)"Create wikidata...");
                WikiDatabasePreparation.processWikidata(wikidataDB, wikidataFolder + WIKIDATA_ARTICLES_GZ, osmCoordinates, 0L, 10000L);
                WikiDatabasePreparation.createOSMWikidataTable(wikidataDB, osmCoordinates);
                break;
            }
            case "create-wikidata-mapping": {
                File wikidataDB = new File(wikidataSqliteName);
                log.info((Object)"Create wikidata mapping DB.");
                WikiDatabasePreparation.createWikidataMapping(wikidataDB, wikidataFolder);
            }
        }
    }

    private static void updateWikidata(OsmCoordinatesByTag osmCoordinates, File wikidataDB, boolean dailyUpdate) throws SQLException, ParserConfigurationException, SAXException, IOException {
        log.info((Object)"Process OSM coordinates...");
        osmCoordinates.parse(wikidataDB.getParentFile());
        WikidataFilesDownloader wfd = new WikidataFilesDownloader(wikidataDB, dailyUpdate);
        List<String> downloadedPageFiles = wfd.getDownloadedPageFiles();
        long maxQId = wfd.getMaxQId();
        log.info((Object)"Updating wikidata...");
        for (String fileName : downloadedPageFiles) {
            log.info((Object)("Updating from " + fileName));
            WikiDatabasePreparation.processWikidata(wikidataDB, fileName, osmCoordinates, maxQId, -1L);
        }
        wfd.removeDownloadedPages();
        WikiDatabasePreparation.createOSMWikidataTable(wikidataDB, osmCoordinates);
    }

    protected static void processWikidataRegions(String sqliteFileName) throws SQLException, IOException {
        File wikiDB = new File(sqliteFileName);
        log.info((Object)"Processing wikidata regions...");
        DBDialect dialect = DBDialect.SQLITE;
        Connection conn = dialect.getDatabaseConnection(wikiDB.getAbsolutePath(), log);
        OsmandRegions regions = new OsmandRegions();
        regions.prepareFile();
        regions.cacheAllCountries();
        PreparedStatement wikiRegionPrep = conn.prepareStatement("INSERT OR IGNORE INTO wiki_region(id, regionName) VALUES(?, ? )");
        ResultSet rs = conn.createStatement().executeQuery("SELECT id from wiki_region");
        TreeSet<Long> existingIds = new TreeSet<Long>();
        while (rs.next()) {
            existingIds.add(rs.getLong(1));
        }
        rs.close();
        rs = conn.createStatement().executeQuery("SELECT id, lat, lon from wiki_coords");
        int batch = 0;
        List rgs = new ArrayList();
        while (rs.next()) {
            if (existingIds.contains(rs.getLong(1))) continue;
            rgs = regions.getRegionsToDownload(rs.getDouble(2), rs.getDouble(3), rgs);
            for (String reg : rgs) {
                wikiRegionPrep.setLong(1, rs.getLong(1));
                wikiRegionPrep.setString(2, reg);
                wikiRegionPrep.addBatch();
                if (batch++ <= 5000) continue;
                wikiRegionPrep.executeBatch();
                batch = 0;
            }
        }
        wikiRegionPrep.executeBatch();
        rs.close();
        wikiRegionPrep.close();
        conn.close();
    }

    public static void downloadPage(String page, String fl) throws IOException {
        int read;
        URL url = new URL(page);
        FileOutputStream fout = new FileOutputStream(new File(fl));
        InputStream in = url.openStream();
        byte[] buf = new byte[1024];
        while ((read = in.read(buf)) != -1) {
            fout.write(buf, 0, read);
        }
        in.close();
        fout.close();
    }

    protected static void testContent(String lang, String folder) throws SQLException, IOException {
        Connection conn = DBDialect.SQLITE.getDatabaseConnection(folder + lang + WIKIPEDIA_SQLITE, log);
        ResultSet rs = conn.createStatement().executeQuery("SELECT * from wiki");
        while (rs.next()) {
            String s;
            double lat = rs.getDouble("lat");
            double lon = rs.getDouble("lon");
            byte[] zp = rs.getBytes("zipContent");
            String title = rs.getString("title");
            BufferedReader rd = new BufferedReader(new InputStreamReader(new GZIPInputStream(new ByteArrayInputStream(zp))));
            System.out.println(title + " " + lat + " " + lon + " " + zp.length);
            while ((s = rd.readLine()) != null) {
                System.out.println(s);
            }
        }
    }

    public static void createOSMWikidataTable(File wikidataDB, OsmCoordinatesByTag c) throws SQLException {
        Connection commonsWikiConn = DBDialect.SQLITE.getDatabaseConnection(wikidataDB.getAbsolutePath(), log);
        Statement st = commonsWikiConn.createStatement();
        ResultSet rs = st.executeQuery("SELECT C.id,M.lang,M.title FROM wiki_coords C LEFT JOIN wiki_mapping M ON M.id=C.id");
        TreeMap<Long, OsmCoordinatesByTag.OsmLatLonId> res = new TreeMap<Long, OsmCoordinatesByTag.OsmLatLonId>();
        int scan = 0;
        long time = System.currentTimeMillis();
        while (rs.next()) {
            long wid = rs.getLong(1);
            String articleLang = rs.getString(2);
            String articleTitle = rs.getString(3);
            if (++scan % 500000 == 0) {
                System.out.println("Scanning wiki to merge with OSM... " + scan + " " + (System.currentTimeMillis() - time) + " ms");
                time = System.currentTimeMillis();
            }
            if (articleLang != null) {
                WikiDatabasePreparation.setWikidataId(res, c.getCoordinates("wikipedia:" + articleLang, articleTitle), wid);
                WikiDatabasePreparation.setWikidataId(res, c.getCoordinates("wikipedia", articleLang + ":" + articleTitle), wid);
                WikiDatabasePreparation.setWikidataId(res, c.getCoordinates("wikipedia", articleTitle), wid);
            }
            WikiDatabasePreparation.setWikidataId(res, c.getCoordinates("wikidata", "Q" + wid), wid);
        }
        try {
            commonsWikiConn.createStatement().executeQuery("DROP TABLE osm_wikidata");
        }
        catch (SQLException e) {
            System.err.println("Table osm_wikidata doesn't exist");
        }
        st.execute("CREATE TABLE osm_wikidata(osmid bigint, osmtype int, wikidataid bigint, lat double, long double,\ntags string, poitype string, poisubtype string, wikiCommonsImg string, wikiCommonsCat string)");
        st.close();
        PreparedStatement ps = commonsWikiConn.prepareStatement("INSERT INTO osm_wikidata VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        int batch = 0;
        for (OsmCoordinatesByTag.OsmLatLonId o : res.values()) {
            ps.setLong(1, o.id);
            ps.setInt(2, o.type);
            ps.setLong(3, o.wikidataId);
            ps.setDouble(4, o.lat);
            ps.setDouble(5, o.lon);
            ps.setString(6, o.tagsJson);
            ps.setString(7, o.amenity == null ? null : o.amenity.getType().getKeyName());
            ps.setString(8, o.amenity == null ? null : o.amenity.getSubType());
            ps.setString(9, o.wikiCommonsImg);
            ps.setString(10, o.wikiCommonsCat);
            ps.addBatch();
            if (batch++ < 1000) continue;
            ps.executeBatch();
        }
        ps.executeBatch();
        ps.close();
        commonsWikiConn.close();
    }

    public static void createWikidataMapping(File sourceDb, String wikidataFolder) throws SQLException {
        Connection srcConn = DBDialect.SQLITE.getDatabaseConnection(sourceDb.getAbsolutePath(), log);
        Statement srcSt = srcConn.createStatement();
        ResultSet rs = srcSt.executeQuery("SELECT id, lang, title FROM wiki_mapping");
        File mappingFile = new File(wikidataFolder, WIKIDATA_MAPPING_SQLITE);
        if (mappingFile.exists()) {
            mappingFile.delete();
        }
        Connection mappingConn = DBDialect.SQLITE.getDatabaseConnection(mappingFile.getAbsolutePath(), log);
        Statement mapSt = mappingConn.createStatement();
        mapSt.execute("DROP TABLE IF EXISTS wiki_mapping");
        mapSt.execute("CREATE TABLE wiki_mapping(id LONG, lang TEXT, title TEXT)");
        mapSt.execute("CREATE INDEX IF NOT EXISTS idx_wm_id ON wiki_mapping(id)");
        mapSt.execute("CREATE INDEX IF NOT EXISTS idx_wm_lang_title ON wiki_mapping(lang, title)");
        PreparedStatement ps = mappingConn.prepareStatement("INSERT INTO wiki_mapping(id, lang, title) VALUES(?, ?, ?)");
        int batch = 0;
        while (rs.next()) {
            ps.setLong(1, rs.getLong("id"));
            ps.setString(2, rs.getString("lang"));
            ps.setString(3, rs.getString("title"));
            ps.addBatch();
            if (++batch % 1000 != 0) continue;
            ps.executeBatch();
        }
        ps.executeBatch();
        ps.close();
        mapSt.close();
        mappingConn.close();
        srcSt.close();
        srcConn.close();
    }

    private static void setWikidataId(Map<Long, OsmCoordinatesByTag.OsmLatLonId> mp, OsmCoordinatesByTag.OsmLatLonId c, long wid) {
        if (c != null) {
            c.wikidataId = wid;
            WikiDatabasePreparation.setWikidataId(mp, c.next, wid);
            mp.put((long)c.type + (c.id << 2), c);
        }
    }

    public static void processWikipedia(String wikipediaFolder, String wikipediaSqliteFileName, String lang, long testArticleId) throws ParserConfigurationException, SAXException, IOException, SQLException {
        File wikipediaSqlite = new File(wikipediaSqliteFileName);
        String wikiFile = wikipediaFolder + lang + WIKI_ARTICLES_GZ;
        SAXParser sx = SAXParserFactory.newInstance().newSAXParser();
        FileProgressImplementation progress = new FileProgressImplementation("Read wikipedia file", new File(wikiFile));
        InputStream streamFile = progress.openFileInputStream();
        InputSource is = WikiDatabasePreparation.getInputSource(streamFile);
        WikipediaHandler handler = new WikipediaHandler(sx, progress, lang, wikipediaSqlite, testArticleId);
        sx.parse(is, (DefaultHandler)handler);
        handler.finish();
    }

    public static void processWikidata(File wikidataSqlite, String wikidataFile, OsmCoordinatesByTag osmCoordinates, long lastProcessedId, long limit) throws ParserConfigurationException, SAXException, IOException, SQLException {
        SAXParser sx = SAXParserFactory.newInstance().newSAXParser();
        FileProgressImplementation progress = new FileProgressImplementation("Read wikidata file", new File(wikidataFile));
        InputStream streamFile = progress.openFileInputStream();
        InputSource is = WikiDatabasePreparation.getInputSource(streamFile);
        OsmandRegions regions = new OsmandRegions();
        regions.prepareFile();
        regions.cacheAllCountries();
        WikiDataHandler handler = new WikiDataHandler(sx, progress, wikidataSqlite, osmCoordinates, regions, lastProcessedId);
        handler.setLimit(limit);
        try {
            sx.parse(is, (DefaultHandler)handler);
        }
        catch (IllegalStateException e) {
            System.out.println("Stopped by limit " + e.getMessage());
        }
        handler.finish();
        osmCoordinates.closeConnection();
    }

    private static InputSource getInputSource(InputStream streamFile) throws IOException {
        GZIPInputStream zis = new GZIPInputStream(streamFile);
        InputStreamReader reader = new InputStreamReader((InputStream)zis, "UTF-8");
        InputSource is = new InputSource(reader);
        is.setEncoding("UTF-8");
        return is;
    }

    public static String getShortDescr(String rawWikiText, CustomWikiModel wikiModel) throws IOException {
        PlainTextConverter converter = new PlainTextConverter(false);
        rawWikiText = rawWikiText.trim();
        while (rawWikiText.startsWith("[")) {
            int last = -1;
            int cnt = 0;
            for (int i = 0; i < rawWikiText.length(); ++i) {
                if (rawWikiText.charAt(i) == '[') {
                    ++cnt;
                    continue;
                }
                if (rawWikiText.charAt(i) != ']' || --cnt != 0) continue;
                last = i + 1;
                break;
            }
            if (last == -1) {
                return "";
            }
            rawWikiText = rawWikiText.substring(last).trim();
        }
        String plainStr = wikiModel.render((ITextConverter)converter, rawWikiText);
        if (plainStr != null) {
            plainStr = plainStr.trim();
            int si = plainStr.indexOf(10);
            while (si < 250 && si >= 0) {
                int ni;
                if (si < 10) {
                    plainStr = plainStr.substring(si).trim();
                    si = -1;
                }
                if ((ni = plainStr.indexOf(10, si + 1)) > 500 && si > 0) break;
                si = ni;
            }
            if (si > 0) {
                plainStr = plainStr.substring(0, si).trim();
            }
            plainStr = plainStr.replace("[\u02c8]", "");
            plainStr = plainStr.replace("[]", "");
            plainStr = plainStr.replace("()", "");
        }
        return plainStr;
    }

    public static String generateHtmlArticle(String text, CustomWikiModel wikiModel) throws IOException {
        HTMLConverter converter = new HTMLConverter(false);
        String plainStr = wikiModel.render((ITextConverter)converter, text);
        plainStr = plainStr.replaceAll("<p>div class=&#34;content&#34;", "<div class=\"content\">\n<p>").replaceAll("<p>/div\n</p>", "</div>");
        return plainStr;
    }

    public static double getDistance(double lat1, double lon1, double lat2, double lon2) {
        double R = 6372.8;
        double dLat = WikiDatabasePreparation.toRadians(lat2 - lat1);
        double dLon = WikiDatabasePreparation.toRadians(lon2 - lon1);
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(WikiDatabasePreparation.toRadians(lat1)) * Math.cos(WikiDatabasePreparation.toRadians(lat2)) * Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0);
        return 2.0 * R * 1000.0 * Math.asin(Math.sqrt(a));
    }

    private static double toRadians(double angdeg) {
        return angdeg / 180.0 * Math.PI;
    }

    public static interface WikiDBBrowser {
        public LatLon getLocation(String var1, String var2, long var3) throws SQLException;

        public String getWikipediaTitleByWid(String var1, long var2) throws SQLException;
    }

    public static enum PoiFieldType {
        NAME,
        PHONE,
        WEBSITE,
        WORK_HOURS,
        PRICE,
        DIRECTIONS,
        WIKIPEDIA,
        WIKIDATA,
        FAX,
        EMAIL,
        DESCRIPTION,
        LON,
        LAT,
        ADDRESS,
        AREA_CODE,
        CATEGORY,
        LATLON;

    }

    public static class WikipediaHandler
    extends DefaultHandler {
        long counter = 1L;
        private final SAXParser saxParser;
        private boolean page = false;
        private boolean revision = false;
        private long namespace = 0L;
        private StringBuilder ctext = null;
        private StringBuilder title = new StringBuilder();
        private StringBuilder text = new StringBuilder();
        private StringBuilder pageId = new StringBuilder();
        private DBDialect dialect = DBDialect.SQLITE;
        private Connection conn;
        private final WikiImageUrlStorage imageUrlStorage;
        private PreparedStatement insertPrep;
        private PreparedStatement selectPrep;
        private int batch = 0;
        private static final int BATCH_SIZE = 1000;
        private static final long ARTICLES_BATCH = 1000L;
        final ByteArrayOutputStream bous = new ByteArrayOutputStream(64000);
        private String lang;
        private FileProgressImplementation progIS;
        private long cid;

        WikipediaHandler(SAXParser saxParser, FileProgressImplementation progIS, String lang, File wikipediaSqlite, long testArticleId) throws SQLException {
            this.lang = lang;
            this.saxParser = saxParser;
            this.progIS = progIS;
            this.conn = this.dialect.getDatabaseConnection(wikipediaSqlite.getAbsolutePath(), log);
            log.info((Object)"Prepare wiki_content table");
            this.conn.createStatement().execute("CREATE TABLE IF NOT EXISTS wiki_content(id long, title text, lang text, shortDescription text, redirect text, zipContent blob)");
            this.conn.createStatement().execute("CREATE INDEX IF NOT EXISTS id_wiki_content ON wiki_content(id)");
            this.conn.createStatement().execute("CREATE INDEX IF NOT EXISTS lang_title_wiki_content ON wiki_content (lang, title)");
            this.conn.createStatement().execute("DELETE FROM wiki_content WHERE lang = '" + lang + "'");
            this.insertPrep = this.conn.prepareStatement("INSERT INTO wiki_content(id, title, lang, shortDescription, redirect, zipContent) VALUES (?, ?, ?, ?, ?, ?)");
            this.selectPrep = this.conn.prepareStatement("SELECT id FROM wiki_mapping WHERE wiki_mapping.title = ? AND wiki_mapping.lang = ?");
            this.imageUrlStorage = new WikiImageUrlStorage(this.conn, wikipediaSqlite.getParent(), lang);
            log.info((Object)"Tables are prepared");
        }

        public void addBatch() throws SQLException {
            this.insertPrep.addBatch();
            if (this.batch++ > 1000) {
                this.insertPrep.executeBatch();
                this.batch = 0;
            }
        }

        public void finish() throws SQLException {
            this.insertPrep.executeBatch();
            if (!this.conn.getAutoCommit()) {
                this.conn.commit();
            }
            this.selectPrep.close();
            this.insertPrep.close();
            this.conn.close();
        }

        public int getCount() {
            return (int)(this.counter - 1L);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            String name;
            String string = name = this.saxParser.isNamespaceAware() ? localName : qName;
            if (!this.page) {
                this.page = name.equals("page");
            } else if (name.equals("title")) {
                this.title.setLength(0);
                this.ctext = this.title;
            } else if (name.equals("text")) {
                this.text.setLength(0);
                this.ctext = this.text;
            } else if (name.equals("ns")) {
                this.ctext = new StringBuilder();
            } else if (name.equals("revision")) {
                this.revision = true;
            } else if (name.equals("id") && !this.revision) {
                this.pageId.setLength(0);
                this.ctext = this.pageId;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.page && this.ctext != null) {
                this.ctext.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            block16: {
                String name = this.saxParser.isNamespaceAware() ? localName : qName;
                try {
                    if (!this.page) break block16;
                    this.progIS.update();
                    if (name.equals("page")) {
                        this.page = false;
                        break block16;
                    }
                    if (name.equals("title")) {
                        this.ctext = null;
                        break block16;
                    }
                    if (name.equals("revision")) {
                        this.revision = false;
                        break block16;
                    }
                    if (name.equals("ns")) {
                        this.namespace = Long.parseLong(this.ctext.toString());
                        this.ctext = null;
                        break block16;
                    }
                    if (name.equals("id") && !this.revision) {
                        this.ctext = null;
                        this.cid = Long.parseLong(this.pageId.toString());
                        break block16;
                    }
                    if (!name.equals("text")) break block16;
                    long wikiId = 0L;
                    String plainStr = null;
                    String shortDescr = null;
                    if (this.namespace == 0L) {
                        this.selectPrep.setString(1, this.title.toString());
                        this.selectPrep.setString(2, this.lang);
                        ResultSet rs = this.selectPrep.executeQuery();
                        if (rs.next()) {
                            wikiId = rs.getLong(1);
                        }
                        rs.close();
                        this.selectPrep.clearParameters();
                    }
                    if (wikiId != 0L) {
                        try {
                            CustomWikiModel wikiModel = new CustomWikiModel("https://" + this.lang + ".wikipedia.org/wiki/${image}", "https://" + this.lang + ".wikipedia.org/wiki/${title}", this.imageUrlStorage, true);
                            String rawWikiText = WikiDatabasePreparation.removeMacroBlocks(this.ctext, null, new HashMap<WikivoyageLangPreparation.WikivoyageTemplates, List<String>>(), null, this.lang, this.title.toString(), null, null);
                            plainStr = WikiDatabasePreparation.generateHtmlArticle(rawWikiText, wikiModel);
                            shortDescr = WikiDatabasePreparation.getShortDescr(rawWikiText, wikiModel);
                        }
                        catch (RuntimeException e) {
                            log.error((Object)String.format("Error with article %d - %s : %s", this.cid, this.title, e.getMessage()), (Throwable)e);
                        }
                    }
                    if (plainStr != null) {
                        String redirect = WikiDatabasePreparation.getRedirect(this.ctext);
                        if (++this.counter % 1000L == 0L) {
                            log.info((Object)("Article accepted " + this.cid + " " + this.title.toString()));
                        }
                        try {
                            this.insertPrep.setLong(1, wikiId);
                            this.insertPrep.setString(2, this.title.toString());
                            this.insertPrep.setString(3, this.lang);
                            this.insertPrep.setString(4, shortDescr);
                            this.insertPrep.setString(5, redirect);
                            this.insertPrep.setBytes(6, this.gzip(plainStr));
                            this.addBatch();
                        }
                        catch (SQLException e) {
                            throw new SAXException(e);
                        }
                    }
                    this.ctext = null;
                }
                catch (IOException | SQLException e) {
                    throw new SAXException(e);
                }
            }
        }

        private byte[] gzip(String plainStr) throws IOException, UnsupportedEncodingException {
            this.bous.reset();
            GZIPOutputStream gzout = new GZIPOutputStream(this.bous);
            gzout.write((plainStr == null ? "" : plainStr).getBytes("UTF-8"));
            gzout.close();
            return this.bous.toByteArray();
        }
    }
}

