/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.binary;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.osmand.binary.BinaryMapAddressReaderAdapter;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapIndexReaderStats;
import net.osmand.binary.BinaryMapPoiReaderAdapter;
import net.osmand.data.Amenity;
import net.osmand.data.Building;
import net.osmand.data.City;
import net.osmand.data.MapObject;
import net.osmand.data.Street;
import net.osmand.util.Algorithms;
import org.json.JSONArray;
import org.json.JSONObject;

public class BinaryMapIndexTestReader
extends BinaryMapIndexReader {
    private List<Amenity> amenities = Collections.emptyList();
    private List<City> cities = Collections.emptyList();
    private List<City> matchedCities = Collections.emptyList();
    private List<City> streetCities = Collections.emptyList();

    private BinaryMapIndexTestReader() throws IOException {
        super(null, null, false);
        this.version = 2;
        this.dateCreated = System.currentTimeMillis();
    }

    public static BinaryMapIndexReader buildTestReader(File jsonFile) throws IOException {
        String sourceJsonText = Algorithms.getFileAsString((File)jsonFile);
        JSONObject sourceJson = null;
        if (!Algorithms.isEmpty((CharSequence)sourceJsonText)) {
            sourceJson = new JSONObject(sourceJsonText);
        }
        if (sourceJson == null) {
            return null;
        }
        BinaryMapIndexTestReader reader = new BinaryMapIndexTestReader();
        if (sourceJson.has("amenities")) {
            JSONArray amenitiesArr = sourceJson.getJSONArray("amenities");
            ArrayList<Amenity> amenities = new ArrayList<Amenity>();
            for (int i = 0; i < amenitiesArr.length(); ++i) {
                JSONObject amenityObj = amenitiesArr.getJSONObject(i);
                amenities.add(Amenity.parseJSON((JSONObject)amenityObj));
            }
            reader.amenities = amenities;
            BinaryMapPoiReaderAdapter.PoiRegion region = new BinaryMapPoiReaderAdapter.PoiRegion();
            region.name = Algorithms.getFileNameWithoutExtension((File)jsonFile);
            region.left31 = 0;
            region.top31 = 0;
            region.right31 = Integer.MAX_VALUE;
            region.bottom31 = Integer.MAX_VALUE;
            reader.poiIndexes.add(region);
            reader.indexes.add(region);
        }
        if (sourceJson.has("cities")) {
            JSONArray citiesArr = sourceJson.getJSONArray("cities");
            HashSet<CallSite> attributeTagsTable = new HashSet<CallSite>();
            ArrayList<City> cities = new ArrayList<City>();
            ArrayList<City> initCities = new ArrayList<City>();
            ArrayList<City> matchedCities = new ArrayList<City>();
            ArrayList<City> streetCities = new ArrayList<City>();
            for (int i = 0; i < citiesArr.length(); ++i) {
                JSONObject cityObj = citiesArr.getJSONObject(i);
                City city = City.parseJSON((JSONObject)cityObj);
                cities.add(city);
                if (cityObj.has("init")) {
                    initCities.add(city);
                }
                if (cityObj.has("matchCity")) {
                    matchedCities.add(city);
                }
                if (cityObj.has("matchStreet")) {
                    streetCities.add(city);
                }
                Set names = city.getNamesMap(false).keySet();
                for (String name : names) {
                    attributeTagsTable.add((CallSite)((Object)("name:" + name)));
                }
                for (Street street : city.getStreets()) {
                    names = street.getNamesMap(false).keySet();
                    for (String name : names) {
                        attributeTagsTable.add((CallSite)((Object)("name:" + name)));
                    }
                }
            }
            reader.cities = cities;
            reader.matchedCities = matchedCities;
            reader.streetCities = streetCities;
            BinaryMapAddressReaderAdapter.AddressRegion region = new BinaryMapAddressReaderAdapter.AddressRegion();
            region.name = Algorithms.getFileNameWithoutExtension((File)jsonFile);
            region.attributeTagsTable = new ArrayList(attributeTagsTable);
            reader.addressIndexes.add(region);
            reader.indexes.add(region);
        }
        return reader;
    }

    public List<Amenity> searchPoiByName(BinaryMapIndexReader.SearchRequest<Amenity> req) throws IOException {
        for (Amenity amenity : this.amenities) {
            req.publish((Object)amenity);
        }
        return req.getSearchResults();
    }

    public List<Amenity> searchPoi(BinaryMapIndexReader.SearchRequest<Amenity> req) throws IOException {
        for (Amenity amenity : this.amenities) {
            req.publish((Object)amenity);
        }
        return req.getSearchResults();
    }

    private static boolean compareType(City.CityType type, int blockType) {
        if (blockType == 0) {
            return type == City.CityType.BOUNDARY;
        }
        if (blockType == 1) {
            return type == City.CityType.CITY || type == City.CityType.TOWN;
        }
        if (blockType == 2) {
            return type == City.CityType.POSTCODE;
        }
        if (blockType == 3) {
            return type == City.CityType.VILLAGE || type == City.CityType.HAMLET || type == City.CityType.SUBURB;
        }
        throw new IllegalArgumentException("Not supported: " + type.name() + " == " + blockType);
    }

    public List<City> getCities(BinaryMapIndexReader.SearchRequest<City> resultMatcher, BinaryMapAddressReaderAdapter.CityBlocks type, BinaryMapAddressReaderAdapter.AddressRegion onlyRegion, BinaryMapIndexReaderStats.SearchStat stat) {
        ArrayList<City> cs = new ArrayList<City>();
        for (City city : this.cities) {
            if (!BinaryMapIndexTestReader.compareType(city.getType(), type.index)) continue;
            if (resultMatcher != null) {
                resultMatcher.publish((Object)city);
            }
            cs.add(city);
        }
        return cs;
    }

    public int preloadStreets(City c, BinaryMapIndexReader.SearchRequest<Street> resultMatcher, BinaryMapIndexReaderStats.SearchStat searchStat) throws IOException {
        return 0;
    }

    public void preloadBuildings(Street s, BinaryMapIndexReader.SearchRequest<Building> resultMatcher, BinaryMapIndexReaderStats.SearchStat searchStat) throws IOException {
    }

    public List<MapObject> searchAddressDataByName(BinaryMapIndexReader.SearchRequest<MapObject> req) throws IOException {
        for (City city : this.streetCities) {
            for (Street street : city.getStreets()) {
                req.publish((Object)street);
            }
        }
        for (City city : this.matchedCities) {
            req.publish((Object)city);
        }
        return req.getSearchResults();
    }

    public String getRegionName() {
        return "Test region";
    }

    public boolean containsPoiData(int left31x, int top31y, int right31x, int bottom31y) {
        return true;
    }

    public boolean containsMapData() {
        return true;
    }

    public boolean containsPoiData() {
        return true;
    }

    public boolean containsRouteData() {
        return true;
    }

    public boolean containsRouteData(int left31x, int top31y, int right31x, int bottom31y, int zoom) {
        return true;
    }

    public boolean containsMapData(int tile31x, int tile31y, int zoom) {
        return true;
    }

    public boolean containsMapData(int left31x, int top31y, int right31x, int bottom31y, int zoom) {
        return true;
    }

    public boolean containsAddressData() {
        return true;
    }
}

