/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.binary;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.WireFormat;
import gnu.trove.list.array.TByteArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.osmand.binary.BinaryIndexPart;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.data.IncompleteTransportRoute;
import net.osmand.data.TransportRoute;
import net.osmand.data.TransportSchedule;
import net.osmand.data.TransportStop;
import net.osmand.data.TransportStopExit;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.Way;
import net.osmand.util.MapUtils;
import net.osmand.util.TransliterationHelper;

public class BinaryMapTransportReaderAdapter {
    private CodedInputStream codedIS;
    private final BinaryMapIndexReader map;

    protected BinaryMapTransportReaderAdapter(BinaryMapIndexReader map) {
        this.codedIS = map.codedIS;
        this.map = map;
    }

    private void skipUnknownField(int t) throws IOException {
        this.map.skipUnknownField(t);
    }

    private long readInt() throws IOException {
        return this.map.readInt();
    }

    protected void readTransportIndex(TransportIndex ind) throws IOException {
        block8: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 3: {
                    this.skipUnknownField(t);
                    continue block8;
                }
                case 1: {
                    ind.setName(this.codedIS.readString());
                    continue block8;
                }
                case 6: {
                    ind.stopsFileLength = this.readInt();
                    ind.stopsFileOffset = this.codedIS.getTotalBytesRead();
                    long old = this.codedIS.pushLimitLong(ind.stopsFileLength);
                    this.readTransportBounds(ind);
                    this.codedIS.popLimit(old);
                    continue block8;
                }
                case 9: {
                    IndexStringTable st = new IndexStringTable();
                    st.length = this.codedIS.readRawVarint32();
                    st.fileOffset = this.codedIS.getTotalBytesRead();
                    ind.stringTable = st;
                    this.codedIS.seek((long)st.length + st.fileOffset);
                    continue block8;
                }
                case 8: {
                    ind.incompleteRoutesLength = this.codedIS.readRawVarint32();
                    ind.incompleteRoutesOffset = this.codedIS.getTotalBytesRead();
                    this.codedIS.seek(ind.incompleteRoutesLength + ind.incompleteRoutesOffset);
                    continue block8;
                }
            }
            this.skipUnknownField(t);
        }
    }

    private void readTransportBounds(TransportIndex ind) throws IOException {
        block7: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 1: {
                    ind.left = this.codedIS.readSInt32();
                    continue block7;
                }
                case 2: {
                    ind.right = this.codedIS.readSInt32();
                    continue block7;
                }
                case 3: {
                    ind.top = this.codedIS.readSInt32();
                    continue block7;
                }
                case 4: {
                    ind.bottom = this.codedIS.readSInt32();
                    continue block7;
                }
            }
            this.skipUnknownField(t);
        }
    }

    protected void searchTransportTreeBounds(int pleft, int pright, int ptop, int pbottom, BinaryMapIndexReader.SearchRequest<TransportStop> req, TIntObjectHashMap<String> stringTable) throws IOException {
        int init = 0;
        int lastIndexResult = -1;
        int cright = 0;
        int cleft = 0;
        int ctop = 0;
        int cbottom = 0;
        ++req.numberOfReadSubtrees;
        block10: while (!req.isCancelled()) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            if (init == 15) {
                init = 0;
                if (cright < req.left || cleft > req.right || ctop > req.bottom || cbottom < req.top) {
                    return;
                }
                ++req.numberOfAcceptedSubtrees;
            }
            switch (tag) {
                case 0: {
                    return;
                }
                case 4: {
                    cbottom = this.codedIS.readSInt32() + pbottom;
                    init |= 1;
                    break;
                }
                case 1: {
                    cleft = this.codedIS.readSInt32() + pleft;
                    init |= 2;
                    break;
                }
                case 2: {
                    cright = this.codedIS.readSInt32() + pright;
                    init |= 4;
                    break;
                }
                case 3: {
                    ctop = this.codedIS.readSInt32() + ptop;
                    init |= 8;
                    break;
                }
                case 8: {
                    long stopOffset = this.codedIS.getTotalBytesRead();
                    long length = this.codedIS.readRawVarint32();
                    long oldLimit = this.codedIS.pushLimitLong(length);
                    if (lastIndexResult == -1) {
                        lastIndexResult = req.getSearchResults().size();
                    }
                    ++req.numberOfVisitedObjects;
                    TransportStop transportStop = this.readTransportStop(stopOffset, cleft, cright, ctop, cbottom, req, stringTable);
                    if (transportStop != null) {
                        req.publish(transportStop);
                    }
                    this.codedIS.popLimit(oldLimit);
                    break;
                }
                case 7: {
                    long oldLimit;
                    long length = this.readInt();
                    long filePointer = this.codedIS.getTotalBytesRead();
                    if (req.limit == -1 || req.limit >= req.getSearchResults().size()) {
                        oldLimit = this.codedIS.pushLimitLong(length);
                        this.searchTransportTreeBounds(cleft, cright, ctop, cbottom, req, stringTable);
                        this.codedIS.popLimit(oldLimit);
                    }
                    this.codedIS.seek(filePointer + length);
                    if (lastIndexResult < 0) continue block10;
                    throw new IllegalStateException();
                }
                case 16: {
                    long baseId = this.codedIS.readUInt64();
                    if (lastIndexResult == -1) continue block10;
                    int i = lastIndexResult;
                    while (true) {
                        if (i >= req.getSearchResults().size()) continue block10;
                        TransportStop rs = req.getSearchResults().get(i);
                        rs.setId(rs.getId() + baseId);
                        ++i;
                    }
                }
                default: {
                    this.skipUnknownField(t);
                }
            }
        }
        return;
    }

    private String regStr(TIntObjectHashMap<String> stringTable) throws IOException {
        int i = this.codedIS.readUInt32();
        stringTable.putIfAbsent(i, (Object)"");
        return "" + (char)i;
    }

    private String regStr(TIntObjectHashMap<String> stringTable, int i) throws IOException {
        stringTable.putIfAbsent(i, (Object)"");
        return "" + (char)i;
    }

    public void readIncompleteRoutesList(TLongObjectHashMap<IncompleteTransportRoute> incompleteRoutes, long transportIndexStart) throws IOException {
        boolean end = false;
        block4: while (!end) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    end = true;
                    continue block4;
                }
                case 6: {
                    int l = this.codedIS.readRawVarint32();
                    long olds = this.codedIS.pushLimitLong(l);
                    IncompleteTransportRoute ir = this.readIncompleteRoute(transportIndexStart);
                    IncompleteTransportRoute itr = (IncompleteTransportRoute)incompleteRoutes.get(ir.getRouteId());
                    if (itr != null) {
                        itr.setNextLinkedRoute(ir);
                    } else {
                        incompleteRoutes.put(ir.getRouteId(), (Object)ir);
                    }
                    this.codedIS.popLimit(olds);
                    continue block4;
                }
            }
            this.skipUnknownField(t);
        }
    }

    public IncompleteTransportRoute readIncompleteRoute(long transportIndexStart) throws IOException {
        IncompleteTransportRoute dataObject = new IncompleteTransportRoute();
        boolean end = false;
        block9: while (!end) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    end = true;
                    continue block9;
                }
                case 1: {
                    dataObject.setRouteId(this.codedIS.readUInt64());
                    continue block9;
                }
                case 7: {
                    int delta = this.codedIS.readRawVarint32();
                    if ((long)delta > transportIndexStart) {
                        dataObject.setRouteOffset(delta);
                        continue block9;
                    }
                    dataObject.setRouteOffset(transportIndexStart + (long)delta);
                    continue block9;
                }
                case 4: {
                    this.skipUnknownField(t);
                    continue block9;
                }
                case 5: {
                    this.skipUnknownField(t);
                    continue block9;
                }
                case 3: {
                    this.skipUnknownField(t);
                    continue block9;
                }
                case 8: {
                    this.skipUnknownField(t);
                    continue block9;
                }
            }
            this.skipUnknownField(t);
        }
        return dataObject;
    }

    public TransportRoute getTransportRoute(long filePointer, TIntObjectHashMap<String> stringTable, boolean onlyDescription) throws IOException {
        this.codedIS.seek(filePointer);
        int routeLength = this.codedIS.readRawVarint32();
        long old = this.codedIS.pushLimitLong(routeLength);
        TransportRoute dataObject = new TransportRoute();
        dataObject.setFileOffset(filePointer);
        boolean end = false;
        long rid = 0L;
        int[] rx = new int[]{0};
        int[] ry = new int[]{0};
        block16: while (!end) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    end = true;
                    continue block16;
                }
                case 8: {
                    dataObject.setDistance(this.codedIS.readUInt32());
                    continue block16;
                }
                case 1: {
                    dataObject.setId(this.codedIS.readUInt64());
                    continue block16;
                }
                case 5: {
                    dataObject.setRef(this.codedIS.readString());
                    continue block16;
                }
                case 3: {
                    dataObject.setType(this.regStr(stringTable));
                    continue block16;
                }
                case 7: {
                    dataObject.setEnName(this.regStr(stringTable));
                    continue block16;
                }
                case 6: {
                    dataObject.setName(this.regStr(stringTable));
                    continue block16;
                }
                case 4: {
                    dataObject.setOperator(this.regStr(stringTable));
                    continue block16;
                }
                case 9: {
                    dataObject.setColor(this.regStr(stringTable));
                    continue block16;
                }
                case 17: {
                    int sizeL = this.codedIS.readRawVarint32();
                    long pold = this.codedIS.pushLimitLong(sizeL);
                    int px = 0;
                    int py = 0;
                    Way w = new Way(-1L);
                    while (this.codedIS.getBytesUntilLimit() > 0L) {
                        int ddx = this.codedIS.readSInt32() << 5;
                        int ddy = this.codedIS.readSInt32() << 5;
                        if (ddx == 0 && ddy == 0) {
                            if (w.getNodes().size() > 0) {
                                dataObject.addWay(w);
                            }
                            w = new Way(-1L);
                            continue;
                        }
                        int x = ddx + px;
                        int y = ddy + py;
                        w.addNode(new Node(MapUtils.get31LatitudeY(y), MapUtils.get31LongitudeX(x), -1L));
                        px = x;
                        py = y;
                    }
                    if (w.getNodes().size() > 0) {
                        dataObject.addWay(w);
                    }
                    this.codedIS.popLimit(pold);
                    continue block16;
                }
                case 18: {
                    int sizeL = this.codedIS.readRawVarint32();
                    long pold = this.codedIS.pushLimitLong(sizeL);
                    this.readTransportSchedule(dataObject.getOrCreateSchedule());
                    this.codedIS.popLimit(pold);
                    continue block16;
                }
                case 15: {
                    if (onlyDescription) {
                        end = true;
                        this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                        continue block16;
                    }
                    int length = this.codedIS.readRawVarint32();
                    long olds = this.codedIS.pushLimitLong(length);
                    TransportStop stop = this.readTransportRouteStop(rx, ry, rid, stringTable, filePointer);
                    dataObject.getForwardStops().add(stop);
                    rid = stop.getId();
                    this.codedIS.popLimit(olds);
                    continue block16;
                }
                case 19: {
                    String str = this.regStr(stringTable);
                    dataObject.addTag(str, "");
                    continue block16;
                }
                case 20: {
                    TByteArrayList buf = new TByteArrayList();
                    int sizeL = this.codedIS.readRawVarint32();
                    long olds = this.codedIS.pushLimitLong(sizeL);
                    String key = this.regStr(stringTable);
                    while (this.codedIS.getBytesUntilLimit() > 0L) {
                        buf.add(this.codedIS.readRawByte());
                    }
                    this.codedIS.popLimit(olds);
                    dataObject.addTag(key, new String(buf.toArray(), StandardCharsets.UTF_8));
                    continue block16;
                }
            }
            this.skipUnknownField(t);
        }
        this.codedIS.popLimit(old);
        return dataObject;
    }

    private void readTransportSchedule(TransportSchedule schedule) throws IOException {
        block6: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 3: {
                    int interval;
                    long sizeL = this.codedIS.readRawVarint32();
                    long old = this.codedIS.pushLimitLong(sizeL);
                    while (this.codedIS.getBytesUntilLimit() > 0L) {
                        interval = this.codedIS.readRawVarint32();
                        schedule.tripIntervals.add(interval);
                    }
                    this.codedIS.popLimit(old);
                    continue block6;
                }
                case 1: {
                    int interval;
                    long sizeL = this.codedIS.readRawVarint32();
                    long old = this.codedIS.pushLimitLong(sizeL);
                    while (this.codedIS.getBytesUntilLimit() > 0L) {
                        interval = this.codedIS.readRawVarint32();
                        schedule.avgStopIntervals.add(interval);
                    }
                    this.codedIS.popLimit(old);
                    continue block6;
                }
                case 2: {
                    int interval;
                    long sizeL = this.codedIS.readRawVarint32();
                    long old = this.codedIS.pushLimitLong(sizeL);
                    while (this.codedIS.getBytesUntilLimit() > 0L) {
                        interval = this.codedIS.readRawVarint32();
                        schedule.avgWaitIntervals.add(interval);
                    }
                    this.codedIS.popLimit(old);
                    continue block6;
                }
            }
            this.skipUnknownField(t);
        }
    }

    protected TIntObjectHashMap<String> initializeStringTable(TransportIndex ind, TIntObjectHashMap<String> requested) throws IOException {
        if (ind.stringTable.stringTable == null) {
            ind.stringTable.stringTable = new TIntObjectHashMap();
            this.codedIS.seek(ind.stringTable.fileOffset);
            long oldLimit = this.codedIS.pushLimitLong(ind.stringTable.length);
            int current = 0;
            block4: while (this.codedIS.getBytesUntilLimit() > 0L) {
                int t = this.codedIS.readTag();
                int tag = WireFormat.getTagFieldNumber(t);
                switch (tag) {
                    case 0: {
                        continue block4;
                    }
                    case 1: {
                        String value = this.codedIS.readString();
                        ind.stringTable.stringTable.put(current, (Object)value);
                        ++current;
                        continue block4;
                    }
                }
                this.skipUnknownField(t);
            }
            this.codedIS.popLimit(oldLimit);
        }
        return ind.stringTable.stringTable;
    }

    protected void initializeNames(boolean onlyDescription, TransportRoute dataObject, TIntObjectHashMap<String> stringTable) throws IOException {
        if (dataObject.getName().length() > 0) {
            dataObject.setName((String)stringTable.get((int)dataObject.getName().charAt(0)));
        }
        if (dataObject.getEnName(false).length() > 0) {
            dataObject.setEnName((String)stringTable.get((int)dataObject.getEnName(false).charAt(0)));
        }
        if (dataObject.getName().length() > 0 && dataObject.getName("en").length() == 0) {
            dataObject.setEnName(TransliterationHelper.transliterate(dataObject.getName()));
        }
        if (dataObject.getOperator() != null && dataObject.getOperator().length() > 0) {
            dataObject.setOperator((String)stringTable.get((int)dataObject.getOperator().charAt(0)));
        }
        if (dataObject.getColor() != null && dataObject.getColor().length() > 0) {
            dataObject.setColor((String)stringTable.get((int)dataObject.getColor().charAt(0)));
        }
        if (dataObject.getType() != null && dataObject.getType().length() > 0) {
            dataObject.setType((String)stringTable.get((int)dataObject.getType().charAt(0)));
        }
        if (!onlyDescription) {
            for (TransportStop s : dataObject.getForwardStops()) {
                this.initializeNames(stringTable, s);
            }
        }
        if (dataObject.getTags() != null && dataObject.getTags().size() > 0) {
            dataObject.setTags(this.initializeTags(stringTable, dataObject));
        }
    }

    private Map<String, String> initializeTags(TIntObjectHashMap<String> stringTable, TransportRoute dataObject) {
        HashMap<String, String> newMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : dataObject.getTags().entrySet()) {
            String string = (String)stringTable.get((int)entry.getKey().charAt(0));
            if (entry.getValue().length() > 0) {
                newMap.put(string, entry.getValue());
                continue;
            }
            int index = string.indexOf(47);
            if (index <= 0) continue;
            newMap.put(string.substring(0, index), string.substring(index + 1));
        }
        return newMap;
    }

    protected void initializeNames(TIntObjectHashMap<String> stringTable, TransportStop s) {
        for (TransportStopExit exit : s.getExits()) {
            if (exit.getRef().length() <= 0) continue;
            exit.setRef((String)stringTable.get((int)exit.getRef().charAt(0)));
        }
        if (s.getName().length() > 0) {
            s.setName((String)stringTable.get((int)s.getName().charAt(0)));
        }
        if (s.getEnName(false).length() > 0) {
            s.setEnName((String)stringTable.get((int)s.getEnName(false).charAt(0)));
        }
        HashMap<String, String> namesMap = new HashMap<String, String>(s.getNamesMap(false));
        if (!s.getNamesMap(false).isEmpty()) {
            s.getNamesMap(false).clear();
        }
        for (Map.Entry e : namesMap.entrySet()) {
            s.setName((String)stringTable.get((int)((String)e.getKey()).charAt(0)), (String)stringTable.get((int)((String)e.getValue()).charAt(0)));
        }
    }

    private TransportStop readTransportRouteStop(int[] dx, int[] dy, long did, TIntObjectHashMap<String> stringTable, long filePointer) throws IOException {
        TransportStop dataObject = new TransportStop();
        dataObject.setFileOffset(this.codedIS.getTotalBytesRead());
        dataObject.setReferencesToRoutes(new long[]{filePointer});
        boolean end = false;
        block8: while (!end) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    end = true;
                    continue block8;
                }
                case 7: {
                    dataObject.setEnName(this.regStr(stringTable));
                    continue block8;
                }
                case 6: {
                    dataObject.setName(this.regStr(stringTable));
                    continue block8;
                }
                case 1: {
                    did += this.codedIS.readSInt64();
                    continue block8;
                }
                case 2: {
                    dx[0] = dx[0] + this.codedIS.readSInt32();
                    continue block8;
                }
                case 3: {
                    dy[0] = dy[0] + this.codedIS.readSInt32();
                    continue block8;
                }
            }
            this.skipUnknownField(t);
        }
        dataObject.setId(did);
        dataObject.setLocation(24, dx[0], dy[0]);
        return dataObject;
    }

    private TransportStop readTransportStop(long shift, int cleft, int cright, int ctop, int cbottom, BinaryMapIndexReader.SearchRequest<TransportStop> req, TIntObjectHashMap<String> stringTable) throws IOException {
        int tag = WireFormat.getTagFieldNumber(this.codedIS.readTag());
        if (1 != tag) {
            throw new IllegalArgumentException();
        }
        int x = this.codedIS.readSInt32() + cleft;
        tag = WireFormat.getTagFieldNumber(this.codedIS.readTag());
        if (2 != tag) {
            throw new IllegalArgumentException();
        }
        int y = this.codedIS.readSInt32() + ctop;
        if (req.right < x || req.left > x || req.top > y || req.bottom < y) {
            this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
            return null;
        }
        ++req.numberOfAcceptedObjects;
        req.cacheIdsA.clear();
        req.cacheIdsB.clear();
        req.cacheIdsC.clear();
        TransportStop dataObject = new TransportStop();
        dataObject.setLocation(24, x, y);
        dataObject.setFileOffset(shift);
        block11: while (true) {
            int t = this.codedIS.readTag();
            tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    dataObject.setReferencesToRoutes(req.cacheIdsC.toArray());
                    dataObject.setDeletedRoutesIds(req.cacheIdsA.toArray());
                    dataObject.setRoutesIds(req.cacheIdsB.toArray());
                    if (dataObject.getName("en").length() == 0) {
                        dataObject.setEnName(TransliterationHelper.transliterate(dataObject.getName()));
                    }
                    return dataObject;
                }
                case 16: {
                    req.cacheIdsC.add(shift - (long)this.codedIS.readUInt32());
                    continue block11;
                }
                case 20: {
                    req.cacheIdsA.add(this.codedIS.readUInt64());
                    continue block11;
                }
                case 22: {
                    req.cacheIdsB.add(this.codedIS.readUInt64());
                    continue block11;
                }
                case 7: {
                    if (stringTable != null) {
                        dataObject.setEnName(this.regStr(stringTable));
                        continue block11;
                    }
                    this.skipUnknownField(t);
                    continue block11;
                }
                case 6: {
                    if (stringTable != null) {
                        dataObject.setName(this.regStr(stringTable));
                        continue block11;
                    }
                    this.skipUnknownField(t);
                    continue block11;
                }
                case 8: {
                    if (stringTable != null) {
                        int sizeL = this.codedIS.readRawVarint32();
                        long oldRef = this.codedIS.pushLimitLong(sizeL);
                        while (this.codedIS.getBytesUntilLimit() > 0L) {
                            dataObject.setName(this.regStr(stringTable, this.codedIS.readRawVarint32()), this.regStr(stringTable, this.codedIS.readRawVarint32()));
                        }
                        this.codedIS.popLimit(oldRef);
                        continue block11;
                    }
                    this.skipUnknownField(t);
                    continue block11;
                }
                case 5: {
                    dataObject.setId(this.codedIS.readSInt64());
                    continue block11;
                }
                case 9: {
                    int length = this.codedIS.readRawVarint32();
                    long oldLimit = this.codedIS.pushLimitLong(length);
                    TransportStopExit transportStopExit = this.readTransportStopExit(cleft, ctop, req, stringTable);
                    dataObject.addExit(transportStopExit);
                    this.codedIS.popLimit(oldLimit);
                    continue block11;
                }
            }
            this.skipUnknownField(t);
        }
    }

    private TransportStopExit readTransportStopExit(int cleft, int ctop, BinaryMapIndexReader.SearchRequest<TransportStop> req, TIntObjectHashMap<String> stringTable) throws IOException {
        TransportStopExit dataObject = new TransportStopExit();
        int x = 0;
        int y = 0;
        block6: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    if (dataObject.getName("en").length() == 0) {
                        dataObject.setEnName(TransliterationHelper.transliterate(dataObject.getName()));
                    }
                    if (x != 0 || y != 0) {
                        dataObject.setLocation(24, x, y);
                    }
                    return dataObject;
                }
                case 3: {
                    if (stringTable != null) {
                        dataObject.setRef(this.regStr(stringTable));
                        continue block6;
                    }
                    this.skipUnknownField(t);
                    continue block6;
                }
                case 1: {
                    x = this.codedIS.readSInt32() + cleft;
                    continue block6;
                }
                case 2: {
                    y = this.codedIS.readSInt32() + ctop;
                    continue block6;
                }
            }
            this.skipUnknownField(t);
        }
    }

    public static class TransportIndex
    extends BinaryIndexPart {
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        long stopsFileOffset = 0L;
        long stopsFileLength = 0L;
        long incompleteRoutesOffset = 0L;
        long incompleteRoutesLength = 0L;
        IndexStringTable stringTable = null;

        @Override
        public String getPartName() {
            return "Transport";
        }

        @Override
        public int getFieldNumber() {
            return 4;
        }

        public int getLeft() {
            return this.left;
        }

        public int getRight() {
            return this.right;
        }

        public int getTop() {
            return this.top;
        }

        public int getBottom() {
            return this.bottom;
        }
    }

    protected static class IndexStringTable {
        long fileOffset = 0L;
        int length = 0;
        TIntObjectHashMap<String> stringTable = null;

        protected IndexStringTable() {
        }
    }
}

