/*
 * Decompiled with CFR 0.152.
 */
package rtree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import rtree.Element;
import rtree.Rect;

public class LeafElement
extends Element {
    long recordPtr;

    public LeafElement(Rect minBndRect, long recordPtr) {
        super(minBndRect);
        this.recordPtr = recordPtr;
    }

    public static int sizeInBytes() {
        return Rect.sizeInBytes() + 8;
    }

    @Override
    public long getPtr() {
        return this.recordPtr;
    }

    @Override
    public int getElementType() {
        return 1;
    }

    @Override
    public void setPtr(long ptr) {
        this.recordPtr = ptr;
    }

    @Override
    public String toString() {
        return super.toString() + "\n\trecPointer: " + this.recordPtr;
    }

    public Object clone() {
        try {
            return new LeafElement(new Rect(this.Rectangle.getMinX(), this.Rectangle.getMinY(), this.Rectangle.getMaxX(), this.Rectangle.getMaxY()), this.recordPtr);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static synchronized List extractPtrs(List elements) throws IllegalArgumentException {
        if (elements == null) {
            throw new IllegalArgumentException("RTree.LeafElement: Argument null");
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        try {
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                result.add(new Integer((int)((LeafElement)i.next()).getPtr()));
            }
            return result;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("RTree.LeafElement: Type of vector is not LeafElement");
        }
    }
}

