/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.wiki;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.osmand.PlatformUtil;
import net.osmand.obf.preparation.DBDialect;
import net.osmand.wiki.AbstractWikiFilesDownloader;
import org.apache.commons.logging.Log;

public class WikidataFilesDownloader
extends AbstractWikiFilesDownloader {
    private static final Log log = PlatformUtil.getLog(WikidataFilesDownloader.class);

    public WikidataFilesDownloader(File wikiDB, boolean daily) {
        super(wikiDB, daily, null);
    }

    @Override
    public String getFilePrefix() {
        return "wikidatawiki";
    }

    @Override
    public long getMaxIdFromDb(File wikiSqlite) throws SQLException {
        DBDialect dialect = DBDialect.SQLITE;
        Connection conn = dialect.getDatabaseConnection(wikiSqlite.getAbsolutePath(), log);
        ResultSet rs = conn.createStatement().executeQuery("SELECT max(id) FROM wiki_coords");
        long maxQId = 0L;
        if (rs.next()) {
            maxQId = rs.getLong(1);
        }
        if ((rs = conn.createStatement().executeQuery("SELECT max(id) FROM wikidata_properties")).next()) {
            maxQId = Math.max(rs.getLong(1), maxQId);
        }
        conn.close();
        if (maxQId == 0L) {
            throw new RuntimeException("Could not get last article name (id) from " + wikiSqlite.getAbsolutePath());
        }
        return maxQId;
    }

    @Override
    public long getMaxPageId() throws IOException {
        JsonNode jsonPageId;
        String s = "https://www.wikidata.org/wiki/Special:EntityData/Q" + this.getMaxQId() + ".json";
        URL url = new URL(s);
        URLConnection connection = url.openConnection();
        connection.setRequestProperty("User-Agent", "OsmAnd-Bot/1.0 (+https://osmand.net; support@osmand.net) OsmAndJavaServer/1.0");
        connection.connect();
        InputStream inputStream = connection.getInputStream();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode json = mapper.readTree(inputStream);
        if (json != null && (jsonPageId = json.findValue("pageid")) != null) {
            return jsonPageId.asLong();
        }
        throw new RuntimeException("Could not get max page id for updating from " + s);
    }
}

