/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.htmlcleaner.util;

import info.bliki.htmlcleaner.TagNode;
import info.bliki.htmlcleaner.util.AbstractHtmlExtractor;
import info.bliki.htmlcleaner.util.HtmlForm;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HtmlFormExtractor
extends AbstractHtmlExtractor<HtmlForm> {
    public static final String FORM_TAG = "form";
    public static final String INPUT_TAG = "input";
    public static final String TEXTAREA_TAG = "textarea";
    private final String fFormID;

    public HtmlFormExtractor(HtmlForm resultForm) {
        this(resultForm, "editform");
    }

    public HtmlFormExtractor(HtmlForm resultForm, String formID) {
        super(resultForm);
        this.fFormID = formID;
    }

    @Override
    public void appendContent(List<Object> nodes) {
        if (nodes != null && !nodes.isEmpty()) {
            for (Object item : nodes) {
                Map<String, String> atts;
                String attributeValue;
                if (item == null || !(item instanceof TagNode)) continue;
                TagNode tagNode = (TagNode)item;
                if (tagNode.getName().equalsIgnoreCase(INPUT_TAG) || tagNode.getName().equalsIgnoreCase(TEXTAREA_TAG)) {
                    Map<String, String> attributes = tagNode.getAttributes();
                    int sz = attributes.size();
                    HtmlForm.ElementAttribute[] elementAttributes = new HtmlForm.ElementAttribute[sz];
                    Set<Map.Entry<String, String>> eSet = attributes.entrySet();
                    int i = 0;
                    for (Map.Entry<String, String> entry : eSet) {
                        elementAttributes[i++] = new HtmlForm.ElementAttribute(entry.getKey(), "CDATA", entry.getValue());
                    }
                    ((HtmlForm)this.fResultObject).addElement(new HtmlForm.Element(tagNode.getName(), elementAttributes));
                }
                if ((attributeValue = (atts = ((TagNode)item).getAttributes()).get("class")) != null && attributeValue.toLowerCase().equals("errorbox") || !(item instanceof List)) continue;
                List list = (List)item;
                this.appendContent(list);
            }
        }
    }

    @Override
    public boolean isFound(TagNode tagNode) {
        Map<String, String> atts;
        String attributeValue;
        String tagName = tagNode.getName();
        if (tagName.equals(FORM_TAG) && (attributeValue = (atts = tagNode.getAttributes()).get("id")) != null && attributeValue.toLowerCase().equals(this.fFormID)) {
            int method = 1;
            ((HtmlForm)this.fResultObject).setID(attributeValue);
            attributeValue = atts.get("name");
            if (attributeValue != null) {
                ((HtmlForm)this.fResultObject).setName(attributeValue);
            }
            if ((attributeValue = atts.get("method")) != null && "get".equalsIgnoreCase(attributeValue)) {
                method = 0;
                ((HtmlForm)this.fResultObject).setMethod(method);
            }
            if ((attributeValue = atts.get("action")) != null) {
                ((HtmlForm)this.fResultObject).setAction(attributeValue);
            }
            if ((attributeValue = atts.get("enctype")) != null) {
                ((HtmlForm)this.fResultObject).setEncType(attributeValue);
            }
            return true;
        }
        return false;
    }
}

