/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.util;

import com.google.openlocationcode.OpenLocationCode;
import com.jwetherell.openmap.common.LatLonPoint;
import com.jwetherell.openmap.common.MGRSPoint;
import com.jwetherell.openmap.common.UTMPoint;
import java.util.ArrayList;
import java.util.List;
import net.osmand.data.LatLon;
import net.osmand.util.Algorithms;
import net.osmand.util.TextDirectionUtil;

public class LocationParser {
    public static boolean isValidOLC(String code) {
        return OpenLocationCode.isValidCode((String)code);
    }

    public static ParsedOpenLocationCode parseOpenLocationCode(String locPhrase) {
        ParsedOpenLocationCode parsedCode = new ParsedOpenLocationCode(locPhrase.trim());
        return !parsedCode.isValidCode() ? null : parsedCode;
    }

    public static LatLon parseLocation(String locPhrase) {
        char ch;
        String[] split;
        locPhrase = ((String)locPhrase).trim();
        boolean valid = LocationParser.isValidLocPhrase((String)(locPhrase = TextDirectionUtil.clearDirectionMarks((String)locPhrase)));
        if (!valid && (split = ((String)locPhrase).split(" ")).length == 4 && split[1].contains(".") && split[3].contains(".")) {
            locPhrase = split[1] + " " + split[3];
            valid = LocationParser.isValidLocPhrase((String)locPhrase);
        }
        if (!valid) {
            return null;
        }
        locPhrase = LocationParser.prepareLatLonWithDecimalCommas((String)locPhrase);
        ArrayList<Double> d = new ArrayList<Double>();
        ArrayList<Object> all = new ArrayList<Object>();
        ArrayList<String> strings = new ArrayList<String>();
        LocationParser.splitObjects((String)locPhrase, d, all, strings);
        if (d.size() == 0) {
            return null;
        }
        if (all.size() == 4 && d.size() == 3 && all.get(1) instanceof String && ((String)all.get(1)).length() == 1 && Character.isLetter(ch = all.get(1).toString().charAt(0))) {
            UTMPoint upoint = new UTMPoint((Double)d.get(2), (Double)d.get(1), ((Double)d.get(0)).intValue(), ch);
            LatLonPoint ll = upoint.toLatLonPoint();
            return LocationParser.validateAndCreateLatLon(ll.getLatitude(), ll.getLongitude());
        }
        if (all.size() == 3 && d.size() == 2 && all.get(1) instanceof String && ((String)all.get(1)).length() == 1) {
            ch = all.get(1).toString().charAt(0);
            String combined = (String)strings.get(2);
            if (Character.isLetter(ch)) {
                try {
                    String east = combined.substring(0, combined.length() / 2);
                    String north = combined.substring(combined.length() / 2);
                    UTMPoint upoint = new UTMPoint(Double.parseDouble(north), Double.parseDouble(east), ((Double)d.get(0)).intValue(), ch);
                    LatLonPoint ll = upoint.toLatLonPoint();
                    return LocationParser.validateAndCreateLatLon(ll.getLatitude(), ll.getLongitude());
                }
                catch (NumberFormatException east) {
                    // empty catch block
                }
            }
        }
        if (all.size() >= 3 && (d.size() == 2 || d.size() == 3) && all.get(1) instanceof String) {
            try {
                MGRSPoint mgrsPoint = new MGRSPoint((String)locPhrase);
                LatLonPoint ll = mgrsPoint.toLatLonPoint();
                return LocationParser.validateAndCreateLatLon(ll.getLatitude(), ll.getLongitude());
            }
            catch (NumberFormatException mgrsPoint) {
                // empty catch block
            }
        }
        int jointNumbers = 0;
        int lastJoin = 0;
        int degSplit = -1;
        int degType = -1;
        boolean finishDegSplit = false;
        int northSplit = -1;
        int eastSplit = -1;
        for (int i = 1; i < all.size(); ++i) {
            if (all.get(i - 1) instanceof Double && all.get(i) instanceof Double) {
                ++jointNumbers;
                lastJoin = i;
            }
            if (all.get(i).equals("n") || all.get(i).equals("s") || all.get(i).equals("N") || all.get(i).equals("S")) {
                northSplit = i + 1;
            }
            if (all.get(i).equals("e") || all.get(i).equals("w") || all.get(i).equals("E") || all.get(i).equals("W")) {
                eastSplit = i;
            }
            int dg = -1;
            if (all.get(i).equals("\u00b0")) {
                dg = 0;
            } else if (all.get(i).equals("'") || all.get(i).equals("\u2032")) {
                dg = 1;
            } else if (all.get(i).equals("\u2033") || all.get(i).equals("\"")) {
                dg = 2;
            }
            if (dg == -1) continue;
            if (!finishDegSplit) {
                if (degType < dg) {
                    degSplit = i + 1;
                    degType = dg;
                    continue;
                }
                finishDegSplit = true;
                degType = dg;
                continue;
            }
            if (degType < dg) {
                degType = dg;
                continue;
            }
            degSplit = -1;
        }
        int split2 = -1;
        if (jointNumbers == 1) {
            split2 = lastJoin;
        }
        if (northSplit != -1 && northSplit < all.size() - 1) {
            split2 = northSplit;
        } else if (eastSplit != -1 && eastSplit < all.size() - 1) {
            split2 = eastSplit;
        } else if (degSplit != -1 && degSplit < all.size() - 1) {
            split2 = degSplit;
        }
        if (split2 != -1) {
            double lat = LocationParser.parse1Coordinate(all, 0, split2);
            double lon = LocationParser.parse1Coordinate(all, split2, all.size());
            return LocationParser.validateAndCreateLatLon(lat, lon);
        }
        if (d.size() == 2) {
            return LocationParser.validateAndCreateLatLon((Double)d.get(0), (Double)d.get(1));
        }
        if (((String)locPhrase).contains("://")) {
            double lat = 0.0;
            double lon = 0.0;
            boolean only2decimals = true;
            for (int i = 0; i < d.size(); ++i) {
                if ((Double)d.get(i) == (double)((Double)d.get(i)).intValue()) continue;
                if (lat == 0.0) {
                    lat = (Double)d.get(i);
                    continue;
                }
                if (lon == 0.0) {
                    lon = (Double)d.get(i);
                    continue;
                }
                only2decimals = false;
            }
            if (lat != 0.0 && lon != 0.0 && only2decimals) {
                return LocationParser.validateAndCreateLatLon(lat, lon);
            }
        }
        if (d.size() > 2 && d.size() % 2 == 0) {
            int ind = d.size() / 2 + 1;
            int splitEq = -1;
            for (int i = 0; i < all.size(); ++i) {
                if (all.get(i) instanceof Double) {
                    --ind;
                }
                if (ind != 0) continue;
                splitEq = i;
                break;
            }
            if (splitEq != -1) {
                double lat = LocationParser.parse1Coordinate(all, 0, splitEq);
                double lon = LocationParser.parse1Coordinate(all, splitEq, all.size());
                return LocationParser.validateAndCreateLatLon(lat, lon);
            }
        }
        return null;
    }

    private static String prepareLatLonWithDecimalCommas(String ll) {
        boolean DIGITS_BEFORE_COMMA = true;
        int DIGITS_AFTER_COMMA = 3;
        int first = -1;
        for (int i = 1; i < ll.length() - 3; ++i) {
            int j;
            if (ll.charAt(i) != ',') continue;
            int before = 0;
            int after = 0;
            for (j = i - 1; j >= i - 1; --j) {
                if (!Character.isDigit(ll.charAt(j))) continue;
                ++before;
            }
            for (j = i + 1; j <= i + 3 && before >= 1; ++j) {
                if (!Character.isDigit(ll.charAt(j))) continue;
                ++after;
            }
            if (before < 1 || after < 3) continue;
            if (first != -1) {
                return ll.substring(0, first) + "." + ll.substring(first + 1, i) + "." + ll.substring(i + 1);
            }
            first = i;
        }
        return ll;
    }

    private static LatLon validateAndCreateLatLon(double lat, double lon) {
        if (Math.abs(lat) <= 90.0 && Math.abs(lon) <= 180.0) {
            return new LatLon(lat, lon);
        }
        return null;
    }

    private static boolean isValidLocPhrase(String locPhrase) {
        if (!locPhrase.isEmpty()) {
            char ch = Character.toLowerCase(locPhrase.charAt(0));
            if (ch == '(' && locPhrase.length() > 1) {
                ch = Character.toLowerCase(locPhrase.charAt(1));
            }
            return ch == '-' || Character.isDigit(ch) || ch == 's' || ch == 'n' || locPhrase.contains("://");
        }
        return false;
    }

    public static double parse1Coordinate(List<Object> all, int begin, int end) {
        boolean neg = false;
        double d = 0.0;
        int type = 0;
        Double prevDouble = null;
        for (int i = begin; i <= end; ++i) {
            String o;
            String string = o = i == end ? "" : all.get(i);
            if (o.equals("S") || o.equals("s") || o.equals("W") || o.equals("w") || o.equals(-0.0)) {
                boolean bl = neg = !neg;
            }
            if (prevDouble != null) {
                if (o.equals("\u00b0")) {
                    type = 0;
                } else if (o.equals("\u2032")) {
                    type = 1;
                } else if (o.equals("\"") || o.equals("\u2033")) {
                    type = 2;
                }
                if (type == 0) {
                    double ld = prevDouble;
                    if (ld < 0.0) {
                        ld = -ld;
                        neg = true;
                    }
                    d += ld;
                } else {
                    d = type == 1 ? (d += prevDouble / 60.0) : (d += prevDouble / 3600.0);
                }
                ++type;
            }
            prevDouble = o instanceof Double ? (Double)((Object)o) : null;
        }
        if (neg) {
            d = -d;
        }
        return d;
    }

    public static void splitObjects(String s, List<Double> d, List<Object> all, List<String> strings) {
        LocationParser.splitObjects(s, d, all, strings, new boolean[]{false});
    }

    public static void splitObjects(String s, List<Double> d, List<Object> all, List<String> strings, boolean[] partial) {
        boolean digit = false;
        int word = -1;
        int firstNumeralIdx = -1;
        for (int i = 0; i <= s.length(); ++i) {
            boolean nonwh;
            char ch = i == s.length() ? (char)' ' : (char)s.charAt(i);
            boolean dg = Character.isDigit(ch);
            boolean bl = nonwh = ch != ',' && ch != ' ' && ch != ';';
            if (ch == '.' || dg || ch == '-') {
                if (!digit) {
                    if (word != -1) {
                        all.add(s.substring(word, i));
                        strings.add(s.substring(word, i));
                    }
                    digit = true;
                    word = i;
                    continue;
                }
                if (word != -1) continue;
                word = i;
                continue;
            }
            if (digit && word != -1) {
                try {
                    double dl = Double.parseDouble(s.substring(word, i));
                    d.add(dl);
                    all.add(dl);
                    if (firstNumeralIdx == -1) {
                        firstNumeralIdx = all.size() - 1;
                    }
                    strings.add(s.substring(word, i));
                    digit = false;
                    word = -1;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (nonwh) {
                if (!Character.isLetter(ch)) {
                    if (word != -1) {
                        all.add(s.substring(word, i));
                        strings.add(s.substring(word, i));
                    }
                    all.add(s.substring(i, i + 1));
                    strings.add(s.substring(i, i + 1));
                    word = -1;
                    continue;
                }
                if (word != -1) continue;
                word = i;
                continue;
            }
            if (word != -1) {
                all.add(s.substring(word, i));
                strings.add(s.substring(word, i));
            }
            word = -1;
        }
        partial[0] = false;
        if (firstNumeralIdx != -1) {
            int nextTokenIdx = firstNumeralIdx + 1;
            if (all.size() <= nextTokenIdx) {
                partial[0] = true;
            }
        }
    }

    public static class ParsedOpenLocationCode {
        private final String text;
        private String code;
        private boolean full;
        private String placeName;
        private OpenLocationCode olc;
        private LatLon latLon;

        private ParsedOpenLocationCode(String text) {
            this.text = text;
            this.parse();
        }

        private void parse() {
            String[] split;
            if (!Algorithms.isEmpty(this.text) && (split = this.text.split(" ")).length > 0) {
                this.code = split[0];
                try {
                    this.olc = new OpenLocationCode(this.code);
                    this.full = this.olc.isFull();
                    if (this.full) {
                        OpenLocationCode.CodeArea codeArea = this.olc.decode();
                        this.latLon = new LatLon(codeArea.getCenterLatitude(), codeArea.getCenterLongitude());
                    } else if (split.length > 1) {
                        this.placeName = this.text.substring(this.code.length() + 1);
                    }
                }
                catch (IllegalArgumentException e) {
                    this.code = null;
                }
            }
        }

        public LatLon recover(LatLon searchLocation) {
            if (this.olc != null) {
                OpenLocationCode.CodeArea codeArea = this.olc.recover(searchLocation.getLatitude(), searchLocation.getLongitude()).decode();
                this.latLon = new LatLon(codeArea.getCenterLatitude(), codeArea.getCenterLongitude());
            }
            return this.latLon;
        }

        boolean isValidCode() {
            return !Algorithms.isEmpty(this.code);
        }

        public String getText() {
            return this.text;
        }

        public String getCode() {
            return this.code;
        }

        public boolean isFull() {
            return this.full;
        }

        public String getPlaceName() {
            return this.placeName;
        }

        public LatLon getLatLon() {
            return this.latLon;
        }
    }
}

