/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx.filters;

import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import net.osmand.shared.settings.enums.AltitudeMetrics;
import net.osmand.shared.settings.enums.MetricsConstants;
import net.osmand.shared.settings.enums.SpeedConstants;
import net.osmand.shared.units.HeartRateUnits;
import net.osmand.shared.units.LengthUnits;
import net.osmand.shared.units.MeasurementUnit;
import net.osmand.shared.units.NoUnit;
import net.osmand.shared.units.PowerUnits;
import net.osmand.shared.units.RotationUnits;
import net.osmand.shared.units.SpeedUnits;
import net.osmand.shared.units.TemperatureUnits;
import net.osmand.shared.units.TimeUnits;
import net.osmand.shared.util.PlatformUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fJ.\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aj\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u001b"}, d2={"Lnet/osmand/shared/gpx/filters/MeasureUnitType;", "", "<init>", "(Ljava/lang/String;I)V", "TIME_DURATION", "DATE", "SPEED", "ALTITUDE", "DISTANCE", "ROTATIONS", "POWER", "TEMPERATURE", "BPM", "NONE", "getFilterUnitText", "", "mc", "Lnet/osmand/shared/settings/enums/MetricsConstants;", "am", "Lnet/osmand/shared/settings/enums/AltitudeMetrics;", "getBaseValueFromFormatted", "", "value", "getUnit", "Lnet/osmand/shared/units/MeasurementUnit;", "sc", "Lnet/osmand/shared/settings/enums/SpeedConstants;", "OsmAnd-shared"})
public final class MeasureUnitType
extends Enum<MeasureUnitType> {
    public static final /* enum */ MeasureUnitType TIME_DURATION = new MeasureUnitType();
    public static final /* enum */ MeasureUnitType DATE = new MeasureUnitType();
    public static final /* enum */ MeasureUnitType SPEED = new MeasureUnitType();
    public static final /* enum */ MeasureUnitType ALTITUDE = new MeasureUnitType();
    public static final /* enum */ MeasureUnitType DISTANCE = new MeasureUnitType();
    public static final /* enum */ MeasureUnitType ROTATIONS = new MeasureUnitType();
    public static final /* enum */ MeasureUnitType POWER = new MeasureUnitType();
    public static final /* enum */ MeasureUnitType TEMPERATURE = new MeasureUnitType();
    public static final /* enum */ MeasureUnitType BPM = new MeasureUnitType();
    public static final /* enum */ MeasureUnitType NONE = new MeasureUnitType();
    private static final /* synthetic */ MeasureUnitType[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    @NotNull
    public final String getFilterUnitText(@NotNull MetricsConstants mc, @NotNull AltitudeMetrics am) {
        Intrinsics.checkNotNullParameter((Object)((Object)mc), (String)"mc");
        Intrinsics.checkNotNullParameter((Object)((Object)am), (String)"am");
        return MeasureUnitType.getUnit$default(this, mc, am, null, 4, null).getSymbol();
    }

    public final double getBaseValueFromFormatted(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return MeasureUnitType.getUnit$default(this, null, null, null, 7, null).toBase(Double.parseDouble(value));
    }

    @NotNull
    public final MeasurementUnit<?> getUnit(@Nullable MetricsConstants mc, @Nullable AltitudeMetrics am, @Nullable SpeedConstants sc) {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1 -> {
                Enum v0 = mc;
                if (v0 == null || (v0 = ((MetricsConstants)v0).getDistanceUnit()) == null) {
                    v0 = LengthUnits.METERS;
                }
                yield (MeasurementUnit)((Object)v0);
            }
            case 2 -> {
                Enum v2 = am;
                if (v2 == null || (v2 = ((AltitudeMetrics)v2).getUnits()) == null) {
                    v2 = LengthUnits.METERS;
                }
                yield (MeasurementUnit)((Object)v2);
            }
            case 3 -> {
                Enum v3 = sc;
                if (v3 == null || (v3 = ((SpeedConstants)v3).toUnits()) == null) {
                    MetricsConstants v4 = mc;
                    v3 = v4 != null ? v4.getSpeedUnit() : SpeedUnits.KILOMETERS_PER_HOUR;
                }
                yield (MeasurementUnit)((Object)v3);
            }
            case 4 -> TemperatureUnits.CELSIUS;
            case 5 -> TimeUnits.MINUTES;
            case 6 -> RotationUnits.RPM;
            case 7 -> PowerUnits.WATTS;
            case 8 -> HeartRateUnits.BPM;
            default -> NoUnit.INSTANCE;
        };
    }

    public static /* synthetic */ MeasurementUnit getUnit$default(MeasureUnitType measureUnitType, MetricsConstants metricsConstants, AltitudeMetrics altitudeMetrics, SpeedConstants speedConstants, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getUnit");
        }
        if ((n & 1) != 0) {
            metricsConstants = PlatformUtil.INSTANCE.getOsmAndContext().getMetricSystem();
        }
        if ((n & 2) != 0) {
            altitudeMetrics = PlatformUtil.INSTANCE.getOsmAndContext().getAltitudeMetric();
        }
        if ((n & 4) != 0) {
            speedConstants = PlatformUtil.INSTANCE.getOsmAndContext().getSpeedSystem();
        }
        return measureUnitType.getUnit(metricsConstants, altitudeMetrics, speedConstants);
    }

    public static MeasureUnitType[] values() {
        return (MeasureUnitType[])$VALUES.clone();
    }

    public static MeasureUnitType valueOf(String value) {
        return Enum.valueOf(MeasureUnitType.class, value);
    }

    @NotNull
    public static EnumEntries<MeasureUnitType> getEntries() {
        return $ENTRIES;
    }

    static {
        $VALUES = measureUnitTypeArray = new MeasureUnitType[]{MeasureUnitType.TIME_DURATION, MeasureUnitType.DATE, MeasureUnitType.SPEED, MeasureUnitType.ALTITUDE, MeasureUnitType.DISTANCE, MeasureUnitType.ROTATIONS, MeasureUnitType.POWER, MeasureUnitType.TEMPERATURE, MeasureUnitType.BPM, MeasureUnitType.NONE};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MeasureUnitType.values().length];
            try {
                nArray[MeasureUnitType.DISTANCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MeasureUnitType.ALTITUDE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MeasureUnitType.SPEED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MeasureUnitType.TEMPERATURE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MeasureUnitType.TIME_DURATION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MeasureUnitType.ROTATIONS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MeasureUnitType.POWER.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MeasureUnitType.BPM.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

