/*
 * Decompiled with CFR 0.152.
 */
package io.github.cosinekitty.astronomy;

import io.github.cosinekitty.astronomy.Astronomy;
import io.github.cosinekitty.astronomy.BodyState;
import io.github.cosinekitty.astronomy.TerseVector;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J \u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lio/github/cosinekitty/astronomy/MajorBodies;", "", "sun", "Lio/github/cosinekitty/astronomy/BodyState;", "jupiter", "saturn", "uranus", "neptune", "<init>", "(Lio/github/cosinekitty/astronomy/BodyState;Lio/github/cosinekitty/astronomy/BodyState;Lio/github/cosinekitty/astronomy/BodyState;Lio/github/cosinekitty/astronomy/BodyState;Lio/github/cosinekitty/astronomy/BodyState;)V", "getSun", "()Lio/github/cosinekitty/astronomy/BodyState;", "getJupiter", "getSaturn", "getUranus", "getNeptune", "acceleration", "Lio/github/cosinekitty/astronomy/TerseVector;", "smallPos", "accelerationIncrement", "gm", "", "majorPos", "OsmAnd-shared"})
final class MajorBodies {
    @NotNull
    private final BodyState sun;
    @NotNull
    private final BodyState jupiter;
    @NotNull
    private final BodyState saturn;
    @NotNull
    private final BodyState uranus;
    @NotNull
    private final BodyState neptune;

    public MajorBodies(@NotNull BodyState sun, @NotNull BodyState jupiter, @NotNull BodyState saturn, @NotNull BodyState uranus, @NotNull BodyState neptune) {
        Intrinsics.checkNotNullParameter((Object)sun, (String)"sun");
        Intrinsics.checkNotNullParameter((Object)jupiter, (String)"jupiter");
        Intrinsics.checkNotNullParameter((Object)saturn, (String)"saturn");
        Intrinsics.checkNotNullParameter((Object)uranus, (String)"uranus");
        Intrinsics.checkNotNullParameter((Object)neptune, (String)"neptune");
        this.sun = sun;
        this.jupiter = jupiter;
        this.saturn = saturn;
        this.uranus = uranus;
        this.neptune = neptune;
    }

    @NotNull
    public final BodyState getSun() {
        return this.sun;
    }

    @NotNull
    public final BodyState getJupiter() {
        return this.jupiter;
    }

    @NotNull
    public final BodyState getSaturn() {
        return this.saturn;
    }

    @NotNull
    public final BodyState getUranus() {
        return this.uranus;
    }

    @NotNull
    public final BodyState getNeptune() {
        return this.neptune;
    }

    @NotNull
    public final TerseVector acceleration(@NotNull TerseVector smallPos) {
        Intrinsics.checkNotNullParameter((Object)smallPos, (String)"smallPos");
        return this.accelerationIncrement(smallPos, 2.959122082855911E-4, this.sun.getR()).plus(this.accelerationIncrement(smallPos, 2.825345909524226E-7, this.jupiter.getR())).plus(this.accelerationIncrement(smallPos, 8.459715185680659E-8, this.saturn.getR())).plus(this.accelerationIncrement(smallPos, 1.292024916781969E-8, this.uranus.getR())).plus(this.accelerationIncrement(smallPos, 1.524358900784276E-8, this.neptune.getR()));
    }

    private final TerseVector accelerationIncrement(TerseVector smallPos, double gm, TerseVector majorPos) {
        TerseVector delta = majorPos.minus(smallPos);
        double r2 = delta.quadrature();
        return Astronomy.times(gm / (r2 * Math.sqrt(r2)), delta);
    }
}

