/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.util;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0002\u00a8\u0006\u000b"}, d2={"Lnet/osmand/shared/util/SharedDateFormatter;", "", "<init>", "()V", "formatYear", "", "timestamp", "", "formatMonthAndYear", "format", "pattern", "OsmAnd-shared"})
public final class SharedDateFormatter {
    @NotNull
    public static final SharedDateFormatter INSTANCE = new SharedDateFormatter();

    private SharedDateFormatter() {
    }

    @NotNull
    public final String formatYear(long timestamp) {
        return this.format(timestamp, "yyyy");
    }

    @NotNull
    public final String formatMonthAndYear(long timestamp) {
        return this.format(timestamp, "MMMM yyyy");
    }

    private final String format(long timestamp, String pattern) {
        if (timestamp == 0L) {
            return "";
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern, Locale.getDefault());
        String string = Instant.ofEpochMilli(timestamp).atZone(ZoneId.systemDefault()).format(formatter);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }
}

