/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.IOUtil;
import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.nativewindow.util.PixelFormat;
import com.jogamp.nativewindow.util.PixelFormatUtil;
import com.jogamp.nativewindow.util.PixelRectangle;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import jogamp.opengl.Debug;
import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.ImageLine;
import jogamp.opengl.util.pngj.ImageLineHelper;
import jogamp.opengl.util.pngj.PngReader;
import jogamp.opengl.util.pngj.PngWriter;
import jogamp.opengl.util.pngj.chunks.PngChunkPLTE;
import jogamp.opengl.util.pngj.chunks.PngChunkTRNS;

public class PNGPixelRect
extends PixelRectangle.GenericPixelRect {
    private static final boolean DEBUG = Debug.debug("PNG");
    private final double[] dpi;

    public static PNGPixelRect read(InputStream inputStream, PixelFormat pixelFormat, boolean bl, int n, boolean bl2) throws IOException {
        int[] nArray;
        int n2;
        boolean bl3;
        boolean bl4;
        PngReader pngReader = new PngReader(new BufferedInputStream(inputStream), null);
        ImageInfo imageInfo = pngReader.imgInfo;
        PngChunkPLTE pngChunkPLTE = pngReader.getMetadata().getPLTE();
        PngChunkTRNS pngChunkTRNS = pngReader.getMetadata().getTRNS();
        boolean bl5 = imageInfo.indexed;
        boolean bl6 = bl5 ? pngChunkTRNS != null : (bl4 = imageInfo.alpha);
        if (DEBUG) {
            System.err.println("PNGPixelRect: " + imageInfo);
        }
        int n3 = bl5 ? (bl4 ? 4 : 3) : imageInfo.channels;
        boolean bl7 = bl3 = 2 == n3 && imageInfo.greyscale && imageInfo.alpha;
        if (1 != n3 && 3 != n3 && 4 != n3 && !bl3) {
            throw new RuntimeException("PNGPixelRect can only handle Lum/RGB/RGBA [1/3/4 channels] or Lum+A (GA) images for now. Channels " + n3 + " Paletted: " + bl5);
        }
        int n4 = n2 = bl5 ? n3 : imageInfo.bytesPixel;
        if (1 != n2 && 3 != n2 && 4 != n2 && !bl3) {
            throw new RuntimeException("PNGPixelRect can only handle Lum/RGB/RGBA [1/3/4 bpp] images for now. BytesPerPixel " + n2);
        }
        if (n3 != n2) {
            throw new RuntimeException("PNGPixelRect currently only handles Channels [1/3/4] == BytePerPixel [1/3/4], channels: " + n3 + ", bytesPerPixel " + n2);
        }
        int n5 = imageInfo.cols;
        int n6 = imageInfo.rows;
        Object object = pngReader.getMetadata().getDpi();
        double d = object[0];
        double d2 = object[1];
        if (bl5) {
            object = bl4 ? (Object)((Object)PixelFormat.RGBA8888) : (Object)((Object)PixelFormat.RGB888);
        } else {
            switch (n3) {
                case 1: {
                    object = (Object)PixelFormat.LUMINANCE;
                    break;
                }
                case 2: {
                    object = (Object)(bl3 ? PixelFormat.LUMINANCE : null);
                    break;
                }
                case 3: {
                    object = (Object)PixelFormat.RGB888;
                    break;
                }
                case 4: {
                    object = (Object)PixelFormat.RGBA8888;
                    break;
                }
                default: {
                    object = null;
                }
            }
            if (null == object) {
                throw new InternalError("XXX: channels: " + n3 + ", bytesPerPixel " + n2);
            }
        }
        Object object2 = null == pixelFormat ? (bl3 ? PixelFormat.BGRA8888 : (Object)object) : pixelFormat;
        int n7 = Math.max(n, object2.comp.bytesPerPixel() * n5);
        ByteBuffer byteBuffer = bl ? Buffers.newDirectByteBuffer((int)(n7 * n6)) : ByteBuffer.allocate(n7 * n6);
        int n8 = n7 * n6;
        if (byteBuffer.limit() < n8) {
            throw new IndexOutOfBoundsException("Dest buffer has insufficient bytes left, needs " + n8 + ": " + byteBuffer);
        }
        n8 = bl2 ? 1 : 0;
        int[] nArray2 = nArray = bl5 ? new int[n5 * n3] : null;
        if (DEBUG) {
            System.err.println("PNGPixelRect: indexed " + bl5 + ", alpha " + bl4 + ", grayscale " + imageInfo.greyscale + ", channels " + n3 + "/" + imageInfo.channels + ", bytesPerPixel " + n2 + "/" + imageInfo.bytesPixel + ", grayAlpha " + bl3 + ", pixels " + n5 + "x" + n6 + ", dpi " + d + "x" + d2 + ", format " + object);
            System.err.println("PNGPixelRect: destFormat " + (Object)object2 + " (" + (Object)((Object)pixelFormat) + ", fast-path " + (object2 == object) + "), destDirectBuffer " + bl + ", destIsGLOriented (flip) " + bl2);
            System.err.println("PNGPixelRect: destStrideInBytes " + n7 + " (destMinStrideInBytes " + n + ")");
        }
        for (int i = 0; i < n6; ++i) {
            int n9;
            int n10;
            ImageLine imageLine = pngReader.readRow(i);
            int n11 = 0;
            int n12 = n10 = n8 != 0 ? (n6 - 1 - i) * n7 : i * n7;
            if (bl5) {
                for (n9 = n5 - 1; n9 >= 0; --n9) {
                    nArray = ImageLineHelper.palette2rgb(imageLine, pngChunkPLTE, pngChunkTRNS, nArray);
                    n10 = PNGPixelRect.getPixelRGBA8ToAny(object2, byteBuffer, n10, nArray, n11, bl4);
                    n11 += n2;
                }
                continue;
            }
            if (1 == n3) {
                for (n9 = n5 - 1; n9 >= 0; --n9) {
                    n10 = PNGPixelRect.getPixelLUMToAny(object2, byteBuffer, n10, (byte)imageLine.scanline[n11++], (byte)-1);
                }
                continue;
            }
            if (bl3) {
                for (n9 = n5 - 1; n9 >= 0; --n9) {
                    n10 = PNGPixelRect.getPixelLUMToAny(object2, byteBuffer, n10, (byte)imageLine.scanline[n11++], (byte)imageLine.scanline[n11++]);
                }
                continue;
            }
            if (object == object2) {
                for (n9 = n5 - 1; n9 >= 0; --n9) {
                    n10 = PNGPixelRect.getPixelRGBSame(byteBuffer, n10, imageLine.scanline, n11, n2);
                    n11 += n2;
                }
                continue;
            }
            for (n9 = n5 - 1; n9 >= 0; --n9) {
                n10 = PNGPixelRect.getPixelRGBA8ToAny(object2, byteBuffer, n10, imageLine.scanline, n11, bl4);
                n11 += n2;
            }
        }
        pngReader.end();
        return new PNGPixelRect((PixelFormat)((Object)object2), new Dimension(n5, n6), n7, bl2, byteBuffer, d, d2);
    }

    private static final int getPixelLUMToAny(PixelFormat pixelFormat, ByteBuffer byteBuffer, int n, byte by, byte by2) {
        switch (pixelFormat) {
            case LUMINANCE: {
                byteBuffer.put(n++, by);
                break;
            }
            case BGR888: 
            case RGB888: {
                byteBuffer.put(n++, by);
                byteBuffer.put(n++, by);
                byteBuffer.put(n++, by);
                break;
            }
            case ABGR8888: 
            case ARGB8888: {
                byteBuffer.put(n++, by2);
                byteBuffer.put(n++, by);
                byteBuffer.put(n++, by);
                byteBuffer.put(n++, by);
                break;
            }
            case BGRA8888: 
            case RGBA8888: {
                byteBuffer.put(n++, by);
                byteBuffer.put(n++, by);
                byteBuffer.put(n++, by);
                byteBuffer.put(n++, by2);
                break;
            }
            default: {
                throw new InternalError("Unhandled format " + (Object)((Object)pixelFormat));
            }
        }
        return n;
    }

    private static final int getPixelRGBA8ToAny(PixelFormat pixelFormat, ByteBuffer byteBuffer, int n, int[] nArray, int n2, boolean bl) {
        int n3 = PixelFormatUtil.convertToInt32(pixelFormat, (byte)nArray[n2], (byte)nArray[n2 + 1], (byte)nArray[n2 + 2], bl ? (byte)nArray[n2 + 3] : (byte)-1);
        int n4 = pixelFormat.comp.bytesPerPixel();
        byteBuffer.put(n++, (byte)n3);
        if (1 < n4) {
            byteBuffer.put(n++, (byte)(n3 >>> 8));
            byteBuffer.put(n++, (byte)(n3 >>> 16));
            if (4 == n4) {
                byteBuffer.put(n++, (byte)(n3 >>> 24));
            }
        }
        return n;
    }

    private static final int getPixelRGBSame(ByteBuffer byteBuffer, int n, int[] nArray, int n2, int n3) {
        byteBuffer.put(n++, (byte)nArray[n2]);
        if (1 < n3) {
            byteBuffer.put(n++, (byte)nArray[n2 + 1]);
            byteBuffer.put(n++, (byte)nArray[n2 + 2]);
            if (4 == n3) {
                byteBuffer.put(n++, (byte)nArray[n2 + 3]);
            }
        }
        return n;
    }

    private int setPixelRGBA8(ImageLine imageLine, int n, ByteBuffer byteBuffer, int n2, int n3, boolean bl) {
        int n4;
        int n5 = n4 = bl ? 3 : 2;
        if (byteBuffer.limit() <= n2 + n4) {
            throw new IndexOutOfBoundsException("Buffer has unsufficient bytes left, needs [" + n2 + ".." + (n2 + n4) + "]: " + byteBuffer);
        }
        int n6 = PixelFormatUtil.convertToInt32(bl ? PixelFormat.RGBA8888 : PixelFormat.RGB888, this.pixelformat, byteBuffer, n2);
        imageLine.scanline[n] = 0xFF & n6;
        imageLine.scanline[n + 1] = 0xFF & n6 >>> 8;
        imageLine.scanline[n + 2] = 0xFF & n6 >>> 16;
        if (bl) {
            imageLine.scanline[n + 3] = 0xFF & n6 >>> 24;
        }
        return n2 + this.pixelformat.comp.bytesPerPixel();
    }

    private static void setPixelRGBA8(PixelFormat pixelFormat, ImageLine imageLine, int n, int n2, int n3, boolean bl) {
        int n4 = PixelFormatUtil.convertToInt32(bl ? PixelFormat.RGBA8888 : PixelFormat.RGB888, pixelFormat, n2);
        imageLine.scanline[n] = 0xFF & n4;
        imageLine.scanline[n + 1] = 0xFF & n4 >>> 8;
        imageLine.scanline[n + 2] = 0xFF & n4 >>> 16;
        if (bl) {
            imageLine.scanline[n + 3] = 0xFF & n4 >>> 24;
        }
    }

    public PNGPixelRect(PixelFormat pixelFormat, DimensionImmutable dimensionImmutable, int n, boolean bl, ByteBuffer byteBuffer, double d, double d2) {
        super(pixelFormat, dimensionImmutable, n, bl, byteBuffer);
        this.dpi = new double[]{d, d2};
    }

    public PNGPixelRect(PixelRectangle pixelRectangle, double d, double d2) {
        super(pixelRectangle);
        this.dpi = new double[]{d, d2};
    }

    public double[] getDpi() {
        return this.dpi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream outputStream, boolean bl) throws IOException {
        int n = this.size.getWidth();
        int n2 = this.size.getHeight();
        int n3 = this.pixelformat.comp.bytesPerPixel();
        ImageInfo imageInfo = new ImageInfo(n, n2, 8, 4 == n3, 1 == n3, false);
        try {
            PngWriter pngWriter = new PngWriter(outputStream, imageInfo);
            pngWriter.getMetadata().setDpi(this.dpi[0], this.dpi[1]);
            pngWriter.getMetadata().setTimeNow(0);
            pngWriter.getMetadata().setText("Title", "JogAmp PNGPixelRect");
            boolean bl2 = 4 == n3;
            ImageLine imageLine = new ImageLine(imageInfo);
            for (int i = 0; i < n2; ++i) {
                int n4;
                int n5 = this.isGLOriented ? (n2 - 1 - i) * this.strideInBytes : i * this.strideInBytes;
                int n6 = 0;
                if (1 == n3) {
                    for (n4 = n - 1; n4 >= 0; --n4) {
                        imageLine.scanline[n6++] = this.pixels.get(n5++);
                    }
                } else {
                    for (n4 = n - 1; n4 >= 0; --n4) {
                        n5 = this.setPixelRGBA8(imageLine, n6, this.pixels, n5, n3, bl2);
                        n6 += n3;
                    }
                }
                pngWriter.writeRow(imageLine, i);
            }
            pngWriter.end();
        }
        finally {
            if (bl) {
                IOUtil.close((Closeable)outputStream, (boolean)false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(PixelFormat pixelFormat, DimensionImmutable dimensionImmutable, int n, boolean bl, IntBuffer intBuffer, double d, double d2, OutputStream outputStream, boolean bl2) throws IOException {
        int n2 = dimensionImmutable.getWidth();
        int n3 = dimensionImmutable.getHeight();
        int n4 = pixelFormat.comp.bytesPerPixel();
        ImageInfo imageInfo = new ImageInfo(n2, n3, 8, 4 == n4, 1 == n4, false);
        if (0 != n) {
            if (n < dimensionImmutable.getWidth()) {
                throw new IllegalArgumentException("Invalid stride " + n4 + ", must be greater than width " + dimensionImmutable.getWidth());
            }
        } else {
            n = dimensionImmutable.getWidth();
        }
        int n5 = n * dimensionImmutable.getHeight();
        if (intBuffer.limit() < n5) {
            throw new IndexOutOfBoundsException("Dest buffer has insufficient pixels left, needs " + n5 + ": " + intBuffer);
        }
        try {
            PngWriter pngWriter = new PngWriter(outputStream, imageInfo);
            pngWriter.getMetadata().setDpi(d, d2);
            pngWriter.getMetadata().setTimeNow(0);
            pngWriter.getMetadata().setText("Title", "JogAmp PNGPixelRect");
            boolean bl3 = 4 == n4;
            ImageLine imageLine = new ImageLine(imageInfo);
            for (int i = 0; i < n3; ++i) {
                int n6;
                int n7 = bl ? (n3 - 1 - i) * n : i * n;
                int n8 = 0;
                if (1 == n4) {
                    for (n6 = n2 - 1; n6 >= 0; --n6) {
                        imageLine.scanline[n8++] = intBuffer.get(n7++);
                    }
                } else {
                    for (n6 = n2 - 1; n6 >= 0; --n6) {
                        PNGPixelRect.setPixelRGBA8(pixelFormat, imageLine, n8, intBuffer.get(n7++), n4, bl3);
                        n8 += n4;
                    }
                }
                pngWriter.writeRow(imageLine, i);
            }
            pngWriter.end();
        }
        finally {
            if (bl2) {
                IOUtil.close((Closeable)outputStream, (boolean)false);
            }
        }
    }
}

