/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.wiki.wikidata;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.osmand.util.Algorithms;
import net.osmand.wiki.WikiDatabasePreparation;
import net.osmand.wiki.WikipediaByCountryDivider;
import net.osmand.wiki.wikidata.ExtractorHandler;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xmlpull.v1.XmlPullParserException;
import org.xwiki.component.manager.ComponentLookupException;

public class ArticleExtractor {
    public static final String helpMessage = " --mode=<cut|test> --lang=<lang> --title=<title> --amount=<amount>--dir=<work_folder> --testID=<article_ID> --LatLon=<testLatLon> --f=<file>\nmode cut without lang - cut out article with <title> (wikidata title 'Q1072074') from <file> or from wikidatawiki-latest-pages-articles.xml.gz\nif --f is absentmode cut with lang - cut out <amount> of articles, beginning with <title> from <lang>wiki-latest-pages-articles.xml.gz and create obf file \non the <LatLon> coordinates(lat;lon)\nmode test - creates obf file for the article with <articleID> by <LatLon> coordinates(lat;lon)\nresults are written to a '<work_folder>/out' folder";

    public static void main(String[] args) throws Exception {
        boolean processWikidata;
        String lang = null;
        String workDir = "";
        String mode = "test";
        String articleID = "";
        String articleLatLon = "50.45191;30.59195";
        String articleTitle = "";
        Object fileName = "";
        int amount = 1;
        block26: for (String arg : args) {
            String key;
            String val = arg.substring(arg.indexOf("=") + 1);
            switch (key = arg.substring(0, arg.indexOf("=") + 1)) {
                case "--mode=": {
                    mode = val;
                    continue block26;
                }
                case "--lang=": {
                    lang = val;
                    continue block26;
                }
                case "--title=": {
                    articleTitle = val;
                    continue block26;
                }
                case "--amount=": {
                    try {
                        amount = Integer.parseInt(val);
                    }
                    catch (NumberFormatException e) {
                        amount = 1;
                    }
                    continue block26;
                }
                case "--dir=": {
                    workDir = val;
                    continue block26;
                }
                case "--articleID=": {
                    articleID = val;
                    continue block26;
                }
                case "--LatLon=": {
                    articleLatLon = val;
                    continue block26;
                }
                case "--f=": {
                    fileName = val;
                }
            }
        }
        if (mode.isEmpty() || !mode.equals("cut") && !mode.equals("test") || workDir.isEmpty() || mode.equals("cut") && articleTitle.isEmpty() || mode.equals("test") && articleID.isEmpty()) {
            System.out.println(helpMessage);
            return;
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        ArticleExtractor articleExtractor = new ArticleExtractor();
        boolean bl = processWikidata = lang == null;
        fileName = !Algorithms.isEmpty((CharSequence)fileName) ? workDir + (String)fileName : (processWikidata ? workDir + "wikidatawiki-latest-pages-articles.xml.gz" : workDir + lang + "wiki-latest-pages-articles.xml.gz");
        File readFile = new File((String)fileName);
        File outputDir = new File(readFile.getParent(), "out");
        outputDir.mkdirs();
        try {
            if ("cut".equals(mode)) {
                File outFile = new File(outputDir, readFile.getName());
                ExtractorHandler handler = new ExtractorHandler(articleTitle, amount);
                InputStream is = ArticleExtractor.getInputStream(readFile);
                SAXParser saxParser = factory.newSAXParser();
                try {
                    saxParser.parse(is, (DefaultHandler)handler);
                }
                catch (ExtractorHandler.StopParsingException e) {
                    System.out.printf("Trim lines number: header end=%d article start=%d, article end =%d\n", handler.getEndHeaderLine(), handler.getFirstArticleLine(), handler.getEndArticleLine());
                }
                if (handler.getFirstArticleLine() == 0 && handler.getEndArticleLine() == 0) {
                    System.out.printf("Article %s not found\n", articleTitle);
                } else {
                    long startTime = System.currentTimeMillis();
                    articleExtractor.cutArticle(readFile, outFile, handler.getEndHeaderLine(), handler.getFirstArticleLine(), handler.getEndArticleLine());
                    System.out.printf("Trim time: %d sec\n", (System.currentTimeMillis() - startTime) / 1000L);
                    articleID = handler.getArticleId();
                }
            }
            if (!processWikidata && !Algorithms.isEmpty((CharSequence)articleID)) {
                String[] arguments = new String[]{"--lang=" + lang, "--wikipediaDir=" + outputDir.getAbsolutePath() + File.separator, "--mode=test-wikipedia", "--testID=" + articleID};
                WikiDatabasePreparation.main(arguments);
                arguments = new String[]{"generate_test_obf", outputDir.getAbsolutePath() + File.separator, "--testLatLon=" + articleLatLon};
                WikipediaByCountryDivider.main(arguments);
            }
        }
        catch (IOException | InterruptedException | SQLException | ParserConfigurationException | SAXException | XmlPullParserException | ComponentLookupException e) {
            e.printStackTrace();
        }
    }

    void cutArticle(File readFile, File outFile, int endHeaderLine, int startArticleLine, int endArticleLine) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(ArticleExtractor.getInputStream(readFile)));
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(ArticleExtractor.getOutputStream(outFile)));
        for (int lineCount = 0; (line = br.readLine()) != null && lineCount < endArticleLine; ++lineCount) {
            if (lineCount < startArticleLine && lineCount >= endHeaderLine) continue;
            pw.println(line);
            pw.flush();
        }
        pw.println("</mediawiki>");
        pw.close();
        br.close();
    }

    private static InputStream getInputStream(File file) throws IOException {
        FilterInputStream is = new BufferedInputStream(new FileInputStream(file));
        if (file.getName().endsWith(".bz2")) {
            is = new BZip2CompressorInputStream((InputStream)is);
        } else if (file.getName().endsWith(".gz")) {
            is = new GZIPInputStream(is);
        }
        return is;
    }

    private static OutputStream getOutputStream(File file) throws IOException {
        OutputStream os = new FileOutputStream(file);
        if (file.getName().endsWith(".bz2")) {
            os = new BZip2CompressorOutputStream(os);
        } else if (file.getName().endsWith(".gz")) {
            os = new GZIPOutputStream(os);
        }
        return os;
    }
}

