/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import gnu.trove.TIntCollection;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.Set;
import net.osmand.PlatformUtil;
import net.osmand.router.HHRouteDataStructure;
import net.osmand.router.HHRoutePlanner;
import net.osmand.router.HHRoutingDB;
import net.osmand.router.HHRoutingPreparationDB;
import net.osmand.router.RoutingContext;
import org.apache.commons.logging.Log;

public class HHRoutingTopGraphCreator {
    static int DEBUG_VERBOSE_LEVEL = 0;
    static final Log LOG = PlatformUtil.getLog(HHRoutingTopGraphCreator.class);
    static final int PROC_MONTECARLO = 1;
    static final int PROC_MIDPOINTS = 2;
    static final int PROC_2ND_LEVEL = 3;
    static final int PROC_CH = 4;
    static int SAVE_ITERATIONS = 20;
    static int LOG_STAT_THRESHOLD = 10;
    static int LOG_STAT_MAX_DEPTH = 30;
    static int PROCESS = 4;
    static long DEBUG_START_TIME = 0L;
    private HHRoutingPreparationDB networkDB;
    private HHRoutePlanner<HHRoutingPreparationDB.NetworkDBPointPrep> routePlanner;

    public HHRoutingTopGraphCreator(HHRoutePlanner<HHRoutingPreparationDB.NetworkDBPointPrep> routePlanner, HHRoutingPreparationDB networkDB) throws SQLException {
        this.routePlanner = routePlanner;
        this.networkDB = networkDB;
    }

    private static File testData() {
        String name = "Montenegro";
        name = "Netherlands_europe";
        return new File(System.getProperty("maps.dir"), name);
    }

    private static void logf(String string, Object ... a) {
        if (DEBUG_START_TIME == 0L) {
            DEBUG_START_TIME = System.currentTimeMillis();
        }
        String ms = String.format("%3.1fs ", Float.valueOf((float)(System.currentTimeMillis() - DEBUG_START_TIME) / 1000.0f));
        System.out.printf(ms + string + "\n", a);
    }

    public static void main(String[] args) throws Exception {
        File obfFile = args.length == 0 ? HHRoutingTopGraphCreator.testData() : new File(args[0]);
        int MAX_ITERATIONS = 100;
        int MAX_DEPTH = 15;
        int PERCENT_CH = 80;
        String ROUTING_PROFILE = "car";
        for (String a : args) {
            if (a.equals("--setup-midpoints")) {
                PROCESS = 2;
                continue;
            }
            if (a.equals("--proc-montecarlo")) {
                PROCESS = 1;
                continue;
            }
            if (a.equals("--proc-ch")) {
                PROCESS = 4;
                continue;
            }
            if (a.equals("--proc-2nd-level")) {
                PROCESS = 3;
                continue;
            }
            if (a.startsWith("--iterations=")) {
                MAX_ITERATIONS = Integer.parseInt(a.substring("--iterations=".length()));
                continue;
            }
            if (a.startsWith("--percent=")) {
                PERCENT_CH = Integer.parseInt(a.substring("--percent=".length()));
                continue;
            }
            if (!a.startsWith("--maxdepth=")) continue;
            MAX_DEPTH = Integer.parseInt(a.substring("--maxdepth=".length()));
        }
        File folder = obfFile.isDirectory() ? obfFile : obfFile.getParentFile();
        String name = obfFile.getCanonicalFile().getName() + "_" + ROUTING_PROFILE;
        HHRoutingPreparationDB networkDB = new HHRoutingPreparationDB(new File(folder, name + ".hhdb"));
        HHRoutePlanner routePlanner = HHRoutePlanner.createDB((RoutingContext)HHRoutePlanner.prepareContext((String)ROUTING_PROFILE), (HHRoutingDB)networkDB, HHRoutingPreparationDB.NetworkDBPointPrep.class);
        HHRoutingTopGraphCreator planner = new HHRoutingTopGraphCreator((HHRoutePlanner<HHRoutingPreparationDB.NetworkDBPointPrep>)routePlanner, networkDB);
        if (PROCESS == 2) {
            planner.calculateMidPoints(MAX_DEPTH, MAX_ITERATIONS);
        } else if (PROCESS == 4) {
            planner.runContractionHierarchy(MAX_DEPTH, (double)PERCENT_CH / 100.0);
        }
        planner.networkDB.close();
    }

    private void calculateMidPoints(int MAX_DEPTH, int MAX_ITERATIONS) throws SQLException, IOException {
        HHRouteDataStructure.HHRoutingConfig config = HHRouteDataStructure.HHRoutingConfig.dijkstra((int)0).preloadSegments();
        HHRouteDataStructure.HHRoutingContext hctx = this.routePlanner.initHCtx(config, null, null);
        long time = System.nanoTime();
        long startTime = System.nanoTime();
        TLongObjectHashMap pnts = hctx.pointsById;
        ArrayList<HHRoutingPreparationDB.NetworkDBPointPrep> pointsList = new ArrayList<HHRoutingPreparationDB.NetworkDBPointPrep>(pnts.valueCollection());
        this.networkDB.loadMidPointsIndex((TLongObjectHashMap<HHRoutingPreparationDB.NetworkDBPointPrep>)pnts, pointsList, false);
        hctx.stats.loadPointsTime += (double)(System.nanoTime() - time) / 1000000.0;
        System.out.printf(" %,d - %.2fms\nRouting...\n", hctx.stats.loadEdgesCnt, hctx.stats.loadEdgesTime);
        int iteration = Math.min(MAX_ITERATIONS, pnts.size() / 2);
        Random random = new Random();
        HHRouteDataStructure.HHRoutingConfig c = new HHRouteDataStructure.HHRoutingConfig();
        c.HEURISTIC_COEFFICIENT = 0.0f;
        c.USE_MIDPOINT = false;
        c.MAX_DEPTH = MAX_DEPTH;
        while (iteration > 0) {
            HHRoutingPreparationDB.NetworkDBPointPrep startPnt = (HHRoutingPreparationDB.NetworkDBPointPrep)((Object)pointsList.get(random.nextInt(pointsList.size())));
            if (startPnt.midProc > 0) continue;
            HHRoutingTopGraphCreator.logf("%d. Routing %s - ", new Object[]{iteration, startPnt});
            --iteration;
            startPnt.midProc = 1;
            hctx.stats = new HHRouteDataStructure.RoutingStats();
            this.routePlanner.runRoutingPointToPoint(hctx, (HHRouteDataStructure.NetworkDBPoint)startPnt, null);
            for (HHRoutingPreparationDB.NetworkDBPointPrep pnt : pointsList) {
                pnt.midDepth = 0;
                if (pnt.rt((boolean)false).rtRouteToPoint == null) continue;
                ++pnt.midDepth;
                HHRoutingPreparationDB.NetworkDBPointPrep p = pnt;
                while ((p = p.rt((boolean)false).rtRouteToPoint) != startPnt) {
                    ++pnt.midDepth;
                }
            }
            for (HHRoutingPreparationDB.NetworkDBPointPrep pnt : pointsList) {
                if (pnt.rt((boolean)false).rtRouteToPoint == null) continue;
                int k = 0;
                HHRoutingPreparationDB.NetworkDBPointPrep p = pnt;
                while ((p = (HHRoutingPreparationDB.NetworkDBPointPrep)p.rt((boolean)false).rtRouteToPoint) != startPnt) {
                    p.midMaxDepth = Math.max(p.midMaxDepth, Math.min(++k, p.midDepth));
                }
            }
            int maxInc = 0;
            int countInc = 0;
            int maxTop = 0;
            for (HHRoutingPreparationDB.NetworkDBPointPrep pnt : pointsList) {
                if (pnt.midMaxDepth - pnt.midPrevMaxDepth > 0 && pnt.midPrevMaxDepth < LOG_STAT_THRESHOLD) {
                    ++countInc;
                    maxInc = Math.max(pnt.midMaxDepth - pnt.midPrevMaxDepth, maxInc);
                    maxTop = Math.max(pnt.midMaxDepth, maxTop);
                }
                pnt.midPrevMaxDepth = pnt.midMaxDepth;
                pnt.clearRouting();
            }
            System.out.printf("increased %d points - max diff %d, max top %d (%,d (%,d unique) visited / %,d added vertices, %.2f queue ms) \n", countInc, maxInc, maxTop, hctx.stats.visitedVertices, hctx.stats.uniqueVisitedVertices, hctx.stats.addedVertices, hctx.stats.addQueueTime);
            if (iteration % SAVE_ITERATIONS != 0) continue;
            this.saveAndPrintMidPoints(pointsList, (TLongObjectHashMap<HHRoutingPreparationDB.NetworkDBPointPrep>)pnts, LOG_STAT_MAX_DEPTH);
        }
        this.saveAndPrintMidPoints(pointsList, (TLongObjectHashMap<HHRoutingPreparationDB.NetworkDBPointPrep>)pnts, LOG_STAT_MAX_DEPTH);
        time = System.nanoTime();
        System.out.printf("Routing finished %.2f ms: load data %.2f ms, routing %.2f ms (%.2f queue ms), prep result %.2f ms\n", (double)(time - startTime) / 1000000.0, hctx.stats.loadEdgesTime + hctx.stats.loadPointsTime, hctx.stats.routingTime, hctx.stats.addQueueTime, hctx.stats.prepTime);
        System.out.println(String.format("Found final route - cost %.2f, %d depth ( %,d (%,d unique) visited / %,d added vertices )", 0.0, 0, hctx.stats.visitedVertices, hctx.stats.uniqueVisitedVertices, hctx.stats.visitedVertices));
    }

    private void saveAndPrintMidPoints(List<HHRoutingPreparationDB.NetworkDBPointPrep> pointsList, TLongObjectHashMap<HHRoutingPreparationDB.NetworkDBPointPrep> pnts, int max) throws SQLException {
        long now = System.currentTimeMillis();
        Collections.sort(pointsList, new Comparator<HHRoutingPreparationDB.NetworkDBPointPrep>(){

            @Override
            public int compare(HHRoutingPreparationDB.NetworkDBPointPrep o1, HHRoutingPreparationDB.NetworkDBPointPrep o2) {
                return -Integer.compare(o1.midMaxDepth, o2.midMaxDepth);
            }
        });
        int prev = 0;
        for (int k = 0; k < pointsList.size(); ++k) {
            HHRoutingPreparationDB.NetworkDBPointPrep p = pointsList.get(k);
            if (k > 0 && Math.min(pointsList.get((int)(k - 1)).midMaxDepth, max) == Math.min(p.midMaxDepth, max)) {
                ++prev;
                continue;
            }
            System.out.printf("\n (^%d, %.1f%%) %d depth: %s", prev, (double)prev * 100.0 / (double)pointsList.size(), p.midMaxDepth, p.toString());
        }
        System.out.printf("\n (^%d, %.1f%%) - saving %.2f s \n", prev, (double)prev * 100.0 / (double)pointsList.size(), (double)(System.currentTimeMillis() - now) / 1000.0);
        this.networkDB.loadMidPointsIndex(pnts, pointsList, true);
        for (HHRoutingPreparationDB.NetworkDBPointPrep pnt : pointsList) {
            pnt.midPrevMaxDepth = pnt.midMaxDepth;
        }
    }

    private void runContractionHierarchy(int maxPoints, double percent) throws SQLException, IOException {
        HHRouteDataStructure.HHRoutingConfig config = HHRouteDataStructure.HHRoutingConfig.dijkstra((int)1).maxSettlePoints(maxPoints).preloadSegments();
        HHRouteDataStructure.HHRoutingContext hctx = this.routePlanner.initHCtx(config, null, null);
        long time = System.nanoTime();
        long startTime = System.nanoTime();
        TLongObjectHashMap pnts = hctx.pointsById;
        ArrayList<HHRoutingPreparationDB.NetworkDBPointPrep> list = new ArrayList<HHRoutingPreparationDB.NetworkDBPointPrep>(pnts.valueCollection());
        time = System.nanoTime();
        System.out.printf(" %,d - %.2fms\nContracting nodes..\n", hctx.stats.loadEdgesCnt, hctx.stats.loadEdgesTime);
        this.calculateAndPrintVertexDegree(list);
        time = System.nanoTime();
        TIntIntHashMap edgeDiffMap = new TIntIntHashMap();
        PriorityQueue<HHRoutingPreparationDB.NetworkDBPointPrep> pq = new PriorityQueue<HHRoutingPreparationDB.NetworkDBPointPrep>(new Comparator<HHRoutingPreparationDB.NetworkDBPointPrep>(){

            @Override
            public int compare(HHRoutingPreparationDB.NetworkDBPointPrep o1, HHRoutingPreparationDB.NetworkDBPointPrep o2) {
                return Integer.compare(o1.chIndexEdgeDiff, o2.chIndexEdgeDiff);
            }
        });
        int prog = 0;
        for (HHRoutingPreparationDB.NetworkDBPointPrep p : list) {
            if (++prog % 1000 == 0) {
                HHRoutingTopGraphCreator.logf("Preparing %d...", prog);
            }
            this.calculateCHEdgeDiff((HHRouteDataStructure.HHRoutingContext<HHRoutingPreparationDB.NetworkDBPointPrep>)hctx, p, null);
            pq.add(p);
            if (!edgeDiffMap.containsKey(p.chIndexEdgeDiff)) {
                edgeDiffMap.put(p.chIndexEdgeDiff, 0);
            }
            edgeDiffMap.put(p.chIndexEdgeDiff, edgeDiffMap.get(p.chIndexEdgeDiff) + 1);
        }
        prog = 0;
        int reindex = 0;
        ArrayList<HHRouteDataStructure.NetworkDBSegment> allShortcuts = new ArrayList<HHRouteDataStructure.NetworkDBSegment>();
        ArrayList<HHRouteDataStructure.NetworkDBSegment> shortcuts = new ArrayList<HHRouteDataStructure.NetworkDBSegment>();
        int contracted = 0;
        long timeC = System.nanoTime();
        double toContract = (double)list.size() * percent;
        while (!pq.isEmpty() && !((double)contracted > toContract)) {
            if (++prog % 1000 == 0) {
                HHRoutingTopGraphCreator.logf("Contracting %d %.1f%% (reindexing %d, shortcuts %d)...", contracted, (double)contracted / toContract * 100.0, reindex, allShortcuts.size());
                this.printStat("Contraction stat ", hctx.stats, timeC, 1000);
                if (prog % 10000 == 0) {
                    this.calculateAndPrintVertexDegree(list);
                }
                hctx.stats = new HHRouteDataStructure.RoutingStats();
                timeC = System.nanoTime();
            }
            HHRoutingPreparationDB.NetworkDBPointPrep pnt = pq.poll();
            int oldIndex = pnt.chIndexEdgeDiff;
            shortcuts.clear();
            this.calculateCHEdgeDiff((HHRouteDataStructure.HHRoutingContext<HHRoutingPreparationDB.NetworkDBPointPrep>)hctx, pnt, shortcuts);
            if (oldIndex < pnt.chIndexEdgeDiff) {
                pq.add(pnt);
                ++reindex;
                continue;
            }
            for (HHRouteDataStructure.NetworkDBSegment sh : shortcuts) {
                HHRouteDataStructure.NetworkDBSegment dup = sh.start.getSegment(sh.end, true);
                if (dup != null) {
                    if (dup.dist < sh.dist) continue;
                    if (dup.shortcut) {
                        allShortcuts.remove(dup);
                        sh.start.connected.remove(dup);
                        sh.end.connectedReverse.remove(sh.end.getSegment(sh.start, false));
                    }
                }
                allShortcuts.add(sh);
                sh.start.connected.add(sh);
                HHRouteDataStructure.NetworkDBSegment rev = new HHRouteDataStructure.NetworkDBSegment(sh.start, sh.end, sh.dist, !sh.direction, sh.shortcut);
                rev.getGeometry().addAll(sh.getGeometry());
                sh.end.connectedReverse.add(rev);
            }
            pnt.chFinalInd = contracted++;
            pnt.rtExclude = true;
        }
        this.networkDB.updatePointsCHInd(list);
        this.networkDB.deleteShortcuts();
        this.networkDB.insertSegments(allShortcuts, ((HHRouteDataStructure.HHRouteRegionPointsCtx)hctx.regions.get((int)0)).routingProfile);
        System.out.printf("Added %d shortcuts, reindexed %d \n", allShortcuts.size(), reindex);
        this.printStat("Contraction ", hctx.stats, time, list.size());
        time = System.nanoTime();
        System.out.printf("Routing finished %.2f ms: load data %.2f ms, routing %.2f ms (%.2f queue ms), prep result %.2f ms\n", (double)(time - startTime) / 1000000.0, hctx.stats.loadEdgesTime + hctx.stats.loadPointsTime, hctx.stats.routingTime, hctx.stats.addQueueTime, hctx.stats.prepTime);
    }

    private void calculateAndPrintVertexDegree(List<HHRoutingPreparationDB.NetworkDBPointPrep> list) {
        TIntIntHashMap degreeIn = new TIntIntHashMap();
        TIntIntHashMap degreeOut = new TIntIntHashMap();
        int cnt = 0;
        for (HHRouteDataStructure.NetworkDBPoint networkDBPoint : list) {
            if (networkDBPoint.rtExclude) continue;
            ++cnt;
            degreeIn.adjustOrPutValue(networkDBPoint.connectedReverse.size(), 1, 1);
            degreeOut.adjustOrPutValue(networkDBPoint.connected.size(), 1, 1);
        }
        if (cnt > 0) {
            System.out.println("Vertex degree in - " + this.formatVertexDegree(degreeIn, cnt).toString());
            System.out.println("Vertex degree out - " + this.formatVertexDegree(degreeOut, cnt).toString());
        }
    }

    private StringBuilder formatVertexDegree(TIntIntHashMap degreeIn, int cnt) {
        int[] keys = degreeIn.keys();
        Arrays.sort(keys);
        StringBuilder s = new StringBuilder();
        int k = -1;
        int st = 0;
        int v = 0;
        for (int l = 0; l <= keys.length; ++l) {
            if (l < keys.length) {
                k = keys[l];
                v += degreeIn.get(k);
            }
            if (!((double)v * 100.0 / (double)cnt > 8.0) && l != keys.length) continue;
            s.append(String.format("%s - %,d (%.1f%%), ", (String)(st != k ? st + "-" : "") + k, v, (double)v * 100.0 / (double)cnt));
            st = k + 1;
            v = 0;
        }
        return s;
    }

    private void printStat(String name, HHRouteDataStructure.RoutingStats stats, long time, int size) {
        double contractionTime = (double)(System.nanoTime() - time) / 1000000.0;
        System.out.println(String.format(name + " for %d - %.2f ms (%.2f mcs per node), visited %,d (%,d unique) of %,d added vertices", size, contractionTime, contractionTime * 1000.0 / (double)size, stats.visitedVertices, stats.uniqueVisitedVertices, stats.addedVertices));
    }

    private void calculateCHEdgeDiff(HHRouteDataStructure.HHRoutingContext<HHRoutingPreparationDB.NetworkDBPointPrep> hctx, HHRoutingPreparationDB.NetworkDBPointPrep p, List<HHRouteDataStructure.NetworkDBSegment> shortcuts) throws SQLException, IOException {
        hctx.config.MAX_COST = 0.0;
        for (HHRouteDataStructure.NetworkDBSegment out : p.connected) {
            hctx.config.MAX_COST = Math.max(out.dist, hctx.config.MAX_COST);
        }
        p.chIndexCnt = 0;
        p.rtExclude = true;
        for (HHRouteDataStructure.NetworkDBSegment in : p.connectedReverse) {
            if (in.start.rtExclude) continue;
            this.routePlanner.runRoutingPointToPoint(hctx, (HHRouteDataStructure.NetworkDBPoint)((HHRoutingPreparationDB.NetworkDBPointPrep)in.start), null);
            for (HHRouteDataStructure.NetworkDBSegment out : p.connected) {
                if (out.end.rtExclude || out.end.rt((boolean)false).rtDistanceFromStart != 0.0 && !(out.end.rt((boolean)false).rtDistanceFromStart > out.dist)) continue;
                ++p.chIndexCnt;
                if (shortcuts == null) continue;
                if (DEBUG_VERBOSE_LEVEL >= 1) {
                    System.out.printf("Shortcut %d -> %d via %d %.2f cost \n ", in.start.index, out.end.index, in.end.index, in.dist + out.dist);
                }
                HHRoutingPreparationDB.NetworkDBSegmentPrep sh = new HHRoutingPreparationDB.NetworkDBSegmentPrep(in.start, out.end, in.dist + out.dist, true, true);
                if (in.shortcut) {
                    sh.segmentsStartEnd.addAll((TIntCollection)((HHRoutingPreparationDB.NetworkDBSegmentPrep)in).segmentsStartEnd);
                } else {
                    sh.segmentsStartEnd.add(in.start.index);
                    sh.segmentsStartEnd.add(in.end.index);
                }
                if (out.shortcut) {
                    sh.segmentsStartEnd.addAll((TIntCollection)((HHRoutingPreparationDB.NetworkDBSegmentPrep)out).segmentsStartEnd);
                } else {
                    sh.segmentsStartEnd.add(out.start.index);
                    sh.segmentsStartEnd.add(out.end.index);
                }
                shortcuts.add(sh);
            }
            hctx.clearVisited();
        }
        p.chIndexEdgeDiff = p.chIndexCnt - p.connected.size() - p.connectedReverse.size();
        p.rtExclude = false;
    }

    class NetworkHHCluster {
        private int clusterId;
        private List<HHRouteDataStructure.NetworkDBPoint> points = new ArrayList<HHRouteDataStructure.NetworkDBPoint>();
        private List<HHRouteDataStructure.NetworkDBPoint> expoints = new ArrayList<HHRouteDataStructure.NetworkDBPoint>();
        private Set<NetworkHHCluster> neighbors = new HashSet<NetworkHHCluster>();
        private NetworkHHCluster mergedTo = null;
        private List<NetworkHHCluster> merged = new ArrayList<NetworkHHCluster>();

        public NetworkHHCluster(int clusterId) {
            this.clusterId = clusterId;
        }

        public String toString() {
            return String.format("C-%d [%d, %d]", this.clusterId, this.points.size(), this.neighbors.size());
        }

        public void clearRouting() {
            for (HHRouteDataStructure.NetworkDBPoint p : this.points) {
                p.clearRouting();
            }
            for (HHRouteDataStructure.NetworkDBPoint p : this.expoints) {
                p.clearRouting();
            }
        }

        public void adoptMerge(NetworkHHCluster c) {
            if (c == this && this.neighbors.size() != 0) {
                throw new IllegalStateException();
            }
            if (this.mergedTo != null) {
                throw new IllegalStateException();
            }
            if (c.mergedTo != null) {
                throw new IllegalStateException();
            }
            c.mergedTo = this;
            if (c != this) {
                for (NetworkHHCluster p : c.merged) {
                    p.mergedTo = this;
                    this.merged.add(p);
                }
                c.merged.clear();
                this.merged.add(c);
            }
        }

        public NetworkHHCluster getMergeCluster() {
            return this.mergedTo == null || this.mergedTo == this ? this : this.mergedTo.getMergeCluster();
        }

        public int neighborsSize() {
            return this.neighbors.size();
        }
    }
}

