/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.wiki;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.osmand.shared.wiki.WikiImage;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u000e\u001a\u00020\u000f2\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0011J \u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0011H\u0002J \u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u001c\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u0005J\u000e\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0005J\u001c\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001e2\u0006\u0010\u001b\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lnet/osmand/shared/wiki/WikiHelper;", "", "<init>", "()V", "WIKIPEDIA_PREFIX", "", "WIKIPEDIA_TAG_PREFIX", "WIKIMEDIA_FILE_PREFIX", "WIKIMEDIA_CATEGORY_PREFIX", "OSMAND_IMAGES_BASE_URL", "IMAGE_FULL_SIZE", "", "IMAGE_THUMB_SIZE", "IMAGE_ICON_SIZE", "extractWikiTagData", "Lnet/osmand/shared/wiki/WikiHelper$WikiTagData;", "tags", "", "extractWikiTitle", "extractWikiCategory", "parseWikipediaUrl", "url", "addFile", "", "wikiImages", "", "Lnet/osmand/shared/wiki/WikiImage;", "imageFileName", "getImageData", "getWikiHash", "Lkotlin/Pair;", "WikiTagData", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nWikiHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WikiHelper.kt\nnet/osmand/shared/wiki/WikiHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1#2:83\n295#3,2:84\n*S KotlinDebug\n*F\n+ 1 WikiHelper.kt\nnet/osmand/shared/wiki/WikiHelper\n*L\n41#1:84,2\n*E\n"})
public final class WikiHelper {
    @NotNull
    public static final WikiHelper INSTANCE = new WikiHelper();
    @NotNull
    private static final String WIKIPEDIA_PREFIX = ".wikipedia.org/wiki/";
    @NotNull
    private static final String WIKIPEDIA_TAG_PREFIX = "wikipedia:";
    @NotNull
    private static final String WIKIMEDIA_FILE_PREFIX = "File:";
    @NotNull
    private static final String WIKIMEDIA_CATEGORY_PREFIX = "Category:";
    @NotNull
    private static final String OSMAND_IMAGES_BASE_URL = "https://data.osmand.net/wikimedia/images-1280";
    private static final int IMAGE_FULL_SIZE = 1280;
    private static final int IMAGE_THUMB_SIZE = 480;
    private static final int IMAGE_ICON_SIZE = 160;

    private WikiHelper() {
    }

    @NotNull
    public final WikiTagData extractWikiTagData(@Nullable Map<String, String> tags) {
        String wikiCategory;
        String wikiTitle;
        Map<String, String> wikidataId;
        List wikiImages;
        block2: {
            wikiImages = new ArrayList();
            Map<String, String> map = tags;
            if (map == null || (map = map.get("wikidata")) == null) {
                map = "";
            }
            wikidataId = map;
            wikiTitle = this.extractWikiTitle(tags);
            wikiCategory = this.extractWikiCategory(tags);
            Map<String, String> map2 = tags;
            if (map2 == null || (map2 = map2.get("wikimedia_commons")) == null) break block2;
            Map<String, String> it = map2;
            boolean bl = false;
            if (StringsKt.startsWith$default((String)((Object)it), (String)WIKIMEDIA_FILE_PREFIX, (boolean)false, (int)2, null)) {
                INSTANCE.addFile(wikiImages, StringsKt.removePrefix((String)((Object)it), (CharSequence)WIKIMEDIA_FILE_PREFIX));
            }
        }
        return new WikiTagData(wikiImages, (String)((Object)wikidataId), wikiCategory, wikiTitle);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String extractWikiTitle(Map<String, String> tags) {
        Object v2;
        block4: {
            String string;
            Map<String, String> map = tags;
            if (map != null && (map = map.get("wikipedia")) != null) {
                Map<String, String> it = map;
                boolean bl = false;
                string = INSTANCE.parseWikipediaUrl((String)((Object)it));
            } else {
                string = null;
            }
            String directTitle = string;
            Set<Map.Entry<String, String>> set = directTitle;
            if (!(set == null || set.length() == 0)) {
                return directTitle;
            }
            if (tags == null) return null;
            set = tags.entrySet();
            if (set == null) return null;
            Iterable $this$firstOrNull$iv = set;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)((String)it.getKey()), (String)WIKIPEDIA_TAG_PREFIX, (boolean)false, (int)2, null)) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        Map.Entry entry = v2;
        if (entry == null) return null;
        Map.Entry it = entry;
        boolean bl = false;
        String string = StringsKt.removePrefix((String)((String)it.getKey()), (CharSequence)WIKIPEDIA_TAG_PREFIX) + ":" + it.getValue();
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String extractWikiCategory(Map<String, String> tags) {
        String string;
        if (tags == null) return null;
        String string2 = tags.get("wikimedia_commons");
        if (string2 == null) return null;
        String it = string = string2;
        boolean bl = false;
        if (!StringsKt.startsWith$default((String)it, (String)WIKIMEDIA_CATEGORY_PREFIX, (boolean)false, (int)2, null)) return null;
        String string3 = string;
        String string4 = string3;
        if (string4 == null) return null;
        String string5 = StringsKt.removePrefix((String)string4, (CharSequence)WIKIMEDIA_CATEGORY_PREFIX);
        return string5;
    }

    private final String parseWikipediaUrl(String url) {
        Object object;
        int urlIndex = StringsKt.indexOf$default((CharSequence)url, (String)WIKIPEDIA_PREFIX, (int)0, (boolean)false, (int)6, null);
        if (urlIndex > 0) {
            String lang = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)url, (String)WIKIPEDIA_PREFIX, null, (int)2, null), (String)"/", null, (int)2, null);
            String string = url.substring(urlIndex + 20);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String title = string;
            object = lang + ":" + title;
        } else {
            object = url;
        }
        return object;
    }

    public final void addFile(@NotNull List<WikiImage> wikiImages, @NotNull String imageFileName) {
        Intrinsics.checkNotNullParameter(wikiImages, (String)"wikiImages");
        Intrinsics.checkNotNullParameter((Object)imageFileName, (String)"imageFileName");
        WikiImage it = this.getImageData(imageFileName);
        boolean bl = false;
        wikiImages.add(it);
    }

    @NotNull
    public final WikiImage getImageData(@NotNull String imageFileName) {
        Intrinsics.checkNotNullParameter((Object)imageFileName, (String)"imageFileName");
        Pair<String, String> hash = this.getWikiHash(imageFileName);
        String h1 = (String)hash.getFirst();
        String h2 = (String)hash.getSecond();
        String string = "https://data.osmand.net/wikimedia/images-1280/" + h1 + "/" + h2 + "/" + imageFileName + "?width=1280";
        String string2 = "https://data.osmand.net/wikimedia/images-1280/" + h1 + "/" + h2 + "/" + imageFileName + "?width=480";
        String string3 = "https://data.osmand.net/wikimedia/images-1280/" + h1 + "/" + h2 + "/" + imageFileName + "?width=160";
        return new WikiImage(imageFileName, imageFileName, string2, string, string3);
    }

    private final Pair<String, String> getWikiHash(String imageFileName) {
        String md5 = ByteString.Companion.encodeUtf8(imageFileName).md5().hex();
        String string = md5.substring(0, 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String string2 = md5.substring(0, 2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return new Pair((Object)string, (Object)string2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J=\u0010\u0015\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lnet/osmand/shared/wiki/WikiHelper$WikiTagData;", "", "wikiImages", "", "Lnet/osmand/shared/wiki/WikiImage;", "wikidataId", "", "wikiCategory", "wikiTitle", "<init>", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getWikiImages", "()Ljava/util/List;", "getWikidataId", "()Ljava/lang/String;", "getWikiCategory", "getWikiTitle", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "OsmAnd-shared"})
    public static final class WikiTagData {
        @NotNull
        private final List<WikiImage> wikiImages;
        @Nullable
        private final String wikidataId;
        @Nullable
        private final String wikiCategory;
        @Nullable
        private final String wikiTitle;

        public WikiTagData(@NotNull List<WikiImage> wikiImages, @Nullable String wikidataId, @Nullable String wikiCategory, @Nullable String wikiTitle) {
            Intrinsics.checkNotNullParameter(wikiImages, (String)"wikiImages");
            this.wikiImages = wikiImages;
            this.wikidataId = wikidataId;
            this.wikiCategory = wikiCategory;
            this.wikiTitle = wikiTitle;
        }

        @NotNull
        public final List<WikiImage> getWikiImages() {
            return this.wikiImages;
        }

        @Nullable
        public final String getWikidataId() {
            return this.wikidataId;
        }

        @Nullable
        public final String getWikiCategory() {
            return this.wikiCategory;
        }

        @Nullable
        public final String getWikiTitle() {
            return this.wikiTitle;
        }

        @NotNull
        public final List<WikiImage> component1() {
            return this.wikiImages;
        }

        @Nullable
        public final String component2() {
            return this.wikidataId;
        }

        @Nullable
        public final String component3() {
            return this.wikiCategory;
        }

        @Nullable
        public final String component4() {
            return this.wikiTitle;
        }

        @NotNull
        public final WikiTagData copy(@NotNull List<WikiImage> wikiImages, @Nullable String wikidataId, @Nullable String wikiCategory, @Nullable String wikiTitle) {
            Intrinsics.checkNotNullParameter(wikiImages, (String)"wikiImages");
            return new WikiTagData(wikiImages, wikidataId, wikiCategory, wikiTitle);
        }

        public static /* synthetic */ WikiTagData copy$default(WikiTagData wikiTagData, List list, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                list = wikiTagData.wikiImages;
            }
            if ((n & 2) != 0) {
                string = wikiTagData.wikidataId;
            }
            if ((n & 4) != 0) {
                string2 = wikiTagData.wikiCategory;
            }
            if ((n & 8) != 0) {
                string3 = wikiTagData.wikiTitle;
            }
            return wikiTagData.copy(list, string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "WikiTagData(wikiImages=" + this.wikiImages + ", wikidataId=" + this.wikidataId + ", wikiCategory=" + this.wikiCategory + ", wikiTitle=" + this.wikiTitle + ")";
        }

        public int hashCode() {
            int result = ((Object)this.wikiImages).hashCode();
            result = result * 31 + (this.wikidataId == null ? 0 : this.wikidataId.hashCode());
            result = result * 31 + (this.wikiCategory == null ? 0 : this.wikiCategory.hashCode());
            result = result * 31 + (this.wikiTitle == null ? 0 : this.wikiTitle.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WikiTagData)) {
                return false;
            }
            WikiTagData wikiTagData = (WikiTagData)other;
            if (!Intrinsics.areEqual(this.wikiImages, wikiTagData.wikiImages)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.wikidataId, (Object)wikiTagData.wikidataId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.wikiCategory, (Object)wikiTagData.wikiCategory)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.wikiTitle, (Object)wikiTagData.wikiTitle);
        }
    }
}

