/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.wiki;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialName;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.DoubleArraySerializer;
import kotlinx.serialization.internal.DoubleSerializer;
import kotlinx.serialization.internal.LongSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonArraySerializer;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.modules.SerializersModule;
import net.osmand.shared.api.NetworkAPI;
import net.osmand.shared.data.KQuadRect;
import net.osmand.shared.util.KAlgorithms;
import net.osmand.shared.util.Logger;
import net.osmand.shared.util.LoggerFactory;
import net.osmand.shared.util.PlatformUtil;
import net.osmand.shared.util.UrlEncoder;
import net.osmand.shared.wiki.WikiCoreHelper$Categorymember$;
import net.osmand.shared.wiki.WikiCoreHelper$Claims$;
import net.osmand.shared.wiki.WikiCoreHelper$Datavalue$;
import net.osmand.shared.wiki.WikiCoreHelper$Mainsnak$;
import net.osmand.shared.wiki.WikiCoreHelper$OsmandAPIFeaturesResponse$;
import net.osmand.shared.wiki.WikiCoreHelper$OsmandAPIResponseV2$;
import net.osmand.shared.wiki.WikiCoreHelper$OsmandApiFeatureData$;
import net.osmand.shared.wiki.WikiCoreHelper$P18$;
import net.osmand.shared.wiki.WikiCoreHelper$Query$;
import net.osmand.shared.wiki.WikiCoreHelper$WikiDataGeometry$;
import net.osmand.shared.wiki.WikiCoreHelper$WikiDataProperties$;
import net.osmand.shared.wiki.WikiCoreHelper$WikidataResponse$;
import net.osmand.shared.wiki.WikiCoreHelper$WikimediaResponse$;
import net.osmand.shared.wiki.WikiHelper;
import net.osmand.shared.wiki.WikiImage;
import net.osmand.shared.wiki.WikiMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0019\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000eGHIJKLMNOPQRSTB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001a2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\tJ,\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u001a2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0'2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)J\"\u0010*\u001a\b\u0012\u0004\u0012\u00020%0\u001a2\u0006\u0010+\u001a\u00020\t2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020%0-J\u001e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\t2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001f0-H\u0002J.\u00101\u001a\b\u0012\u0004\u0012\u00020%0\u001a2\u0006\u00100\u001a\u00020\t2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020%0-2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J&\u00102\u001a\b\u0012\u0004\u0012\u00020%0\u001a2\b\u00103\u001a\u0004\u0018\u0001042\f\u0010,\u001a\b\u0012\u0004\u0012\u00020%0-H\u0002J,\u00105\u001a\b\u0012\u0004\u0012\u00020%0\u001a2\u0006\u00106\u001a\u00020\t2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020%0-2\u0006\u00107\u001a\u00020\u0012H\u0002J\"\u00108\u001a\b\u0012\u0004\u0012\u00020%0\u001a2\u0006\u00109\u001a\u00020\t2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020%0-J\u0012\u0010:\u001a\u0004\u0018\u00010%2\u0006\u0010;\u001a\u00020<H\u0002J\u0012\u0010=\u001a\u0004\u0018\u00010%2\u0006\u0010>\u001a\u00020\tH\u0002J\u0010\u0010?\u001a\u00020\u00072\u0006\u0010@\u001a\u00020%H\u0002J4\u0010A\u001a\u0004\u0018\u0001HB\"\u0006\b\u0000\u0010B\u0018\u00012\u0006\u00100\u001a\u00020\t2\u0006\u0010C\u001a\u00020\u00072\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)H\u0082\b\u00a2\u0006\u0002\u0010DJ\u0016\u0010E\u001a\u0004\u0018\u00010\t*\u00020<2\u0006\u0010F\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001d\u0010\u0003\u00a8\u0006U"}, d2={"Lnet/osmand/shared/wiki/WikiCoreHelper;", "", "<init>", "()V", "LOG", "Lnet/osmand/shared/util/Logger;", "USE_OSMAND_WIKI_API", "", "WIKIMEDIA_API_ENDPOINT", "", "WIKIDATA_API_ENDPOINT", "WIKIDATA_ACTION", "WIKIMEDIA_ACTION", "CM_LIMIT", "FORMAT_JSON", "WIKIMEDIA_FILE", "WIKIMEDIA_CATEGORY", "THUMB_SIZE", "", "ICON_SIZE", "OSMAND_API_ENDPOINT", "OSMAND_SEARCH_ENDPOINT", "WIKI_PLACE_ACTION", "GET_WIKI_DATA_ACTION", "DEPT_CAT_LIMIT", "IMAGE_EXTENSIONS", "", "jsonParser", "Lkotlinx/serialization/json/Json;", "getJsonParser$annotations", "getExploreImageList", "Lnet/osmand/shared/wiki/WikiCoreHelper$OsmandApiFeatureData;", "mapRect", "Lnet/osmand/shared/data/KQuadRect;", "zoom", "langs", "getWikiImageList", "Lnet/osmand/shared/wiki/WikiImage;", "tags", "", "listener", "Lnet/osmand/shared/wiki/WikiCoreHelper$NetworkResponseListener;", "getImagesFromJson", "json", "wikiImages", "", "getNearbyImagesOsmAndAPIRequest", "", "url", "getImagesOsmAndAPIRequestV2", "createWikiImages", "response", "Lnet/osmand/shared/wiki/WikiCoreHelper$OsmandAPIResponseV2;", "getWikimediaImageCategory", "categoryName", "depth", "getWikidataImageWikidata", "wikidataId", "parseImageDataWithMetaData", "image", "Lkotlinx/serialization/json/JsonObject;", "parseImageDataFromFile", "imageUrl", "isUrlFileImage", "wikiImage", "sendWikipediaApiRequest", "T", "useGzip", "(Ljava/lang/String;ZLnet/osmand/shared/wiki/WikiCoreHelper$NetworkResponseListener;)Ljava/lang/Object;", "getString", "key", "OsmandAPIFeaturesResponse", "OsmandAPIResponseV2", "OsmandApiFeatureData", "WikiDataGeometry", "WikiDataProperties", "WikidataResponse", "Claims", "P18", "Mainsnak", "Datavalue", "WikimediaResponse", "Query", "Categorymember", "NetworkResponseListener", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nWikiCoreHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WikiCoreHelper.kt\nnet/osmand/shared/wiki/WikiCoreHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,330:1\n237#1,10:332\n248#1,6:343\n242#1,5:349\n248#1,6:355\n237#1,10:363\n248#1,6:374\n237#1,10:380\n248#1,6:391\n1#2:331\n96#3:342\n96#3:354\n96#3:373\n96#3:390\n96#3:399\n1863#4,2:361\n1863#4,2:397\n*S KotlinDebug\n*F\n+ 1 WikiCoreHelper.kt\nnet/osmand/shared/wiki/WikiCoreHelper\n*L\n126#1:332,10\n126#1:343,6\n136#1:349,5\n136#1:355,6\n163#1:363,10\n163#1:374,6\n188#1:380,10\n188#1:391,6\n126#1:342\n136#1:354\n163#1:373\n188#1:390\n246#1:399\n144#1:361,2\n190#1:397,2\n*E\n"})
public final class WikiCoreHelper {
    @NotNull
    public static final WikiCoreHelper INSTANCE = new WikiCoreHelper();
    @NotNull
    private static final Logger LOG = LoggerFactory.INSTANCE.getLogger("WikiCoreHelper");
    public static final boolean USE_OSMAND_WIKI_API = true;
    @NotNull
    private static final String WIKIMEDIA_API_ENDPOINT = "https://commons.wikimedia.org/w/api.php";
    @NotNull
    private static final String WIKIDATA_API_ENDPOINT = "https://www.wikidata.org/w/api.php";
    @NotNull
    private static final String WIKIDATA_ACTION = "?action=wbgetclaims&property=P18&entity=";
    @NotNull
    private static final String WIKIMEDIA_ACTION = "?action=query&list=categorymembers&cmtitle=";
    @NotNull
    private static final String CM_LIMIT = "&cmlimit=100";
    @NotNull
    private static final String FORMAT_JSON = "&format=json";
    @NotNull
    public static final String WIKIMEDIA_FILE = "File:";
    @NotNull
    public static final String WIKIMEDIA_CATEGORY = "Category:";
    private static final int THUMB_SIZE = 480;
    private static final int ICON_SIZE = 64;
    @NotNull
    public static final String OSMAND_API_ENDPOINT = "https://osmand.net/api/";
    @NotNull
    public static final String OSMAND_SEARCH_ENDPOINT = "https://osmand.net/search/";
    @NotNull
    private static final String WIKI_PLACE_ACTION = "wiki_place?";
    @NotNull
    private static final String GET_WIKI_DATA_ACTION = "get-wiki-data?";
    private static final int DEPT_CAT_LIMIT = 1;
    @NotNull
    private static final List<String> IMAGE_EXTENSIONS;
    @NotNull
    private static final Json jsonParser;

    private WikiCoreHelper() {
    }

    private static /* synthetic */ void getJsonParser$annotations() {
    }

    @NotNull
    public final List<OsmandApiFeatureData> getExploreImageList(@NotNull KQuadRect mapRect, int zoom, @NotNull String langs) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)mapRect, (String)"mapRect");
        Intrinsics.checkNotNullParameter((Object)langs, (String)"langs");
        List wikiImages = new ArrayList();
        String baseApiActionUrl = "https://osmand.net/search/get-wiki-data?";
        String nw = mapRect.getTop() + "," + mapRect.getLeft();
        String se = mapRect.getBottom() + "," + mapRect.getRight();
        StringBuilder $this$getExploreImageList_u24lambda_u241 = stringBuilder = new StringBuilder(baseApiActionUrl);
        boolean bl = false;
        $this$getExploreImageList_u24lambda_u241.append("northWest=").append(UrlEncoder.INSTANCE.encode(nw));
        $this$getExploreImageList_u24lambda_u241.append("&southEast=").append(UrlEncoder.INSTANCE.encode(se));
        $this$getExploreImageList_u24lambda_u241.append("&zoom=").append(zoom);
        $this$getExploreImageList_u24lambda_u241.append("&lang=").append(langs);
        $this$getExploreImageList_u24lambda_u241.append("&filters=");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String url = string;
        LOG.debug("Download images " + url);
        this.getNearbyImagesOsmAndAPIRequest(url, wikiImages);
        return wikiImages;
    }

    @NotNull
    public final List<WikiImage> getWikiImageList(@NotNull Map<String, String> tags, @Nullable NetworkResponseListener listener) {
        String string;
        String string2;
        String it;
        String string3;
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        WikiHelper.WikiTagData wikiTagData = WikiHelper.INSTANCE.extractWikiTagData(tags);
        String wikidataId = wikiTagData.getWikidataId();
        String wikiCategory = wikiTagData.getWikiCategory();
        String wikiTitle = wikiTagData.getWikiTitle();
        List<WikiImage> wikiImages = wikiTagData.getWikiImages();
        List params = new ArrayList();
        String string4 = wikidataId;
        if (string4 != null) {
            it = string3 = string4;
            boolean bl = false;
            string4 = ((CharSequence)it).length() > 0 ? string3 : null;
            if (string4 != null) {
                it = string4;
                boolean bl2 = false;
                params.add("article=" + UrlEncoder.INSTANCE.encode(it));
            }
        }
        if ((string2 = wikiCategory) != null) {
            it = string3 = string2;
            boolean bl = false;
            string2 = ((CharSequence)it).length() > 0 ? string3 : null;
            if (string2 != null) {
                it = string2;
                boolean bl3 = false;
                params.add("category=" + UrlEncoder.INSTANCE.encode(it));
            }
        }
        if ((string = wikiTitle) != null) {
            it = string3 = string;
            boolean bl = false;
            string = ((CharSequence)it).length() > 0 ? string3 : null;
            if (string != null) {
                it = string;
                boolean bl4 = false;
                params.add("wiki=" + UrlEncoder.INSTANCE.encode(it));
            }
        }
        if (!((Collection)params).isEmpty()) {
            String urlParams = CollectionsKt.joinToString$default((Iterable)params, (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
            String finalUrl = "https://osmand.net/api/wiki_place?" + urlParams + "&addMetaData=true";
            this.getImagesOsmAndAPIRequestV2(finalUrl, wikiImages, listener);
        }
        return wikiImages;
    }

    public static /* synthetic */ List getWikiImageList$default(WikiCoreHelper wikiCoreHelper, Map map, NetworkResponseListener networkResponseListener, int n, Object object) {
        if ((n & 2) != 0) {
            networkResponseListener = null;
        }
        return wikiCoreHelper.getWikiImageList(map, networkResponseListener);
    }

    @NotNull
    public final List<WikiImage> getImagesFromJson(@NotNull String json, @NotNull List<WikiImage> wikiImages) {
        List<WikiImage> list;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter(wikiImages, (String)"wikiImages");
        try {
            OsmandAPIResponseV2 response = (OsmandAPIResponseV2)jsonParser.decodeFromString((DeserializationStrategy)OsmandAPIResponseV2.Companion.serializer(), json);
            list = this.createWikiImages(response, wikiImages);
        }
        catch (Exception e) {
            LOG.error("Failed to parse JSON from string", e);
            list = wikiImages;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final void getNearbyImagesOsmAndAPIRequest(String url, List<OsmandApiFeatureData> wikiImages) {
        block5: {
            OsmandAPIFeaturesResponse response;
            Object object;
            NetworkAPI.NetworkResponse response$iv;
            boolean useGzip$iv = true;
            Object listener$iv = null;
            boolean $i$f$sendWikipediaApiRequest = false;
            try {
                Object object2;
                response$iv = NetworkAPI.sendGetRequest$default(PlatformUtil.INSTANCE.getNetworkAPI(), url, null, useGzip$iv, null, 8, null);
                if (response$iv.getError() == null && response$iv.getResponse() != null) {
                    void this_$iv$iv;
                    Json json = WikiCoreHelper.jsonParser;
                    String string$iv$iv = response$iv.getResponse();
                    boolean $i$f$decodeFromString = false;
                    this_$iv$iv.getSerializersModule();
                    object2 = this_$iv$iv.decodeFromString((DeserializationStrategy)OsmandAPIFeaturesResponse.Companion.serializer(), string$iv$iv);
                } else {
                    Logger.error$default(WikiCoreHelper.LOG, "Request failed: " + response$iv.getError(), null, 2, null);
                    object2 = null;
                }
                response$iv = object2;
            }
            catch (Exception e$iv) {
                Logger logger = WikiCoreHelper.LOG;
                String string = e$iv.getMessage();
                if (string == null) {
                    string = "Request/parse failed";
                }
                logger.error(string, e$iv);
                response$iv = null;
            }
            if ((object = (response = (OsmandAPIFeaturesResponse)((Object)response$iv))) == null || (object = ((OsmandAPIFeaturesResponse)object).getFeatures()) == null) break block5;
            Object it = object;
            boolean bl = false;
            wikiImages.addAll((Collection)it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<WikiImage> getImagesOsmAndAPIRequestV2(String url, List<WikiImage> wikiImages, NetworkResponseListener listener) {
        Object object;
        WikiCoreHelper wikiCoreHelper = this;
        boolean useGzip$iv = false;
        boolean $i$f$sendWikipediaApiRequest = false;
        try {
            Object object2;
            NetworkAPI.NetworkResponse response$iv = NetworkAPI.sendGetRequest$default(PlatformUtil.INSTANCE.getNetworkAPI(), url, null, useGzip$iv, null, 8, null);
            if (response$iv.getError() == null && response$iv.getResponse() != null) {
                void this_$iv$iv;
                NetworkResponseListener networkResponseListener = listener;
                if (networkResponseListener != null) {
                    networkResponseListener.onGetRawResponse(response$iv.getResponse());
                }
                Json json = WikiCoreHelper.jsonParser;
                String string$iv$iv = response$iv.getResponse();
                boolean $i$f$decodeFromString = false;
                this_$iv$iv.getSerializersModule();
                object2 = this_$iv$iv.decodeFromString((DeserializationStrategy)OsmandAPIResponseV2.Companion.serializer(), string$iv$iv);
            } else {
                Logger.error$default(WikiCoreHelper.LOG, "Request failed: " + response$iv.getError(), null, 2, null);
                object2 = null;
            }
            object = object2;
        }
        catch (Exception e$iv) {
            Logger logger = WikiCoreHelper.LOG;
            String string = e$iv.getMessage();
            if (string == null) {
                string = "Request/parse failed";
            }
            logger.error(string, e$iv);
            object = null;
        }
        OsmandAPIResponseV2 response = (OsmandAPIResponseV2)object;
        return this.createWikiImages(response, wikiImages);
    }

    private final List<WikiImage> createWikiImages(OsmandAPIResponseV2 response, List<WikiImage> wikiImages) {
        block1: {
            OsmandAPIResponseV2 osmandAPIResponseV2 = response;
            if (osmandAPIResponseV2 == null || (osmandAPIResponseV2 = osmandAPIResponseV2.getImages()) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)((Object)osmandAPIResponseV2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WikiImage wikiImage;
                JsonElement obj = (JsonElement)element$iv;
                boolean bl = false;
                if (!(obj instanceof JsonObject) || (wikiImage = INSTANCE.parseImageDataWithMetaData((JsonObject)obj)) == null || !INSTANCE.isUrlFileImage(wikiImage)) continue;
                wikiImages.add(wikiImage);
            }
        }
        return wikiImages;
    }

    /*
     * WARNING - void declaration
     */
    private final List<WikiImage> getWikimediaImageCategory(String categoryName, List<WikiImage> wikiImages, int depth) {
        WikimediaResponse response;
        Object object;
        NetworkAPI.NetworkResponse response$iv;
        Object name = StringsKt.startsWith$default((String)categoryName, (String)WIKIMEDIA_CATEGORY, (boolean)false, (int)2, null) ? categoryName : WIKIMEDIA_CATEGORY + categoryName;
        String url = "https://commons.wikimedia.org/w/api.php?action=query&list=categorymembers&cmtitle=" + (String)name + "&cmlimit=100&format=json";
        boolean useGzip$iv = false;
        Collection listener$iv = null;
        boolean $i$f$sendWikipediaApiRequest = false;
        try {
            Object object2;
            response$iv = NetworkAPI.sendGetRequest$default(PlatformUtil.INSTANCE.getNetworkAPI(), url, null, useGzip$iv, null, 8, null);
            if (response$iv.getError() == null && response$iv.getResponse() != null) {
                void this_$iv$iv;
                Json json = WikiCoreHelper.jsonParser;
                String string$iv$iv = response$iv.getResponse();
                boolean $i$f$decodeFromString = false;
                this_$iv$iv.getSerializersModule();
                object2 = this_$iv$iv.decodeFromString((DeserializationStrategy)WikimediaResponse.Companion.serializer(), string$iv$iv);
            } else {
                Logger.error$default(WikiCoreHelper.LOG, "Request failed: " + response$iv.getError(), null, 2, null);
                object2 = null;
            }
            response$iv = object2;
        }
        catch (Exception e$iv) {
            Logger logger = WikiCoreHelper.LOG;
            String string = e$iv.getMessage();
            if (string == null) {
                string = "Request/parse failed";
            }
            logger.error(string, e$iv);
            response$iv = null;
        }
        List<Categorymember> members = (object = (response = (WikimediaResponse)((Object)response$iv))) != null && (object = ((WikimediaResponse)object).getQuery()) != null ? ((Query)object).getCategorymembers() : null;
        listener$iv = members;
        if (!(listener$iv == null || listener$iv.isEmpty())) {
            List subCategories = new ArrayList();
            for (Categorymember cm : members) {
                String memberTitle;
                if (cm.getTitle() == null) continue;
                if (StringsKt.startsWith$default((String)memberTitle, (String)WIKIMEDIA_CATEGORY, (boolean)false, (int)2, null)) {
                    subCategories.add(memberTitle);
                    continue;
                }
                if (!StringsKt.startsWith$default((String)memberTitle, (String)WIKIMEDIA_FILE, (boolean)false, (int)2, null)) continue;
                WikiHelper.INSTANCE.addFile(wikiImages, memberTitle);
            }
            if (depth < 1) {
                for (String subCategory : subCategories) {
                    this.getWikimediaImageCategory(subCategory, wikiImages, depth + 1);
                }
            }
        }
        return wikiImages;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<WikiImage> getWikidataImageWikidata(@NotNull String wikidataId, @NotNull List<WikiImage> wikiImages) {
        block6: {
            WikidataResponse response;
            List<P18> list;
            NetworkAPI.NetworkResponse response$iv;
            Intrinsics.checkNotNullParameter((Object)wikidataId, (String)"wikidataId");
            Intrinsics.checkNotNullParameter(wikiImages, (String)"wikiImages");
            String url = "https://www.wikidata.org/w/api.php?action=wbgetclaims&property=P18&entity=" + wikidataId + FORMAT_JSON;
            boolean useGzip$iv = false;
            Object listener$iv = null;
            boolean $i$f$sendWikipediaApiRequest = false;
            try {
                Object object;
                response$iv = NetworkAPI.sendGetRequest$default(PlatformUtil.INSTANCE.getNetworkAPI(), url, null, useGzip$iv, null, 8, null);
                if (response$iv.getError() == null && response$iv.getResponse() != null) {
                    void this_$iv$iv;
                    Json json = WikiCoreHelper.jsonParser;
                    String string$iv$iv = response$iv.getResponse();
                    boolean $i$f$decodeFromString = false;
                    this_$iv$iv.getSerializersModule();
                    object = this_$iv$iv.decodeFromString((DeserializationStrategy)WikidataResponse.Companion.serializer(), string$iv$iv);
                } else {
                    Logger.error$default(WikiCoreHelper.LOG, "Request failed: " + response$iv.getError(), null, 2, null);
                    object = null;
                }
                response$iv = object;
            }
            catch (Exception e$iv) {
                Logger logger = WikiCoreHelper.LOG;
                String string = e$iv.getMessage();
                if (string == null) {
                    string = "Request/parse failed";
                }
                logger.error(string, e$iv);
                response$iv = null;
            }
            if ((list = (response = (WikidataResponse)((Object)response$iv))) == null || (list = ((WikidataResponse)((Object)list)).getClaims()) == null || (list = ((Claims)((Object)list)).getP18()) == null) break block6;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                P18 p18 = (P18)element$iv;
                boolean bl = false;
                Object object = p18.getMainsnak();
                if (object == null || (object = ((Mainsnak)object).getDatavalue()) == null || (object = ((Datavalue)object).getValue()) == null) continue;
                Object imageFileName = object;
                boolean bl2 = false;
                WikiImage wikiImage = WikiHelper.INSTANCE.getImageData((String)imageFileName);
                wikiImages.add(wikiImage);
            }
        }
        return wikiImages;
    }

    private final WikiImage parseImageDataWithMetaData(JsonObject image) {
        Object object;
        String it;
        String string = this.getString(image, "image");
        if (string == null) {
            return null;
        }
        String imageUrl = string;
        WikiImage wikiImage = this.parseImageDataFromFile(imageUrl);
        if (wikiImage == null) {
            return null;
        }
        WikiImage wikiImage2 = wikiImage;
        WikiMetadata.Metadata metadata = wikiImage2.getMetadata();
        String string2 = this.getString(image, "date");
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            metadata.setDate(it);
        }
        String string3 = this.getString(image, "author");
        if (string3 != null) {
            it = string3;
            boolean bl = false;
            metadata.setAuthor(it);
        }
        String string4 = this.getString(image, "license");
        if (string4 != null) {
            it = string4;
            boolean bl = false;
            metadata.setLicense(it);
        }
        long mediaIdLong = (object = this.getString(image, "mediaId")) != null && (object = StringsKt.toLongOrNull((String)object)) != null ? (Long)object : -1L;
        wikiImage2.setMediaId(mediaIdLong);
        return wikiImage2;
    }

    private final WikiImage parseImageDataFromFile(String imageUrl) {
        String imageHiResUrl = StringsKt.replace$default((String)StringsKt.replace$default((String)imageUrl, (String)"%20", (String)" ", (boolean)false, (int)4, null), (String)" ", (String)"_", (boolean)false, (int)4, null);
        String decodedUrl = UrlEncoder.INSTANCE.decode(imageUrl);
        String imageFileName = KAlgorithms.INSTANCE.getFileWithoutDirs(decodedUrl);
        String imageName = KAlgorithms.INSTANCE.getFileNameWithoutExtension(decodedUrl);
        String imageStubUrl = imageHiResUrl + "?width=480";
        String imageIconUrl = imageHiResUrl + "?width=64";
        return new WikiImage(imageFileName, imageName, imageStubUrl, imageHiResUrl, imageIconUrl);
    }

    private final boolean isUrlFileImage(WikiImage wikiImage) {
        String path = wikiImage.getImageHiResUrl();
        int lastDot = StringsKt.lastIndexOf$default((CharSequence)path, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (lastDot != -1) {
            String string = path.substring(lastDot);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String ext = string2;
            return IMAGE_EXTENSIONS.contains(ext);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final /* synthetic */ <T> T sendWikipediaApiRequest(String url, boolean useGzip, NetworkResponseListener listener) {
        Object object;
        boolean $i$f$sendWikipediaApiRequest = false;
        try {
            Object object2;
            NetworkAPI.NetworkResponse response = NetworkAPI.sendGetRequest$default(PlatformUtil.INSTANCE.getNetworkAPI(), url, null, useGzip, null, 8, null);
            if (response.getError() == null && response.getResponse() != null) {
                void this_$iv;
                NetworkResponseListener networkResponseListener = listener;
                if (networkResponseListener != null) {
                    networkResponseListener.onGetRawResponse(response.getResponse());
                }
                Json json = WikiCoreHelper.jsonParser;
                String string$iv = response.getResponse();
                boolean $i$f$decodeFromString = false;
                SerializersModule serializersModule = this_$iv.getSerializersModule();
                Intrinsics.reifiedOperationMarker((int)6, (String)"T");
                MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
                object2 = this_$iv.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, null), string$iv);
            } else {
                Logger.error$default(WikiCoreHelper.LOG, "Request failed: " + response.getError(), null, 2, null);
                object2 = null;
            }
            object = object2;
        }
        catch (Exception e) {
            Logger logger = WikiCoreHelper.LOG;
            String string = e.getMessage();
            if (string == null) {
                string = "Request/parse failed";
            }
            logger.error(string, e);
            object = null;
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object sendWikipediaApiRequest$default(WikiCoreHelper $this, String url, boolean useGzip, NetworkResponseListener listener, int n, Object object) {
        if ((n & 4) != 0) {
            listener = null;
        }
        boolean $i$f$sendWikipediaApiRequest = false;
        try {
            Object object2;
            NetworkAPI.NetworkResponse response = NetworkAPI.sendGetRequest$default(PlatformUtil.INSTANCE.getNetworkAPI(), url, null, useGzip, null, 8, null);
            if (response.getError() == null && response.getResponse() != null) {
                void this_$iv;
                NetworkResponseListener networkResponseListener = listener;
                if (networkResponseListener != null) {
                    networkResponseListener.onGetRawResponse(response.getResponse());
                }
                Json json = WikiCoreHelper.jsonParser;
                String string$iv = response.getResponse();
                boolean $i$f$decodeFromString = false;
                SerializersModule serializersModule = this_$iv.getSerializersModule();
                Intrinsics.reifiedOperationMarker((int)6, (String)"T");
                MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
                object2 = this_$iv.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, null), string$iv);
            } else {
                Logger.error$default(WikiCoreHelper.LOG, "Request failed: " + response.getError(), null, 2, null);
                object2 = null;
            }
            object = object2;
        }
        catch (Exception e) {
            Logger logger = WikiCoreHelper.LOG;
            String string = e.getMessage();
            if (string == null) {
                string = "Request/parse failed";
            }
            logger.error(string, e);
            object = null;
        }
        return object;
    }

    private final String getString(JsonObject $this$getString, String key) {
        JsonElement jsonElement = (JsonElement)$this$getString.get((Object)key);
        if (jsonElement == null) {
            return null;
        }
        JsonElement value = jsonElement;
        JsonElement jsonElement2 = value;
        return jsonElement2 instanceof JsonNull ? null : (jsonElement2 instanceof JsonPrimitive ? JsonElementKt.getContentOrNull((JsonPrimitive)((JsonPrimitive)value)) : value.toString());
    }

    private static final Unit jsonParser$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setCoerceInputValues(true);
        $this$Json.setExplicitNulls(false);
        $this$Json.setLenient(true);
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new String[]{".jpeg", ".jpg", ".png", ".gif"};
        IMAGE_EXTENSIONS = CollectionsKt.listOf((Object[])objectArray);
        jsonParser = JsonKt.Json$default(null, WikiCoreHelper::jsonParser$lambda$0, (int)1, null);
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B%\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0004\u0010\nJ\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0001\u00a2\u0006\u0002\b\u001bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lnet/osmand/shared/wiki/WikiCoreHelper$Categorymember;", "", "title", "", "<init>", "(Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getTitle", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$OsmAnd_shared", "$serializer", "Companion", "OsmAnd-shared"})
    public static final class Categorymember {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String title;

        public Categorymember(@Nullable String title) {
            this.title = title;
        }

        public /* synthetic */ Categorymember(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            this(string);
        }

        @Nullable
        public final String getTitle() {
            return this.title;
        }

        @Nullable
        public final String component1() {
            return this.title;
        }

        @NotNull
        public final Categorymember copy(@Nullable String title) {
            return new Categorymember(title);
        }

        public static /* synthetic */ Categorymember copy$default(Categorymember categorymember, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = categorymember.title;
            }
            return categorymember.copy(string);
        }

        @NotNull
        public String toString() {
            return "Categorymember(title=" + this.title + ")";
        }

        public int hashCode() {
            return this.title == null ? 0 : this.title.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Categorymember)) {
                return false;
            }
            Categorymember categorymember = (Categorymember)other;
            return Intrinsics.areEqual((Object)this.title, (Object)categorymember.title);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$OsmAnd_shared(Categorymember self, CompositeEncoder output, SerialDescriptor serialDesc) {
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.title != null) {
                output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.title);
            }
        }

        public /* synthetic */ Categorymember(int seen0, String title, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen0) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)Categorymember$$serializer.INSTANCE.getDescriptor());
            }
            this.title = (seen0 & 1) == 0 ? null : title;
        }

        public Categorymember() {
            this(null, 1, null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lnet/osmand/shared/wiki/WikiCoreHelper$Categorymember$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lnet/osmand/shared/wiki/WikiCoreHelper$Categorymember;", "OsmAnd-shared"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Categorymember> serializer() {
                return (KSerializer)Categorymember$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 !2\u00020\u0001:\u0002 !B\u0019\u0012\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B+\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\u0011\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001b\u0010\u0011\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J%\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0001\u00a2\u0006\u0002\b\u001fR$\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Lnet/osmand/shared/wiki/WikiCoreHelper$Claims;", "", "p18", "", "Lnet/osmand/shared/wiki/WikiCoreHelper$P18;", "<init>", "(Ljava/util/List;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/util/List;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getP18$annotations", "()V", "getP18", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$OsmAnd_shared", "$serializer", "Companion", "OsmAnd-shared"})
    public static final class Claims {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final List<P18> p18;
        @JvmField
        @NotNull
        private static final KSerializer<Object>[] $childSerializers;

        public Claims(@Nullable List<P18> p18) {
            this.p18 = p18;
        }

        public /* synthetic */ Claims(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = null;
            }
            this(list);
        }

        @Nullable
        public final List<P18> getP18() {
            return this.p18;
        }

        @SerialName(value="P18")
        public static /* synthetic */ void getP18$annotations() {
        }

        @Nullable
        public final List<P18> component1() {
            return this.p18;
        }

        @NotNull
        public final Claims copy(@Nullable List<P18> p18) {
            return new Claims(p18);
        }

        public static /* synthetic */ Claims copy$default(Claims claims, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = claims.p18;
            }
            return claims.copy(list);
        }

        @NotNull
        public String toString() {
            return "Claims(p18=" + this.p18 + ")";
        }

        public int hashCode() {
            return this.p18 == null ? 0 : ((Object)this.p18).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Claims)) {
                return false;
            }
            Claims claims = (Claims)other;
            return Intrinsics.areEqual(this.p18, claims.p18);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$OsmAnd_shared(Claims self, CompositeEncoder output, SerialDescriptor serialDesc) {
            KSerializer<Object>[] kSerializerArray = $childSerializers;
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.p18 != null) {
                output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)kSerializerArray[0], self.p18);
            }
        }

        public /* synthetic */ Claims(int seen0, List p18, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen0) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)Claims$$serializer.INSTANCE.getDescriptor());
            }
            this.p18 = (seen0 & 1) == 0 ? null : p18;
        }

        public Claims() {
            this(null, 1, null);
        }

        public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            KSerializer[] kSerializerArray = new KSerializer[]{new ArrayListSerializer((KSerializer)P18$$serializer.INSTANCE)};
            $childSerializers = kSerializerArray;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lnet/osmand/shared/wiki/WikiCoreHelper$Claims$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lnet/osmand/shared/wiki/WikiCoreHelper$Claims;", "OsmAnd-shared"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Claims> serializer() {
                return (KSerializer)Claims$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000  2\u00020\u0001:\u0002\u001f B\u001f\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B/\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J!\u0010\u0011\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0001\u00a2\u0006\u0002\b\u001eR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006!"}, d2={"Lnet/osmand/shared/wiki/WikiCoreHelper$Datavalue;", "", "value", "", "type", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getValue", "()Ljava/lang/String;", "getType", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$OsmAnd_shared", "$serializer", "Companion", "OsmAnd-shared"})
    public static final class Datavalue {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String value;
        @Nullable
        private final String type;

        public Datavalue(@Nullable String value, @Nullable String type) {
            this.value = value;
            this.type = type;
        }

        public /* synthetic */ Datavalue(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            this(string, string2);
        }

        @Nullable
        public final String getValue() {
            return this.value;
        }

        @Nullable
        public final String getType() {
            return this.type;
        }

        @Nullable
        public final String component1() {
            return this.value;
        }

        @Nullable
        public final String component2() {
            return this.type;
        }

        @NotNull
        public final Datavalue copy(@Nullable String value, @Nullable String type) {
            return new Datavalue(value, type);
        }

        public static /* synthetic */ Datavalue copy$default(Datavalue datavalue, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = datavalue.value;
            }
            if ((n & 2) != 0) {
                string2 = datavalue.type;
            }
            return datavalue.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Datavalue(value=" + this.value + ", type=" + this.type + ")";
        }

        public int hashCode() {
            int result = this.value == null ? 0 : this.value.hashCode();
            result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Datavalue)) {
                return false;
            }
            Datavalue datavalue = (Datavalue)other;
            if (!Intrinsics.areEqual((Object)this.value, (Object)datavalue.value)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.type, (Object)datavalue.type);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$OsmAnd_shared(Datavalue self, CompositeEncoder output, SerialDescriptor serialDesc) {
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.value != null) {
                output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.value);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.type != null) {
                output.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.type);
            }
        }

        public /* synthetic */ Datavalue(int seen0, String value, String type, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen0) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)Datavalue$$serializer.INSTANCE.getDescriptor());
            }
            this.value = (seen0 & 1) == 0 ? null : value;
            this.type = (seen0 & 2) == 0 ? null : type;
        }

        public Datavalue() {
            this(null, null, 3, null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lnet/osmand/shared/wiki/WikiCoreHelper$Datavalue$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lnet/osmand/shared/wiki/WikiCoreHelper$Datavalue;", "OsmAnd-shared"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Datavalue> serializer() {
                return (KSerializer)Datavalue$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \"2\u00020\u0001:\u0002!\"B\u001f\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B/\b\u0010\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J!\u0010\u0013\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001J%\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0001\u00a2\u0006\u0002\b R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006#"}, d2={"Lnet/osmand/shared/wiki/WikiCoreHelper$Mainsnak;", "", "datavalue", "Lnet/osmand/shared/wiki/WikiCoreHelper$Datavalue;", "datatype", "", "<init>", "(Lnet/osmand/shared/wiki/WikiCoreHelper$Datavalue;Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILnet/osmand/shared/wiki/WikiCoreHelper$Datavalue;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getDatavalue", "()Lnet/osmand/shared/wiki/WikiCoreHelper$Datavalue;", "getDatatype", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$OsmAnd_shared", "$serializer", "Companion", "OsmAnd-shared"})
    public static final class Mainsnak {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final Datavalue datavalue;
        @Nullable
        private final String datatype;

        public Mainsnak(@Nullable Datavalue datavalue, @Nullable String datatype) {
            this.datavalue = datavalue;
            this.datatype = datatype;
        }

        public /* synthetic */ Mainsnak(Datavalue datavalue, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                datavalue = null;
            }
            if ((n & 2) != 0) {
                string = null;
            }
            this(datavalue, string);
        }

        @Nullable
        public final Datavalue getDatavalue() {
            return this.datavalue;
        }

        @Nullable
        public final String getDatatype() {
            return this.datatype;
        }

        @Nullable
        public final Datavalue component1() {
            return this.datavalue;
        }

        @Nullable
        public final String component2() {
            return this.datatype;
        }

        @NotNull
        public final Mainsnak copy(@Nullable Datavalue datavalue, @Nullable String datatype) {
            return new Mainsnak(datavalue, datatype);
        }

        public static /* synthetic */ Mainsnak copy$default(Mainsnak mainsnak, Datavalue datavalue, String string, int n, Object object) {
            if ((n & 1) != 0) {
                datavalue = mainsnak.datavalue;
            }
            if ((n & 2) != 0) {
                string = mainsnak.datatype;
            }
            return mainsnak.copy(datavalue, string);
        }

        @NotNull
        public String toString() {
            return "Mainsnak(datavalue=" + this.datavalue + ", datatype=" + this.datatype + ")";
        }

        public int hashCode() {
            int result = this.datavalue == null ? 0 : this.datavalue.hashCode();
            result = result * 31 + (this.datatype == null ? 0 : this.datatype.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Mainsnak)) {
                return false;
            }
            Mainsnak mainsnak = (Mainsnak)other;
            if (!Intrinsics.areEqual((Object)this.datavalue, (Object)mainsnak.datavalue)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.datatype, (Object)mainsnak.datatype);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$OsmAnd_shared(Mainsnak self, CompositeEncoder output, SerialDescriptor serialDesc) {
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.datavalue != null) {
                output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)Datavalue$$serializer.INSTANCE, (Object)self.datavalue);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.datatype != null) {
                output.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.datatype);
            }
        }

        public /* synthetic */ Mainsnak(int seen0, Datavalue datavalue, String datatype, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen0) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)Mainsnak$$serializer.INSTANCE.getDescriptor());
            }
            this.datavalue = (seen0 & 1) == 0 ? null : datavalue;
            this.datatype = (seen0 & 2) == 0 ? null : datatype;
        }

        public Mainsnak() {
            this(null, null, 3, null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lnet/osmand/shared/wiki/WikiCoreHelper$Mainsnak$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lnet/osmand/shared/wiki/WikiCoreHelper$Mainsnak;", "OsmAnd-shared"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Mainsnak> serializer() {
                return (KSerializer)Mainsnak$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lnet/osmand/shared/wiki/WikiCoreHelper$NetworkResponseListener;", "", "onGetRawResponse", "", "response", "", "OsmAnd-shared"})
    public static interface NetworkResponseListener {
        public void onGetRawResponse(@NotNull String var1);
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001e\u001fB\u0019\u0012\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B+\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\u0011\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001b\u0010\u000f\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\bH\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J%\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0001\u00a2\u0006\u0002\b\u001dR\u0019\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"Lnet/osmand/shared/wiki/WikiCoreHelper$OsmandAPIFeaturesResponse;", "", "features", "", "Lnet/osmand/shared/wiki/WikiCoreHelper$OsmandApiFeatureData;", "<init>", "(Ljava/util/List;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/util/List;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getFeatures", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$OsmAnd_shared", "$serializer", "Companion", "OsmAnd-shared"})
    public static final class OsmandAPIFeaturesResponse {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final List<OsmandApiFeatureData> features;
        @JvmField
        @NotNull
        private static final KSerializer<Object>[] $childSerializers;

        public OsmandAPIFeaturesResponse(@Nullable List<OsmandApiFeatureData> features) {
            this.features = features;
        }

        public /* synthetic */ OsmandAPIFeaturesResponse(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = null;
            }
            this(list);
        }

        @Nullable
        public final List<OsmandApiFeatureData> getFeatures() {
            return this.features;
        }

        @Nullable
        public final List<OsmandApiFeatureData> component1() {
            return this.features;
        }

        @NotNull
        public final OsmandAPIFeaturesResponse copy(@Nullable List<OsmandApiFeatureData> features) {
            return new OsmandAPIFeaturesResponse(features);
        }

        public static /* synthetic */ OsmandAPIFeaturesResponse copy$default(OsmandAPIFeaturesResponse osmandAPIFeaturesResponse, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = osmandAPIFeaturesResponse.features;
            }
            return osmandAPIFeaturesResponse.copy(list);
        }

        @NotNull
        public String toString() {
            return "OsmandAPIFeaturesResponse(features=" + this.features + ")";
        }

        public int hashCode() {
            return this.features == null ? 0 : ((Object)this.features).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OsmandAPIFeaturesResponse)) {
                return false;
            }
            OsmandAPIFeaturesResponse osmandAPIFeaturesResponse = (OsmandAPIFeaturesResponse)other;
            return Intrinsics.areEqual(this.features, osmandAPIFeaturesResponse.features);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$OsmAnd_shared(OsmandAPIFeaturesResponse self, CompositeEncoder output, SerialDescriptor serialDesc) {
            KSerializer<Object>[] kSerializerArray = $childSerializers;
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.features != null) {
                output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)kSerializerArray[0], self.features);
            }
        }

        public /* synthetic */ OsmandAPIFeaturesResponse(int seen0, List features, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen0) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)OsmandAPIFeaturesResponse$$serializer.INSTANCE.getDescriptor());
            }
            this.features = (seen0 & 1) == 0 ? null : features;
        }

        public OsmandAPIFeaturesResponse() {
            this(null, 1, null);
        }

        public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            KSerializer[] kSerializerArray = new KSerializer[]{new ArrayListSerializer((KSerializer)OsmandApiFeatureData$$serializer.INSTANCE)};
            $childSerializers = kSerializerArray;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lnet/osmand/shared/wiki/WikiCoreHelper$OsmandAPIFeaturesResponse$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lnet/osmand/shared/wiki/WikiCoreHelper$OsmandAPIFeaturesResponse;", "OsmAnd-shared"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<OsmandAPIFeaturesResponse> serializer() {
                return (KSerializer)OsmandAPIFeaturesResponse$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000  2\u00020\u0001:\u0002\u001f B\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B%\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0004\u0010\nJ\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\u0010\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J%\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0001\u00a2\u0006\u0002\b\u001eR\u001e\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lnet/osmand/shared/wiki/WikiCoreHelper$OsmandAPIResponseV2;", "", "images", "Lkotlinx/serialization/json/JsonArray;", "<init>", "(Lkotlinx/serialization/json/JsonArray;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILkotlinx/serialization/json/JsonArray;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getImages$annotations", "()V", "getImages", "()Lkotlinx/serialization/json/JsonArray;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$OsmAnd_shared", "$serializer", "Companion", "OsmAnd-shared"})
    public static final class OsmandAPIResponseV2 {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final JsonArray images;

        public OsmandAPIResponseV2(@Nullable JsonArray images) {
            this.images = images;
        }

        public /* synthetic */ OsmandAPIResponseV2(JsonArray jsonArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                jsonArray = null;
            }
            this(jsonArray);
        }

        @Nullable
        public final JsonArray getImages() {
            return this.images;
        }

        @SerialName(value="features-v2")
        public static /* synthetic */ void getImages$annotations() {
        }

        @Nullable
        public final JsonArray component1() {
            return this.images;
        }

        @NotNull
        public final OsmandAPIResponseV2 copy(@Nullable JsonArray images) {
            return new OsmandAPIResponseV2(images);
        }

        public static /* synthetic */ OsmandAPIResponseV2 copy$default(OsmandAPIResponseV2 osmandAPIResponseV2, JsonArray jsonArray, int n, Object object) {
            if ((n & 1) != 0) {
                jsonArray = osmandAPIResponseV2.images;
            }
            return osmandAPIResponseV2.copy(jsonArray);
        }

        @NotNull
        public String toString() {
            return "OsmandAPIResponseV2(images=" + this.images + ")";
        }

        public int hashCode() {
            return this.images == null ? 0 : this.images.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OsmandAPIResponseV2)) {
                return false;
            }
            OsmandAPIResponseV2 osmandAPIResponseV2 = (OsmandAPIResponseV2)other;
            return Intrinsics.areEqual((Object)this.images, (Object)osmandAPIResponseV2.images);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$OsmAnd_shared(OsmandAPIResponseV2 self, CompositeEncoder output, SerialDescriptor serialDesc) {
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.images != null) {
                output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)JsonArraySerializer.INSTANCE, (Object)self.images);
            }
        }

        public /* synthetic */ OsmandAPIResponseV2(int seen0, JsonArray images, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen0) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)OsmandAPIResponseV2$$serializer.INSTANCE.getDescriptor());
            }
            this.images = (seen0 & 1) == 0 ? null : images;
        }

        public OsmandAPIResponseV2() {
            this(null, 1, null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lnet/osmand/shared/wiki/WikiCoreHelper$OsmandAPIResponseV2$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lnet/osmand/shared/wiki/WikiCoreHelper$OsmandAPIResponseV2;", "OsmAnd-shared"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<OsmandAPIResponseV2> serializer() {
                return (KSerializer)OsmandAPIResponseV2$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 #2\u00020\u0001:\u0002\"#B\u001f\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B/\b\u0010\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J!\u0010\u0013\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J%\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0001\u00a2\u0006\u0002\b!R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006$"}, d2={"Lnet/osmand/shared/wiki/WikiCoreHelper$OsmandApiFeatureData;", "", "properties", "Lnet/osmand/shared/wiki/WikiCoreHelper$WikiDataProperties;", "geometry", "Lnet/osmand/shared/wiki/WikiCoreHelper$WikiDataGeometry;", "<init>", "(Lnet/osmand/shared/wiki/WikiCoreHelper$WikiDataProperties;Lnet/osmand/shared/wiki/WikiCoreHelper$WikiDataGeometry;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILnet/osmand/shared/wiki/WikiCoreHelper$WikiDataProperties;Lnet/osmand/shared/wiki/WikiCoreHelper$WikiDataGeometry;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getProperties", "()Lnet/osmand/shared/wiki/WikiCoreHelper$WikiDataProperties;", "getGeometry", "()Lnet/osmand/shared/wiki/WikiCoreHelper$WikiDataGeometry;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$OsmAnd_shared", "$serializer", "Companion", "OsmAnd-shared"})
    public static final class OsmandApiFeatureData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final WikiDataProperties properties;
        @Nullable
        private final WikiDataGeometry geometry;

        public OsmandApiFeatureData(@Nullable WikiDataProperties properties, @Nullable WikiDataGeometry geometry) {
            this.properties = properties;
            this.geometry = geometry;
        }

        public /* synthetic */ OsmandApiFeatureData(WikiDataProperties wikiDataProperties, WikiDataGeometry wikiDataGeometry, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                wikiDataProperties = null;
            }
            if ((n & 2) != 0) {
                wikiDataGeometry = null;
            }
            this(wikiDataProperties, wikiDataGeometry);
        }

        @Nullable
        public final WikiDataProperties getProperties() {
            return this.properties;
        }

        @Nullable
        public final WikiDataGeometry getGeometry() {
            return this.geometry;
        }

        @Nullable
        public final WikiDataProperties component1() {
            return this.properties;
        }

        @Nullable
        public final WikiDataGeometry component2() {
            return this.geometry;
        }

        @NotNull
        public final OsmandApiFeatureData copy(@Nullable WikiDataProperties properties, @Nullable WikiDataGeometry geometry) {
            return new OsmandApiFeatureData(properties, geometry);
        }

        public static /* synthetic */ OsmandApiFeatureData copy$default(OsmandApiFeatureData osmandApiFeatureData, WikiDataProperties wikiDataProperties, WikiDataGeometry wikiDataGeometry, int n, Object object) {
            if ((n & 1) != 0) {
                wikiDataProperties = osmandApiFeatureData.properties;
            }
            if ((n & 2) != 0) {
                wikiDataGeometry = osmandApiFeatureData.geometry;
            }
            return osmandApiFeatureData.copy(wikiDataProperties, wikiDataGeometry);
        }

        @NotNull
        public String toString() {
            return "OsmandApiFeatureData(properties=" + this.properties + ", geometry=" + this.geometry + ")";
        }

        public int hashCode() {
            int result = this.properties == null ? 0 : this.properties.hashCode();
            result = result * 31 + (this.geometry == null ? 0 : this.geometry.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OsmandApiFeatureData)) {
                return false;
            }
            OsmandApiFeatureData osmandApiFeatureData = (OsmandApiFeatureData)other;
            if (!Intrinsics.areEqual((Object)this.properties, (Object)osmandApiFeatureData.properties)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.geometry, (Object)osmandApiFeatureData.geometry);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$OsmAnd_shared(OsmandApiFeatureData self, CompositeEncoder output, SerialDescriptor serialDesc) {
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.properties != null) {
                output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)WikiDataProperties$$serializer.INSTANCE, (Object)self.properties);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.geometry != null) {
                output.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)WikiDataGeometry$$serializer.INSTANCE, (Object)self.geometry);
            }
        }

        public /* synthetic */ OsmandApiFeatureData(int seen0, WikiDataProperties properties, WikiDataGeometry geometry, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen0) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)OsmandApiFeatureData$$serializer.INSTANCE.getDescriptor());
            }
            this.properties = (seen0 & 1) == 0 ? null : properties;
            this.geometry = (seen0 & 2) == 0 ? null : geometry;
        }

        public OsmandApiFeatureData() {
            this(null, null, 3, null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lnet/osmand/shared/wiki/WikiCoreHelper$OsmandApiFeatureData$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lnet/osmand/shared/wiki/WikiCoreHelper$OsmandApiFeatureData;", "OsmAnd-shared"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<OsmandApiFeatureData> serializer() {
                return (KSerializer)OsmandApiFeatureData$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001d\u001eB\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B%\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0004\u0010\nJ\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J%\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0001\u00a2\u0006\u0002\b\u001cR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Lnet/osmand/shared/wiki/WikiCoreHelper$P18;", "", "mainsnak", "Lnet/osmand/shared/wiki/WikiCoreHelper$Mainsnak;", "<init>", "(Lnet/osmand/shared/wiki/WikiCoreHelper$Mainsnak;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILnet/osmand/shared/wiki/WikiCoreHelper$Mainsnak;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getMainsnak", "()Lnet/osmand/shared/wiki/WikiCoreHelper$Mainsnak;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$OsmAnd_shared", "$serializer", "Companion", "OsmAnd-shared"})
    public static final class P18 {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final Mainsnak mainsnak;

        public P18(@Nullable Mainsnak mainsnak) {
            this.mainsnak = mainsnak;
        }

        public /* synthetic */ P18(Mainsnak mainsnak, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                mainsnak = null;
            }
            this(mainsnak);
        }

        @Nullable
        public final Mainsnak getMainsnak() {
            return this.mainsnak;
        }

        @Nullable
        public final Mainsnak component1() {
            return this.mainsnak;
        }

        @NotNull
        public final P18 copy(@Nullable Mainsnak mainsnak) {
            return new P18(mainsnak);
        }

        public static /* synthetic */ P18 copy$default(P18 p18, Mainsnak mainsnak, int n, Object object) {
            if ((n & 1) != 0) {
                mainsnak = p18.mainsnak;
            }
            return p18.copy(mainsnak);
        }

        @NotNull
        public String toString() {
            return "P18(mainsnak=" + this.mainsnak + ")";
        }

        public int hashCode() {
            return this.mainsnak == null ? 0 : this.mainsnak.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof P18)) {
                return false;
            }
            P18 p18 = (P18)other;
            return Intrinsics.areEqual((Object)this.mainsnak, (Object)p18.mainsnak);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$OsmAnd_shared(P18 self, CompositeEncoder output, SerialDescriptor serialDesc) {
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.mainsnak != null) {
                output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)Mainsnak$$serializer.INSTANCE, (Object)self.mainsnak);
            }
        }

        public /* synthetic */ P18(int seen0, Mainsnak mainsnak, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen0) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)P18$$serializer.INSTANCE.getDescriptor());
            }
            this.mainsnak = (seen0 & 1) == 0 ? null : mainsnak;
        }

        public P18() {
            this(null, 1, null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lnet/osmand/shared/wiki/WikiCoreHelper$P18$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lnet/osmand/shared/wiki/WikiCoreHelper$P18;", "OsmAnd-shared"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<P18> serializer() {
                return (KSerializer)P18$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001e\u001fB\u0019\u0012\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B+\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\u0011\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001b\u0010\u000f\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\bH\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J%\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0001\u00a2\u0006\u0002\b\u001dR\u0019\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"Lnet/osmand/shared/wiki/WikiCoreHelper$Query;", "", "categorymembers", "", "Lnet/osmand/shared/wiki/WikiCoreHelper$Categorymember;", "<init>", "(Ljava/util/List;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/util/List;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getCategorymembers", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$OsmAnd_shared", "$serializer", "Companion", "OsmAnd-shared"})
    public static final class Query {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final List<Categorymember> categorymembers;
        @JvmField
        @NotNull
        private static final KSerializer<Object>[] $childSerializers;

        public Query(@Nullable List<Categorymember> categorymembers) {
            this.categorymembers = categorymembers;
        }

        public /* synthetic */ Query(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = null;
            }
            this(list);
        }

        @Nullable
        public final List<Categorymember> getCategorymembers() {
            return this.categorymembers;
        }

        @Nullable
        public final List<Categorymember> component1() {
            return this.categorymembers;
        }

        @NotNull
        public final Query copy(@Nullable List<Categorymember> categorymembers) {
            return new Query(categorymembers);
        }

        public static /* synthetic */ Query copy$default(Query query, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = query.categorymembers;
            }
            return query.copy(list);
        }

        @NotNull
        public String toString() {
            return "Query(categorymembers=" + this.categorymembers + ")";
        }

        public int hashCode() {
            return this.categorymembers == null ? 0 : ((Object)this.categorymembers).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Query)) {
                return false;
            }
            Query query = (Query)other;
            return Intrinsics.areEqual(this.categorymembers, query.categorymembers);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$OsmAnd_shared(Query self, CompositeEncoder output, SerialDescriptor serialDesc) {
            KSerializer<Object>[] kSerializerArray = $childSerializers;
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.categorymembers != null) {
                output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)kSerializerArray[0], self.categorymembers);
            }
        }

        public /* synthetic */ Query(int seen0, List categorymembers, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen0) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)Query$$serializer.INSTANCE.getDescriptor());
            }
            this.categorymembers = (seen0 & 1) == 0 ? null : categorymembers;
        }

        public Query() {
            this(null, 1, null);
        }

        public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            KSerializer[] kSerializerArray = new KSerializer[]{new ArrayListSerializer((KSerializer)Categorymember$$serializer.INSTANCE)};
            $childSerializers = kSerializerArray;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lnet/osmand/shared/wiki/WikiCoreHelper$Query$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lnet/osmand/shared/wiki/WikiCoreHelper$Query;", "OsmAnd-shared"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Query> serializer() {
                return (KSerializer)Query$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001d\u001eB\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B%\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0004\u0010\nJ\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J%\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0001\u00a2\u0006\u0002\b\u001cR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Lnet/osmand/shared/wiki/WikiCoreHelper$WikiDataGeometry;", "", "coordinates", "", "<init>", "([D)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(I[DLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getCoordinates", "()[D", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$OsmAnd_shared", "$serializer", "Companion", "OsmAnd-shared"})
    public static final class WikiDataGeometry {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final double[] coordinates;

        public WikiDataGeometry(@Nullable double[] coordinates) {
            this.coordinates = coordinates;
        }

        public /* synthetic */ WikiDataGeometry(double[] dArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                dArray = null;
            }
            this(dArray);
        }

        @Nullable
        public final double[] getCoordinates() {
            return this.coordinates;
        }

        @Nullable
        public final double[] component1() {
            return this.coordinates;
        }

        @NotNull
        public final WikiDataGeometry copy(@Nullable double[] coordinates) {
            return new WikiDataGeometry(coordinates);
        }

        public static /* synthetic */ WikiDataGeometry copy$default(WikiDataGeometry wikiDataGeometry, double[] dArray, int n, Object object) {
            if ((n & 1) != 0) {
                dArray = wikiDataGeometry.coordinates;
            }
            return wikiDataGeometry.copy(dArray);
        }

        @NotNull
        public String toString() {
            return "WikiDataGeometry(coordinates=" + Arrays.toString(this.coordinates) + ")";
        }

        public int hashCode() {
            return this.coordinates == null ? 0 : Arrays.hashCode(this.coordinates);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WikiDataGeometry)) {
                return false;
            }
            WikiDataGeometry wikiDataGeometry = (WikiDataGeometry)other;
            return Intrinsics.areEqual((Object)this.coordinates, (Object)wikiDataGeometry.coordinates);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$OsmAnd_shared(WikiDataGeometry self, CompositeEncoder output, SerialDescriptor serialDesc) {
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.coordinates != null) {
                output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)DoubleArraySerializer.INSTANCE, (Object)self.coordinates);
            }
        }

        public /* synthetic */ WikiDataGeometry(int seen0, double[] coordinates, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen0) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)WikiDataGeometry$$serializer.INSTANCE.getDescriptor());
            }
            this.coordinates = (double[])((seen0 & 1) == 0 ? null : coordinates);
        }

        public WikiDataGeometry() {
            this(null, 1, null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lnet/osmand/shared/wiki/WikiCoreHelper$WikiDataGeometry$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lnet/osmand/shared/wiki/WikiCoreHelper$WikiDataGeometry;", "OsmAnd-shared"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<WikiDataGeometry> serializer() {
                return (KSerializer)WikiDataGeometry$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b,\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 U2\u00020\u0001:\u0002TUB\u00d1\u0001\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018B\u00c3\u0001\b\u0010\u0012\u0006\u0010\u0019\u001a\u00020\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u00a2\u0006\u0004\b\u0017\u0010\u001cJ\u000b\u00104\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u00105\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u00106\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u00107\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u00108\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u00109\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010:\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010;\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010<\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010=\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010>\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010?\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010@\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010A\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010B\u001a\u0004\u0018\u00010\u0012H\u00c6\u0003\u00a2\u0006\u0002\u0010-J\u0010\u0010C\u001a\u0004\u0018\u00010\u0014H\u00c6\u0003\u00a2\u0006\u0002\u00100J\t\u0010D\u001a\u00020\u0016H\u00c6\u0003J\u00d8\u0001\u0010E\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u00c6\u0001\u00a2\u0006\u0002\u0010FJ\u0013\u0010G\u001a\u00020H2\b\u0010I\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010J\u001a\u00020\u0016H\u00d6\u0001J\t\u0010K\u001a\u00020\u0003H\u00d6\u0001J%\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020\u00002\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020RH\u0001\u00a2\u0006\u0002\bSR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001eR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001eR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001eR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001eR\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001eR\u0013\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001eR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001eR\u0013\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001eR\u0013\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u001eR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u001eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u001eR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u001eR\u0015\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\n\n\u0002\u0010.\u001a\u0004\b,\u0010-R\u0015\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\n\n\u0002\u00101\u001a\u0004\b/\u00100R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103\u00a8\u0006V"}, d2={"Lnet/osmand/shared/wiki/WikiCoreHelper$WikiDataProperties;", "", "id", "", "photoId", "photoTitle", "wikiTitle", "poitype", "poisubtype", "catId", "catTitle", "depId", "depTitle", "wikiLang", "wikiDesc", "wikiLangs", "wikiLangViews", "osmid", "", "elo", "", "osmtype", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/Double;I)V", "seen0", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/Double;ILkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getId", "()Ljava/lang/String;", "getPhotoId", "getPhotoTitle", "getWikiTitle", "getPoitype", "getPoisubtype", "getCatId", "getCatTitle", "getDepId", "getDepTitle", "getWikiLang", "getWikiDesc", "getWikiLangs", "getWikiLangViews", "getOsmid", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getElo", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getOsmtype", "()I", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/Double;I)Lnet/osmand/shared/wiki/WikiCoreHelper$WikiDataProperties;", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$OsmAnd_shared", "$serializer", "Companion", "OsmAnd-shared"})
    public static final class WikiDataProperties {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String id;
        @Nullable
        private final String photoId;
        @Nullable
        private final String photoTitle;
        @Nullable
        private final String wikiTitle;
        @Nullable
        private final String poitype;
        @Nullable
        private final String poisubtype;
        @Nullable
        private final String catId;
        @Nullable
        private final String catTitle;
        @Nullable
        private final String depId;
        @Nullable
        private final String depTitle;
        @Nullable
        private final String wikiLang;
        @Nullable
        private final String wikiDesc;
        @Nullable
        private final String wikiLangs;
        @Nullable
        private final String wikiLangViews;
        @Nullable
        private final Long osmid;
        @Nullable
        private final Double elo;
        private final int osmtype;

        public WikiDataProperties(@Nullable String id, @Nullable String photoId, @Nullable String photoTitle, @Nullable String wikiTitle, @Nullable String poitype, @Nullable String poisubtype, @Nullable String catId, @Nullable String catTitle, @Nullable String depId, @Nullable String depTitle, @Nullable String wikiLang, @Nullable String wikiDesc, @Nullable String wikiLangs, @Nullable String wikiLangViews, @Nullable Long osmid, @Nullable Double elo, int osmtype) {
            this.id = id;
            this.photoId = photoId;
            this.photoTitle = photoTitle;
            this.wikiTitle = wikiTitle;
            this.poitype = poitype;
            this.poisubtype = poisubtype;
            this.catId = catId;
            this.catTitle = catTitle;
            this.depId = depId;
            this.depTitle = depTitle;
            this.wikiLang = wikiLang;
            this.wikiDesc = wikiDesc;
            this.wikiLangs = wikiLangs;
            this.wikiLangViews = wikiLangViews;
            this.osmid = osmid;
            this.elo = elo;
            this.osmtype = osmtype;
        }

        public /* synthetic */ WikiDataProperties(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, Long l, Double d, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                string = null;
            }
            if ((n2 & 2) != 0) {
                string2 = null;
            }
            if ((n2 & 4) != 0) {
                string3 = null;
            }
            if ((n2 & 8) != 0) {
                string4 = null;
            }
            if ((n2 & 0x10) != 0) {
                string5 = null;
            }
            if ((n2 & 0x20) != 0) {
                string6 = null;
            }
            if ((n2 & 0x40) != 0) {
                string7 = null;
            }
            if ((n2 & 0x80) != 0) {
                string8 = null;
            }
            if ((n2 & 0x100) != 0) {
                string9 = null;
            }
            if ((n2 & 0x200) != 0) {
                string10 = null;
            }
            if ((n2 & 0x400) != 0) {
                string11 = null;
            }
            if ((n2 & 0x800) != 0) {
                string12 = null;
            }
            if ((n2 & 0x1000) != 0) {
                string13 = null;
            }
            if ((n2 & 0x2000) != 0) {
                string14 = null;
            }
            if ((n2 & 0x4000) != 0) {
                l = null;
            }
            if ((n2 & 0x8000) != 0) {
                d = null;
            }
            if ((n2 & 0x10000) != 0) {
                n = 0;
            }
            this(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, string14, l, d, n);
        }

        @Nullable
        public final String getId() {
            return this.id;
        }

        @Nullable
        public final String getPhotoId() {
            return this.photoId;
        }

        @Nullable
        public final String getPhotoTitle() {
            return this.photoTitle;
        }

        @Nullable
        public final String getWikiTitle() {
            return this.wikiTitle;
        }

        @Nullable
        public final String getPoitype() {
            return this.poitype;
        }

        @Nullable
        public final String getPoisubtype() {
            return this.poisubtype;
        }

        @Nullable
        public final String getCatId() {
            return this.catId;
        }

        @Nullable
        public final String getCatTitle() {
            return this.catTitle;
        }

        @Nullable
        public final String getDepId() {
            return this.depId;
        }

        @Nullable
        public final String getDepTitle() {
            return this.depTitle;
        }

        @Nullable
        public final String getWikiLang() {
            return this.wikiLang;
        }

        @Nullable
        public final String getWikiDesc() {
            return this.wikiDesc;
        }

        @Nullable
        public final String getWikiLangs() {
            return this.wikiLangs;
        }

        @Nullable
        public final String getWikiLangViews() {
            return this.wikiLangViews;
        }

        @Nullable
        public final Long getOsmid() {
            return this.osmid;
        }

        @Nullable
        public final Double getElo() {
            return this.elo;
        }

        public final int getOsmtype() {
            return this.osmtype;
        }

        @Nullable
        public final String component1() {
            return this.id;
        }

        @Nullable
        public final String component2() {
            return this.photoId;
        }

        @Nullable
        public final String component3() {
            return this.photoTitle;
        }

        @Nullable
        public final String component4() {
            return this.wikiTitle;
        }

        @Nullable
        public final String component5() {
            return this.poitype;
        }

        @Nullable
        public final String component6() {
            return this.poisubtype;
        }

        @Nullable
        public final String component7() {
            return this.catId;
        }

        @Nullable
        public final String component8() {
            return this.catTitle;
        }

        @Nullable
        public final String component9() {
            return this.depId;
        }

        @Nullable
        public final String component10() {
            return this.depTitle;
        }

        @Nullable
        public final String component11() {
            return this.wikiLang;
        }

        @Nullable
        public final String component12() {
            return this.wikiDesc;
        }

        @Nullable
        public final String component13() {
            return this.wikiLangs;
        }

        @Nullable
        public final String component14() {
            return this.wikiLangViews;
        }

        @Nullable
        public final Long component15() {
            return this.osmid;
        }

        @Nullable
        public final Double component16() {
            return this.elo;
        }

        public final int component17() {
            return this.osmtype;
        }

        @NotNull
        public final WikiDataProperties copy(@Nullable String id, @Nullable String photoId, @Nullable String photoTitle, @Nullable String wikiTitle, @Nullable String poitype, @Nullable String poisubtype, @Nullable String catId, @Nullable String catTitle, @Nullable String depId, @Nullable String depTitle, @Nullable String wikiLang, @Nullable String wikiDesc, @Nullable String wikiLangs, @Nullable String wikiLangViews, @Nullable Long osmid, @Nullable Double elo, int osmtype) {
            return new WikiDataProperties(id, photoId, photoTitle, wikiTitle, poitype, poisubtype, catId, catTitle, depId, depTitle, wikiLang, wikiDesc, wikiLangs, wikiLangViews, osmid, elo, osmtype);
        }

        public static /* synthetic */ WikiDataProperties copy$default(WikiDataProperties wikiDataProperties, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, Long l, Double d, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = wikiDataProperties.id;
            }
            if ((n2 & 2) != 0) {
                string2 = wikiDataProperties.photoId;
            }
            if ((n2 & 4) != 0) {
                string3 = wikiDataProperties.photoTitle;
            }
            if ((n2 & 8) != 0) {
                string4 = wikiDataProperties.wikiTitle;
            }
            if ((n2 & 0x10) != 0) {
                string5 = wikiDataProperties.poitype;
            }
            if ((n2 & 0x20) != 0) {
                string6 = wikiDataProperties.poisubtype;
            }
            if ((n2 & 0x40) != 0) {
                string7 = wikiDataProperties.catId;
            }
            if ((n2 & 0x80) != 0) {
                string8 = wikiDataProperties.catTitle;
            }
            if ((n2 & 0x100) != 0) {
                string9 = wikiDataProperties.depId;
            }
            if ((n2 & 0x200) != 0) {
                string10 = wikiDataProperties.depTitle;
            }
            if ((n2 & 0x400) != 0) {
                string11 = wikiDataProperties.wikiLang;
            }
            if ((n2 & 0x800) != 0) {
                string12 = wikiDataProperties.wikiDesc;
            }
            if ((n2 & 0x1000) != 0) {
                string13 = wikiDataProperties.wikiLangs;
            }
            if ((n2 & 0x2000) != 0) {
                string14 = wikiDataProperties.wikiLangViews;
            }
            if ((n2 & 0x4000) != 0) {
                l = wikiDataProperties.osmid;
            }
            if ((n2 & 0x8000) != 0) {
                d = wikiDataProperties.elo;
            }
            if ((n2 & 0x10000) != 0) {
                n = wikiDataProperties.osmtype;
            }
            return wikiDataProperties.copy(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, string14, l, d, n);
        }

        @NotNull
        public String toString() {
            return "WikiDataProperties(id=" + this.id + ", photoId=" + this.photoId + ", photoTitle=" + this.photoTitle + ", wikiTitle=" + this.wikiTitle + ", poitype=" + this.poitype + ", poisubtype=" + this.poisubtype + ", catId=" + this.catId + ", catTitle=" + this.catTitle + ", depId=" + this.depId + ", depTitle=" + this.depTitle + ", wikiLang=" + this.wikiLang + ", wikiDesc=" + this.wikiDesc + ", wikiLangs=" + this.wikiLangs + ", wikiLangViews=" + this.wikiLangViews + ", osmid=" + this.osmid + ", elo=" + this.elo + ", osmtype=" + this.osmtype + ")";
        }

        public int hashCode() {
            int result = this.id == null ? 0 : this.id.hashCode();
            result = result * 31 + (this.photoId == null ? 0 : this.photoId.hashCode());
            result = result * 31 + (this.photoTitle == null ? 0 : this.photoTitle.hashCode());
            result = result * 31 + (this.wikiTitle == null ? 0 : this.wikiTitle.hashCode());
            result = result * 31 + (this.poitype == null ? 0 : this.poitype.hashCode());
            result = result * 31 + (this.poisubtype == null ? 0 : this.poisubtype.hashCode());
            result = result * 31 + (this.catId == null ? 0 : this.catId.hashCode());
            result = result * 31 + (this.catTitle == null ? 0 : this.catTitle.hashCode());
            result = result * 31 + (this.depId == null ? 0 : this.depId.hashCode());
            result = result * 31 + (this.depTitle == null ? 0 : this.depTitle.hashCode());
            result = result * 31 + (this.wikiLang == null ? 0 : this.wikiLang.hashCode());
            result = result * 31 + (this.wikiDesc == null ? 0 : this.wikiDesc.hashCode());
            result = result * 31 + (this.wikiLangs == null ? 0 : this.wikiLangs.hashCode());
            result = result * 31 + (this.wikiLangViews == null ? 0 : this.wikiLangViews.hashCode());
            result = result * 31 + (this.osmid == null ? 0 : ((Object)this.osmid).hashCode());
            result = result * 31 + (this.elo == null ? 0 : ((Object)this.elo).hashCode());
            result = result * 31 + Integer.hashCode(this.osmtype);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WikiDataProperties)) {
                return false;
            }
            WikiDataProperties wikiDataProperties = (WikiDataProperties)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)wikiDataProperties.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.photoId, (Object)wikiDataProperties.photoId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.photoTitle, (Object)wikiDataProperties.photoTitle)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.wikiTitle, (Object)wikiDataProperties.wikiTitle)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.poitype, (Object)wikiDataProperties.poitype)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.poisubtype, (Object)wikiDataProperties.poisubtype)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.catId, (Object)wikiDataProperties.catId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.catTitle, (Object)wikiDataProperties.catTitle)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.depId, (Object)wikiDataProperties.depId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.depTitle, (Object)wikiDataProperties.depTitle)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.wikiLang, (Object)wikiDataProperties.wikiLang)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.wikiDesc, (Object)wikiDataProperties.wikiDesc)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.wikiLangs, (Object)wikiDataProperties.wikiLangs)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.wikiLangViews, (Object)wikiDataProperties.wikiLangViews)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.osmid, (Object)wikiDataProperties.osmid)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.elo, (Object)wikiDataProperties.elo)) {
                return false;
            }
            return this.osmtype == wikiDataProperties.osmtype;
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$OsmAnd_shared(WikiDataProperties self, CompositeEncoder output, SerialDescriptor serialDesc) {
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.id != null) {
                output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.id);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.photoId != null) {
                output.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.photoId);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : self.photoTitle != null) {
                output.encodeNullableSerializableElement(serialDesc, 2, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.photoTitle);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : self.wikiTitle != null) {
                output.encodeNullableSerializableElement(serialDesc, 3, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.wikiTitle);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 4) ? true : self.poitype != null) {
                output.encodeNullableSerializableElement(serialDesc, 4, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.poitype);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 5) ? true : self.poisubtype != null) {
                output.encodeNullableSerializableElement(serialDesc, 5, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.poisubtype);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 6) ? true : self.catId != null) {
                output.encodeNullableSerializableElement(serialDesc, 6, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.catId);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 7) ? true : self.catTitle != null) {
                output.encodeNullableSerializableElement(serialDesc, 7, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.catTitle);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 8) ? true : self.depId != null) {
                output.encodeNullableSerializableElement(serialDesc, 8, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.depId);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 9) ? true : self.depTitle != null) {
                output.encodeNullableSerializableElement(serialDesc, 9, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.depTitle);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 10) ? true : self.wikiLang != null) {
                output.encodeNullableSerializableElement(serialDesc, 10, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.wikiLang);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 11) ? true : self.wikiDesc != null) {
                output.encodeNullableSerializableElement(serialDesc, 11, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.wikiDesc);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 12) ? true : self.wikiLangs != null) {
                output.encodeNullableSerializableElement(serialDesc, 12, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.wikiLangs);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 13) ? true : self.wikiLangViews != null) {
                output.encodeNullableSerializableElement(serialDesc, 13, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.wikiLangViews);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 14) ? true : self.osmid != null) {
                output.encodeNullableSerializableElement(serialDesc, 14, (SerializationStrategy)LongSerializer.INSTANCE, (Object)self.osmid);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 15) ? true : self.elo != null) {
                output.encodeNullableSerializableElement(serialDesc, 15, (SerializationStrategy)DoubleSerializer.INSTANCE, (Object)self.elo);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 16) ? true : self.osmtype != 0) {
                output.encodeIntElement(serialDesc, 16, self.osmtype);
            }
        }

        public /* synthetic */ WikiDataProperties(int seen0, String id, String photoId, String photoTitle, String wikiTitle, String poitype, String poisubtype, String catId, String catTitle, String depId, String depTitle, String wikiLang, String wikiDesc, String wikiLangs, String wikiLangViews, Long osmid, Double elo, int osmtype, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen0) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)WikiDataProperties$$serializer.INSTANCE.getDescriptor());
            }
            this.id = (seen0 & 1) == 0 ? null : id;
            this.photoId = (seen0 & 2) == 0 ? null : photoId;
            this.photoTitle = (seen0 & 4) == 0 ? null : photoTitle;
            this.wikiTitle = (seen0 & 8) == 0 ? null : wikiTitle;
            this.poitype = (seen0 & 0x10) == 0 ? null : poitype;
            this.poisubtype = (seen0 & 0x20) == 0 ? null : poisubtype;
            this.catId = (seen0 & 0x40) == 0 ? null : catId;
            this.catTitle = (seen0 & 0x80) == 0 ? null : catTitle;
            this.depId = (seen0 & 0x100) == 0 ? null : depId;
            this.depTitle = (seen0 & 0x200) == 0 ? null : depTitle;
            this.wikiLang = (seen0 & 0x400) == 0 ? null : wikiLang;
            this.wikiDesc = (seen0 & 0x800) == 0 ? null : wikiDesc;
            this.wikiLangs = (seen0 & 0x1000) == 0 ? null : wikiLangs;
            this.wikiLangViews = (seen0 & 0x2000) == 0 ? null : wikiLangViews;
            this.osmid = (seen0 & 0x4000) == 0 ? null : osmid;
            this.elo = (seen0 & 0x8000) == 0 ? null : elo;
            this.osmtype = (seen0 & 0x10000) == 0 ? 0 : osmtype;
        }

        public WikiDataProperties() {
            this(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0, 131071, null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lnet/osmand/shared/wiki/WikiCoreHelper$WikiDataProperties$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lnet/osmand/shared/wiki/WikiCoreHelper$WikiDataProperties;", "OsmAnd-shared"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<WikiDataProperties> serializer() {
                return (KSerializer)WikiDataProperties$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001d\u001eB\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B%\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0004\u0010\nJ\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J%\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0001\u00a2\u0006\u0002\b\u001cR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Lnet/osmand/shared/wiki/WikiCoreHelper$WikidataResponse;", "", "claims", "Lnet/osmand/shared/wiki/WikiCoreHelper$Claims;", "<init>", "(Lnet/osmand/shared/wiki/WikiCoreHelper$Claims;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILnet/osmand/shared/wiki/WikiCoreHelper$Claims;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getClaims", "()Lnet/osmand/shared/wiki/WikiCoreHelper$Claims;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$OsmAnd_shared", "$serializer", "Companion", "OsmAnd-shared"})
    public static final class WikidataResponse {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final Claims claims;

        public WikidataResponse(@Nullable Claims claims) {
            this.claims = claims;
        }

        public /* synthetic */ WikidataResponse(Claims claims, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                claims = null;
            }
            this(claims);
        }

        @Nullable
        public final Claims getClaims() {
            return this.claims;
        }

        @Nullable
        public final Claims component1() {
            return this.claims;
        }

        @NotNull
        public final WikidataResponse copy(@Nullable Claims claims) {
            return new WikidataResponse(claims);
        }

        public static /* synthetic */ WikidataResponse copy$default(WikidataResponse wikidataResponse, Claims claims, int n, Object object) {
            if ((n & 1) != 0) {
                claims = wikidataResponse.claims;
            }
            return wikidataResponse.copy(claims);
        }

        @NotNull
        public String toString() {
            return "WikidataResponse(claims=" + this.claims + ")";
        }

        public int hashCode() {
            return this.claims == null ? 0 : this.claims.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WikidataResponse)) {
                return false;
            }
            WikidataResponse wikidataResponse = (WikidataResponse)other;
            return Intrinsics.areEqual((Object)this.claims, (Object)wikidataResponse.claims);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$OsmAnd_shared(WikidataResponse self, CompositeEncoder output, SerialDescriptor serialDesc) {
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.claims != null) {
                output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)Claims$$serializer.INSTANCE, (Object)self.claims);
            }
        }

        public /* synthetic */ WikidataResponse(int seen0, Claims claims, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen0) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)WikidataResponse$$serializer.INSTANCE.getDescriptor());
            }
            this.claims = (seen0 & 1) == 0 ? null : claims;
        }

        public WikidataResponse() {
            this(null, 1, null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lnet/osmand/shared/wiki/WikiCoreHelper$WikidataResponse$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lnet/osmand/shared/wiki/WikiCoreHelper$WikidataResponse;", "OsmAnd-shared"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<WikidataResponse> serializer() {
                return (KSerializer)WikidataResponse$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001d\u001eB\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B%\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0004\u0010\nJ\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J%\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0001\u00a2\u0006\u0002\b\u001cR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Lnet/osmand/shared/wiki/WikiCoreHelper$WikimediaResponse;", "", "query", "Lnet/osmand/shared/wiki/WikiCoreHelper$Query;", "<init>", "(Lnet/osmand/shared/wiki/WikiCoreHelper$Query;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILnet/osmand/shared/wiki/WikiCoreHelper$Query;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getQuery", "()Lnet/osmand/shared/wiki/WikiCoreHelper$Query;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$OsmAnd_shared", "$serializer", "Companion", "OsmAnd-shared"})
    public static final class WikimediaResponse {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final Query query;

        public WikimediaResponse(@Nullable Query query) {
            this.query = query;
        }

        public /* synthetic */ WikimediaResponse(Query query, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                query = null;
            }
            this(query);
        }

        @Nullable
        public final Query getQuery() {
            return this.query;
        }

        @Nullable
        public final Query component1() {
            return this.query;
        }

        @NotNull
        public final WikimediaResponse copy(@Nullable Query query) {
            return new WikimediaResponse(query);
        }

        public static /* synthetic */ WikimediaResponse copy$default(WikimediaResponse wikimediaResponse, Query query, int n, Object object) {
            if ((n & 1) != 0) {
                query = wikimediaResponse.query;
            }
            return wikimediaResponse.copy(query);
        }

        @NotNull
        public String toString() {
            return "WikimediaResponse(query=" + this.query + ")";
        }

        public int hashCode() {
            return this.query == null ? 0 : this.query.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WikimediaResponse)) {
                return false;
            }
            WikimediaResponse wikimediaResponse = (WikimediaResponse)other;
            return Intrinsics.areEqual((Object)this.query, (Object)wikimediaResponse.query);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$OsmAnd_shared(WikimediaResponse self, CompositeEncoder output, SerialDescriptor serialDesc) {
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.query != null) {
                output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)Query$$serializer.INSTANCE, (Object)self.query);
            }
        }

        public /* synthetic */ WikimediaResponse(int seen0, Query query, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen0) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)WikimediaResponse$$serializer.INSTANCE.getDescriptor());
            }
            this.query = (seen0 & 1) == 0 ? null : query;
        }

        public WikimediaResponse() {
            this(null, 1, null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lnet/osmand/shared/wiki/WikiCoreHelper$WikimediaResponse$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lnet/osmand/shared/wiki/WikiCoreHelper$WikimediaResponse;", "OsmAnd-shared"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<WikimediaResponse> serializer() {
                return (KSerializer)WikimediaResponse$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

