/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.swing;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.util.Animator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JTextField;
import net.osmand.PlatformUtil;
import net.osmand.core.jni.AreaI;
import net.osmand.core.jni.AtlasMapRendererConfiguration;
import net.osmand.core.jni.CoreResourcesEmbeddedBundle;
import net.osmand.core.jni.IMapRenderer;
import net.osmand.core.jni.Logger;
import net.osmand.core.jni.MapObjectsSymbolsProvider;
import net.osmand.core.jni.MapPresentationEnvironment;
import net.osmand.core.jni.MapPrimitivesProvider;
import net.osmand.core.jni.MapPrimitiviser;
import net.osmand.core.jni.MapRasterLayerProvider_Software;
import net.osmand.core.jni.MapRendererClass;
import net.osmand.core.jni.MapRendererDebugSettings;
import net.osmand.core.jni.MapRendererSetupOptions;
import net.osmand.core.jni.MapStylesCollection;
import net.osmand.core.jni.ObfMapObjectsProvider;
import net.osmand.core.jni.ObfsCollection;
import net.osmand.core.jni.OsmAndCore;
import net.osmand.core.jni.PointI;
import net.osmand.core.jni.QIODeviceLogSink;
import net.osmand.core.jni.QStringStringHash;
import net.osmand.core.jni.ResolvedMapStyle;
import net.osmand.data.LatLon;
import net.osmand.swing.DataExtractionSettings;
import net.osmand.swing.OsmExtractionUI;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class QtCorePanel
implements GLEventListener {
    private static CoreResourcesEmbeddedBundle coreResourcesEmbeddedBundle;
    public static Boolean loaded;
    private static String OS;
    private MapCanvas mapCanvas;
    private JTextField zoomField;
    private IMapRenderer mapRenderer;
    private RenderRequestCallback callback;
    private String styleFile;
    private String renderingProperties;
    private float referenceTileSize;

    public static boolean isWindows() {
        return OS.indexOf("win") >= 0;
    }

    public static boolean isMac() {
        return OS.indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        return OS.indexOf("nix") >= 0 || OS.indexOf("nux") >= 0 || OS.indexOf("aix") > 0;
    }

    public static void loadNative(String folder) {
        if (loaded == null) {
            try {
                System.load(folder + "/" + System.mapLibraryName("OsmAndCoreWithJNI_standalone"));
                coreResourcesEmbeddedBundle = CoreResourcesEmbeddedBundle.loadFromLibrary(folder + "/" + System.mapLibraryName("OsmAndCore_ResourcesBundle_shared"));
                OsmAndCore.InitializeCore(coreResourcesEmbeddedBundle);
                loaded = true;
            }
            catch (Throwable e) {
                System.err.println("Failed to load OsmAndCoreWithJNI:" + String.valueOf(e));
                System.exit(0);
                loaded = false;
            }
        }
    }

    public QtCorePanel(LatLon location, int zoom) {
        this.mapCanvas = new MapCanvas(location, zoom);
        this.callback = new RenderRequestCallback();
    }

    public void setRenderingStyleFile(String styleFile) {
        this.styleFile = styleFile;
    }

    public void setRenderingProperties(String renderingProperties) {
        this.renderingProperties = renderingProperties;
    }

    protected void saveLocation(boolean save) {
        DataExtractionSettings settings = DataExtractionSettings.getSettings();
        settings.saveLocation(this.mapCanvas.latitude, this.mapCanvas.longitude, this.mapCanvas.zoom, save);
    }

    public Frame showFrame(int w, int h) {
        final Frame frame = new Frame("OsmAnd Core");
        frame.setSize(w, h);
        final Animator animator = new Animator();
        frame.setLayout(new BorderLayout());
        animator.add((GLAutoDrawable)this.mapCanvas);
        this.mapCanvas.registerListeners();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                QtCorePanel.this.saveLocation(true);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        animator.stop();
                        frame.dispose();
                    }
                }).start();
            }
        });
        frame.add((Component)((Object)this.mapCanvas), "Center");
        this.zoomField = new JTextField();
        this.zoomField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String txt = QtCorePanel.this.zoomField.getText();
                int i = txt.indexOf("#map=");
                String[] vs = txt.substring(i + "#map=".length()).split("/");
                QtCorePanel.this.mapCanvas.setLatLon(Float.parseFloat(vs[1]), Float.parseFloat(vs[2]));
                QtCorePanel.this.mapCanvas.setZoom(Integer.parseInt(vs[0]));
            }
        });
        frame.add((Component)this.zoomField, "North");
        frame.setBounds(DataExtractionSettings.getSettings().getWindowBounds());
        frame.validate();
        frame.setVisible(true);
        animator.start();
        return frame;
    }

    public void init(GLAutoDrawable drawable) {
        NativeEngineOptions options = new NativeEngineOptions();
        options.parseRenderingProperties(this.renderingProperties);
        MapStylesCollection mapStylesCollection = new MapStylesCollection();
        ResolvedMapStyle mapStyle = null;
        if (this.styleFile != null) {
            File styleDir = new File(this.styleFile).getParentFile();
            this.loadRenderer(mapStylesCollection, this.styleFile, styleDir);
            this.loadRendererAddons(mapStylesCollection, styleDir);
            mapStyle = mapStylesCollection.getResolvedStyleByName(new File(this.styleFile).getName());
        } else {
            System.out.println("Going to use embedded map style");
            mapStyle = mapStylesCollection.getResolvedStyleByName("default");
        }
        if (mapStyle == null) {
            System.err.println("Failed to resolve style");
            this.release();
            OsmAndCore.ReleaseCore();
            System.exit(0);
        }
        ObfsCollection obfsCollection = new ObfsCollection();
        String filesDir = DataExtractionSettings.getSettings().getBinaryFilesDir();
        obfsCollection.addDirectory(filesDir, false);
        MapPresentationEnvironment mapPresentationEnvironment = new MapPresentationEnvironment(mapStyle, options.density, 1.0f, options.symbolsScale / options.density);
        mapPresentationEnvironment.setLocaleLanguageId(options.getLocaleLanguageId());
        mapPresentationEnvironment.setLanguagePreference(options.getLanguagePreference());
        this.referenceTileSize = 256.0f * options.density;
        int rasterTileSize = Integer.highestOneBit((int)this.referenceTileSize - 1) * 2;
        mapPresentationEnvironment.setSettings(options.getStyleSettings());
        MapPrimitiviser mapPrimitiviser = new MapPrimitiviser(mapPresentationEnvironment);
        ObfMapObjectsProvider obfMapObjectsProvider = new ObfMapObjectsProvider(obfsCollection);
        MapPrimitivesProvider mapPrimitivesProvider = new MapPrimitivesProvider(obfMapObjectsProvider, mapPrimitiviser, rasterTileSize);
        MapObjectsSymbolsProvider mapObjectsSymbolsProvider = new MapObjectsSymbolsProvider(mapPrimitivesProvider, rasterTileSize);
        MapRasterLayerProvider_Software mapRasterLayerProvider = new MapRasterLayerProvider_Software(mapPrimitivesProvider);
        this.mapRenderer = OsmAndCore.createMapRenderer(MapRendererClass.AtlasMapRenderer_OpenGL2plus);
        if (this.mapRenderer == null) {
            System.err.println("Failed to create map renderer 'AtlasMapRenderer_OpenGL2plus'");
            this.release();
            OsmAndCore.ReleaseCore();
            System.exit(0);
        }
        QIODeviceLogSink logSink = QIODeviceLogSink.createFileLogSink(OsmExtractionUI.getUserLogDirectoryPath() + "/osmandcore.log");
        Logger.get().addLogSink(logSink);
        MapRendererSetupOptions rendererSetupOptions = new MapRendererSetupOptions();
        rendererSetupOptions.setGpuWorkerThreadEnabled(false);
        rendererSetupOptions.setFrameUpdateRequestCallback(this.callback.getBinding());
        rendererSetupOptions.setPathToOpenGLShadersCache(DataExtractionSettings.getSettings().getBinaryFilesDir());
        rendererSetupOptions.setMaxNumberOfRasterMapLayersInBatch(4L);
        this.mapRenderer.setup(rendererSetupOptions);
        AtlasMapRendererConfiguration atlasRendererConfiguration = AtlasMapRendererConfiguration.Casts.upcastFrom(this.mapRenderer.getConfiguration());
        atlasRendererConfiguration.setReferenceTileSizeOnScreenInPixels(this.referenceTileSize);
        this.mapRenderer.setConfiguration(AtlasMapRendererConfiguration.Casts.downcastTo_MapRendererConfiguration(atlasRendererConfiguration));
        this.mapRenderer.addSymbolsProvider(mapObjectsSymbolsProvider);
        this.mapRenderer.setAzimuth(0.0f);
        this.mapRenderer.setElevationAngle(90.0f);
        this.mapRenderer.setDebugSettings(options.getDebugSettings());
        this.mapCanvas.updateRenderer();
        this.mapRenderer.setMapLayerProvider(0, mapRasterLayerProvider);
    }

    private void loadRenderer(MapStylesCollection mapStylesCollection, String styleFile, File styleDir) {
        String depends = this.getDepends(styleFile);
        if (!Algorithms.isEmpty((CharSequence)depends)) {
            String dependsStyle = new File(styleDir, depends + ".render.xml").getAbsolutePath();
            this.loadRenderer(mapStylesCollection, dependsStyle, styleDir);
        }
        mapStylesCollection.addStyleFromFile(styleFile);
        System.out.println("Going to use map style from: " + styleFile);
    }

    private String getDepends(String styleFile) {
        String depends = null;
        try {
            int tok;
            XmlPullParser parser = PlatformUtil.newXMLPullParser();
            parser.setInput((InputStream)new FileInputStream(styleFile), null);
            while ((tok = parser.next()) != 1) {
                if (tok != 2 || !"renderingStyle".equals(parser.getName())) continue;
                depends = parser.getAttributeValue(null, "depends");
                break;
            }
        }
        catch (IOException | XmlPullParserException e) {
            throw new RuntimeException(e);
        }
        return depends;
    }

    private void loadRendererAddons(MapStylesCollection mapStylesCollection, File stylesDir) {
        File[] files = stylesDir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile() || !file.getName().endsWith("addon.render.xml")) continue;
                mapStylesCollection.addStyleFromFile(file.getAbsolutePath());
            }
        }
    }

    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        this.mapRenderer.setViewport(new AreaI(0, 0, height, width));
        this.mapRenderer.setWindowSize(new PointI(width, height));
        if (!this.mapRenderer.isRenderingInitialized() && !this.mapRenderer.initializeRendering(true)) {
            System.err.println("Failed to initialize rendering");
        }
    }

    public void display(GLAutoDrawable drawable) {
        if (this.mapRenderer == null) {
            return;
        }
        if (!this.mapRenderer.isRenderingInitialized()) {
            return;
        }
        this.mapRenderer.update();
        if (this.mapRenderer.prepareFrame()) {
            this.mapRenderer.renderFrame();
        }
    }

    public void dispose(GLAutoDrawable drawable) {
        if (this.mapRenderer != null && this.mapRenderer.isRenderingInitialized()) {
            this.mapRenderer.releaseRendering();
        }
        this.release();
        this.saveDefaultSettings();
        System.out.println("GL window is disposed.");
    }

    protected void saveDefaultSettings() {
        DataExtractionSettings settings = DataExtractionSettings.getSettings();
        settings.saveDefaultLocation(this.mapCanvas.latitude, this.mapCanvas.longitude);
        settings.saveDefaultZoom(this.mapCanvas.zoom);
    }

    private void release() {
    }

    public static void main(String[] args) {
        String nativePath = "/home/victor/temp/OsmAndMapCreator-main/lib";
        if (args.length > 0) {
            nativePath = args[0];
        }
        QtCorePanel.loadNative(nativePath);
        QtCorePanel sample = new QtCorePanel(DataExtractionSettings.getSettings().getDefaultLocation(), DataExtractionSettings.getSettings().getDefaultZoom());
        Frame frame = sample.showFrame(800, 600);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        OsmAndCore.ReleaseCore();
                        System.exit(0);
                    }
                }).start();
            }
        });
    }

    static {
        loaded = null;
        OS = System.getProperty("os.name").toLowerCase();
    }

    private class MapCanvas
    extends GLCanvas {
        private int zoom;
        private double longitude;
        private double latitude;

        public MapCanvas(LatLon location, int zoom) {
            this.latitude = location.getLatitude();
            this.longitude = location.getLongitude();
            this.zoom = zoom;
        }

        public void updateRenderer() {
            QtCorePanel.this.mapRenderer.setTarget(new PointI(MapUtils.get31TileNumberX((double)this.longitude), MapUtils.get31TileNumberY((double)this.latitude)));
            QtCorePanel.this.mapRenderer.setZoom(this.zoom);
            QtCorePanel.this.zoomField.setText("http://www.openstreetmap.org/#map=" + this.zoom + "/" + (float)this.latitude + "/" + (float)this.longitude);
        }

        public void registerListeners() {
            MapMouseAdapter mouse = new MapMouseAdapter();
            QtCorePanel.this.mapCanvas.addMouseListener(mouse);
            QtCorePanel.this.mapCanvas.addMouseMotionListener(mouse);
            QtCorePanel.this.mapCanvas.addMouseWheelListener(mouse);
            QtCorePanel.this.mapCanvas.addGLEventListener(QtCorePanel.this);
        }

        public int getZoom() {
            return this.zoom;
        }

        public double getCenterPointX() {
            return this.getWidth() / 2;
        }

        public double getCenterPointY() {
            return this.getHeight() / 2;
        }

        public double getTileSize() {
            return QtCorePanel.this.referenceTileSize;
        }

        private void setLatLon(double lat, double lon) {
            this.latitude = lat;
            this.longitude = lon;
            this.updateRenderer();
            QtCorePanel.this.saveLocation(false);
        }

        protected void processKeyEvent(KeyEvent e) {
            boolean processed = false;
            if (e.getID() == 402) {
                if (e.getKeyCode() == 37) {
                    this.longitude = MapUtils.getLongitudeFromTile((double)this.zoom, (double)(this.getXTile() - 0.5));
                    processed = true;
                } else if (e.getKeyCode() == 39) {
                    this.longitude = MapUtils.getLongitudeFromTile((double)this.zoom, (double)(this.getXTile() + 0.5));
                    processed = true;
                } else if (e.getKeyCode() == 38) {
                    this.latitude = MapUtils.getLatitudeFromTile((float)this.zoom, (double)(this.getYTile() - 0.5));
                    processed = true;
                } else if (e.getKeyCode() == 40) {
                    this.latitude = MapUtils.getLatitudeFromTile((float)this.zoom, (double)(this.getYTile() + 0.5));
                    processed = true;
                }
            }
            if (e.getID() == 400) {
                if (e.getKeyChar() == '+' || e.getKeyChar() == '=') {
                    if (this.zoom < this.getMaximumZoomSupported()) {
                        ++this.zoom;
                        processed = true;
                    }
                } else if (e.getKeyChar() == '-' && this.zoom > this.getMinimumZoomSupported()) {
                    --this.zoom;
                    processed = true;
                }
            }
            if (processed) {
                e.consume();
            }
            super.processKeyEvent(e);
        }

        private int getMinimumZoomSupported() {
            return 1;
        }

        private int getMaximumZoomSupported() {
            return 21;
        }

        private double getYTile() {
            return MapUtils.getTileNumberY((float)this.zoom, (double)this.latitude);
        }

        private double getXTile() {
            return MapUtils.getTileNumberX((float)this.zoom, (double)this.longitude);
        }

        public void setZoom(int f) {
            this.zoom = f;
            this.updateRenderer();
        }

        public class MapMouseAdapter
        extends MouseAdapter {
            private Point startDragging = null;

            @Override
            public void mouseClicked(MouseEvent e) {
                MapCanvas.this.requestFocus();
            }

            public void dragTo(Point p) {
                double dx = ((double)this.startDragging.x - (double)p.x) / (double)QtCorePanel.this.referenceTileSize;
                double dy = ((double)this.startDragging.y - (double)p.y) / (double)QtCorePanel.this.referenceTileSize;
                double lat = MapUtils.getLatitudeFromTile((float)MapCanvas.this.zoom, (double)(MapCanvas.this.getYTile() + dy));
                double lon = MapUtils.getLongitudeFromTile((double)MapCanvas.this.zoom, (double)(MapCanvas.this.getXTile() + dx));
                MapCanvas.this.setLatLon(lat, lon);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (this.startDragging != null && Math.abs(e.getPoint().x - this.startDragging.x) + Math.abs(e.getPoint().y - this.startDragging.y) >= 8) {
                    this.dragTo(e.getPoint());
                    this.startDragging = e.getPoint();
                }
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                double dy = (double)e.getPoint().y - MapCanvas.this.getCenterPointY();
                double dx = (double)e.getPoint().x - MapCanvas.this.getCenterPointX();
                double lat = MapUtils.getLatitudeFromTile((float)MapCanvas.this.zoom, (double)(MapCanvas.this.getYTile() + dy / MapCanvas.this.getTileSize()));
                double lon = MapUtils.getLongitudeFromTile((double)MapCanvas.this.zoom, (double)(MapCanvas.this.getXTile() + dx / MapCanvas.this.getTileSize()));
                MapCanvas.this.setLatLon(lat, lon);
                if (e.getWheelRotation() < 0) {
                    MapCanvas.this.setZoom(MapCanvas.this.getZoom() + 1);
                } else if (e.getWheelRotation() > 0) {
                    MapCanvas.this.setZoom(MapCanvas.this.getZoom() - 1);
                }
                lat = MapUtils.getLatitudeFromTile((float)MapCanvas.this.zoom, (double)(MapCanvas.this.getYTile() - dy / MapCanvas.this.getTileSize()));
                lon = MapUtils.getLongitudeFromTile((double)MapCanvas.this.zoom, (double)(MapCanvas.this.getXTile() - dx / MapCanvas.this.getTileSize()));
                MapCanvas.this.setLatLon(lat, lon);
                super.mouseWheelMoved(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3 && this.startDragging == null) {
                    this.startDragging = e.getPoint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3 && this.startDragging != null) {
                    this.dragTo(e.getPoint());
                    this.startDragging = null;
                }
                super.mouseReleased(e);
            }
        }
    }

    private class RenderRequestCallback
    extends MapRendererSetupOptions.IFrameUpdateRequestCallback {
        private RenderRequestCallback() {
        }

        @Override
        public void method(IMapRenderer mapRenderer) {
            QtCorePanel.this.mapCanvas.repaint();
        }
    }

    private class NativeEngineOptions {
        private MapRendererDebugSettings debugSettings = new MapRendererDebugSettings();
        private String localeLanguageId = "en";
        private float density = 1.0f;
        private float symbolsScale = 1.0f;
        private MapPresentationEnvironment.LanguagePreference languagePreference = MapPresentationEnvironment.LanguagePreference.LocalizedOrNative;
        private final QStringStringHash styleSettings = new QStringStringHash();

        private NativeEngineOptions() {
        }

        public void parseRenderingProperties(String renderingProperties) {
            this.styleSettings.clear();
            this.localeLanguageId = "en";
            if (renderingProperties == null) {
                return;
            }
            for (String s : renderingProperties.split(",")) {
                int i = s.indexOf(61);
                if (i <= 0) continue;
                String name = s.substring(0, i).trim();
                String value = s.substring(i + 1).trim();
                if (value.contains(";")) {
                    value = value.substring(0, value.indexOf(59));
                }
                if (name.equals("lang")) {
                    this.localeLanguageId = value;
                    continue;
                }
                if (name.equals("density")) {
                    this.density = Float.parseFloat(value);
                    continue;
                }
                if (name.equals("languagePreference")) {
                    if (value.equals("nativeOnly")) {
                        this.languagePreference = MapPresentationEnvironment.LanguagePreference.NativeOnly;
                        continue;
                    }
                    if (value.equals("localizedOrNative")) {
                        this.languagePreference = MapPresentationEnvironment.LanguagePreference.LocalizedOrNative;
                        continue;
                    }
                    if (value.equals("nativeAndLocalized")) {
                        this.languagePreference = MapPresentationEnvironment.LanguagePreference.NativeAndLocalized;
                        continue;
                    }
                    if (value.equals("nativeAndLocalizedOrTransliterated")) {
                        this.languagePreference = MapPresentationEnvironment.LanguagePreference.NativeAndLocalizedOrTransliterated;
                        continue;
                    }
                    if (value.equals("localizedAndNative")) {
                        this.languagePreference = MapPresentationEnvironment.LanguagePreference.LocalizedAndNative;
                        continue;
                    }
                    if (!value.equals("localizedOrTransliteratedAndNative")) continue;
                    this.languagePreference = MapPresentationEnvironment.LanguagePreference.LocalizedOrTransliteratedAndNative;
                    continue;
                }
                if (name.equals("textScale")) {
                    this.symbolsScale = Float.parseFloat(value);
                    continue;
                }
                if (name.equals("debugStageEnabled")) {
                    this.debugSettings.setDebugStageEnabled(value.equals("true"));
                    continue;
                }
                if (name.equals("excludeOnPathSymbols")) {
                    this.debugSettings.setExcludeOnPathSymbolsFromProcessing(value.equals("true"));
                    continue;
                }
                if (name.equals("excludeBillboardSymbols")) {
                    this.debugSettings.setExcludeBillboardSymbolsFromProcessing(value.equals("true"));
                    continue;
                }
                if (name.equals("excludeOnSurfaceSymbols")) {
                    this.debugSettings.setExcludeOnSurfaceSymbolsFromProcessing(value.equals("true"));
                    continue;
                }
                if (name.equals("skipSymbolsIntersection")) {
                    this.debugSettings.setSkipSymbolsIntersectionCheck(value.equals("true"));
                    continue;
                }
                if (name.equals("showSymbolsBBoxesAccByIntersection")) {
                    this.debugSettings.setShowSymbolsBBoxesAcceptedByIntersectionCheck(value.equals("true"));
                    continue;
                }
                if (name.equals("showSymbolsBBoxesRejByIntersection")) {
                    this.debugSettings.setShowSymbolsBBoxesRejectedByIntersectionCheck(value.equals("true"));
                    continue;
                }
                if (name.equals("skipSymbolsMinDistance")) {
                    this.debugSettings.setSkipSymbolsMinDistanceToSameContentFromOtherSymbolCheck(value.equals("true"));
                    continue;
                }
                if (name.equals("showSymbolsBBoxesRejectedByMinDist")) {
                    this.debugSettings.setShowSymbolsBBoxesRejectedByMinDistanceToSameContentFromOtherSymbolCheck(value.equals("true"));
                    continue;
                }
                if (name.equals("showSymbolsCheckBBoxesRejectedByMinDist")) {
                    this.debugSettings.setShowSymbolsCheckBBoxesRejectedByMinDistanceToSameContentFromOtherSymbolCheck(value.equals("true"));
                    continue;
                }
                if (name.equals("skipSymbolsPresentationModeCheck")) {
                    this.debugSettings.setSkipSymbolsPresentationModeCheck(value.equals("true"));
                    continue;
                }
                if (name.equals("showSymbolsBBoxesRejectedByPresentationMode")) {
                    this.debugSettings.setShowSymbolsBBoxesRejectedByPresentationMode(value.equals("true"));
                    continue;
                }
                if (name.equals("showOnPathSymbolsRenderablesPaths")) {
                    this.debugSettings.setShowOnPathSymbolsRenderablesPaths(value.equals("true"));
                    continue;
                }
                if (name.equals("showOnPath2dSymbolGlyphDetails")) {
                    this.debugSettings.setShowOnPath2dSymbolGlyphDetails(value.equals("true"));
                    continue;
                }
                if (name.equals("showOnPath3dSymbolGlyphDetails")) {
                    this.debugSettings.setShowOnPath3dSymbolGlyphDetails(value.equals("true"));
                    continue;
                }
                if (name.equals("allSymbolsTransparentForIntersectionLookup")) {
                    this.debugSettings.setAllSymbolsTransparentForIntersectionLookup(value.equals("true"));
                    continue;
                }
                if (name.equals("showTooShortOnPathSymbolsRenderablesPaths")) {
                    this.debugSettings.setShowTooShortOnPathSymbolsRenderablesPaths(value.equals("true"));
                    continue;
                }
                if (name.equals("showAllPaths")) {
                    this.debugSettings.setShowAllPaths(value.equals("true"));
                    continue;
                }
                this.styleSettings.set(name, value);
            }
        }

        public MapRendererDebugSettings getDebugSettings() {
            return this.debugSettings;
        }

        public String getLocaleLanguageId() {
            return this.localeLanguageId;
        }

        public MapPresentationEnvironment.LanguagePreference getLanguagePreference() {
            return this.languagePreference;
        }

        public QStringStringHash getStyleSettings() {
            return this.styleSettings;
        }
    }
}

