/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.swing;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.osmand.Location;
import net.osmand.LocationsHolder;
import net.osmand.NativeLibrary;
import net.osmand.PlatformUtil;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.data.DataTileManager;
import net.osmand.data.LatLon;
import net.osmand.data.QuadRect;
import net.osmand.data.QuadTree;
import net.osmand.obf.preparation.DBDialect;
import net.osmand.obf.preparation.IndexHeightData;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.OSMSettings;
import net.osmand.osm.edit.Way;
import net.osmand.router.BinaryRoutePlanner;
import net.osmand.router.GeneralRouter;
import net.osmand.router.GpxRouteApproximation;
import net.osmand.router.HHRouteDataStructure;
import net.osmand.router.HHRoutePlanner;
import net.osmand.router.HHRoutingDB;
import net.osmand.router.HHRoutingUtilities;
import net.osmand.router.PrecalculatedRouteDirection;
import net.osmand.router.RouteCalculationProgress;
import net.osmand.router.RouteExporter;
import net.osmand.router.RoutePlannerFrontEnd;
import net.osmand.router.RouteResultPreparation;
import net.osmand.router.RouteSegmentResult;
import net.osmand.router.RoutingConfiguration;
import net.osmand.router.RoutingContext;
import net.osmand.router.TurnType;
import net.osmand.shared.gpx.GpxFile;
import net.osmand.shared.gpx.GpxTrackAnalysis;
import net.osmand.shared.gpx.GpxUtilities;
import net.osmand.shared.gpx.primitives.Track;
import net.osmand.shared.gpx.primitives.TrkSegment;
import net.osmand.shared.gpx.primitives.WptPt;
import net.osmand.shared.io.KFile;
import net.osmand.shared.routing.RouteColorize;
import net.osmand.swing.DataExtractionSettings;
import net.osmand.swing.ExceptionHandler;
import net.osmand.swing.MapPanel;
import net.osmand.swing.MapPanelLayer;
import net.osmand.swing.NativeSwingRendering;
import net.osmand.swing.OsmExtractionUI;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MapRouterLayer
implements MapPanelLayer {
    private static final Log log = PlatformUtil.getLog(MapRouterLayer.class);
    private static final double MIN_STRAIGHT_DIST = 50000.0;
    private static final double ANGLE_TO_DECLINE = 15.0;
    private static boolean USE_CACHE_CONTEXT = false;
    private HHRouteDataStructure.HHRoutingContext<HHRouteDataStructure.NetworkDBPoint> cacheHHCtx;
    private RoutingContext cacheRctx;
    private String cacheRouteParams;
    private MapPanel map;
    private LatLon startRoute;
    private LatLon endRoute;
    private List<LatLon> intermediates = new ArrayList<LatLon>();
    private boolean nextAvailable = true;
    private boolean pause = true;
    private boolean stop = false;
    private int steps = 1;
    private JButton nextTurn;
    private JButton playPauseButton;
    private JButton stopButton;
    private GpxFile selectedGPXFile;
    private QuadTree<Node> directionPointsFile;
    private List<RouteSegmentResult> previousRoute;
    public ActionListener setStartActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MapRouterLayer.this.setStart(new LatLon(MapRouterLayer.this.map.getLatitude(), MapRouterLayer.this.map.getLongitude()));
        }
    };
    public ActionListener setEndActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MapRouterLayer.this.setEnd(new LatLon(MapRouterLayer.this.map.getLatitude(), MapRouterLayer.this.map.getLongitude()));
        }
    };
    private boolean gpx = false;

    private File getHHFile(String profile) {
        return new File(DataExtractionSettings.getSettings().getBinaryFilesDir(), "Maps_" + profile + ".hhdb");
    }

    @Override
    public void destroyLayer() {
    }

    public void setStart(LatLon start) {
        this.startRoute = start;
        DataExtractionSettings.getSettings().saveStartLocation(start.getLatitude(), start.getLongitude());
        this.map.repaint();
    }

    public void setEnd(LatLon end) {
        this.endRoute = end;
        DataExtractionSettings.getSettings().saveEndLocation(end.getLatitude(), end.getLongitude());
        this.map.repaint();
    }

    @Override
    public void initLayer(MapPanel map) {
        this.map = map;
        this.startRoute = DataExtractionSettings.getSettings().getStartLocation();
        this.endRoute = DataExtractionSettings.getSettings().getEndLocation();
        this.nextTurn = new JButton(">>");
        this.nextTurn.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                MapRouterLayer.this.nextAvailable = true;
                MapRouterLayer mapRouterLayer = MapRouterLayer.this;
                synchronized (mapRouterLayer) {
                    MapRouterLayer.this.notify();
                }
            }
        });
        this.nextTurn.setVisible(false);
        this.nextTurn.setAlignmentY(0.0f);
        map.add((Component)this.nextTurn, 0);
        this.playPauseButton = new JButton("Play");
        this.playPauseButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                MapRouterLayer.this.pause = !MapRouterLayer.this.pause;
                MapRouterLayer.this.playPauseButton.setText(MapRouterLayer.this.pause ? "Play" : "Pause");
                MapRouterLayer.this.nextAvailable = true;
                MapRouterLayer mapRouterLayer = MapRouterLayer.this;
                synchronized (mapRouterLayer) {
                    MapRouterLayer.this.notify();
                }
            }
        });
        this.playPauseButton.setVisible(false);
        this.playPauseButton.setAlignmentY(0.0f);
        map.add((Component)this.playPauseButton, 0);
        this.stopButton = new JButton("Stop");
        this.stopButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                MapRouterLayer.this.stop = true;
                MapRouterLayer.this.nextAvailable = true;
                MapRouterLayer mapRouterLayer = MapRouterLayer.this;
                synchronized (mapRouterLayer) {
                    MapRouterLayer.this.notify();
                }
            }
        });
        this.stopButton.setVisible(false);
        this.stopButton.setAlignmentY(0.0f);
        map.add(this.stopButton);
    }

    private LatLon getPointFromMenu() {
        Point popupMenuPoint = this.map.getPopupMenuPoint();
        double fy = ((double)popupMenuPoint.y - this.map.getCenterPointY()) / this.map.getTileSize();
        double fx = ((double)popupMenuPoint.x - this.map.getCenterPointX()) / this.map.getTileSize();
        double latitude = MapUtils.checkLatitude((double)MapUtils.getLatitudeFromTile((float)this.map.getZoom(), (double)(this.map.getYTile() + fy)));
        double longitude = MapUtils.checkLongitude((double)MapUtils.getLongitudeFromTile((double)this.map.getZoom(), (double)(this.map.getXTile() + fx)));
        LatLon l = new LatLon(latitude, longitude);
        return l;
    }

    @Override
    public void fillPopupMenuWithActions(JPopupMenu menu) {
        AbstractAction start = new AbstractAction("Mark start point"){
            private static final long serialVersionUID = 507156107455281238L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MapRouterLayer.this.setStart(MapRouterLayer.this.getPointFromMenu());
            }
        };
        menu.add(start);
        AbstractAction end = new AbstractAction("Mark end point"){
            private static final long serialVersionUID = 4446789424902471319L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MapRouterLayer.this.setEnd(MapRouterLayer.this.getPointFromMenu());
            }
        };
        menu.add(end);
        JMenu points = new JMenu("Transit Points");
        AbstractAction swapLocations = new AbstractAction("Swap locations"){
            private static final long serialVersionUID = 507156107455281238L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LatLon l = MapRouterLayer.this.endRoute;
                MapRouterLayer.this.endRoute = MapRouterLayer.this.startRoute;
                MapRouterLayer.this.startRoute = l;
                MapRouterLayer.this.map.repaint();
            }
        };
        points.add(swapLocations);
        AbstractAction addIntermediate = new AbstractAction("Add transit point"){
            private static final long serialVersionUID = 1021949691943312782L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MapRouterLayer.this.intermediates.add(MapRouterLayer.this.getPointFromMenu());
                MapRouterLayer.this.map.repaint();
            }
        };
        points.add(addIntermediate);
        AbstractAction remove = new AbstractAction("Remove transit point"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MapRouterLayer.this.intermediates.size() > 0) {
                    MapRouterLayer.this.intermediates.remove(0);
                }
                MapRouterLayer.this.map.repaint();
            }
        };
        points.add(remove);
        menu.add(points);
        JMenu directions = new JMenu("Directions");
        menu.add(directions);
        AbstractAction complexRoute = new AbstractAction("Build route (OsmAnd 2-phase|COMPLEX)"){
            private static final long serialVersionUID = 8049785829806139142L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MapRouterLayer.this.previousRoute = null;
                MapRouterLayer.this.calcRoute(RoutePlannerFrontEnd.RouteCalculationMode.COMPLEX, false);
            }
        };
        directions.add(complexRoute);
        AbstractAction selfRoute = new AbstractAction("Build route (OsmAnd slow+precise|NORMAL)"){
            private static final long serialVersionUID = 507156107455281238L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MapRouterLayer.this.previousRoute = null;
                MapRouterLayer.this.calcRoute(RoutePlannerFrontEnd.RouteCalculationMode.NORMAL, false);
            }
        };
        directions.add(selfRoute);
        AbstractAction selfBaseRoute = new AbstractAction("Build route (OsmAnd fast+long|BASE)"){
            private static final long serialVersionUID = 8049785829806139142L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MapRouterLayer.this.previousRoute = null;
                MapRouterLayer.this.calcRoute(RoutePlannerFrontEnd.RouteCalculationMode.BASE, false);
            }
        };
        directions.add(selfBaseRoute);
        AbstractAction selfHHRoute = new AbstractAction("Build HH route (only)"){
            private static final long serialVersionUID = 8049785829806139142L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MapRouterLayer.this.previousRoute = null;
                MapRouterLayer.this.calcRoute(RoutePlannerFrontEnd.RouteCalculationMode.NORMAL, true);
            }
        };
        directions.add(selfHHRoute);
        if (this.selectedGPXFile != null) {
            AbstractAction approximateByRouting = new AbstractAction("Approximate GPX (by routing)"){
                private static final long serialVersionUID = 507156107455281238L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    MapRouterLayer.this.calcRouteGpx(MapRouterLayer.this.selectedGPXFileToPolyline(), false);
                }
            };
            directions.add(approximateByRouting);
            AbstractAction approximateByGeometry = new AbstractAction("Approximate GPX (by geometry)"){
                private static final long serialVersionUID = 507156107455281238L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    MapRouterLayer.this.calcRouteGpx(MapRouterLayer.this.selectedGPXFileToPolyline(), true);
                }
            };
            directions.add(approximateByGeometry);
        }
        if (this.previousRoute != null) {
            AbstractAction recalculate = new AbstractAction("Rebuild route (OsmAnd)"){
                private static final long serialVersionUID = 507156107455281238L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    MapRouterLayer.this.calcRoute(RoutePlannerFrontEnd.RouteCalculationMode.NORMAL, false);
                }
            };
            directions.add(recalculate);
        }
        AbstractAction straightRoute = new AbstractAction("Build straight route "){
            private static final long serialVersionUID = 8049785829806139142L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MapRouterLayer.this.previousRoute = null;
                MapRouterLayer.this.calcStraightRoute(MapRouterLayer.this.getPointFromMenu());
                MapRouterLayer.this.map.fillPopupActions();
            }
        };
        directions.add(straightRoute);
        if (this.directionPointsFile == null) {
            loadGeoJSON = new AbstractAction("Load Direction Points (GeoJSON)..."){
                private static final long serialVersionUID = 507356107455281238L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser fileChooser = new JFileChooser(DataExtractionSettings.getSettings().getDefaultWorkingDir());
                    if (fileChooser.showOpenDialog(MapRouterLayer.this.map) == 0) {
                        File file = fileChooser.getSelectedFile();
                        Gson gson = new Gson();
                        MapRouterLayer.this.directionPointsFile = new QuadTree(new QuadRect(0.0, 0.0, 2.147483647E9, 2.147483647E9), 15, 0.5f);
                        try {
                            JsonObject mp = (JsonObject)gson.fromJson(new JsonReader((Reader)new FileReader(file)), JsonObject.class);
                            JsonElement features = mp.get("features");
                            if (features == null) {
                                return;
                            }
                            Iterator jsonE = features.getAsJsonArray().iterator();
                            while (jsonE.hasNext()) {
                                JsonObject obj = ((JsonElement)jsonE.next()).getAsJsonObject();
                                JsonArray ar = obj.get("geometry").getAsJsonObject().get("coordinates").getAsJsonArray();
                                double lon = ar.get(0).getAsDouble();
                                double lat = ar.get(1).getAsDouble();
                                JsonObject props = obj.get("properties").getAsJsonObject();
                                Node pt = new Node(lat, lon, -1L);
                                int x = MapUtils.get31TileNumberX((double)lon);
                                int y = MapUtils.get31TileNumberY((double)lat);
                                for (Map.Entry el : props.entrySet()) {
                                    pt.putTag((String)el.getKey(), ((JsonElement)el.getValue()).getAsString());
                                }
                                MapRouterLayer.this.directionPointsFile.insert((Object)pt, new QuadRect((double)x, (double)y, (double)x, (double)y));
                            }
                        }
                        catch (Exception e1) {
                            log.info((Object)("Error loading directions point (geojson): " + e1.getMessage()), (Throwable)e1);
                        }
                        MapRouterLayer.this.displayGpxFiles();
                        MapRouterLayer.this.map.fillPopupActions();
                    }
                }
            };
            directions.add(loadGeoJSON);
        } else {
            loadGeoJSON = new AbstractAction("Unload Direction Points"){
                private static final long serialVersionUID = 507356107455281238L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    MapRouterLayer.this.directionPointsFile = null;
                    MapRouterLayer.this.displayGpxFiles();
                    MapRouterLayer.this.map.fillPopupActions();
                }
            };
            directions.add(loadGeoJSON);
        }
        if (this.previousRoute != null) {
            AbstractAction saveGPX = new AbstractAction("Save GPX..."){
                private static final long serialVersionUID = 5757334824774850326L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ArrayList<Entity> es = new ArrayList<Entity>();
                    MapRouterLayer.this.calculateResult(es, MapRouterLayer.this.previousRoute);
                    ArrayList<Location> locations = new ArrayList<Location>();
                    for (Entity ent : es) {
                        if (!(ent instanceof Way)) continue;
                        for (Node node : ((Way)ent).getNodes()) {
                            locations.add(new Location("", node.getLatitude(), node.getLongitude()));
                        }
                    }
                    String name = new SimpleDateFormat("yyyy-MM-dd_HH-mm_EEE", Locale.US).format(new Date());
                    RouteExporter exporter = new RouteExporter(name, MapRouterLayer.this.previousRoute, locations, null, null);
                    GpxFile gpxFile = exporter.exportRoute();
                    JFileChooser fileChooser = new JFileChooser(DataExtractionSettings.getSettings().getDefaultWorkingDir());
                    if (fileChooser.showSaveDialog(MapRouterLayer.this.map) == 0) {
                        KFile file = new KFile(fileChooser.getSelectedFile().getAbsolutePath());
                        GpxUtilities.INSTANCE.writeGpxFile(file, gpxFile);
                    }
                }
            };
            directions.add(saveGPX);
        }
        if (this.selectedGPXFile == null) {
            AbstractAction loadGPXFile = new AbstractAction("Load GPX file..."){
                private static final long serialVersionUID = 507156107455281238L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser fileChooser = new JFileChooser(DataExtractionSettings.getSettings().getLastUsedDir());
                    if (fileChooser.showOpenDialog(MapRouterLayer.this.map) == 0) {
                        File file = fileChooser.getSelectedFile();
                        KFile kFile = new KFile(file.getAbsolutePath());
                        DataExtractionSettings.getSettings().setLastUsedDir(file.getParent());
                        MapRouterLayer.this.selectedGPXFile = GpxUtilities.INSTANCE.loadGpxFile(kFile);
                        MapRouterLayer.this.displayGpxFiles();
                        MapRouterLayer.this.map.fillPopupActions();
                    }
                }
            };
            menu.add(loadGPXFile);
        } else {
            AbstractAction unselectGPXFile = new AbstractAction("Unselect GPX file"){
                private static final long serialVersionUID = 507156107455281238L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataTileManager points = new DataTileManager(11);
                    MapRouterLayer.this.map.setPoints((DataTileManager<Entity>)points);
                    MapRouterLayer.this.selectedGPXFile = null;
                    MapRouterLayer.this.displayGpxFiles();
                    MapRouterLayer.this.map.setColorizationType(MapRouterLayer.this.selectedGPXFile, RouteColorize.ColorizationType.NONE, true);
                    MapRouterLayer.this.map.fillPopupActions();
                }
            };
            menu.add(unselectGPXFile);
            AbstractAction calcAltitude = new AbstractAction("Recalculate altitude "){
                private static final long serialVersionUID = 507156107454181238L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    File[] missingFile = new File[1];
                    MapRouterLayer.this.displayTrackInfo(MapRouterLayer.this.selectedGPXFile, "Unprocessed track info");
                    GpxFile res = MapRouterLayer.this.calculateAltitude(MapRouterLayer.this.selectedGPXFile, missingFile);
                    if (res == null || missingFile[0] != null) {
                        String msg = missingFile[0] != null ? "Missing in 'srtm' folder: " + missingFile[0].getName() : "Missing 'srtm' folder: " + DataExtractionSettings.getSettings().getBinaryFilesDir() + "/srtm";
                        JOptionPane.showMessageDialog(OsmExtractionUI.MAIN_APP.getFrame(), msg, "Missing srtm data", 1);
                    } else {
                        MapRouterLayer.this.selectedGPXFile = res;
                        MapRouterLayer.this.displayTrackInfo(MapRouterLayer.this.selectedGPXFile, "Processed track info");
                        MapRouterLayer.this.displayGpxFiles();
                        MapRouterLayer.this.map.fillPopupActions();
                    }
                }
            };
            menu.add(calcAltitude);
            final JMenu colorize = new JMenu("Colorize GPX file");
            AbstractAction altitude = new AbstractAction("Altitude"){
                private static final long serialVersionUID = 507156107355281238L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    int result = MapRouterLayer.this.showOptionColorSchemeDialog(colorize);
                    MapRouterLayer.this.map.setColorizationType(MapRouterLayer.this.selectedGPXFile, RouteColorize.ColorizationType.ELEVATION, result == 0);
                    MapRouterLayer.this.map.fillPopupActions();
                }
            };
            colorize.add(altitude);
            AbstractAction speed = new AbstractAction("Speed"){
                private static final long serialVersionUID = 507156107455281238L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    int result = MapRouterLayer.this.showOptionColorSchemeDialog(colorize);
                    MapRouterLayer.this.map.setColorizationType(MapRouterLayer.this.selectedGPXFile, RouteColorize.ColorizationType.SPEED, result == 0);
                    MapRouterLayer.this.map.fillPopupActions();
                }
            };
            colorize.add(speed);
            AbstractAction slope = new AbstractAction("Slope"){
                private static final long serialVersionUID = 50715610765281238L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    int result = MapRouterLayer.this.showOptionColorSchemeDialog(colorize);
                    MapRouterLayer.this.map.setColorizationType(MapRouterLayer.this.selectedGPXFile, RouteColorize.ColorizationType.SLOPE, result == 0);
                    MapRouterLayer.this.map.fillPopupActions();
                }
            };
            colorize.add(slope);
            menu.add(colorize);
        }
    }

    protected void displayTrackInfo(GpxFile gpxFile, String header) {
        GpxTrackAnalysis analysis = this.selectedGPXFile.getAnalysis(gpxFile.getModifiedTime());
        StringBuilder msg = new StringBuilder();
        msg.append(String.format("Track: distance %.1f, distance no gaps %.1f, tracks %d, points %d\n", Float.valueOf(analysis.getTotalDistance()), Float.valueOf(analysis.getTotalDistanceWithoutGaps()), analysis.getTotalTracks(), analysis.getWptPoints()));
        if (analysis.hasElevationData()) {
            msg.append(String.format("Ele: min - %.1f, max - %.1f, avg - %.1f, uphill - %.1f, downhill - %.1f\n", analysis.getMinElevation(), analysis.getMaxElevation(), analysis.getAvgElevation(), analysis.getDiffElevationUp(), analysis.getDiffElevationDown()));
        }
        if (analysis.hasSpeedData()) {
            msg.append(String.format("Speed: min - %.1f, max - %.1f, avg - %.1f, dist+speed - %.1f, dist+speed no gaps - %.1f\n", Float.valueOf(analysis.getMinSpeed()), Float.valueOf(analysis.getMaxSpeed()), Float.valueOf(analysis.getAvgSpeed()), Float.valueOf(analysis.getTotalDistanceMoving()), Float.valueOf(analysis.getTotalDistanceMovingWithoutGaps())));
        }
        if (analysis.getStartTime() != analysis.getEndTime()) {
            msg.append(String.format("Time: start - %s, end - %s, span - %.1f min, span no gaps - %.1f min\n", new Date(analysis.getStartTime()), new Date(analysis.getEndTime()), (double)analysis.getTimeSpan() / 60000.0, (double)analysis.getTimeSpanWithoutGaps() / 60000.0));
        }
        log.info((Object)(header + " " + String.valueOf(msg)));
        JOptionPane.showMessageDialog(OsmExtractionUI.MAIN_APP.getFrame(), msg, header, 1);
    }

    private int showOptionColorSchemeDialog(JMenu frame) {
        Object[] options = new String[]{"Grey", "Red, yellow, green"};
        return JOptionPane.showOptionDialog(frame, "What color scheme to use?", "Color scheme", 0, 1, null, options, null);
    }

    protected GpxFile calculateAltitude(GpxFile gpxFile, File[] missingFile) {
        File srtmFolder = new File(DataExtractionSettings.getSettings().getBinaryFilesDir(), "srtm");
        if (!srtmFolder.exists()) {
            return null;
        }
        IndexHeightData hd = new IndexHeightData();
        hd.setSrtmData(srtmFolder.getAbsolutePath(), srtmFolder);
        for (Track tr : gpxFile.getTracks()) {
            for (TrkSegment s : tr.getSegments()) {
                for (int i = 0; i < s.getPoints().size(); ++i) {
                    WptPt wpt = (WptPt)s.getPoints().get(i);
                    double h = hd.getPointHeight(wpt.getLat(), wpt.getLon(), missingFile);
                    if (h != Double.MIN_VALUE) {
                        wpt.setEle(h);
                        continue;
                    }
                    if (i != 0) continue;
                    return null;
                }
            }
        }
        return gpxFile;
    }

    private void displayGpxFiles() {
        DataTileManager points = new DataTileManager(9);
        if (this.selectedGPXFile != null) {
            for (Track t : this.selectedGPXFile.getTracks()) {
                for (TrkSegment ts : t.getSegments()) {
                    Way w = new Way(-1L);
                    int id = 0;
                    for (WptPt p : ts.getPoints()) {
                        Node n = new Node(p.getLat(), p.getLon(), -1L);
                        w.addNode(n);
                        n.putTag(OSMSettings.OSMTagKey.NAME.getValue(), String.valueOf(id));
                        n.putTag("gpx", "yes");
                        n.putTag("colour", "blue");
                        points.registerObject(n.getLatitude(), n.getLongitude(), (Object)n);
                        ++id;
                    }
                    w.putTag("gpx", "yes");
                    w.putTag("colour", "green");
                    LatLon n = w.getLatLon();
                    points.registerObject(n.getLatitude(), n.getLongitude(), (Object)w);
                }
            }
        }
        if (this.directionPointsFile != null) {
            List pnts = this.directionPointsFile.queryInBox(new QuadRect(0.0, 0.0, 2.147483647E9, 2.147483647E9), new ArrayList());
            for (Node n : pnts) {
                points.registerObject(n.getLatitude(), n.getLongitude(), (Object)n);
            }
        }
        this.map.setPoints((DataTileManager<Entity>)points);
    }

    private void calcStraightRoute(LatLon currentLatLon) {
        System.out.println("Distance: " + MapUtils.getDistance((LatLon)this.startRoute, (LatLon)this.endRoute));
        ArrayList<Way> ways = new ArrayList<Way>();
        Way w = new Way(1L);
        w.addNode(new Node(this.startRoute.getLatitude(), this.startRoute.getLongitude(), -1L));
        this.addStraightLine(w, this.startRoute, this.endRoute);
        Location c = new Location("");
        c.setLatitude(currentLatLon.getLatitude());
        c.setLongitude(currentLatLon.getLongitude());
        double minDist = w.getFirstNode().getLocation().distanceTo(c);
        int minInd = 0;
        LatLon prev = null;
        for (int ind = 1; ind < w.getNodes().size(); ++ind) {
            float dt = ((Node)w.getNodes().get(ind)).getLocation().distanceTo(c);
            if (!((double)dt < minDist)) continue;
            minDist = dt;
            minInd = ind;
            prev = ((Node)w.getNodes().get(ind - 1)).getLatLon();
        }
        while (minInd > 0) {
            w.removeNodeByIndex(0);
            --minInd;
        }
        while (w.getNodes().size() > 1) {
            Node s = w.getFirstNode();
            Node n = (Node)w.getNodes().get(1);
            float bearingTo = c.bearingTo(s.getLocation());
            float bearingTo2 = c.bearingTo(n.getLocation());
            if (!(Math.abs(MapUtils.degreesDiff((double)bearingTo2, (double)bearingTo)) > 15.0)) break;
            w.removeNodeByIndex(0);
            prev = s.getLatLon();
        }
        if (prev != null) {
            LatLon f = w.getFirstNode().getLatLon();
            float bearingTo = c.bearingTo(w.getFirstNode().getLocation());
            LatLon mp = MapUtils.calculateMidPoint(prev, (LatLon)f);
            while (MapUtils.getDistance((LatLon)mp, (LatLon)f) > 100.0) {
                Location l = new Location("");
                l.setLatitude(mp.getLatitude());
                l.setLongitude(mp.getLongitude());
                float bearingMid = c.bearingTo(l);
                if (Math.abs(MapUtils.degreesDiff((double)bearingMid, (double)bearingTo)) < 15.0) {
                    prev = mp;
                    w.addNode(new Node(mp.getLatitude(), mp.getLongitude(), -1L), 0);
                    break;
                }
                mp = MapUtils.calculateMidPoint((LatLon)mp, (LatLon)f);
            }
        }
        Way wr = new Way(2L);
        wr.addNode(new Node(currentLatLon.getLatitude(), currentLatLon.getLongitude(), -1L), 0);
        this.addStraightLine(wr, currentLatLon, ((Node)w.getNodes().get(0)).getLatLon());
        for (int i = 1; i < w.getNodes().size(); ++i) {
            wr.addNode((Node)w.getNodes().get(i));
        }
        ways.add(wr);
        DataTileManager points = new DataTileManager(11);
        for (Way w2 : ways) {
            LatLon n = w2.getLatLon();
            points.registerObject(n.getLatitude(), n.getLongitude(), (Object)w2);
        }
        this.map.setPoints((DataTileManager<Entity>)points);
    }

    private void addStraightLine(Way w, LatLon s1, LatLon s2) {
        if (MapUtils.getDistance((LatLon)s1, (LatLon)s2) > 50000.0) {
            LatLon m = MapUtils.calculateMidPoint((LatLon)s1, (LatLon)s2);
            this.addStraightLine(w, s1, m);
            this.addStraightLine(w, m, s2);
        } else {
            w.addNode(new Node(s2.getLatitude(), s2.getLongitude(), -1L));
        }
    }

    private LatLon toLatLon(WptPt wptPt) {
        return new LatLon(wptPt.getLat(), wptPt.getLon());
    }

    private void calcRouteGpx(final List<LatLon> polyline, final boolean useGeometryBased) {
        new Thread(){

            @Override
            public void run() {
                RoutePlannerFrontEnd frontEnd = new RoutePlannerFrontEnd();
                frontEnd.setUseGeometryBasedApproximation(useGeometryBased);
                List<Entity> entities = MapRouterLayer.this.selfRoute(MapRouterLayer.this.startRoute, MapRouterLayer.this.endRoute, polyline, true, null, frontEnd, RoutePlannerFrontEnd.RouteCalculationMode.NORMAL);
                if (entities != null) {
                    DataTileManager points = new DataTileManager(11);
                    for (Entity w : entities) {
                        LatLon n = w.getLatLon();
                        points.registerObject(n.getLatitude(), n.getLongitude(), (Object)w);
                    }
                    MapRouterLayer.this.map.setPoints((DataTileManager<Entity>)points);
                    MapRouterLayer.this.map.fillPopupActions();
                }
                if (MapRouterLayer.this.selectedGPXFile != null) {
                    JOptionPane.showMessageDialog(OsmExtractionUI.MAIN_APP.getFrame(), "Check validity of GPX File", "GPX route correction", 1);
                }
            }
        }.start();
    }

    private void calcRoute(final RoutePlannerFrontEnd.RouteCalculationMode m, final boolean hh) {
        new Thread(){

            @Override
            public void run() {
                List<Entity> res;
                MapRouterLayer.this.map.setPoints((DataTileManager<Entity>)new DataTileManager(11));
                RoutePlannerFrontEnd router = new RoutePlannerFrontEnd();
                if (hh) {
                    if (DataExtractionSettings.getSettings().useNativeRouting()) {
                        router.setHHRouteCpp(true);
                    }
                    HHRouteDataStructure.HHRoutingConfig hhConfig = HHRoutePlanner.prepareDefaultRoutingConfig(null).cacheContext(MapRouterLayer.this.cacheHHCtx);
                    router.setUseOnlyHHRouting(true).setHHRoutingConfig(hhConfig);
                    res = MapRouterLayer.this.selfRoute(MapRouterLayer.this.startRoute, MapRouterLayer.this.endRoute, MapRouterLayer.this.intermediates, false, MapRouterLayer.this.previousRoute, router, m);
                    if (USE_CACHE_CONTEXT) {
                        MapRouterLayer.this.cacheHHCtx = hhConfig.cacheCtx;
                    }
                } else {
                    router.setUseOnlyHHRouting(false).setHHRoutingConfig(null);
                    res = MapRouterLayer.this.selfRoute(MapRouterLayer.this.startRoute, MapRouterLayer.this.endRoute, MapRouterLayer.this.intermediates, false, MapRouterLayer.this.previousRoute, router, m);
                }
                if (res != null) {
                    DataTileManager points = new DataTileManager(11);
                    for (Entity w : res) {
                        LatLon n = w.getLatLon();
                        points.registerObject(n.getLatitude(), n.getLongitude(), (Object)w);
                    }
                    MapRouterLayer.this.map.setPoints((DataTileManager<Entity>)points);
                    MapRouterLayer.this.map.fillPopupActions();
                }
            }
        }.start();
    }

    private static Reader getUTF8Reader(InputStream f) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(f);
        assert (bis.markSupported());
        bis.mark(3);
        boolean reset = true;
        byte[] t = new byte[3];
        bis.read(t);
        if (t[0] == -17 && t[1] == -69 && t[2] == -65) {
            reset = false;
        }
        if (reset) {
            bis.reset();
        }
        return new InputStreamReader((InputStream)bis, "UTF-8");
    }

    public List<Way> parseGPX(File f) {
        ArrayList<Way> res = new ArrayList<Way>();
        try {
            StringBuilder content = new StringBuilder();
            BufferedReader reader = new BufferedReader(MapRouterLayer.getUTF8Reader(new FileInputStream(f)));
            String s = null;
            boolean fist = true;
            while ((s = reader.readLine()) != null) {
                if (fist) {
                    fist = false;
                }
                content.append(s).append("\n");
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dom = factory.newDocumentBuilder();
            Document doc = dom.parse(new InputSource(new StringReader(content.toString())));
            NodeList list = doc.getElementsByTagName("trkpt");
            Way w = new Way(-1L);
            for (int i = 0; i < list.getLength(); ++i) {
                Element item = (Element)list.item(i);
                try {
                    double lon = Double.parseDouble(item.getAttribute("lon"));
                    double lat = Double.parseDouble(item.getAttribute("lat"));
                    w.addNode(new Node(lat, lon, -1L));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!w.getNodes().isEmpty()) {
                res.add(w);
            }
        }
        catch (IOException e) {
            ExceptionHandler.handle(e);
        }
        catch (ParserConfigurationException e) {
            ExceptionHandler.handle(e);
        }
        catch (SAXException e) {
            ExceptionHandler.handle(e);
        }
        return res;
    }

    private static Double[] decodeGooglePolylinesFlow(String encodedData) {
        ArrayList<Double> decodedValues = new ArrayList<Double>();
        int rawDecodedValue = 0;
        int carriage = 0;
        int xx = encodedData.length();
        for (int x = 0; x < xx; ++x) {
            boolean isLast;
            int i = encodedData.charAt(x);
            int _5_bits = (i -= 63) << 27 >>> 27;
            rawDecodedValue |= _5_bits << carriage;
            carriage += 5;
            boolean bl = isLast = (i & 0x20) == 0;
            if (!isLast) continue;
            boolean isNegative = (rawDecodedValue & 1) == 1;
            rawDecodedValue >>>= 1;
            if (isNegative) {
                rawDecodedValue ^= 0xFFFFFFFF;
            }
            decodedValues.add((double)rawDecodedValue / 100000.0);
            carriage = 0;
            rawDecodedValue = 0;
        }
        return decodedValues.toArray(new Double[decodedValues.size()]);
    }

    public static List<Way> route_OSRM(LatLon start, LatLon end) {
        ArrayList<Way> res = new ArrayList<Way>();
        long time = System.currentTimeMillis();
        System.out.println("Route from " + String.valueOf(start) + " to " + String.valueOf(end));
        if (start != null && end != null) {
            try {
                StringBuilder uri = new StringBuilder();
                uri.append(DataExtractionSettings.getSettings().getOsrmServerAddress());
                uri.append("/viaroute?");
                uri.append("&loc=").append(start.getLatitude()).append(",").append(start.getLongitude());
                uri.append("&loc=").append(end.getLatitude()).append(",").append(end.getLongitude());
                uri.append("&output=json");
                uri.append("&instructions=false");
                uri.append("&geomformat=cmp");
                URL url = new URL(uri.toString());
                URLConnection connection = url.openConnection();
                StringBuilder content = new StringBuilder();
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String s = null;
                boolean fist = true;
                while ((s = reader.readLine()) != null) {
                    if (fist) {
                        fist = false;
                    }
                    content.append(s).append("\n");
                }
                System.out.println(content);
                JSONObject jsonContent = (JSONObject)new JSONTokener(content.toString()).nextValue();
                String routeGeometry = jsonContent.getString("route_geometry");
                Double[] route = MapRouterLayer.decodeGooglePolylinesFlow(routeGeometry);
                double latitude = 0.0;
                double longitude = 0.0;
                Way w = new Way(-1L);
                for (int routePointIdx = 0; routePointIdx < route.length / 2; ++routePointIdx) {
                    w.addNode(new Node(latitude += route[routePointIdx * 2 + 0].doubleValue(), longitude += route[routePointIdx * 2 + 1].doubleValue(), -1L));
                }
                if (!w.getNodes().isEmpty()) {
                    res.add(w);
                }
            }
            catch (IOException e) {
                ExceptionHandler.handle(e);
            }
            catch (JSONException e) {
                ExceptionHandler.handle(e);
            }
            System.out.println("Finding routes " + res.size() + " " + (System.currentTimeMillis() - time) + " ms");
        }
        return res;
    }

    protected Collection<Entity> hhRoute(LatLon startRoute, LatLon endRoute) {
        try {
            HHRoutePlanner hhRoutePlanner;
            String profile = DataExtractionSettings.getSettings().getRouteMode();
            if (profile.indexOf(44) != -1) {
                profile = profile.substring(0, profile.indexOf(44)).trim();
            }
            File hhFile = this.getHHFile(profile);
            BinaryMapIndexReader[] readers = DataExtractionSettings.getSettings().getObfReaders();
            RoutingContext ctx = this.prepareRoutingContext(null, DataExtractionSettings.getSettings().getRouteMode(), RoutePlannerFrontEnd.RouteCalculationMode.NORMAL, readers, new RoutePlannerFrontEnd());
            if (hhFile.exists()) {
                Connection conn = DBDialect.SQLITE.getDatabaseConnection(hhFile.getAbsolutePath(), log);
                hhRoutePlanner = HHRoutePlanner.createDB((RoutingContext)ctx, (HHRoutingDB)new HHRoutingDB(hhFile, conn));
            } else {
                hhRoutePlanner = HHRoutePlanner.create((RoutingContext)ctx);
            }
            HHRouteDataStructure.HHNetworkRouteRes route = hhRoutePlanner.runRouting(startRoute, endRoute, null);
            ArrayList<Entity> lst = new ArrayList<Entity>();
            if (route.getError() != null) {
                JOptionPane.showMessageDialog(OsmExtractionUI.MAIN_APP.getFrame(), route.getError(), "Routing error", 0);
                System.err.println(route.getError());
            }
            if (!route.getList().isEmpty()) {
                this.calculateResult(lst, route.getList());
            } else {
                TLongObjectHashMap entities = new TLongObjectHashMap();
                for (HHRouteDataStructure.HHNetworkSegmentRes r : route.segments) {
                    if (r.list != null) {
                        for (RouteSegmentResult rs : r.list) {
                            HHRoutingUtilities.addWay((TLongObjectHashMap)entities, (RouteSegmentResult)rs, (String)"highway", (String)"secondary");
                        }
                        continue;
                    }
                    if (r.segment == null) continue;
                    HHRoutingUtilities.addWay((TLongObjectHashMap)entities, (HHRouteDataStructure.NetworkDBSegment)r.segment, (String)"highway", (String)"primary");
                }
                lst.addAll(entities.valueCollection());
            }
            for (HHRouteDataStructure.HHNetworkRouteRes altRoute : route.altRoutes) {
                TLongObjectHashMap entities = new TLongObjectHashMap();
                for (HHRouteDataStructure.HHNetworkSegmentRes r : altRoute.segments) {
                    if (r.list != null) {
                        for (RouteSegmentResult rs : r.list) {
                            HHRoutingUtilities.addWay((TLongObjectHashMap)entities, (RouteSegmentResult)rs, (String)"highway", (String)"tertiary");
                        }
                        continue;
                    }
                    if (r.segment == null) continue;
                    HHRoutingUtilities.addWay((TLongObjectHashMap)entities, (HHRouteDataStructure.NetworkDBSegment)r.segment, (String)"highway", (String)"tertiary");
                }
                lst.addAll(entities.valueCollection());
            }
            return lst;
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return new ArrayList<Entity>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Entity> selfRoute(LatLon start, LatLon end, List<LatLon> intermediates, boolean gpx, List<RouteSegmentResult> previousRoute, RoutePlannerFrontEnd router, RoutePlannerFrontEnd.RouteCalculationMode rm) {
        this.gpx = gpx;
        ArrayList<Entity> res = new ArrayList<Entity>();
        long time = System.currentTimeMillis();
        boolean animateRoutingCalculation = DataExtractionSettings.getSettings().isAnimateRouting();
        if (animateRoutingCalculation) {
            this.nextTurn.setVisible(true);
            this.playPauseButton.setVisible(true);
            this.stopButton.setVisible(true);
            this.pause = true;
            this.playPauseButton.setText("Play");
        }
        this.stop = false;
        System.out.println("Self made route from " + String.valueOf(start) + " to " + String.valueOf(end));
        if (start != null && end != null) {
            try {
                BinaryMapIndexReader[] files = DataExtractionSettings.getSettings().getObfReaders();
                if (files.length == 0) {
                    JOptionPane.showMessageDialog(OsmExtractionUI.MAIN_APP.getFrame(), "Please specify obf file in settings", "Obf file not found", 0);
                    List<Entity> list = null;
                    return list;
                }
                PrecalculatedRouteDirection precalculatedRouteDirection = null;
                RoutingContext ctx = this.cacheRctx;
                if (!DataExtractionSettings.getSettings().getRouteMode().equals(this.cacheRouteParams) || ctx == null) {
                    this.cacheRouteParams = DataExtractionSettings.getSettings().getRouteMode();
                    ctx = this.prepareRoutingContext(previousRoute, this.cacheRouteParams, rm, files, router);
                } else {
                    ctx.calculationProgress = new RouteCalculationProgress();
                }
                DataTileManager<Entity> points = this.map.getPoints();
                this.map.setPoints(points);
                ctx.setVisitor(this.createSegmentVisitor(animateRoutingCalculation, points));
                long nt = System.nanoTime();
                this.startProgressThread(ctx);
                try {
                    GpxRouteApproximation gctx = new GpxRouteApproximation(ctx);
                    List gpxPoints = router.generateGpxPoints(gctx, new LocationsHolder(intermediates));
                    RouteResultPreparation.RouteCalcResult searchRoute = gpx ? this.getGpxAproximation(router, gctx, gpxPoints) : router.searchRoute(ctx, start, end, intermediates, precalculatedRouteDirection);
                    this.throwExceptionIfRouteNotFound(ctx, searchRoute);
                    System.out.println("Routing time " + (float)(System.nanoTime() - nt) / 1.0E9f);
                    if (animateRoutingCalculation) {
                        this.playPauseButton.setVisible(false);
                        this.nextTurn.setText("FINISH");
                        this.waitNextPress();
                        this.nextTurn.setText(">>");
                    }
                    this.previousRoute = searchRoute.getList();
                    this.calculateResult(res, searchRoute.getList());
                }
                finally {
                    if (ctx.calculationProgress != null) {
                        ctx.calculationProgress.isCancelled = true;
                    }
                    if (USE_CACHE_CONTEXT) {
                        this.cacheRctx = ctx;
                    }
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle(e);
            }
            finally {
                this.playPauseButton.setVisible(false);
                this.nextTurn.setVisible(false);
                this.stopButton.setVisible(false);
                if (this.map.getPoints() != null) {
                    this.map.getPoints().clear();
                }
            }
            System.out.println("!!! Finding self route: " + res.size() + " " + (System.currentTimeMillis() - time) + " ms");
        }
        return res;
    }

    private RoutingContext prepareRoutingContext(List<RouteSegmentResult> previousRoute, String routeMode, RoutePlannerFrontEnd.RouteCalculationMode rm, BinaryMapIndexReader[] files, RoutePlannerFrontEnd router) throws IOException {
        String[] props = routeMode.split("\\,");
        LinkedHashMap<String, String> paramsR = new LinkedHashMap<String, String>();
        for (String p : props) {
            if (p.contains("=")) {
                paramsR.put(p.split("=")[0], p.split("=")[1]);
                continue;
            }
            paramsR.put(p, "true");
        }
        RoutingConfiguration.RoutingMemoryLimits memoryLimit = new RoutingConfiguration.RoutingMemoryLimits(2000, 2560);
        GeneralRouter.IMPASSABLE_ROAD_SHIFT = 6;
        RoutingConfiguration config = DataExtractionSettings.getSettings().getRoutingConfig().setDirectionPoints(this.directionPointsFile).build(props[0], memoryLimit, paramsR);
        try {
            config.minPointApproximation = RoutingConfiguration.parseSilentFloat((String)((String)paramsR.get("minPointApproximation")), (float)config.minPointApproximation);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        RoutingContext ctx = router.buildRoutingContext(config, (NativeLibrary)(DataExtractionSettings.getSettings().useNativeRouting() ? NativeSwingRendering.getDefaultFromSettings() : null), files, rm);
        ctx.leftSideNavigation = false;
        ctx.previouslyCalculatedRoute = previousRoute;
        log.info((Object)("Use " + config.routerName + " mode for routing"));
        return ctx;
    }

    private RouteResultPreparation.RouteCalcResult getGpxAproximation(RoutePlannerFrontEnd router, GpxRouteApproximation gctx, List<RoutePlannerFrontEnd.GpxPoint> gpxPoints) throws IOException, InterruptedException {
        if (DataExtractionSettings.getSettings().useNativeRouting()) {
            router.setUseNativeApproximation(true);
        }
        GpxRouteApproximation r = router.searchGpxRoute(gctx, gpxPoints, null, false);
        return new RouteResultPreparation.RouteCalcResult(r.collectFinalPointsAsRoute());
    }

    private void throwExceptionIfRouteNotFound(RoutingContext ctx, RouteResultPreparation.RouteCalcResult searchRoute) {
        if (searchRoute == null) {
            Object reason = "unknown";
            if (ctx.calculationProgress.segmentNotFound >= 0) {
                reason = ctx.calculationProgress.segmentNotFound == 0 ? " start point is too far from road" : " target point " + ctx.calculationProgress.segmentNotFound + " is too far from road";
            } else if (ctx.calculationProgress.directSegmentQueueSize == 0) {
                reason = " route can not be found from start point (" + ctx.calculationProgress.distanceFromBegin / 1000.0f + " km)";
            } else if (ctx.calculationProgress.reverseSegmentQueueSize == 0) {
                reason = " route can not be found from end point (" + ctx.calculationProgress.distanceFromEnd / 1000.0f + " km)";
            }
            throw new RuntimeException("Route not found : " + (String)reason);
        }
        if (!searchRoute.isCorrect()) {
            throw new RuntimeException("Route not found : " + searchRoute.getError());
        }
    }

    private void startProgressThread(final RoutingContext ctx) {
        new Thread(){

            @Override
            public void run() {
                while (ctx.calculationProgress != null && !ctx.calculationProgress.isCancelled) {
                    try {
                        30.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }.start();
    }

    private void calculateResult(List<Entity> res, List<RouteSegmentResult> searchRoute) {
        RouteSegmentResult prevSegm = null;
        int indVisual = 0;
        for (RouteSegmentResult segm : searchRoute) {
            Way way = new Way(-1L);
            TurnType tt = segm.getTurnType();
            Object name = "";
            if (tt != null) {
                name = ++indVisual + ". " + tt.toXmlString() + (tt.isSkipToSpeak() ? "*" : "");
                if (tt.getLanes() != null) {
                    name = (String)name + " [" + TurnType.lanesToString((int[])tt.getLanes()) + "]";
                }
            }
            way.putTag(OSMSettings.OSMTagKey.NAME.getValue(), (String)name);
            if (prevSegm != null && MapUtils.getDistance((LatLon)prevSegm.getEndPoint(), (LatLon)segm.getStartPoint()) > 0.0) {
                Node pp = new Node(prevSegm.getEndPoint().getLatitude(), prevSegm.getEndPoint().getLongitude(), -1L);
                res.add((Entity)pp);
                pp.putTag("colour", "blue");
                Node pn = new Node(segm.getStartPoint().getLatitude(), segm.getStartPoint().getLongitude(), -1L);
                pn.putTag("colour", "red");
                res.add((Entity)pn);
                System.out.println(String.format("Not connected road '%f m' (%.5f/%.5f -> %.5f/%.5f) [%d: %s -> %d: %s]", MapUtils.getDistance((LatLon)prevSegm.getEndPoint(), (LatLon)segm.getStartPoint()), pp.getLatLon().getLatitude(), pp.getLatLon().getLongitude(), pn.getLatLon().getLatitude(), pn.getLatLon().getLongitude(), segm.getStartPointIndex(), segm.getObject(), prevSegm.getStartPointIndex(), prevSegm.getObject()));
            }
            boolean plus = segm.getStartPointIndex() < segm.getEndPointIndex();
            int ind = segm.getStartPointIndex();
            while (true) {
                LatLon l = segm.getPoint(ind);
                Node n = new Node(l.getLatitude(), l.getLongitude(), -1L);
                int[] pointTypes = segm.getObject().getPointTypes(ind);
                if (pointTypes != null && pointTypes.length == 1 && segm.getObject().region.routeEncodingRules.size() > pointTypes[0]) {
                    BinaryMapRouteReaderAdapter.RouteTypeRule rtr = segm.getObject().region.quickGetEncodingRule(pointTypes[0]);
                    if (rtr == null || !rtr.getTag().equals("osmand_dp")) {
                        way.addNode(n);
                    }
                } else {
                    way.addNode(n);
                }
                if (ind == segm.getEndPointIndex()) break;
                if (plus) {
                    ++ind;
                    continue;
                }
                --ind;
            }
            if (way.getNodes().size() > 0) {
                res.add((Entity)way);
            }
            prevSegm = segm;
        }
    }

    private BinaryRoutePlanner.RouteSegmentVisitor createSegmentVisitor(final boolean animateRoutingCalculation, final DataTileManager<Entity> points) {
        return new BinaryRoutePlanner.RouteSegmentVisitor(){
            private List<BinaryRoutePlanner.RouteSegment> cache = new ArrayList<BinaryRoutePlanner.RouteSegment>();
            private List<BinaryRoutePlanner.RouteSegment> pollCache = new ArrayList<BinaryRoutePlanner.RouteSegment>();
            private List<Integer> cacheInt = new ArrayList<Integer>();

            public void visitSegment(BinaryRoutePlanner.RouteSegment s, int endSegment, boolean poll) {
                if (MapRouterLayer.this.gpx) {
                    return;
                }
                if (MapRouterLayer.this.stop) {
                    throw new RuntimeException("Interrupted");
                }
                if (!animateRoutingCalculation) {
                    return;
                }
                if (!poll && MapRouterLayer.this.pause) {
                    this.pollCache.add(s);
                    return;
                }
                this.cache.add(s);
                this.cacheInt.add(endSegment);
                if (this.cache.size() < MapRouterLayer.this.steps) {
                    return;
                }
                if (MapRouterLayer.this.pause) {
                    this.registerObjects((DataTileManager<Entity>)points, poll, this.pollCache, null);
                    this.pollCache.clear();
                }
                this.registerObjects((DataTileManager<Entity>)points, !poll, this.cache, this.cacheInt);
                this.cache.clear();
                this.cacheInt.clear();
                MapRouterLayer.this.redraw();
                if (MapRouterLayer.this.pause) {
                    MapRouterLayer.this.waitNextPress();
                }
            }

            public void visitApproximatedSegments(List<RouteSegmentResult> segment, RoutePlannerFrontEnd.GpxPoint start, RoutePlannerFrontEnd.GpxPoint target) {
                if (MapRouterLayer.this.stop) {
                    throw new RuntimeException("Interrupted");
                }
                if (!animateRoutingCalculation) {
                    return;
                }
                for (List list : points.getAllEditObjects()) {
                    Iterator it = list.iterator();
                    while (it.hasNext()) {
                        Entity e = (Entity)it.next();
                        if ("yes".equals(e.getTag("gpx"))) continue;
                        it.remove();
                    }
                }
                MapRouterLayer.this.startRoute = start.loc;
                MapRouterLayer.this.endRoute = target.loc;
                for (int i = 0; i < segment.size(); ++i) {
                    this.cache.add(new BinaryRoutePlanner.RouteSegment(segment.get(i).getObject(), segment.get(i).getStartPointIndex()));
                    this.cacheInt.add(segment.get(i).getEndPointIndex());
                }
                if (this.cache.size() < MapRouterLayer.this.steps) {
                    return;
                }
                if (MapRouterLayer.this.pause) {
                    this.registerObjects((DataTileManager<Entity>)points, false, this.pollCache, null);
                    this.pollCache.clear();
                }
                this.registerObjects((DataTileManager<Entity>)points, false, this.cache, this.cacheInt);
                this.cache.clear();
                this.cacheInt.clear();
                MapRouterLayer.this.redraw();
                if (MapRouterLayer.this.pause) {
                    MapRouterLayer.this.waitNextPress();
                }
            }

            private void registerObjects(DataTileManager<Entity> points2, boolean white, List<BinaryRoutePlanner.RouteSegment> registerCache, List<Integer> cacheInt) {
                for (int l = 0; l < registerCache.size(); ++l) {
                    int to;
                    BinaryRoutePlanner.RouteSegment segment = registerCache.get(l);
                    Way way = new Way(-1L);
                    way.putTag(OSMSettings.OSMTagKey.NAME.getValue(), segment.getTestName());
                    if (white) {
                        way.putTag("color", "white");
                    }
                    int from = cacheInt != null ? segment.getSegmentStart() : segment.getSegmentStart() - 2;
                    int n = to = cacheInt != null ? cacheInt.get(l) : segment.getSegmentStart() + 2;
                    if (from > to) {
                        int x = from;
                        from = to;
                        to = x;
                    }
                    for (int i = from; i <= to; ++i) {
                        if (i < 0 || i >= segment.getRoad().getPointsLength()) continue;
                        Node n2 = MapRouterLayer.this.createNode(segment, i);
                        way.addNode(n2);
                        if (i == from || i == to) {
                            n2.putTag("colour", "red");
                        }
                        points2.registerObject(n2.getLatitude(), n2.getLongitude(), (Object)n2);
                    }
                    LatLon n3 = way.getLatLon();
                    points2.registerObject(n3.getLatitude(), n3.getLongitude(), (Object)way);
                }
            }
        };
    }

    private Node createNode(BinaryRoutePlanner.RouteSegment segment, int i) {
        Node n = new Node(MapUtils.get31LatitudeY((int)segment.getRoad().getPoint31YTile(i)), MapUtils.get31LongitudeX((int)segment.getRoad().getPoint31XTile(i)), -1L);
        return n;
    }

    private void redraw() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    MapRouterLayer.this.map.prepareImage();
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitNextPress() {
        this.nextTurn.setVisible(true);
        while (!this.nextAvailable) {
            try {
                MapRouterLayer mapRouterLayer = this;
                synchronized (mapRouterLayer) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.nextTurn.setVisible(false);
        this.nextAvailable = false;
    }

    @Override
    public void prepareToDraw() {
    }

    @Override
    public void paintLayer(Graphics2D g) {
        int y;
        int x;
        g.setColor(Color.green);
        if (this.startRoute != null) {
            x = this.map.getMapXForPoint(this.startRoute.getLongitude());
            y = this.map.getMapYForPoint(this.startRoute.getLatitude());
            g.drawOval(x, y, 12, 12);
            g.fillOval(x, y, 12, 12);
        }
        g.setColor(Color.red);
        if (this.endRoute != null) {
            x = this.map.getMapXForPoint(this.endRoute.getLongitude());
            y = this.map.getMapYForPoint(this.endRoute.getLatitude());
            g.drawOval(x, y, 12, 12);
            g.fillOval(x, y, 12, 12);
        }
        g.setColor(Color.yellow);
        for (LatLon i : this.intermediates) {
            int x2 = this.map.getMapXForPoint(i.getLongitude());
            int y2 = this.map.getMapYForPoint(i.getLatitude());
            g.drawOval(x2, y2, 12, 12);
            g.fillOval(x2, y2, 12, 12);
        }
    }

    public LatLon[] parseGPXDocument(String fileName) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dom = factory.newDocumentBuilder();
        Document doc = dom.parse(new InputSource(new FileInputStream(fileName)));
        NodeList list = doc.getElementsByTagName("trkpt");
        LatLon[] x = new LatLon[list.getLength()];
        for (int i = 0; i < list.getLength(); ++i) {
            Element item = (Element)list.item(i);
            x[i] = new LatLon(Double.parseDouble(item.getAttribute("lat")), Double.parseDouble(item.getAttribute("lon")));
        }
        return x;
    }

    private List<LatLon> selectedGPXFileToPolyline() {
        if (this.selectedGPXFile.hasTrkPt()) {
            TrkSegment trkSegment = (TrkSegment)((Track)this.selectedGPXFile.getTracks().get(0)).getSegments().get(0);
            this.startRoute = this.toLatLon((WptPt)trkSegment.getPoints().get(0));
            this.endRoute = this.toLatLon((WptPt)trkSegment.getPoints().get(trkSegment.getPoints().size() - 1));
            ArrayList<LatLon> polyline = new ArrayList<LatLon>(trkSegment.getPoints().size());
            for (WptPt p : trkSegment.getPoints()) {
                polyline.add(this.toLatLon(p));
            }
            return polyline;
        }
        return new ArrayList<LatLon>();
    }

    @Override
    public void applySettings() {
    }
}

