/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.swing;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.osmand.ResultMatcher;
import net.osmand.binary.BinaryMapDataObject;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.data.Amenity;
import net.osmand.data.DataTileManager;
import net.osmand.data.LatLon;
import net.osmand.data.QuadRect;
import net.osmand.obf.BinaryInspector;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.OSMSettings;
import net.osmand.swing.DataExtractionSettings;
import net.osmand.swing.MapPanel;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

public class MapDataPrinter {
    private static final int SHIFT_CONSTANT = 1;
    private int numSearchAttempts = 1;
    private final MapPanel panel;
    private final Log log;
    private List<Node> nodes = new ArrayList<Node>();
    private int zoom;

    public MapDataPrinter(MapPanel panel, Log log) {
        this.panel = panel;
        this.log = log;
        this.zoom = panel.getZoom();
    }

    public void searchAndPrintObjects(MouseEvent e) {
        if (this.panel.getZoom() < 14) {
            return;
        }
        double dx = (double)e.getX() - this.panel.getCenterPointX();
        double dy = (double)e.getY() - this.panel.getCenterPointY();
        double tileOffsetX = dx / this.panel.getTileSize();
        double tileOffsetY = dy / this.panel.getTileSize();
        double longitude = MapUtils.getLongitudeFromTile((double)this.panel.getZoom(), (double)(this.panel.getXTile() + tileOffsetX));
        double latitude = MapUtils.getLatitudeFromTile((float)this.panel.getZoom(), (double)(this.panel.getYTile() + tileOffsetY));
        final LatLon center = new LatLon(latitude, longitude);
        final int radius = this.getRadius(latitude, 100);
        QuadRect bbox = MapUtils.calculateLatLonBbox((double)latitude, (double)longitude, (int)radius);
        int left = MapUtils.get31TileNumberX((double)bbox.left);
        int right = MapUtils.get31TileNumberX((double)bbox.right);
        int top = MapUtils.get31TileNumberY((double)bbox.top);
        int bottom = MapUtils.get31TileNumberY((double)bbox.bottom);
        final ArrayList objects = new ArrayList();
        final ArrayList distances = new ArrayList();
        ResultMatcher<BinaryMapDataObject> rmForObject = new ResultMatcher<BinaryMapDataObject>(){

            public boolean publish(BinaryMapDataObject object) {
                double distance = MapDataPrinter.getMinDistance(object, center, radius);
                if (distance <= (double)radius) {
                    objects.add(object);
                    distances.add(distance);
                }
                return false;
            }

            public boolean isCancelled() {
                return false;
            }
        };
        ResultMatcher<Amenity> rmForAmenity = new ResultMatcher<Amenity>(){

            public boolean publish(Amenity object) {
                double distance = MapUtils.getDistance((LatLon)center, (LatLon)object.getLocation());
                if (distance <= (double)radius) {
                    objects.add(object);
                    distances.add(distance);
                }
                return false;
            }

            public boolean isCancelled() {
                return false;
            }
        };
        try {
            BinaryMapIndexReader[] readers;
            for (BinaryMapIndexReader reader : readers = DataExtractionSettings.getSettings().getObfReaders()) {
                BinaryMapIndexReader.SearchRequest req = BinaryMapIndexReader.buildSearchRequest((int)left, (int)right, (int)top, (int)bottom, (int)this.panel.getZoom(), null, (ResultMatcher)rmForObject);
                reader.searchMapIndex(req);
                BinaryMapIndexReader.SearchRequest reqAmenity = BinaryMapIndexReader.buildSearchPoiRequest((int)left, (int)right, (int)top, (int)bottom, (int)this.panel.getZoom(), null, (ResultMatcher)rmForAmenity);
                reader.searchPoi(reqAmenity);
            }
            System.out.printf("%d. Found %d objects in %s around center (%s) within %d meters.\n", this.numSearchAttempts++, objects.size(), bbox, center, radius);
            for (int i = 0; i < objects.size(); ++i) {
                Object o = objects.get(i);
                if (o instanceof BinaryMapDataObject) {
                    MapDataPrinter.printDataObject((BinaryMapDataObject)o, (Double)distances.get(i));
                    continue;
                }
                if (!(o instanceof Amenity)) continue;
                MapDataPrinter.printAmenity((Amenity)o, (Double)distances.get(i));
            }
        }
        catch (IOException ex) {
            this.log.error((Object)"Error searching for map objects", (Throwable)ex);
        }
    }

    public void searchPOIs(boolean refresh) {
        DataTileManager points = this.panel.getPoints();
        if (points == null) {
            points = new DataTileManager(15);
        }
        if (refresh) {
            Point popupMenuPoint = this.panel.getPopupMenuPoint();
            double fy = ((double)popupMenuPoint.y - this.panel.getCenterPointY()) / this.panel.getTileSize();
            double fx = ((double)popupMenuPoint.x - this.panel.getCenterPointX()) / this.panel.getTileSize();
            double latitude = MapUtils.getLatitudeFromTile((float)this.panel.getZoom(), (double)(this.panel.getYTile() + fy));
            double longitude = MapUtils.getLongitudeFromTile((double)this.panel.getZoom(), (double)(this.panel.getXTile() + fx));
            final LatLon center = new LatLon(latitude, longitude);
            final int radius = Math.min(this.getRadius(latitude, 2), 10000);
            QuadRect bbox = MapUtils.calculateLatLonBbox((double)latitude, (double)longitude, (int)radius);
            int left = MapUtils.get31TileNumberX((double)bbox.left);
            int right = MapUtils.get31TileNumberX((double)bbox.right);
            int top = MapUtils.get31TileNumberY((double)bbox.top);
            int bottom = MapUtils.get31TileNumberY((double)bbox.bottom);
            final ArrayList objects = new ArrayList();
            ResultMatcher<Amenity> rm = new ResultMatcher<Amenity>(){

                public boolean publish(Amenity object) {
                    double distance = MapUtils.getDistance((LatLon)center, (LatLon)object.getLocation());
                    if (distance <= (double)radius) {
                        objects.add(object);
                    }
                    return false;
                }

                public boolean isCancelled() {
                    return false;
                }
            };
            try {
                BinaryMapIndexReader[] readers = DataExtractionSettings.getSettings().getObfReaders();
                for (BinaryMapIndexReader reader : readers) {
                    BinaryMapIndexReader.SearchRequest reqAmenity = BinaryMapIndexReader.buildSearchPoiRequest((int)left, (int)right, (int)top, (int)bottom, (int)this.panel.getZoom(), null, (ResultMatcher)rm);
                    reader.searchPoi(reqAmenity);
                }
            }
            catch (IOException ex) {
                this.log.error((Object)"Error searching for POI objects", (Throwable)ex);
            }
            System.out.printf("%d. Found %d POIs in %s around center (%s) within %d meters.\n", this.numSearchAttempts++, objects.size(), bbox, center, radius);
            for (Amenity object : objects) {
                MapDataPrinter.printAmenity(object);
            }
            ArrayList<Node> poiNodes = new ArrayList<Node>();
            for (Amenity poi : objects) {
                LatLon loc = poi.getLocation();
                Node n = new Node(loc.getLatitude(), loc.getLongitude(), poi.getId().longValue());
                n.putTag(OSMSettings.OSMTagKey.NAME.getValue(), this.panel.getZoom() <= 16 ? "" : MapDataPrinter.displayString(poi));
                poiNodes.add(n);
            }
            for (Node n : this.nodes) {
                LatLon ll = n.getLatLon();
                points.unregisterObject(ll.getLatitude(), ll.getLongitude(), (Object)n);
            }
            for (Node n : poiNodes) {
                LatLon ll = n.getLatLon();
                points.registerObject(ll.getLatitude(), ll.getLongitude(), (Object)n);
            }
            this.nodes = poiNodes;
        }
        if (refresh || this.zoom != this.panel.getZoom()) {
            this.zoom = this.panel.getZoom();
            this.panel.setPoints((DataTileManager<Entity>)points);
            this.panel.repaint();
        }
    }

    public void clearPOIs() {
        DataTileManager<Entity> points = this.panel.getPoints();
        if (points != null) {
            for (Node n : this.nodes) {
                LatLon ll = n.getLatLon();
                points.unregisterObject(ll.getLatitude(), ll.getLongitude(), (Object)n);
            }
        }
        this.nodes.clear();
        this.zoom = this.panel.getZoom();
        if (points != null) {
            this.panel.setPoints(points);
            this.panel.repaint();
        }
    }

    private static String displayString(Amenity object) {
        long id = object.getId();
        if (id > 0L) {
            id >>= 1;
        }
        return object.getSubType() + ":" + (String)(object.getName() != null && !object.getName().trim().isEmpty() ? "\n" + object.getName() : "") + "\nosmid=" + id;
    }

    private static void printAmenity(Amenity object) {
        String s = object.printNamesAndAdditional().toString();
        long id = object.getId();
        if (id > 0L) {
            id >>= 1;
        }
        System.out.println(object.getType().getKeyName() + ": " + object.getSubType() + " " + object.getName() + " " + String.valueOf(object.getLocation()) + " osmid=" + id + " " + s);
    }

    private int getRadius(double latitude, int partSize) {
        double tileWidthInMeters = MapUtils.getTileDistanceWidth((double)latitude, (float)this.panel.getZoom());
        double metersPerPixel = tileWidthInMeters / this.panel.getTileSize();
        return (int)((double)this.panel.getWidth() / (double)partSize * metersPerPixel);
    }

    private static void printAmenity(Amenity amenity, Double distance) {
        Map tagGroups;
        StringBuilder s = new StringBuilder(String.valueOf(amenity.printNamesAndAdditional()));
        long id = amenity.getId();
        if (id > 0L) {
            id >>= 1;
        }
        if ((tagGroups = amenity.getTagGroups()) != null) {
            s.append(" cities:");
            for (Map.Entry entry : tagGroups.entrySet()) {
                s.append("[");
                for (BinaryMapIndexReader.TagValuePair p : (List)entry.getValue()) {
                    s.append(p.tag).append("=").append(p.value).append(" ");
                }
                s.append("]");
            }
        }
        System.out.println(amenity.getType().getKeyName() + ": " + amenity.getSubType() + " " + amenity.getName() + " " + String.valueOf(amenity.getLocation()) + " osmid=" + id + " " + String.valueOf(s) + " distance=" + String.format("%.2f", distance));
    }

    private static void printDataObject(BinaryMapDataObject object, Double distance) {
        StringBuilder s = new StringBuilder();
        BinaryInspector.printMapDetails((BinaryMapDataObject)object, (StringBuilder)s, (boolean)false);
        s.append(" distance=").append(String.format("%.2f", distance));
        System.out.println(s);
    }

    private static double getMinDistance(BinaryMapDataObject object, LatLon center, int radiusMeters) {
        int pointsCount = object.getPointsLength();
        double minDistance = Double.MAX_VALUE;
        for (int i = 0; i < pointsCount; ++i) {
            double lat = MapUtils.get31LatitudeY((int)object.getPoint31YTile(i));
            double lon = MapUtils.get31LongitudeX((int)object.getPoint31XTile(i));
            double distance = MapUtils.getDistance((double)center.getLatitude(), (double)center.getLongitude(), (double)lat, (double)lon);
            if (distance <= (double)radiusMeters) {
                return distance;
            }
            if (!(minDistance > distance)) continue;
            minDistance = distance;
        }
        return minDistance;
    }
}

