/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.core.jni;

import net.osmand.core.jni.OsmAndCoreJNI;
import net.osmand.core.jni.VectorLine;

public class QListVectorLine {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected QListVectorLine(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(QListVectorLine qListVectorLine) {
        return qListVectorLine == null ? 0L : qListVectorLine.swigCPtr;
    }

    protected static long swigRelease(QListVectorLine qListVectorLine) {
        long l = 0L;
        if (qListVectorLine != null) {
            if (!qListVectorLine.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = qListVectorLine.swigCPtr;
            qListVectorLine.swigCMemOwn = false;
            qListVectorLine.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OsmAndCoreJNI.delete_QListVectorLine(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public QListVectorLine() {
        this(OsmAndCoreJNI.new_QListVectorLine(), true);
    }

    public long size() {
        return OsmAndCoreJNI.QListVectorLine_size(this.swigCPtr, this);
    }

    public void reserve(long l) {
        OsmAndCoreJNI.QListVectorLine_reserve(this.swigCPtr, this, l);
    }

    public boolean isEmpty() {
        return OsmAndCoreJNI.QListVectorLine_isEmpty(this.swigCPtr, this);
    }

    public void clear() {
        OsmAndCoreJNI.QListVectorLine_clear(this.swigCPtr, this);
    }

    public void add(VectorLine vectorLine) {
        OsmAndCoreJNI.QListVectorLine_add(this.swigCPtr, this, VectorLine.getCPtr(vectorLine), vectorLine);
    }

    public VectorLine get(int n) {
        long l = OsmAndCoreJNI.QListVectorLine_get(this.swigCPtr, this, n);
        return l == 0L ? null : new VectorLine(l, true);
    }

    public void set(int n, VectorLine vectorLine) {
        OsmAndCoreJNI.QListVectorLine_set(this.swigCPtr, this, n, VectorLine.getCPtr(vectorLine), vectorLine);
    }
}

