/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.compile;

import com.atilika.kuromoji.compile.Compiler;
import com.atilika.kuromoji.io.IntegerArrayIO;
import com.atilika.kuromoji.io.StringArrayIO;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class CharacterDefinitionsCompiler
implements Compiler {
    private Map<String, int[]> categoryDefinitions = new TreeMap<String, int[]>();
    private List<Set<String>> codepointCategories = new ArrayList<Set<String>>(new TreeSet());
    private OutputStream output;

    public CharacterDefinitionsCompiler(OutputStream output) {
        this.output = output;
        for (int i = 0; i < 65536; ++i) {
            this.codepointCategories.add(null);
        }
    }

    public void readCharacterDefinition(InputStream stream, String encoding) throws IOException {
        String line;
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(stream, encoding));
        while ((line = reader.readLine()) != null) {
            if ((line = line.replaceAll("\\s*#.*", "")).isEmpty()) continue;
            if (this.isCategoryEntry(line)) {
                this.parseCategory(line);
                continue;
            }
            this.parseMapping(line);
        }
    }

    private void parseCategory(String line) {
        String[] values = line.split("\\s+");
        String classname = values[0];
        int invoke = Integer.parseInt(values[1]);
        int group = Integer.parseInt(values[2]);
        int length = Integer.parseInt(values[3]);
        assert (!this.categoryDefinitions.containsKey(classname));
        this.categoryDefinitions.put(classname, new int[]{invoke, group, length});
    }

    private void parseMapping(String line) {
        String[] values = line.split("\\s+");
        assert (values.length >= 2);
        String codepointString = values[0];
        List<String> categories = this.getCategories(values);
        if (codepointString.contains("..")) {
            String[] codepoints = codepointString.split("\\.\\.");
            int lowerCodepoint = Integer.decode(codepoints[0]);
            int upperCodepoint = Integer.decode(codepoints[1]);
            for (int i = lowerCodepoint; i <= upperCodepoint; ++i) {
                this.addMapping(i, categories);
            }
        } else {
            int codepoint = Integer.decode(codepointString);
            this.addMapping(codepoint, categories);
        }
    }

    private List<String> getCategories(String[] values) {
        return Arrays.asList(values).subList(1, values.length);
    }

    private void addMapping(int codepoint, List<String> categories) {
        for (String category : categories) {
            this.addMapping(codepoint, category);
        }
    }

    private void addMapping(int codepoint, String category) {
        Set<String> categories = this.codepointCategories.get(codepoint);
        if (categories == null) {
            categories = new TreeSet<String>();
            this.codepointCategories.set(codepoint, categories);
        }
        categories.add(category);
    }

    private boolean isCategoryEntry(String line) {
        return !line.startsWith("0x");
    }

    public Map<String, Integer> makeCharacterCategoryMap() {
        TreeMap<String, Integer> classMapping = new TreeMap<String, Integer>();
        int i = 0;
        for (String category : this.categoryDefinitions.keySet()) {
            classMapping.put(category, i++);
        }
        return classMapping;
    }

    private int[][] makeCharacterDefinitions() {
        Map<String, Integer> categoryMap = this.makeCharacterCategoryMap();
        int size = categoryMap.size();
        int[][] array = new int[size][];
        for (String category : this.categoryDefinitions.keySet()) {
            int[] values = this.categoryDefinitions.get(category);
            assert (values.length == 3);
            int index = categoryMap.get(category);
            array[index] = values;
        }
        return array;
    }

    private int[][] makeCharacterMappings() {
        Map<String, Integer> categoryMap = this.makeCharacterCategoryMap();
        int size = this.codepointCategories.size();
        int[][] array = new int[size][];
        for (int i = 0; i < size; ++i) {
            Set<String> categories = this.codepointCategories.get(i);
            if (categories == null) continue;
            int innerSize = categories.size();
            int[] inner = new int[innerSize];
            int j = 0;
            for (String value : categories) {
                inner[j++] = categoryMap.get(value);
            }
            array[i] = inner;
        }
        return array;
    }

    private String[] makeCharacterCategorySymbols() {
        Map<String, Integer> categoryMap = this.makeCharacterCategoryMap();
        TreeMap<Integer, String> inverted = new TreeMap<Integer, String>();
        for (String key : categoryMap.keySet()) {
            inverted.put(categoryMap.get(key), key);
        }
        String[] categories = new String[inverted.size()];
        for (Integer index : inverted.keySet()) {
            categories[index.intValue()] = (String)inverted.get(index);
        }
        return categories;
    }

    public Map<String, int[]> getCategoryDefinitions() {
        return this.categoryDefinitions;
    }

    public List<Set<String>> getCodepointCategories() {
        return this.codepointCategories;
    }

    @Override
    public void compile() throws IOException {
        IntegerArrayIO.writeSparseArray2D(this.output, this.makeCharacterDefinitions());
        IntegerArrayIO.writeSparseArray2D(this.output, this.makeCharacterMappings());
        StringArrayIO.writeArray(this.output, this.makeCharacterCategorySymbols());
        this.output.close();
    }
}

