/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.search.core;

import net.osmand.data.LatLon;
import net.osmand.search.core.ObjectType;
import net.osmand.search.core.SearchResult;

public class SearchWord {
    private String word;
    private SearchResult result;

    public SearchWord(String word, SearchResult res) {
        this.word = word.trim();
        this.result = res;
    }

    public ObjectType getType() {
        return this.result == null ? ObjectType.UNKNOWN_NAME_FILTER : this.result.objectType;
    }

    public String getWord() {
        return this.word;
    }

    public SearchResult getResult() {
        return this.result;
    }

    public void syncWordWithResult() {
        this.word = this.result.wordsSpan != null ? this.result.wordsSpan : this.result.localeName.trim();
    }

    public LatLon getLocation() {
        return this.result == null ? null : this.result.location;
    }

    public String toString() {
        return this.word;
    }
}

