/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.osmand.PlatformUtil;
import net.osmand.binary.MapZooms;
import net.osmand.impl.ConsoleProgressImplementation;
import net.osmand.obf.preparation.IndexCreator;
import net.osmand.obf.preparation.IndexCreatorSettings;
import net.osmand.osm.MapRenderingTypesEncoder;
import net.osmand.util.Algorithms;
import org.apache.commons.logging.Log;
import org.kxml2.io.KXmlSerializer;
import org.xml.sax.SAXException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class CountryOcbfGeneration {
    private int OSM_ID = -1000;
    private static final Log log = PlatformUtil.getLog(CountryOcbfGeneration.class);

    public static void main(String[] args) throws XmlPullParserException, IOException, SAXException, SQLException, InterruptedException {
        String repo = "/Users/ivan/OsmAnd/";
        if (args != null && args.length > 0) {
            repo = args[0];
        }
        new CountryOcbfGeneration().generate(repo);
    }

    public Map<String, File> getPolygons(String repo) {
        String[] polygonFolders = new String[]{repo + "misc/osm-planet/polygons", repo + "misc/osm-planet/geo-polygons", repo + "misc/osm-planet/srtm-polygons"};
        LinkedHashMap<String, File> polygonFiles = new LinkedHashMap<String, File>();
        for (String folder : polygonFolders) {
            this.scanPolygons(new File(folder), polygonFiles);
        }
        return polygonFiles;
    }

    public Map<String, Set<TranslateEntity>> getTranslates(String repo) throws XmlPullParserException, IOException {
        String[] translations = new String[]{repo + "misc/osm-planet/osm-data/states_places.osm", repo + "misc/osm-planet/osm-data/states_regions.osm", repo + "misc/osm-planet/osm-data/countries_places.osm", repo + "misc/osm-planet/osm-data/countries_admin_level_2.osm"};
        TreeMap<String, Set<TranslateEntity>> translates = new TreeMap<String, Set<TranslateEntity>>();
        for (String t : translations) {
            this.scanTranslates(new File(t), translates);
        }
        return translates;
    }

    public CountryRegion parseDefaultOsmAndRegionStructure() throws XmlPullParserException, IOException {
        URL url = new URL("https://raw.githubusercontent.com/osmandapp/OsmAnd-resources/master/countries-info/regions.xml");
        return this.parseRegionStructure(url.openStream());
    }

    public CountryRegion parseRegionStructure(InputStream repo) throws XmlPullParserException, IOException {
        int tok;
        XmlPullParser parser = PlatformUtil.newXMLPullParser();
        parser.setInput((Reader)new InputStreamReader(repo, "UTF-8"));
        CountryRegion global = new CountryRegion();
        ArrayList<CountryRegion> stack = new ArrayList<CountryRegion>();
        stack.add(global);
        CountryRegion current = global;
        while ((tok = parser.next()) != 1) {
            String name;
            if (tok == 2) {
                name = parser.getName();
                if (!name.equals("region")) continue;
                LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
                for (int i = 0; i < parser.getAttributeCount(); ++i) {
                    attrs.put(parser.getAttributeName(i), parser.getAttributeValue(i));
                }
                CountryRegion cr = this.createRegion(current, attrs);
                stack.add(cr);
                current = cr;
                continue;
            }
            if (tok != 3 || !(name = parser.getName()).equals("region")) continue;
            stack.remove(stack.size() - 1);
            current = (CountryRegion)stack.get(stack.size() - 1);
        }
        repo.close();
        return global;
    }

    private void scanTranslates(File file, Map<String, Set<TranslateEntity>> translates) throws XmlPullParserException, IOException {
        int tok;
        XmlPullParser parser = PlatformUtil.newXMLPullParser();
        parser.setInput((Reader)new FileReader(file));
        TranslateEntity te = null;
        while ((tok = parser.next()) != 1) {
            String name;
            if (tok == 2) {
                name = parser.getName();
                if (name.equals("way") || name.equals("node") || name.equals("relation")) {
                    te = new TranslateEntity(name);
                    continue;
                }
                if (!name.equals("tag") || te == null) continue;
                LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
                for (int i = 0; i < parser.getAttributeCount(); ++i) {
                    attrs.put(parser.getAttributeName(i), parser.getAttributeValue(i));
                }
                te.tm.put((String)attrs.get("k"), (String)attrs.get("v"));
                continue;
            }
            if (tok != 3 || !(name = parser.getName()).equals("way") && !name.equals("node") && !name.equals("relation")) continue;
            if (!te.isEmpty()) {
                Iterator<Map.Entry<String, String>> it = te.tm.entrySet().iterator();
                this.addTranslate(translates, te, "entity=" + te.name);
                while (it.hasNext()) {
                    Map.Entry<String, String> e = it.next();
                    this.addTranslate(translates, te, e.getKey().toLowerCase() + "=" + e.getValue().toLowerCase());
                }
            }
            te = null;
        }
    }

    private void addTranslate(Map<String, Set<TranslateEntity>> translates, TranslateEntity te, String k) {
        if (!translates.containsKey(k)) {
            translates.put(k, new HashSet());
        }
        translates.get(k).add(te);
    }

    private void generate(String repo) throws XmlPullParserException, IOException, SAXException, SQLException, InterruptedException {
        String targetObf = repo + "regions.ocbf";
        String targetOsmXml = repo + "regions.osm.xml";
        Map<String, Set<TranslateEntity>> translates = this.getTranslates(repo);
        Map<String, File> polygonFiles = this.getPolygons(repo);
        CountryRegion global = this.parseRegionStructureFromRepo(repo);
        this.createFile(global, translates, polygonFiles, targetObf, targetOsmXml);
    }

    public CountryRegion parseRegionStructureFromRepo(String repo) throws XmlPullParserException, IOException, FileNotFoundException {
        String regionsXml = repo + "/resources/countries-info/regions.xml";
        return this.parseRegionStructure(new FileInputStream(regionsXml));
    }

    private void createFile(CountryRegion global, Map<String, Set<TranslateEntity>> translates, Map<String, File> polygonFiles, String targetObf, String targetOsmXml) throws IOException, SQLException, InterruptedException, XmlPullParserException {
        File osm = new File(targetOsmXml);
        KXmlSerializer serializer = new KXmlSerializer();
        FileOutputStream fous = new FileOutputStream(osm);
        serializer.setOutput((OutputStream)fous, "UTF-8");
        serializer.startDocument("UTF-8", Boolean.valueOf(true));
        serializer.startTag(null, "osm");
        serializer.attribute(null, "version", "0.6");
        serializer.attribute(null, "generator", "OsmAnd");
        serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        for (CountryRegion r : global.children) {
            r.parent = null;
            this.processRegion(r, translates, polygonFiles, targetObf, targetOsmXml, "", (XmlSerializer)serializer);
        }
        serializer.endDocument();
        serializer.flush();
        fous.close();
        IndexCreatorSettings settings = new IndexCreatorSettings();
        settings.indexMap = true;
        settings.indexAddress = false;
        settings.indexPOI = false;
        settings.indexTransport = false;
        settings.indexRouting = false;
        IndexCreator creator = new IndexCreator(new File(targetObf).getParentFile(), settings);
        creator.setMapFileName(new File(targetObf).getName());
        MapZooms zooms = MapZooms.parseZooms((String)"5-6");
        MapRenderingTypesEncoder encoder = new MapRenderingTypesEncoder("regions");
        encoder.addExternalAdditionalText("short_name", true);
        encoder.addExternalAdditionalText("alt_name", true);
        encoder.addExternalAdditionalText("name:abbreviation", false);
        creator.generateIndexes(osm, new ConsoleProgressImplementation(1.0), null, zooms, encoder, log);
    }

    private static void addTag(XmlSerializer serializer, String key, String value) throws IOException {
        serializer.startTag(null, "tag");
        serializer.attribute(null, "k", key);
        serializer.attribute(null, "v", value);
        serializer.endTag(null, "tag");
    }

    /*
     * WARNING - void declaration
     */
    private void processRegion(CountryRegion r, Map<String, Set<TranslateEntity>> translates, Map<String, File> polygonFiles, String targetObf, String targetOsmXml, String indent, XmlSerializer serializer) throws IOException {
        if (r.areaExtract) {
            return;
        }
        String line = "key=" + r.name;
        File boundary = null;
        if (r.boundary != null) {
            boundary = polygonFiles.get(r.boundary);
            if (boundary == null) {
                System.out.println("!!! Missing boundary " + r.boundary);
            } else {
                line = line + " boundary=" + boundary.getName();
            }
        }
        List<Object> boundaryPoints = Collections.emptyList();
        if (boundary != null) {
            boundaryPoints = this.readBoundaryPoints(boundary, serializer);
        }
        if (boundaryPoints.size() > 0) {
            int i;
            String[] ls = (String[])boundaryPoints.get(0);
            for (i = 0; i < boundaryPoints.size(); ++i) {
                if (ls.size() >= ((List)boundaryPoints.get(i)).size()) continue;
                ls = (List)boundaryPoints.get(i);
            }
            for (i = 0; i < boundaryPoints.size(); ++i) {
                if (boundaryPoints.get(i) == ls) continue;
                this.writeWay(serializer, (List)boundaryPoints.get(i));
                CountryOcbfGeneration.addTag(serializer, "osmand_region", "boundary");
                CountryOcbfGeneration.addTag(serializer, "key_name", r.name);
                CountryOcbfGeneration.addTag(serializer, "download_name", r.getDownloadName());
                CountryOcbfGeneration.addTag(serializer, "region_full_name", r.getFullName());
                serializer.endTag(null, "way");
            }
            this.writeWay(serializer, (List<String>)ls);
        } else {
            serializer.startTag(null, "node");
            serializer.attribute(null, "id", "" + this.OSM_ID--);
            serializer.attribute(null, "visible", "true");
            serializer.attribute(null, "lat", "0");
            serializer.attribute(null, "lon", "0");
        }
        CountryOcbfGeneration.addTag(serializer, "osmand_region", "yes");
        CountryOcbfGeneration.addTag(serializer, "key_name", r.name);
        CountryOcbfGeneration.addTag(serializer, "region_full_name", r.getFullName());
        if (r.parent != null) {
            CountryOcbfGeneration.addTag(serializer, "region_parent_name", r.parent.getFullName());
        }
        for (String tg : CountryRegion.tagsPropagate) {
            if (Algorithms.isEmpty((CharSequence)r.getAdditionalTag(tg))) continue;
            CountryOcbfGeneration.addTag(serializer, "region_" + tg, r.getAdditionalTag(tg));
        }
        if (r.map || r.roads || r.wiki || r.srtm || r.hillshade || r.slope || r.heightmap) {
            line = line + " download=" + r.getDownloadName();
            CountryOcbfGeneration.addTag(serializer, "download_name", r.getDownloadName());
            CountryOcbfGeneration.addTag(serializer, "region_prefix", r.getDownloadPrefix());
            CountryOcbfGeneration.addTag(serializer, "region_suffix", r.getDownloadSuffix());
            if (r.map) {
                line = line + " map=yes";
                CountryOcbfGeneration.addTag(serializer, "region_map", "yes");
            }
            if (r.jointMap) {
                line = line + " join_map_files=yes";
                CountryOcbfGeneration.addTag(serializer, "region_join_map", "yes");
            }
            if (r.wiki) {
                line = line + " wiki=yes";
                CountryOcbfGeneration.addTag(serializer, "region_wiki", "yes");
            }
            if (r.roads) {
                line = line + " roads=yes";
                CountryOcbfGeneration.addTag(serializer, "region_roads", "yes");
            }
            if (r.jointRoads) {
                line = line + " join_road_files=yes";
                CountryOcbfGeneration.addTag(serializer, "region_join_roads", "yes");
            }
            if (r.srtm) {
                line = line + " srtm=yes";
                CountryOcbfGeneration.addTag(serializer, "region_srtm", "yes");
            }
            if (r.hillshade) {
                line = line + " hillshade=yes";
                CountryOcbfGeneration.addTag(serializer, "region_hillshade", "yes");
            }
            if (r.slope) {
                line = line + " slope=yes";
                CountryOcbfGeneration.addTag(serializer, "region_slope", "yes");
            }
            if (r.heightmap) {
                line = line + " heightmap=yes";
                CountryOcbfGeneration.addTag(serializer, "region_heightmap", "yes");
            }
        }
        if (r.translate == null) {
            line = line + " translate-no=" + Algorithms.capitalizeFirstLetterAndLowercase((String)r.name);
        } else if (r.translate.startsWith("=")) {
            line = line + " translate-assign=" + r.translate.substring(1);
        } else {
            String[] tags = r.translate.split(";");
            Set<TranslateEntity> set = null;
            for (String string : tags) {
                void var16_22;
                if (!string.contains("=")) {
                    if (translates.containsKey("name=" + string)) {
                        String string2 = "name=" + string;
                    } else if (translates.containsKey("name:en=" + string)) {
                        String string3 = "name:en=" + string;
                    }
                }
                if (set == null) {
                    set = translates.get(var16_22);
                    if (set != null) continue;
                    break;
                }
                Set<TranslateEntity> st2 = translates.get(var16_22);
                if (st2 != null) {
                    set = new HashSet<TranslateEntity>(set);
                    set.retainAll(st2);
                    continue;
                }
                set = null;
                break;
            }
            if (set == null || set.size() == 0) {
                System.out.println("!!! Couldn't find translation name " + r.translate);
            } else if (set.size() > 1) {
                System.out.println("!!! More than 1 translation " + r.translate);
            } else {
                TranslateEntity nt = (TranslateEntity)set.iterator().next();
                line = line + " translate-" + nt.tm.size() + "=" + nt.tm.get("name");
                for (Map.Entry<String, String> e : nt.tm.entrySet()) {
                    CountryOcbfGeneration.addTag(serializer, e.getKey(), e.getValue());
                }
            }
        }
        System.out.println(indent + line);
        if (boundaryPoints.size() > 0) {
            serializer.endTag(null, "way");
        } else {
            serializer.endTag(null, "node");
        }
        for (CountryRegion c : r.children) {
            this.processRegion(c, translates, polygonFiles, targetObf, targetOsmXml, indent + "  ", serializer);
        }
    }

    private void writeWay(XmlSerializer serializer, List<String> ls) throws IOException {
        serializer.startTag(null, "way");
        serializer.attribute(null, "id", "" + this.OSM_ID--);
        serializer.attribute(null, "visible", "true");
        for (String bnd : ls) {
            serializer.startTag(null, "nd");
            serializer.attribute(null, "ref", bnd);
            serializer.endTag(null, "nd");
        }
    }

    private List<List<String>> readBoundaryPoints(File boundary, XmlSerializer serializer) throws IOException {
        String s;
        ArrayList<List<String>> res = new ArrayList<List<String>>();
        ArrayList<CallSite> l = new ArrayList<CallSite>();
        BufferedReader br = new BufferedReader(new FileReader(boundary));
        br.readLine();
        boolean newContour = true;
        while ((s = br.readLine()) != null) {
            if (newContour) {
                newContour = false;
                if (l.size() > 0) {
                    res.add(l);
                }
                l = new ArrayList();
                continue;
            }
            if (s.trim().length() == 0) continue;
            if (s.trim().equals("END")) {
                newContour = true;
                continue;
            }
            int i = (s = s.trim()).indexOf(32);
            if (i == -1) {
                i = s.indexOf(9);
            }
            if (i == -1) {
                System.err.println("? " + s);
            }
            String lat = s.substring(i, s.length()).trim();
            String lon = s.substring(0, i).trim();
            serializer.startTag(null, "node");
            try {
                serializer.attribute(null, "lat", "" + Double.parseDouble(lat));
                serializer.attribute(null, "lon", "" + Double.parseDouble(lon));
            }
            catch (NumberFormatException e) {
                System.err.println(lat + " " + lon);
                e.printStackTrace();
            }
            long id = this.OSM_ID--;
            l.add((CallSite)((Object)("" + id)));
            serializer.attribute(null, "id", "" + id);
            serializer.endTag(null, "node");
        }
        if (l.size() > 0) {
            res.add(l);
        }
        br.close();
        return res;
    }

    private CountryRegion createRegion(CountryRegion parent, Map<String, String> attrs) {
        CountryRegion reg = new CountryRegion();
        reg.parent = parent;
        if (parent != null) {
            parent.children.add(reg);
        }
        String type = attrs.get("type");
        reg.areaExtract = "area-extract".equals(type);
        reg.name = attrs.get("name");
        reg.setDownloadSuffix(attrs.get("download_suffix"));
        reg.setDownloadPrefix(attrs.get("download_prefix"));
        reg.setInnerDownloadSuffix(attrs.get("inner_download_suffix"));
        reg.setInnerDownloadPrefix(attrs.get("inner_download_prefix"));
        for (String tg : CountryRegion.tagsPropagate) {
            reg.additionalTags.put(tg, attrs.get(tg));
        }
        if (attrs.containsKey("hillshade")) {
            reg.hillshade = this.parseBoolean(attrs.get("hillshade"));
        } else {
            boolean bl = reg.hillshade = type == null || type.equals("hillshade");
        }
        if (attrs.containsKey("heightmap")) {
            reg.heightmap = this.parseBoolean(attrs.get("heightmap"));
        } else {
            boolean bl = reg.heightmap = type == null || type.equals("heightmap");
        }
        if (attrs.containsKey("slope")) {
            reg.slope = this.parseBoolean(attrs.get("slope"));
        } else {
            boolean bl = reg.slope = type == null || type.equals("slope");
        }
        if (attrs.containsKey("srtm")) {
            reg.srtm = this.parseBoolean(attrs.get("srtm"));
        } else {
            boolean bl = reg.srtm = type == null || type.equals("srtm");
        }
        if (attrs.containsKey("map")) {
            reg.map = this.parseBoolean(attrs.get("map"));
        } else {
            boolean bl = reg.map = type == null || type.equals("map");
        }
        if (attrs.containsKey("join_road_files")) {
            reg.jointRoads = this.parseBoolean(attrs.get("join_road_files"));
        }
        if (attrs.containsKey("join_map_files")) {
            reg.jointMap = this.parseBoolean(attrs.get("join_map_files"));
        }
        reg.roads = attrs.containsKey("roads") ? this.parseBoolean(attrs.get("roads")) : reg.map;
        reg.wiki = attrs.containsKey("wiki") ? this.parseBoolean(attrs.get("wiki")) : reg.map;
        if (attrs.containsKey("poly_extract")) {
            reg.polyExtract = attrs.get("poly_extract");
        }
        if (attrs.containsKey("translate")) {
            reg.translate = attrs.get("translate").toLowerCase();
            if (reg.translate.equals("no")) {
                reg.translate = null;
            }
        } else {
            reg.translate = "entity=node;" + reg.name.toLowerCase();
        }
        if (attrs.containsKey("boundary")) {
            reg.boundary = attrs.get("boundary");
            if (reg.boundary.equals("no")) {
                reg.boundary = null;
            }
        } else {
            reg.boundary = reg.name;
        }
        return reg;
    }

    private boolean parseBoolean(String string) {
        return Boolean.parseBoolean(string) || "yes".equalsIgnoreCase(string);
    }

    private void scanPolygons(File file, Map<String, File> polygonFiles) {
        if (file.isDirectory()) {
            for (File c : file.listFiles()) {
                if (c.isDirectory()) {
                    this.scanPolygons(c, polygonFiles);
                    continue;
                }
                if (!c.getName().endsWith(".poly")) continue;
                String name = c.getName().substring(0, c.getName().length() - 5);
                if (!polygonFiles.containsKey(name)) {
                    polygonFiles.put(name, c);
                } else {
                    File rm = polygonFiles.remove(name);
                    System.out.println("Polygon duplicate -> " + rm.getParentFile().getName() + "/" + name + " and " + c.getParentFile().getName() + "/" + name);
                }
                polygonFiles.put(c.getParentFile().getName() + "/" + name, c);
            }
        }
    }

    public static class CountryRegion {
        CountryRegion parent = null;
        List<CountryRegion> children = new ArrayList<CountryRegion>();
        static final String[] tagsPropagate = new String[]{"lang", "left_hand_navigation", "metric", "road_signs", "maxspeed", "maxspeed_urban", "maxspeed_rural"};
        Map<String, String> additionalTags = new LinkedHashMap<String, String>();
        String name;
        String downloadSuffix;
        String innerDownloadSuffix;
        String downloadPrefix;
        String innerDownloadPrefix;
        public String boundary;
        public String translate;
        public String polyExtract;
        public boolean areaExtract;
        public boolean jointMap;
        public boolean jointRoads;
        public boolean map;
        public boolean wiki;
        public boolean roads;
        public boolean hillshade;
        public boolean slope;
        public boolean heightmap;
        public boolean srtm;
        public long timestampToUpdate;

        public CountryRegion getParent() {
            return this.parent;
        }

        public List<CountryRegion> getChildren() {
            return this.children;
        }

        public Iterator<CountryRegion> iterator() {
            final LinkedList<CountryRegion> stack = new LinkedList<CountryRegion>(this.children);
            return new Iterator<CountryRegion>(){

                @Override
                public boolean hasNext() {
                    return !stack.isEmpty();
                }

                @Override
                public CountryRegion next() {
                    CountryRegion reg = (CountryRegion)stack.pollFirst();
                    stack.addAll(0, reg.children);
                    return reg;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public String getPolyExtract() {
            if (!Algorithms.isEmpty((CharSequence)this.polyExtract) || this.parent == null) {
                return this.polyExtract;
            }
            return this.parent.getPolyExtract();
        }

        public String getSinglePolyExtract() {
            return this.polyExtract;
        }

        public String getAdditionalTag(String tg) {
            if (!Algorithms.isEmpty((CharSequence)this.additionalTags.get(tg)) || this.parent == null) {
                return this.additionalTags.get(tg);
            }
            return this.parent.getAdditionalTag(tg);
        }

        public String getFullName() {
            if (this.parent == null) {
                return this.name;
            }
            return this.parent.getFullName() + "_" + this.name;
        }

        public String getDownloadName() {
            String suf;
            Object s = this.name;
            String p = this.getDownloadPrefix();
            if (p != null && p.length() > 0) {
                s = p + "_" + (String)s;
            }
            if ((suf = this.getDownloadSuffix()) != null && suf.length() > 0) {
                s = (String)s + "_" + suf;
            }
            return s;
        }

        public String getInnerDownloadPrefix() {
            if (this.innerDownloadPrefix != null) {
                return this.innerDownloadPrefix;
            }
            return this.getDownloadPrefix();
        }

        public String getDownloadPrefix() {
            if (this.downloadPrefix == null && this.parent != null) {
                return this.parent.getInnerDownloadPrefix();
            }
            return this.downloadPrefix == null ? "" : this.downloadPrefix;
        }

        public String getInnerDownloadSuffix() {
            if (this.innerDownloadSuffix != null) {
                return this.innerDownloadSuffix;
            }
            return this.getDownloadSuffix();
        }

        public String getDownloadSuffix() {
            if (this.downloadSuffix == null && this.parent != null) {
                return this.parent.getInnerDownloadSuffix();
            }
            return this.downloadSuffix == null ? "" : this.downloadSuffix;
        }

        public void setInnerDownloadSuffix(String string) {
            if (string != null) {
                this.innerDownloadSuffix = "$name".equals(string) ? this.name : string;
            }
        }

        public void setDownloadPrefix(String string) {
            if (string != null) {
                this.downloadPrefix = "$name".equals(string) ? this.name : string;
            }
        }

        public void setDownloadSuffix(String string) {
            if (string != null) {
                this.downloadSuffix = "$name".equals(string) ? this.name : string;
            }
        }

        public void setInnerDownloadPrefix(String string) {
            if (string != null) {
                this.innerDownloadPrefix = "$name".equals(string) ? this.name : string;
            }
        }

        public boolean hasMapFiles() {
            if (this.map) {
                return true;
            }
            for (CountryRegion c : this.children) {
                if (!c.hasMapFiles()) continue;
                return true;
            }
            return false;
        }
    }

    public static class TranslateEntity {
        private Map<String, String> tm = new TreeMap<String, String>();
        private String name;

        public TranslateEntity(String name) {
            this.name = name;
        }

        public boolean isEmpty() {
            return this.tm.isEmpty();
        }
    }
}

