/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.internal.input;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.filter.input.DefaultFileInputSource;
import org.xwiki.filter.input.DefaultInputStreamInputSource;
import org.xwiki.filter.input.DefaultReaderInputSource;
import org.xwiki.filter.input.DefaultURLInputSource;
import org.xwiki.filter.input.InputSource;
import org.xwiki.filter.input.StringInputSource;
import org.xwiki.properties.converter.AbstractConverter;
import org.xwiki.properties.converter.ConversionException;

@Component
@Singleton
public class InputSourceConverter
extends AbstractConverter<InputSource> {
    protected <G extends InputSource> G convertToType(Type targetType, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof InputSource) {
            return (G)((InputSource)value);
        }
        InputSource inputSource = value instanceof InputStream ? new DefaultInputStreamInputSource((InputStream)value) : (value instanceof File ? new DefaultFileInputSource((File)value) : (value instanceof Reader ? new DefaultReaderInputSource((Reader)value) : (value instanceof URL ? new DefaultURLInputSource((URL)value) : this.fromString(value.toString()))));
        return (G)inputSource;
    }

    private InputSource fromString(String source) {
        InputSource inputSource;
        if (source.startsWith("url:")) {
            try {
                inputSource = new DefaultURLInputSource(new URL(source.substring("url:".length())));
            }
            catch (Exception e) {
                throw new ConversionException("Failed to create input source for URL [" + source + "]", (Throwable)e);
            }
        } else {
            inputSource = source.startsWith("file:") ? new DefaultFileInputSource(new File(source.substring("file:".length()))) : new StringInputSource(source);
        }
        return inputSource;
    }
}

