/*
 * Decompiled with CFR 0.152.
 */
package com.wdtinc.mapbox_vector_tile.adapt.jts;

import com.wdtinc.mapbox_vector_tile.adapt.jts.IUserDataConverter;
import com.wdtinc.mapbox_vector_tile.builder.MvtLayerProps;
import java.util.Map;
import net.osmand.binary.VectorTile;

public final class UserDataKeyValueMapConverter
implements IUserDataConverter {
    private final boolean setId;
    private final String idKey;

    public UserDataKeyValueMapConverter() {
        this.setId = false;
        this.idKey = null;
    }

    public UserDataKeyValueMapConverter(String idKey) {
        if (idKey == null) {
            throw new NullPointerException();
        }
        this.setId = true;
        this.idKey = idKey;
    }

    @Override
    public void addTags(Object userData, MvtLayerProps layerProps, VectorTile.Tile.Feature.Builder featureBuilder) {
        if (userData != null) {
            try {
                Object idValue;
                Map userDataMap = (Map)userData;
                for (Map.Entry e : userDataMap.entrySet()) {
                    int valueIndex;
                    String key = (String)e.getKey();
                    Object value = e.getValue();
                    if (key == null || value == null || (valueIndex = layerProps.addValue(value)) < 0) continue;
                    featureBuilder.addTags(layerProps.addKey(key));
                    featureBuilder.addTags(valueIndex);
                }
                if (this.setId && (idValue = userDataMap.get(this.idKey)) != null) {
                    if (idValue instanceof Long || idValue instanceof Integer || idValue instanceof Float || idValue instanceof Double || idValue instanceof Byte || idValue instanceof Short) {
                        featureBuilder.setId((Long)idValue);
                    } else if (idValue instanceof String) {
                        try {
                            featureBuilder.setId(Long.valueOf((String)idValue));
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }
}

