/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.namespaces;

import info.bliki.Messages;
import info.bliki.wiki.filter.Encoder;
import info.bliki.wiki.namespaces.INamespace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class Namespace
implements INamespace {
    private final Map<String, NamespaceValue> TEXT_TO_NAMESPACE_MAP = new TreeMap<String, NamespaceValue>(String.CASE_INSENSITIVE_ORDER);
    private final Map<Integer, NamespaceValue> namespaceMap = new HashMap<Integer, NamespaceValue>(INamespace.NamespaceCode.values().length);
    public final NamespaceValue MEDIA = new NamespaceValue(INamespace.NamespaceCode.MEDIA_NAMESPACE_KEY, (NamespaceValue)null, new String[]{"Media"});
    public final NamespaceValue SPECIAL = new NamespaceValue(INamespace.NamespaceCode.SPECIAL_NAMESPACE_KEY, (NamespaceValue)null, new String[]{"Special"});
    public final NamespaceValue TALK = new NamespaceValue(INamespace.NamespaceCode.TALK_NAMESPACE_KEY, new String[]{"Talk"});
    public final NamespaceValue MAIN = new NamespaceValue(INamespace.NamespaceCode.MAIN_NAMESPACE_KEY, this.TALK, new String[]{""});
    public final NamespaceValue USER_TALK = new NamespaceValue(INamespace.NamespaceCode.USER_TALK_NAMESPACE_KEY, new String[]{"User_talk"});
    public final NamespaceValue USER = new NamespaceValue(INamespace.NamespaceCode.USER_NAMESPACE_KEY, this.USER_TALK, new String[]{"User"});
    public final NamespaceValue PROJECT_TALK = new NamespaceValue(INamespace.NamespaceCode.PROJECT_TALK_NAMESPACE_KEY, new String[]{"Project_talk", "Meta_talk"});
    public final NamespaceValue PROJECT = new NamespaceValue(INamespace.NamespaceCode.PROJECT_NAMESPACE_KEY, this.PROJECT_TALK, new String[]{"Project", "Meta"});
    public final NamespaceValue IMAGE_TALK = new NamespaceValue(INamespace.NamespaceCode.FILE_TALK_NAMESPACE_KEY, new String[]{"File_talk", "Image_talk"});
    public final NamespaceValue IMAGE = new NamespaceValue(INamespace.NamespaceCode.FILE_NAMESPACE_KEY, this.IMAGE_TALK, new String[]{"File", "Image"});
    public final NamespaceValue MEDIAWIKI_TALK = new NamespaceValue(INamespace.NamespaceCode.MEDIAWIKI_TALK_NAMESPACE_KEY, new String[]{"MediaWiki_talk"});
    public final NamespaceValue MEDIAWIKI = new NamespaceValue(INamespace.NamespaceCode.MEDIAWIKI_NAMESPACE_KEY, this.MEDIAWIKI_TALK, new String[]{"MediaWiki"});
    public final NamespaceValue MODULE_TALK = new NamespaceValue(INamespace.NamespaceCode.MODULE_TALK_NAMESPACE_KEY, new String[]{"Module_talk"});
    public final NamespaceValue MODULE = new NamespaceValue(INamespace.NamespaceCode.MODULE_NAMESPACE_KEY, this.MODULE_TALK, new String[]{"Module"});
    public final NamespaceValue TEMPLATE_TALK = new NamespaceValue(INamespace.NamespaceCode.TEMPLATE_TALK_NAMESPACE_KEY, new String[]{"Template_talk"});
    public final NamespaceValue TEMPLATE = new NamespaceValue(INamespace.NamespaceCode.TEMPLATE_NAMESPACE_KEY, this.TEMPLATE_TALK, new String[]{"Template"});
    public final NamespaceValue HELP_TALK = new NamespaceValue(INamespace.NamespaceCode.HELP_TALK_NAMESPACE_KEY, new String[]{"Help_talk"});
    public final NamespaceValue HELP = new NamespaceValue(INamespace.NamespaceCode.HELP_NAMESPACE_KEY, this.HELP_TALK, new String[]{"Help"});
    public final NamespaceValue CATEGORY_TALK = new NamespaceValue(INamespace.NamespaceCode.CATEGORY_TALK_NAMESPACE_KEY, new String[]{"Category_talk"});
    public final NamespaceValue CATEGORY = new NamespaceValue(INamespace.NamespaceCode.CATEGORY_NAMESPACE_KEY, this.CATEGORY_TALK, new String[]{"Category"});
    public final NamespaceValue PORTAL_TALK = new NamespaceValue(INamespace.NamespaceCode.PORTAL_TALK_NAMESPACE_KEY, new String[]{"Portal_talk"});
    public final NamespaceValue PORTAL = new NamespaceValue(INamespace.NamespaceCode.PORTAL_NAMESPACE_KEY, this.PORTAL_TALK, new String[]{"Portal"});
    public final NamespaceValue BOOK_TALK = new NamespaceValue(INamespace.NamespaceCode.BOOK_TALK_NAMESPACE_KEY, new String[]{"Book_talk"});
    public final NamespaceValue BOOK = new NamespaceValue(INamespace.NamespaceCode.BOOK_NAMESPACE_KEY, this.BOOK_TALK, new String[]{"Book"});
    public final NamespaceValue DRAFT_TALK = new NamespaceValue(INamespace.NamespaceCode.DRAFT_TALK_NAMESPACE_KEY, new String[]{"Draft_talk"});
    public final NamespaceValue DRAFT = new NamespaceValue(INamespace.NamespaceCode.DRAFT_NAMESPACE_KEY, this.DRAFT_TALK, new String[]{"Draft"});
    public final NamespaceValue EP_TALK = new NamespaceValue(INamespace.NamespaceCode.EP_TALK_NAMESPACE_KEY, new String[]{"Education_Program_talk"});
    public final NamespaceValue EP = new NamespaceValue(INamespace.NamespaceCode.EP_NAMESPACE_KEY, this.EP_TALK, new String[]{"Education_Program"});
    public final NamespaceValue TIMEDTEXT_TALK = new NamespaceValue(INamespace.NamespaceCode.TIMEDTEXT_TALK_NAMESPACE_KEY, new String[]{"TimedText_talk"});
    public final NamespaceValue TIMEDTEXT = new NamespaceValue(INamespace.NamespaceCode.TIMEDTEXT_NAMESPACE_KEY, this.TIMEDTEXT_TALK, new String[]{"TimedText"});
    public final NamespaceValue TOPIC = new NamespaceValue(INamespace.NamespaceCode.TOPIC_NAMESPACE_KEY, new String[]{"Topic"});
    protected ResourceBundle fResourceBundle;
    protected ResourceBundle fResourceBundleEn;

    public Namespace() {
        this((ResourceBundle)null);
    }

    public Namespace(Locale locale) {
        this(Messages.getResourceBundle(locale));
    }

    public Namespace(ResourceBundle resourceBundle) {
        this.fResourceBundle = resourceBundle;
        this.fResourceBundleEn = Messages.getResourceBundle(Locale.ENGLISH);
        this.initializeNamespaces();
    }

    @Override
    public boolean isNamespace(String namespace, INamespace.NamespaceCode code) {
        NamespaceValue nsVal = this.getNamespace(namespace);
        return nsVal != null && this.isNamespace(nsVal, code);
    }

    @Override
    public boolean isNamespace(INamespace.INamespaceValue namespace, INamespace.NamespaceCode code) {
        return namespace != null && namespace.getCode() == code;
    }

    @Override
    @Nullable
    public NamespaceValue getNamespace(String namespace) {
        return this.TEXT_TO_NAMESPACE_MAP.get(namespace);
    }

    @Override
    public NamespaceValue getNamespaceByNumber(INamespace.NamespaceCode numberCode) {
        return this.getNamespaceByNumber(numberCode.code);
    }

    @Override
    @Nullable
    public NamespaceValue getNamespaceByNumber(int numberCode) {
        return this.namespaceMap.get(numberCode);
    }

    @Override
    public ResourceBundle getResourceBundle() {
        return this.fResourceBundle;
    }

    private void extractFromResource(ResourceBundle resourceBundle, String ns1Id, String ns2Id, INamespace.NamespaceCode code, ExtractType cmd) {
        NamespaceValue namespace = this.getNamespaceByNumber(code);
        assert (namespace != null) : "undefined namespace code: " + (Object)((Object)code);
        String ns1 = Messages.getString(resourceBundle, ns1Id, null);
        if (ns1 != null) {
            String ns2 = Messages.getString(resourceBundle, ns2Id, null);
            switch (cmd) {
                case REPLACE_TEXTS: {
                    if (ns2 != null) {
                        namespace.setTexts(ns1, ns2);
                    } else {
                        namespace.setTexts(ns1);
                    }
                }
                case APPEND_AS_ALIASES: {
                    namespace.addAlias(ns1);
                    if (ns2 == null) break;
                    namespace.addAlias(ns2);
                }
            }
        }
    }

    protected void extractFromResource(ResourceBundle resource, ExtractType cmd) {
        if (resource == null) {
            return;
        }
        this.extractFromResource(resource, "wiki.api.media1", "wiki.api.media2", INamespace.NamespaceCode.MEDIA_NAMESPACE_KEY, cmd);
        this.extractFromResource(resource, "wiki.api.special1", "wiki.api.special2", INamespace.NamespaceCode.SPECIAL_NAMESPACE_KEY, cmd);
        this.extractFromResource(resource, "wiki.api.talk1", "wiki.api.talk2", INamespace.NamespaceCode.TALK_NAMESPACE_KEY, cmd);
        this.extractFromResource(resource, "wiki.api.user1", "wiki.api.user2", INamespace.NamespaceCode.USER_NAMESPACE_KEY, cmd);
        this.extractFromResource(resource, "wiki.api.usertalk1", "wiki.api.usertalk2", INamespace.NamespaceCode.USER_TALK_NAMESPACE_KEY, cmd);
        this.extractFromResource(resource, "wiki.api.meta1", "wiki.api.meta2", INamespace.NamespaceCode.PROJECT_NAMESPACE_KEY, cmd);
        this.extractFromResource(resource, "wiki.api.metatalk1", "wiki.api.metatalk2", INamespace.NamespaceCode.PROJECT_TALK_NAMESPACE_KEY, cmd);
        this.extractFromResource(resource, "wiki.api.image1", "wiki.api.image2", INamespace.NamespaceCode.FILE_NAMESPACE_KEY, cmd);
        this.extractFromResource(resource, "wiki.api.imagetalk1", "wiki.api.imagetalk2", INamespace.NamespaceCode.FILE_TALK_NAMESPACE_KEY, cmd);
        this.extractFromResource(resource, "wiki.api.mediawiki1", "wiki.api.mediawiki2", INamespace.NamespaceCode.MEDIAWIKI_NAMESPACE_KEY, cmd);
        this.extractFromResource(resource, "wiki.api.mediawikitalk1", "wiki.api.mediawikitalk2", INamespace.NamespaceCode.MEDIAWIKI_TALK_NAMESPACE_KEY, cmd);
        this.extractFromResource(resource, "wiki.api.template1", "wiki.api.template2", INamespace.NamespaceCode.TEMPLATE_NAMESPACE_KEY, cmd);
        this.extractFromResource(resource, "wiki.api.templatetalk1", "wiki.api.templatetalk2", INamespace.NamespaceCode.TEMPLATE_TALK_NAMESPACE_KEY, cmd);
        this.extractFromResource(resource, "wiki.api.help1", "wiki.api.help2", INamespace.NamespaceCode.HELP_NAMESPACE_KEY, cmd);
        this.extractFromResource(resource, "wiki.api.helptalk1", "wiki.api.helptalk2", INamespace.NamespaceCode.HELP_TALK_NAMESPACE_KEY, cmd);
        this.extractFromResource(resource, "wiki.api.category1", "wiki.api.category2", INamespace.NamespaceCode.CATEGORY_NAMESPACE_KEY, cmd);
        this.extractFromResource(resource, "wiki.api.categorytalk1", "wiki.api.categorytalk2", INamespace.NamespaceCode.CATEGORY_TALK_NAMESPACE_KEY, cmd);
        this.extractFromResource(resource, "wiki.api.portal1", "wiki.api.portal2", INamespace.NamespaceCode.PORTAL_NAMESPACE_KEY, cmd);
        this.extractFromResource(resource, "wiki.api.portaltalk1", "wiki.api.portaltalk2", INamespace.NamespaceCode.PORTAL_TALK_NAMESPACE_KEY, cmd);
        this.extractFromResource(resource, "wiki.api.module1", "wiki.api.module2", INamespace.NamespaceCode.MODULE_NAMESPACE_KEY, cmd);
        this.extractFromResource(resource, "wiki.api.moduletalk1", "wiki.api.moduletalk2", INamespace.NamespaceCode.MODULE_TALK_NAMESPACE_KEY, cmd);
    }

    private void initializeNamespaces() {
        this.extractFromResource(this.fResourceBundle, ExtractType.REPLACE_TEXTS);
        this.extractFromResource(this.fResourceBundleEn, ExtractType.APPEND_AS_ALIASES);
        this.PROJECT.addAlias("WP");
        this.PROJECT.addAlias("Project");
        this.PROJECT_TALK.addAlias("WT");
        this.PROJECT_TALK.addAlias("Project_talk");
    }

    @Override
    public NamespaceValue getTalkspace(String namespace) {
        NamespaceValue nsVal = this.getNamespace(namespace);
        if (nsVal != null) {
            return nsVal.getTalkspace();
        }
        return null;
    }

    @Override
    public NamespaceValue getContentspace(String talkNamespace) {
        NamespaceValue nsVal = this.getNamespace(talkNamespace);
        if (nsVal != null) {
            return nsVal.getContentspace();
        }
        return null;
    }

    @Override
    public INamespace.INamespaceValue getMedia() {
        return this.MEDIA;
    }

    @Override
    public INamespace.INamespaceValue getSpecial() {
        return this.SPECIAL;
    }

    @Override
    public INamespace.INamespaceValue getMain() {
        return this.MAIN;
    }

    @Override
    public INamespace.INamespaceValue getTalk() {
        return this.TALK;
    }

    @Override
    public INamespace.INamespaceValue getUser() {
        return this.USER;
    }

    @Override
    public INamespace.INamespaceValue getUser_talk() {
        return this.USER_TALK;
    }

    @Override
    public INamespace.INamespaceValue getProject() {
        return this.PROJECT;
    }

    @Override
    public INamespace.INamespaceValue getProject_talk() {
        return this.PROJECT_TALK;
    }

    @Override
    public INamespace.INamespaceValue getImage() {
        return this.IMAGE;
    }

    @Override
    public INamespace.INamespaceValue getImage_talk() {
        return this.IMAGE_TALK;
    }

    @Override
    public INamespace.INamespaceValue getMediaWiki() {
        return this.MEDIAWIKI;
    }

    @Override
    public INamespace.INamespaceValue getMediaWiki_talk() {
        return this.MEDIAWIKI_TALK;
    }

    @Override
    public INamespace.INamespaceValue getModule() {
        return this.MODULE;
    }

    @Override
    public INamespace.INamespaceValue getTemplate() {
        return this.TEMPLATE;
    }

    @Override
    public INamespace.INamespaceValue getTemplate_talk() {
        return this.TEMPLATE_TALK;
    }

    @Override
    public INamespace.INamespaceValue getHelp() {
        return this.HELP;
    }

    @Override
    public INamespace.INamespaceValue getHelp_talk() {
        return this.HELP_TALK;
    }

    @Override
    public INamespace.INamespaceValue getCategory() {
        return this.CATEGORY;
    }

    @Override
    public INamespace.INamespaceValue getCategory_talk() {
        return this.CATEGORY_TALK;
    }

    @Override
    public INamespace.INamespaceValue getPortal() {
        return this.PORTAL;
    }

    @Override
    public INamespace.INamespaceValue getPortal_talk() {
        return this.PORTAL_TALK;
    }

    @Override
    public String[] splitNsTitle(String fullTitle) {
        return this.splitNsTitle(fullTitle, true, ' ', true);
    }

    @Override
    public String[] splitNsTitle(String fullTitle, boolean underScoreIsWhitespace, char whiteSpaceChar, boolean firstCharacterAsUpperCase) {
        String maybeNs;
        int colonIndex = fullTitle.indexOf(58);
        if (colonIndex != -1 && this.getNamespace(maybeNs = Encoder.normaliseTitle(fullTitle.substring(0, colonIndex), underScoreIsWhitespace, whiteSpaceChar, firstCharacterAsUpperCase)) != null) {
            return new String[]{maybeNs, Encoder.normaliseTitle(fullTitle.substring(colonIndex + 1), underScoreIsWhitespace, whiteSpaceChar, firstCharacterAsUpperCase)};
        }
        return new String[]{"", Encoder.normaliseTitle(fullTitle, underScoreIsWhitespace, whiteSpaceChar, firstCharacterAsUpperCase)};
    }

    public class NamespaceValue
    implements INamespace.INamespaceValue {
        private final INamespace.NamespaceCode code;
        private final String[] canonicalAliases;
        private List<String> texts;
        private NamespaceValue talkspace;
        private NamespaceValue contentspace;

        private NamespaceValue(INamespace.NamespaceCode code, String ... aliases) {
            this.code = code;
            this.texts = new ArrayList<String>(2);
            Namespace.this.namespaceMap.put(code.code, this);
            this.talkspace = this;
            this.canonicalAliases = aliases;
            this.setTexts(aliases);
        }

        private NamespaceValue(INamespace.NamespaceCode code, NamespaceValue talkspace, String ... aliases) {
            this(code, aliases);
            if (talkspace != null) {
                assert (talkspace.contentspace == null);
                this.talkspace = talkspace;
                this.talkspace.contentspace = this;
            }
            this.contentspace = this;
        }

        @Override
        public INamespace.NamespaceCode getCode() {
            return this.code;
        }

        @Override
        public void setTexts(String ... aliases) {
            assert (aliases.length >= 1);
            for (String text : this.texts) {
                Namespace.this.TEXT_TO_NAMESPACE_MAP.remove(text);
                Namespace.this.TEXT_TO_NAMESPACE_MAP.remove(text.replace(' ', '_'));
                Namespace.this.TEXT_TO_NAMESPACE_MAP.remove(text.replace('_', ' '));
            }
            this.texts = new ArrayList<String>(aliases.length);
            for (String alias : aliases) {
                assert (alias != null);
                this.addAlias(alias);
            }
        }

        @Override
        public void addAlias(String alias) {
            if (!Namespace.this.TEXT_TO_NAMESPACE_MAP.containsKey(alias)) {
                this.texts.add(alias);
                Namespace.this.TEXT_TO_NAMESPACE_MAP.put(alias, this);
                Namespace.this.TEXT_TO_NAMESPACE_MAP.put(alias.replace(' ', '_'), this);
                Namespace.this.TEXT_TO_NAMESPACE_MAP.put(alias.replace('_', ' '), this);
            }
        }

        @Override
        public String getPrimaryText() {
            return this.texts.isEmpty() ? null : this.texts.get(0);
        }

        @Override
        public String getCanonicalName() {
            return this.canonicalAliases[0];
        }

        @Override
        public List<String> getTexts() {
            return this.texts;
        }

        @Override
        public NamespaceValue getTalkspace() {
            return this.talkspace;
        }

        @Override
        public NamespaceValue getContentspace() {
            return this.contentspace;
        }

        @Override
        public NamespaceValue getAssociatedspace() {
            if (this.isSubject()) {
                return this.getTalkspace();
            }
            if (this.isTalk()) {
                return this.getContentspace();
            }
            return null;
        }

        @Override
        public String makeFullPagename(String pageName) {
            String primaryText = this.getPrimaryText();
            if (primaryText.isEmpty()) {
                return pageName;
            }
            return primaryText + ":" + pageName;
        }

        @Override
        public boolean isType(INamespace.NamespaceCode code) {
            return this.code == code;
        }

        @Override
        public boolean hasSubpages() {
            return this.code.hasSubpages();
        }

        @Override
        public boolean hasGenderDistinction() {
            return this.code == INamespace.NamespaceCode.USER_NAMESPACE_KEY || this.code == INamespace.NamespaceCode.USER_TALK_NAMESPACE_KEY;
        }

        @Override
        public boolean isCapitalized() {
            return true;
        }

        @Override
        public boolean isContent() {
            return this.code == INamespace.NamespaceCode.MAIN_NAMESPACE_KEY;
        }

        @Override
        public boolean isIncludable() {
            return true;
        }

        @Override
        public boolean isMovable() {
            return false;
        }

        @Override
        public boolean isSubject() {
            return this.talkspace != this;
        }

        @Override
        public boolean isTalk() {
            return this.talkspace == this;
        }

        public String toString() {
            return this.getPrimaryText();
        }
    }

    protected static enum ExtractType {
        REPLACE_TEXTS,
        APPEND_AS_ALIASES;

    }
}

