/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.api;

import info.bliki.api.AbstractXMLParser;
import info.bliki.api.Link;
import info.bliki.api.Page;
import info.bliki.api.PageInfo;
import info.bliki.api.Revision;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLPagesParser
extends AbstractXMLParser {
    private static final String REV_ID = "rev";
    private static final String CATEGORY_ID = "cl";
    private static final String URL_ID = "url";
    private static final String THUMB_URL_ID = "thumburl";
    private static final String ANON_ID = "anon";
    private static final String PL_ID = "pl";
    private static final String TIMESTAMP_ID = "timestamp";
    private static final String IMAGEINFO_ID = "imageinfo";
    private static final String II_ID = "ii";
    private static final String EDIT_TOKEN_ID = "edittoken";
    private static final String WARNINGS = "warnings";
    private static final String PAGE_MISSING_ATTRIBUTE = "missing";
    private static final String PAGE_INVALID_ATTRIBUTE = "invalid";
    private Page fPage;
    private Revision fRevision;
    private List<Page> pagesList = new ArrayList<Page>();
    private List<String> warnings;
    private boolean isParsingWarnings;

    public XMLPagesParser(String xmlText) throws SAXException {
        super(xmlText);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        this.fAttributes = atts;
        if ("page".equals(qName) || "p".equals(qName)) {
            this.fPage = new Page();
            this.fPage.setPageid(this.fAttributes.getValue("pageid"));
            this.fPage.setNs(this.fAttributes.getValue("ns"));
            this.fPage.setTitle(this.fAttributes.getValue("title"));
            this.fPage.setEditToken(this.fAttributes.getValue(EDIT_TOKEN_ID));
            this.fPage.setMissing(this.fAttributes.getValue(PAGE_MISSING_ATTRIBUTE) != null);
            this.fPage.setInvalid(this.fAttributes.getValue(PAGE_INVALID_ATTRIBUTE) != null);
        } else if (REV_ID.equals(qName)) {
            this.fRevision = new Revision();
            this.fRevision.setAnon(this.fAttributes.getValue(ANON_ID));
            this.fRevision.setTimestamp(this.fAttributes.getValue(TIMESTAMP_ID));
            this.fPage.setCurrentRevision(this.fRevision);
        } else if (CATEGORY_ID.equals(qName)) {
            if (this.fPage != null) {
                PageInfo cat = new PageInfo();
                cat.setNs(this.fAttributes.getValue("ns"));
                cat.setTitle(this.fAttributes.getValue("title"));
                this.fPage.addCategory(cat);
            }
        } else if (PL_ID.equals(qName)) {
            if (this.fPage != null) {
                Link link = new Link();
                link.setNs(this.fAttributes.getValue("ns"));
                link.setTitle(this.fAttributes.getValue("title"));
                this.fPage.addLink(link);
            }
        } else if (II_ID.equals(qName)) {
            if (this.fPage != null) {
                this.fPage.setImageUrl(this.fAttributes.getValue(URL_ID));
                this.fPage.setImageThumbUrl(this.fAttributes.getValue(THUMB_URL_ID));
            }
        } else if (WARNINGS.equals(qName)) {
            this.warnings = new ArrayList<String>();
            this.isParsingWarnings = true;
        }
        this.fData = null;
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        try {
            String warning;
            if (REV_ID.equals(qName)) {
                if (this.fRevision != null) {
                    this.fRevision.setContent(this.getString());
                }
            } else if ("page".equals(qName) || "p".equals(qName)) {
                if (this.fPage != null) {
                    this.pagesList.add(this.fPage);
                }
            } else if (WARNINGS.equals(qName)) {
                this.isParsingWarnings = false;
            } else if (this.isParsingWarnings && (warning = this.getString()) != null) {
                this.warnings.add(warning);
            }
            this.fData = null;
            this.fAttributes = null;
        }
        catch (RuntimeException re) {
            re.printStackTrace();
        }
    }

    public List<Page> getPagesList() {
        return this.pagesList;
    }

    public List<String> getWarnings() {
        if (this.warnings == null) {
            return Collections.emptyList();
        }
        return this.warnings;
    }
}

