/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.data.LatLon;
import net.osmand.router.HHRouteDataStructure;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;

public class HHRoutingDB {
    public static final String EXT = ".hhdb";
    public static final String CEXT = ".chdb";
    protected static final int XY_SHORTCUT_GEOM = 0;
    protected final Connection conn;
    protected final File file;
    protected PreparedStatement loadGeometry;
    protected PreparedStatement loadSegmentEnd;
    protected PreparedStatement loadSegmentStart;
    protected final int BATCH_SIZE = 10000;
    protected int batchInsPoint = 0;
    protected String routingProfile = "";
    protected TIntObjectHashMap<String> routingProfiles = new TIntObjectHashMap();
    protected boolean compactDB;
    protected static Comparator<HHRouteDataStructure.NetworkDBPoint> indexComparator = new Comparator<HHRouteDataStructure.NetworkDBPoint>(){

        @Override
        public int compare(HHRouteDataStructure.NetworkDBPoint o1, HHRouteDataStructure.NetworkDBPoint o2) {
            return Integer.compare(o1.index, o2.index);
        }
    };

    public HHRoutingDB(File f, Connection conn) throws SQLException {
        this.conn = conn;
        this.file = f;
        Statement st = conn.createStatement();
        this.compactDB = this.checkColumnExist(st, "ins", "segments");
        st.execute("CREATE TABLE IF NOT EXISTS profiles(profile, id, params)");
        if (!this.compactDB) {
            st.execute("CREATE TABLE IF NOT EXISTS points(idPoint, pointGeoUniDir, pointGeoId, clusterId, fileDbId, dualIdPoint, dualClusterId, chInd, roadId, start, end, sx31, sy31, ex31, ey31, tagValues, PRIMARY KEY(idPoint))");
            st.execute("CREATE UNIQUE INDEX IF NOT EXISTS pointsUnique on points(pointGeoId)");
            st.execute("CREATE TABLE IF NOT EXISTS segments(idPoint, idConnPoint, dist, shortcut, profile)");
            st.execute("CREATE UNIQUE INDEX IF NOT EXISTS segmentsUnique on segments(idPoint, idConnPoint, profile)");
            st.execute("CREATE INDEX IF NOT EXISTS segmentsPntInd on segments(idPoint, profile)");
            st.execute("CREATE INDEX IF NOT EXISTS segmentsConnPntInd on segments(idConnPoint, profile)");
            st.execute("CREATE TABLE IF NOT EXISTS geometry(idPoint, idConnPoint, geometry, shortcut, profile)");
            st.execute("CREATE UNIQUE INDEX IF NOT EXISTS geometryMainInd on geometry(idPoint,idConnPoint,shortcut, profile)");
            st.execute("CREATE TABLE IF NOT EXISTS midpoints(ind, maxMidDepth, proc, PRIMARY key (ind))");
            this.loadGeometry = conn.prepareStatement("SELECT geometry, shortcut FROM geometry WHERE idPoint = ? AND idConnPoint = ? AND profile = ?");
            this.loadSegmentEnd = conn.prepareStatement("SELECT idPoint, idConnPoint, dist, shortcut from segments where idPoint = ? AND profile = ?");
            this.loadSegmentStart = conn.prepareStatement("SELECT idPoint, idConnPoint, dist, shortcut from segments where idConnPoint = ? AND profile = ?");
        } else {
            this.loadSegmentStart = conn.prepareStatement("SELECT id, ins, outs from segments where id = ? and profile = ? ");
        }
        ResultSet rs = st.executeQuery("SELECT profile, id, params from profiles");
        while (rs.next()) {
            this.routingProfile = rs.getString(1);
            this.routingProfiles.put(rs.getInt(2), (Object)rs.getString(3));
        }
        st.close();
    }

    public String getRoutingProfile() {
        return this.routingProfile;
    }

    public File getFile() {
        return this.file;
    }

    public TIntObjectHashMap<String> getRoutingProfiles() {
        return this.routingProfiles;
    }

    public int insertRoutingProfile(String routingProfile, String profileParams) throws SQLException {
        TIntObjectIterator it = this.routingProfiles.iterator();
        while (it.hasNext()) {
            it.advance();
            String p = (String)it.value();
            if (!p.equals(profileParams)) continue;
            return it.key();
        }
        Statement s = this.conn.createStatement();
        int id = this.routingProfiles.size();
        this.routingProfiles.put(id, (Object)profileParams);
        s.execute(String.format("INSERT INTO profiles(profile, id, params) VALUES('%s', %d, '%s')", routingProfile, id, profileParams));
        return id;
    }

    private boolean checkColumnExist(Statement st, String col, String table) throws SQLException {
        try {
            return st.execute("SELECT " + col + " FROM " + table + " limit 1 ");
        }
        catch (SQLException e) {
            return false;
        }
    }

    public <T extends HHRouteDataStructure.NetworkDBPoint> TLongObjectHashMap<T> loadNetworkPoints(short mapId, Class<T> cl) throws SQLException {
        Statement st = this.conn.createStatement();
        ResultSet rs = st.executeQuery("SELECT dualIdPoint, idPoint, clusterId, chInd, roadId, start, end, sx31, sy31, ex31, ey31, tagValues  from points");
        TLongObjectHashMap mp = new TLongObjectHashMap();
        while (rs.next()) {
            HHRouteDataStructure.NetworkDBPoint pnt;
            try {
                pnt = (HHRouteDataStructure.NetworkDBPoint)cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            int p = 1;
            int dualIdPoint = rs.getInt(p++);
            if (dualIdPoint == 0) continue;
            pnt.mapId = mapId;
            pnt.index = rs.getInt(p++);
            pnt.clusterId = rs.getInt(p++);
            int chInd = rs.getInt(p++);
            if (pnt instanceof HHRouteDataStructure.NetworkDBPointCh) {
                ((HHRouteDataStructure.NetworkDBPointCh)pnt).chInd = chInd;
            }
            pnt.roadId = rs.getLong(p++);
            pnt.start = rs.getShort(p++);
            pnt.end = rs.getShort(p++);
            pnt.startX = rs.getInt(p++);
            pnt.startY = rs.getInt(p++);
            pnt.endX = rs.getInt(p++);
            pnt.endY = rs.getInt(p++);
            String tagValues = null;
            if (this.compactDB) {
                byte[] bytes;
                if ((bytes = rs.getBytes(p++)) != null) {
                    tagValues = Algorithms.gzipToString(bytes);
                }
            } else {
                tagValues = rs.getString(p++);
            }
            Object[] arr = Algorithms.deserializeStringArray(tagValues);
            if (arr != null && arr.length > 0) {
                if (arr.length % 2 == 1) {
                    throw new IllegalArgumentException(String.format("Illegal tag/values %s - %s ", pnt, Arrays.toString(arr)));
                }
                pnt.tagValues = new ArrayList<BinaryMapIndexReader.TagValuePair>();
                for (int i = 0; i < arr.length; i += 2) {
                    pnt.tagValues.add(new BinaryMapIndexReader.TagValuePair((String)arr[i], (String)arr[i + 1], -1));
                }
            }
            mp.put((long)pnt.index, (Object)pnt);
            if (!mp.contains((long)dualIdPoint)) continue;
            pnt.dualPoint = (HHRouteDataStructure.NetworkDBPoint)mp.get((long)dualIdPoint);
            pnt.dualPoint.dualPoint = pnt;
        }
        rs.close();
        st.close();
        return mp;
    }

    public boolean loadGeometry(HHRouteDataStructure.NetworkDBSegment segment, int profile, boolean reload) throws SQLException {
        List<LatLon> geometry = segment.getGeometry();
        geometry.clear();
        geometry.addAll(this.parseGeometry(segment.start.index, segment.end.index, profile, segment.shortcut));
        return !geometry.isEmpty();
    }

    public void loadSegmentPointInternal(int id, int profile, byte[][] res) throws SQLException {
        this.loadSegmentStart.setInt(1, id);
        this.loadSegmentStart.setInt(2, profile);
        ResultSet rs = this.loadSegmentStart.executeQuery();
        if (rs.next()) {
            byte[] ins = rs.getBytes(2);
            res[0] = ins;
            byte[] outs = rs.getBytes(3);
            res[1] = outs;
        }
        rs.close();
    }

    public synchronized void loadSegmentPointInternalSync(int id, int profile, byte[][] res) throws SQLException {
        this.loadSegmentStart.setInt(1, id);
        this.loadSegmentStart.setInt(2, profile);
        ResultSet rs = this.loadSegmentStart.executeQuery();
        if (rs.next()) {
            byte[] ins = rs.getBytes(2);
            res[0] = ins;
            byte[] outs = rs.getBytes(3);
            res[1] = outs;
        }
        rs.close();
    }

    public <T extends HHRouteDataStructure.NetworkDBPoint> int loadNetworkSegmentPoint(HHRouteDataStructure.HHRoutingContext<T> ctx, HHRouteDataStructure.HHRouteRegionPointsCtx<T> reg, T point, boolean reverse) throws SQLException {
        if (point.connected(reverse) != null) {
            return 0;
        }
        int loadedSegs = 0;
        if (this.compactDB) {
            this.loadSegmentStart.setInt(1, point.index);
            this.loadSegmentStart.setInt(2, reg.routingProfile);
            ResultSet rs = this.loadSegmentStart.executeQuery();
            if (rs.next()) {
                HHRouteDataStructure.setSegments(ctx, point, rs.getBytes(2), rs.getBytes(3));
                return point.connected(true).size() + point.connected(false).size();
            }
            point.connectedSet(true, new ArrayList<HHRouteDataStructure.NetworkDBSegment>());
            point.connectedSet(false, new ArrayList<HHRouteDataStructure.NetworkDBSegment>());
            return 0;
        }
        ArrayList<HHRouteDataStructure.NetworkDBSegment> l = new ArrayList<HHRouteDataStructure.NetworkDBSegment>();
        PreparedStatement pre = reverse ? this.loadSegmentStart : this.loadSegmentEnd;
        pre.setInt(1, point.index);
        pre.setInt(2, reg.routingProfile);
        ResultSet rs = pre.executeQuery();
        while (rs.next()) {
            ++loadedSegs;
            HHRouteDataStructure.NetworkDBPoint start = (HHRouteDataStructure.NetworkDBPoint)ctx.pointsById.get(rs.getLong(1));
            HHRouteDataStructure.NetworkDBPoint end = (HHRouteDataStructure.NetworkDBPoint)ctx.pointsById.get(rs.getLong(2));
            double dist = rs.getDouble(3);
            boolean shortcut = rs.getInt(4) > 0;
            HHRouteDataStructure.NetworkDBSegment rev = new HHRouteDataStructure.NetworkDBSegment(start, end, dist, !reverse, shortcut);
            l.add(rev);
        }
        point.connectedSet(reverse, l);
        rs.close();
        return loadedSegs;
    }

    public int loadNetworkSegments(Collection<? extends HHRouteDataStructure.NetworkDBPoint> points, int routingProfile) throws SQLException {
        return this.loadNetworkSegmentsInternal(points, routingProfile, false);
    }

    public int loadNetworkSegmentsInternal(Collection<? extends HHRouteDataStructure.NetworkDBPoint> points, int routingProfile, boolean excludeShortcuts) throws SQLException {
        TLongObjectHashMap pntsById = new TLongObjectHashMap();
        for (HHRouteDataStructure.NetworkDBPoint networkDBPoint : points) {
            pntsById.put((long)networkDBPoint.index, (Object)networkDBPoint);
        }
        Statement st = this.conn.createStatement();
        ResultSet resultSet = st.executeQuery("SELECT idPoint, idConnPoint, dist, shortcut from segments where profile = " + routingProfile);
        int x = 0;
        while (resultSet.next()) {
            boolean shortcut;
            boolean bl = shortcut = resultSet.getInt(4) > 0;
            if (excludeShortcuts && shortcut) continue;
            ++x;
            HHRouteDataStructure.NetworkDBPoint start = (HHRouteDataStructure.NetworkDBPoint)pntsById.get(resultSet.getLong(1));
            HHRouteDataStructure.NetworkDBPoint end = (HHRouteDataStructure.NetworkDBPoint)pntsById.get(resultSet.getLong(2));
            double dist = resultSet.getDouble(3);
            HHRouteDataStructure.NetworkDBSegment segment = new HHRouteDataStructure.NetworkDBSegment(start, end, dist, true, shortcut);
            HHRouteDataStructure.NetworkDBSegment rev = new HHRouteDataStructure.NetworkDBSegment(start, end, dist, false, shortcut);
            start.connected.add(segment);
            end.connectedReverse.add(rev);
        }
        resultSet.close();
        st.close();
        return x;
    }

    private List<LatLon> parseGeometry(int start, int end, int profile, boolean shortcut) throws SQLException {
        ArrayList<LatLon> l = new ArrayList<LatLon>();
        this.loadGeometry.setLong(1, start);
        this.loadGeometry.setLong(2, end);
        this.loadGeometry.setInt(3, profile);
        short shortcutN = shortcut ? (short)1 : 0;
        ResultSet rs = this.loadGeometry.executeQuery();
        while (rs.next()) {
            int k;
            if (shortcutN != rs.getShort(2)) continue;
            byte[] geom = rs.getBytes(1);
            if (geom.length > 8 && Algorithms.parseIntFromBytes(geom, 0) == 0 && Algorithms.parseIntFromBytes(geom, 4) == 0) {
                for (k = 8; k < geom.length; k += 8) {
                    int st = Algorithms.parseIntFromBytes(geom, k);
                    int en = Algorithms.parseIntFromBytes(geom, k + 4);
                    List<LatLon> gg = this.parseGeometry(st, en, profile, false);
                    l.addAll(gg);
                }
                continue;
            }
            for (k = 0; k < geom.length; k += 8) {
                int x = Algorithms.parseIntFromBytes(geom, k);
                int y = Algorithms.parseIntFromBytes(geom, k + 4);
                l.add(new LatLon(MapUtils.get31LatitudeY(y), MapUtils.get31LongitudeX(x)));
            }
        }
        if (l.isEmpty()) {
            System.err.printf("Empty route geometry %d -> %d  %s\n", start, end, shortcut ? "sh" : "bs");
        }
        return l;
    }

    public void close() throws SQLException {
        this.conn.close();
    }
}

