/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.search.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.osmand.CollatorStringMatcher;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.data.Amenity;
import net.osmand.data.City;
import net.osmand.data.LatLon;
import net.osmand.data.Street;
import net.osmand.osm.AbstractPoiType;
import net.osmand.osm.PoiCategory;
import net.osmand.osm.PoiFilter;
import net.osmand.osm.PoiType;
import net.osmand.search.core.ObjectType;
import net.osmand.search.core.SearchPhrase;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;

public class SearchResult {
    public static final String DELIMITER = " ";
    private static final String HYPHEN = "-";
    static final int NEAREST_METERS_LIMIT = 30000;
    public static final double MAX_TYPES_BASE_10 = 10.0;
    public static final double MAX_PHRASE_WEIGHT_TOTAL = 100.0;
    private static final int MIN_ELO_RATING = 1800;
    private static final int MAX_ELO_RATING = 4300;
    public SearchPhrase requiredSearchPhrase;
    public SearchResult parentSearchResult;
    String wordsSpan;
    boolean firstUnknownWordMatches;
    Collection<String> otherWordsMatch = null;
    public Object object;
    public ObjectType objectType;
    public BinaryMapIndexReader file;
    public double priority;
    public double priorityDistance;
    public LatLon location;
    public int preferredZoom = 15;
    public String localeName;
    public String alternateName;
    public String addressName;
    public String cityName;
    public Collection<String> otherNames;
    public String localeRelatedObjectName;
    public Object relatedObject;
    public double distRelatedObjectName;
    private boolean impreciseCoordinates;
    private double unknownPhraseMatchWeight = 0.0;
    private CheckWordsMatchCount completeMatchRes = null;
    private SearchResultResource searchResultResource;

    public SearchResult() {
        this.requiredSearchPhrase = SearchPhrase.emptyPhrase();
    }

    public SearchResult(SearchPhrase sp) {
        this.requiredSearchPhrase = sp;
    }

    public boolean hasImpreciseCoordinates() {
        return this.impreciseCoordinates;
    }

    public void setImpreciseCoordinates(boolean imprecise) {
        this.impreciseCoordinates = imprecise;
    }

    public double getUnknownPhraseMatchWeight() {
        if (this.unknownPhraseMatchWeight != 0.0) {
            return this.unknownPhraseMatchWeight;
        }
        this.unknownPhraseMatchWeight = this.getSumPhraseMatchWeight(null);
        return this.unknownPhraseMatchWeight;
    }

    public CheckWordsMatchCount getCompleteMatchRes() {
        if (this.completeMatchRes != null) {
            return this.completeMatchRes;
        }
        this.getSumPhraseMatchWeight(null);
        return this.completeMatchRes;
    }

    private double getSumPhraseMatchWeight(SearchResult exactResult) {
        double res = ObjectType.getTypeWeight(this.objectType);
        this.completeMatchRes = new CheckWordsMatchCount();
        if (this.requiredSearchPhrase.getUnselectedPoiType() == null && this.objectType != ObjectType.POI_TYPE) {
            Amenity a;
            int elo;
            Object bbox31;
            Object s;
            Object object;
            boolean matched;
            boolean bl = matched = this.localeName != null && this.allWordsMatched(this.localeName, exactResult, this.completeMatchRes);
            if (!matched && this.alternateName != null && !Algorithms.objectEquals(this.cityName, this.alternateName)) {
                matched = this.allWordsMatched(this.alternateName, exactResult, this.completeMatchRes);
            }
            if (!matched && this.otherNames != null) {
                for (String otherName : this.otherNames) {
                    if (!this.allWordsMatched(otherName, exactResult, this.completeMatchRes)) continue;
                    matched = true;
                    break;
                }
            }
            City selectedCity = null;
            if (exactResult != null && (object = exactResult.object) instanceof Street) {
                Street s2 = (Street)object;
                selectedCity = s2.getCity();
            } else if (exactResult != null && exactResult.parentSearchResult != null && (object = exactResult.parentSearchResult.object) instanceof Street) {
                s = (Street)object;
                selectedCity = ((Street)s).getCity();
            }
            if (matched && selectedCity != null && (s = this.object) instanceof City) {
                City c = (City)s;
                if (!Algorithms.objectEquals(selectedCity.getName(), c.getName())) {
                    matched = false;
                    bbox31 = selectedCity.getBbox31();
                    LatLon latlon = selectedCity.getLocation();
                    if (bbox31 != null) {
                        double lon = MapUtils.get31LongitudeX((int)(bbox31[0] / 2 + bbox31[2] / 2));
                        double lat = MapUtils.get31LatitudeY((int)(bbox31[1] / 2 + bbox31[3] / 2));
                        latlon = new LatLon(lat, lon);
                    }
                    res += 100.0 / Math.max(100.0, MapUtils.getDistance(this.location, latlon));
                }
            }
            if (matched) {
                res = this.getPhraseWeightForCompleteMatch(exactResult, this.completeMatchRes);
            }
            if ((bbox31 = this.object) instanceof Amenity && (elo = (a = (Amenity)bbox31).getTravelEloNumber()) > 1800) {
                double rat = ((double)elo - 1800.0) / 2500.0;
                res += rat * 100.0 * 2.0 / 3.0;
            }
        }
        if (this.parentSearchResult != null) {
            res += this.parentSearchResult.getSumPhraseMatchWeight(exactResult == null ? this : exactResult) / 100.0;
        }
        return res;
    }

    private double getPhraseWeightForCompleteMatch(SearchResult exactResult, CheckWordsMatchCount completeMatchRes) {
        double dist;
        double res = (double)ObjectType.getTypeWeight(this.objectType) * 10.0;
        boolean closeDistance = false;
        if (this.requiredSearchPhrase.getLastTokenLocation() != null && this.location != null && (dist = MapUtils.getDistance(this.requiredSearchPhrase.getLastTokenLocation(), this.location)) <= 30000.0) {
            int coef = (int)((30000.0 - dist) / 30000.0 * 15.0);
            res = (double)ObjectType.getTypeWeight(this.objectType) + 40.0 + (double)coef;
            closeDistance = true;
        }
        if (completeMatchRes.allWordsEqual && (this.objectType != ObjectType.POI || closeDistance)) {
            res = (double)ObjectType.getTypeWeight(this.objectType) * 10.0 + 50.0;
        }
        return res;
    }

    public int getDepth() {
        if (this.parentSearchResult != null) {
            return 1 + this.parentSearchResult.getDepth();
        }
        return 1;
    }

    public int getFoundWordCount() {
        int inc = this.getSelfWordCount();
        if (this.parentSearchResult != null) {
            inc += this.parentSearchResult.getFoundWordCount();
        }
        return inc;
    }

    private boolean allWordsMatched(String name, SearchResult exactResult, CheckWordsMatchCount cnt) {
        int i;
        List<String> searchPhraseNames = this.getSearchPhraseNames();
        if (!Algorithms.isEmpty(name = CollatorStringMatcher.alignChars(name)) && name.indexOf(40) != -1) {
            name = SearchPhrase.stripBraces(name);
        }
        List<String> localResultNames = !this.requiredSearchPhrase.getFullSearchPhrase().contains(HYPHEN) ? SearchPhrase.splitWords(name, new ArrayList<String>(), "\\s|,|-") : SearchPhrase.splitWords(name, new ArrayList<String>(), "\\s|,");
        if (searchPhraseNames.isEmpty()) {
            return false;
        }
        while (exactResult != null && exactResult != this) {
            List<String> lst = exactResult.getSearchPhraseNames();
            for (String l : lst) {
                i = searchPhraseNames.indexOf(l);
                if (i == -1) continue;
                searchPhraseNames.remove(i);
            }
            exactResult = exactResult.parentSearchResult;
        }
        int idxMatchedWord = -1;
        for (String searchPhraseName : searchPhraseNames) {
            boolean wordMatched = false;
            for (i = idxMatchedWord + 1; i < localResultNames.size(); ++i) {
                int r = this.requiredSearchPhrase.getCollator().compare(searchPhraseName, localResultNames.get(i));
                if (r != 0) continue;
                wordMatched = true;
                idxMatchedWord = i;
                break;
            }
            if (wordMatched) continue;
            return false;
        }
        if (searchPhraseNames.size() == localResultNames.size()) {
            cnt.allWordsEqual = true;
        }
        cnt.allWordsInPhraseAreInResult = true;
        return true;
    }

    private List<String> getSearchPhraseNames() {
        ArrayList<String> searchPhraseNames = new ArrayList<String>();
        String fw = this.requiredSearchPhrase.getFirstUnknownSearchWord();
        List<String> ow = this.requiredSearchPhrase.getUnknownSearchWords();
        if (fw != null && fw.length() > 0) {
            searchPhraseNames.add(CollatorStringMatcher.alignChars(fw));
        }
        if (ow != null) {
            for (String o : ow) {
                searchPhraseNames.add(CollatorStringMatcher.alignChars(o));
            }
        }
        if (this.parentSearchResult != null && this.requiredSearchPhrase == this.parentSearchResult.requiredSearchPhrase && this.parentSearchResult.getOtherWordsMatch() != null) {
            for (String s : this.parentSearchResult.getOtherWordsMatch()) {
                int i = searchPhraseNames.indexOf(CollatorStringMatcher.alignChars(s));
                if (i == -1) continue;
                searchPhraseNames.remove(i);
            }
        }
        return searchPhraseNames;
    }

    private int getSelfWordCount() {
        int inc = 0;
        if (this.firstUnknownWordMatches) {
            inc = 1;
        }
        if (this.otherWordsMatch != null) {
            inc += this.otherWordsMatch.size();
        }
        return inc;
    }

    public double getSearchDistance(LatLon location) {
        double distance = 0.0;
        if (location != null && this.location != null) {
            distance = MapUtils.getDistance(location, this.location);
        }
        return this.priority - 1.0 / (1.0 + this.priorityDistance * distance);
    }

    public double getSearchDistance(LatLon location, double pd) {
        double distance = 0.0;
        if (location != null && this.location != null) {
            distance = MapUtils.getDistance(location, this.location);
        }
        return this.priority - 1.0 / (1.0 + pd * distance);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (!Algorithms.isEmpty(this.localeName)) {
            b.append(this.localeName);
        }
        if (!Algorithms.isEmpty(this.localeRelatedObjectName)) {
            Street street;
            City city;
            if (b.length() > 0) {
                b.append(", ");
            }
            b.append(this.localeRelatedObjectName);
            if (this.relatedObject instanceof Street && (city = (street = (Street)this.relatedObject).getCity()) != null) {
                b.append(", ").append(city.getName(this.requiredSearchPhrase.getSettings().getLang(), this.requiredSearchPhrase.getSettings().isTransliterate()));
            }
        } else if (this.object instanceof AbstractPoiType) {
            AbstractPoiType poiType;
            if (b.length() > 0) {
                b.append(DELIMITER);
            }
            if ((poiType = (AbstractPoiType)this.object) instanceof PoiCategory) {
                b.append("(Category)");
            } else if (poiType instanceof PoiFilter) {
                b.append("(Filter)");
            } else if (poiType instanceof PoiType) {
                PoiType p = (PoiType)poiType;
                AbstractPoiType parentType = p.getParentType();
                if (parentType != null) {
                    String translation = parentType.getTranslation();
                    b.append("(").append(translation);
                    if (parentType instanceof PoiCategory) {
                        b.append(" / Category)");
                    } else if (parentType instanceof PoiFilter) {
                        b.append(" / Filter)");
                    } else if (parentType instanceof PoiType) {
                        PoiType pp = (PoiType)poiType;
                        PoiFilter filter = pp.getFilter();
                        PoiCategory category = pp.getCategory();
                        if (filter != null && !filter.getTranslation().equals(translation)) {
                            b.append(" / ").append(filter.getTranslation()).append(")");
                        } else if (category != null && !category.getTranslation().equals(translation)) {
                            b.append(" / ").append(category.getTranslation()).append(")");
                        } else {
                            b.append(")");
                        }
                    }
                } else if (p.getFilter() != null) {
                    b.append("(").append(p.getFilter().getTranslation()).append(")");
                } else if (p.getCategory() != null) {
                    b.append("(").append(p.getCategory().getTranslation()).append(")");
                }
            }
        }
        return b.toString();
    }

    public SearchResultResource getResourceType() {
        if (this.searchResultResource == null) {
            Object object;
            this.searchResultResource = SearchResultResource.DETAILED;
            if (this.object != null && (object = this.object) instanceof Amenity) {
                Amenity amenity = (Amenity)object;
                SearchResultResource searchResultResource = this.searchResultResource = amenity.getType().isWiki() ? SearchResultResource.WIKIPEDIA : this.searchResultResource;
            }
            if (this.file != null) {
                this.searchResultResource = this.file.getFile().getName().contains(".travel") ? SearchResultResource.TRAVEL : this.searchResultResource;
                this.searchResultResource = this.file.isBasemap() ? SearchResultResource.BASEMAP : this.searchResultResource;
            }
        }
        return this.searchResultResource;
    }

    public Collection<String> getOtherWordsMatch() {
        return this.otherWordsMatch;
    }

    public void setOtherWordsMatch(Collection<String> set) {
        this.otherWordsMatch = set;
    }

    public void setUnknownPhraseMatchWeight(double weight) {
        this.unknownPhraseMatchWeight = weight;
    }

    public boolean isFullPhraseEqualLocaleName() {
        return this.requiredSearchPhrase.getFullSearchPhrase().equalsIgnoreCase(this.localeName);
    }

    public List<String> filterUnknownSearchWord(List<String> leftUnknownSearchWords) {
        if (leftUnknownSearchWords == null) {
            leftUnknownSearchWords = new ArrayList<String>(this.requiredSearchPhrase.getUnknownSearchWords());
            leftUnknownSearchWords.add(0, this.requiredSearchPhrase.getFirstUnknownSearchWord());
        }
        if (this.firstUnknownWordMatches) {
            leftUnknownSearchWords.remove(this.requiredSearchPhrase.getFirstUnknownSearchWord());
        }
        if (this.otherWordsMatch != null) {
            for (String otherWord : this.otherWordsMatch) {
                int ind = this.firstUnknownWordMatches ? leftUnknownSearchWords.indexOf(otherWord) : leftUnknownSearchWords.lastIndexOf(otherWord);
                if (ind == -1) continue;
                leftUnknownSearchWords.remove(ind);
            }
        }
        return leftUnknownSearchWords;
    }

    public void restoreBraceNames(String[] backup) {
        if (backup != null) {
            if (backup[0] != null) {
                this.localeName = backup[0];
            }
            if (backup[1] != null) {
                this.localeName = backup[1];
            }
            if (backup.length > 2) {
                ArrayList<String> oth = new ArrayList<String>();
                for (int i = 2; i < backup.length; ++i) {
                    oth.add(backup[i]);
                }
                this.otherNames = oth;
            }
        }
    }

    public String[] stripBracesNames() {
        char[] brace = new char[]{'('};
        boolean noBrace = true;
        noBrace &= !Algorithms.containsChar(this.localeName, brace);
        noBrace &= !Algorithms.containsChar(this.alternateName, brace);
        if (this.otherNames != null) {
            for (String o : this.otherNames) {
                if (!(noBrace &= !Algorithms.containsChar(o, brace))) break;
            }
        }
        if (noBrace) {
            return null;
        }
        String[] backup = new String[2 + (this.otherNames == null ? 0 : this.otherNames.size())];
        if (this.localeName != null) {
            backup[0] = this.localeName;
            this.localeName = SearchPhrase.stripBraces(this.localeName);
        }
        if (this.alternateName != null) {
            backup[1] = this.alternateName;
            this.alternateName = SearchPhrase.stripBraces(this.alternateName);
        }
        if (this.otherNames != null) {
            Iterator<String> it = this.otherNames.iterator();
            ArrayList<String> oth = new ArrayList<String>();
            for (int i = 0; i < this.otherNames.size(); ++i) {
                String o;
                backup[2 + i] = o = SearchPhrase.stripBraces(it.next());
                oth.add(o);
            }
            this.otherNames = oth;
        }
        return backup;
    }

    public static class CheckWordsMatchCount {
        public boolean allWordsEqual;
        public boolean allWordsInPhraseAreInResult;
    }

    public static enum SearchResultResource {
        DETAILED,
        WIKIPEDIA,
        BASEMAP,
        TRAVEL;

    }
}

