/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.core.jni;

import java.util.AbstractList;
import java.util.RandomAccess;
import net.osmand.core.jni.OsmAndCoreJNI;

public class VectorDouble
extends AbstractList<Double>
implements RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected VectorDouble(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(VectorDouble vectorDouble) {
        return vectorDouble == null ? 0L : vectorDouble.swigCPtr;
    }

    protected static long swigRelease(VectorDouble vectorDouble) {
        long l = 0L;
        if (vectorDouble != null) {
            if (!vectorDouble.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = vectorDouble.swigCPtr;
            vectorDouble.swigCMemOwn = false;
            vectorDouble.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OsmAndCoreJNI.delete_VectorDouble(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public VectorDouble(double[] dArray) {
        this();
        this.reserve(dArray.length);
        for (double d : dArray) {
            this.add(d);
        }
    }

    public VectorDouble(Iterable<Double> iterable) {
        this();
        for (double d : iterable) {
            this.add(d);
        }
    }

    @Override
    public Double get(int n) {
        return this.doGet(n);
    }

    @Override
    public Double set(int n, Double d) {
        return this.doSet(n, d);
    }

    @Override
    public boolean add(Double d) {
        ++this.modCount;
        this.doAdd(d);
        return true;
    }

    @Override
    public void add(int n, Double d) {
        ++this.modCount;
        this.doAdd(n, d);
    }

    @Override
    public Double remove(int n) {
        ++this.modCount;
        return this.doRemove(n);
    }

    @Override
    protected void removeRange(int n, int n2) {
        ++this.modCount;
        this.doRemoveRange(n, n2);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public VectorDouble() {
        this(OsmAndCoreJNI.new_VectorDouble__SWIG_0(), true);
    }

    public VectorDouble(VectorDouble vectorDouble) {
        this(OsmAndCoreJNI.new_VectorDouble__SWIG_1(VectorDouble.getCPtr(vectorDouble), vectorDouble), true);
    }

    public long capacity() {
        return OsmAndCoreJNI.VectorDouble_capacity(this.swigCPtr, this);
    }

    public void reserve(long l) {
        OsmAndCoreJNI.VectorDouble_reserve(this.swigCPtr, this, l);
    }

    @Override
    public boolean isEmpty() {
        return OsmAndCoreJNI.VectorDouble_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        OsmAndCoreJNI.VectorDouble_clear(this.swigCPtr, this);
    }

    public VectorDouble(int n, double d) {
        this(OsmAndCoreJNI.new_VectorDouble__SWIG_2(n, d), true);
    }

    private int doSize() {
        return OsmAndCoreJNI.VectorDouble_doSize(this.swigCPtr, this);
    }

    private void doAdd(double d) {
        OsmAndCoreJNI.VectorDouble_doAdd__SWIG_0(this.swigCPtr, this, d);
    }

    private void doAdd(int n, double d) {
        OsmAndCoreJNI.VectorDouble_doAdd__SWIG_1(this.swigCPtr, this, n, d);
    }

    private double doRemove(int n) {
        return OsmAndCoreJNI.VectorDouble_doRemove(this.swigCPtr, this, n);
    }

    private double doGet(int n) {
        return OsmAndCoreJNI.VectorDouble_doGet(this.swigCPtr, this, n);
    }

    private double doSet(int n, double d) {
        return OsmAndCoreJNI.VectorDouble_doSet(this.swigCPtr, this, n, d);
    }

    private void doRemoveRange(int n, int n2) {
        OsmAndCoreJNI.VectorDouble_doRemoveRange(this.swigCPtr, this, n, n2);
    }
}

