/*
 * Decompiled with CFR 0.152.
 */
package io.github.cosinekitty.astronomy;

import io.github.cosinekitty.astronomy.InternalError;
import io.github.cosinekitty.astronomy.Time;
import io.github.cosinekitty.astronomy.Visibility;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lio/github/cosinekitty/astronomy/ElongationInfo;", "", "time", "Lio/github/cosinekitty/astronomy/Time;", "visibility", "Lio/github/cosinekitty/astronomy/Visibility;", "elongation", "", "eclipticSeparation", "<init>", "(Lio/github/cosinekitty/astronomy/Time;Lio/github/cosinekitty/astronomy/Visibility;DD)V", "getTime", "()Lio/github/cosinekitty/astronomy/Time;", "getVisibility", "()Lio/github/cosinekitty/astronomy/Visibility;", "getElongation", "()D", "getEclipticSeparation", "validateAngle", "", "angle", "name", "", "OsmAnd-shared"})
public final class ElongationInfo {
    @NotNull
    private final Time time;
    @NotNull
    private final Visibility visibility;
    private final double elongation;
    private final double eclipticSeparation;

    public ElongationInfo(@NotNull Time time, @NotNull Visibility visibility, double elongation, double eclipticSeparation) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)((Object)visibility), (String)"visibility");
        this.time = time;
        this.visibility = visibility;
        this.elongation = elongation;
        this.eclipticSeparation = eclipticSeparation;
        this.validateAngle(this.elongation, "Elongation");
        this.validateAngle(this.eclipticSeparation, "Ecliptic separation");
    }

    @NotNull
    public final Time getTime() {
        return this.time;
    }

    @NotNull
    public final Visibility getVisibility() {
        return this.visibility;
    }

    public final double getElongation() {
        return this.elongation;
    }

    public final double getEclipticSeparation() {
        return this.eclipticSeparation;
    }

    private final void validateAngle(double angle, String name) {
        if (angle < 0.0 || angle > 180.0) {
            throw new InternalError(name + " angle is not in the required range [0, 180].");
        }
    }
}

