/*
 * Decompiled with CFR 0.152.
 */
package rtree;

import rtree.Element;
import rtree.Rect;

public class NonLeafElement
extends Element {
    long nodePtr;

    public NonLeafElement(Rect nodeRect, long nodePtr) {
        super(nodeRect);
        this.nodePtr = nodePtr;
    }

    public static int sizeInBytes() {
        return Rect.sizeInBytes() + 8;
    }

    @Override
    public long getPtr() {
        return this.nodePtr;
    }

    @Override
    public int getElementType() {
        return 2;
    }

    @Override
    public void setPtr(long ptr) {
        this.nodePtr = ptr;
    }

    @Override
    public String toString() {
        return super.toString() + "\n\tnodePointer: " + this.nodePtr;
    }

    public static void sort(Element[] elmts, int on) {
        NonLeafElement.twoWayMerge(elmts, 0, elmts.length - 1, on);
    }

    static void twoWayMerge(Element[] elmts, int start, int finish, int on) {
        try {
            int size = finish - start + 1;
            if (size <= 2) {
                int midValJ;
                if (size < 2) {
                    return;
                }
                int midValI = NonLeafElement.getMid(elmts[start], on);
                if (midValI > (midValJ = NonLeafElement.getMid(elmts[finish], on))) {
                    Element temp = elmts[start];
                    elmts[start] = elmts[finish];
                    elmts[finish] = temp;
                }
                return;
            }
            Double middle = new Double(start + finish);
            middle = new Double(Math.ceil(middle / 2.0));
            NonLeafElement.twoWayMerge(elmts, start, middle.intValue(), on);
            NonLeafElement.twoWayMerge(elmts, middle.intValue(), finish, on);
            NonLeafElement.simpleMerge(elmts, start, middle.intValue(), finish, on);
        }
        catch (Exception e) {
            System.out.println("rtree.Element.twoWayMerge: probably index out of bound");
        }
    }

    private static void simpleMerge(Element[] elmts, int first, int second, int third, int on) throws Exception {
        int i = first;
        int j = second;
        int l = 0;
        Element[] temp = new Element[third - first + 1];
        while (i < second && j <= third) {
            int midValJ;
            int midValI = NonLeafElement.getMid(elmts[i], on);
            if (midValI <= (midValJ = NonLeafElement.getMid(elmts[j], on))) {
                temp[l++] = elmts[i++];
                continue;
            }
            temp[l++] = elmts[j++];
        }
        if (i >= second) {
            while (j <= third) {
                temp[l++] = elmts[j++];
            }
        } else {
            while (i < second) {
                temp[l++] = elmts[i++];
            }
        }
        System.arraycopy(temp, 0, elmts, first, temp.length);
    }

    private static int getMid(Element elmt, int on) {
        if (on == 0) {
            return (elmt.getRect().getMaxX() + elmt.getRect().getMinX()) / 2;
        }
        return (elmt.getRect().getMaxY() + elmt.getRect().getMinY()) / 2;
    }

    public Object clone() {
        try {
            return new NonLeafElement(new Rect(this.Rectangle.getMinX(), this.Rectangle.getMinY(), this.Rectangle.getMaxX(), this.Rectangle.getMaxY()), this.nodePtr);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

