/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import java.util.ArrayList;
import java.util.List;
import net.osmand.ColorPalette;
import net.osmand.PlatformUtil;
import net.osmand.gpx.GPXFile;
import net.osmand.gpx.GPXTrackAnalysis;
import net.osmand.gpx.GPXUtilities;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.OsmMapUtils;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

@Deprecated
public class RouteColorize {
    public static double MAX_CORRECT_ELEVATION_DISTANCE = 100.0;
    public static int SLOPE_RANGE = 150;
    private static final Log LOG = PlatformUtil.getLog(RouteColorize.class);
    private static final float DEFAULT_BASE = 17.2f;
    private static final double MIN_DIFFERENCE_SLOPE = 0.05;
    private double[] latitudes;
    private double[] longitudes;
    private double[] values;
    private double minValue;
    private double maxValue;
    private ColorPalette palette;
    private List<RouteColorizationPoint> dataList;
    private ColorizationType colorizationType;

    public RouteColorize(double[] latitudes, double[] longitudes, double[] values, double minValue, double maxValue, ColorPalette palette) {
        this.latitudes = latitudes;
        this.longitudes = longitudes;
        this.values = values;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.palette = palette;
        if (Double.isNaN(minValue) || Double.isNaN(maxValue)) {
            this.calculateMinMaxValue();
        }
        this.palette = palette == null || palette.getColors().size() < 2 ? new ColorPalette(ColorPalette.MIN_MAX_PALETTE, minValue, maxValue) : palette;
    }

    public RouteColorize(GPXFile gpxFile, ColorizationType type, ColorPalette palette) {
        this(gpxFile, null, type, palette, 0.0f);
    }

    public RouteColorize(GPXFile gpxFile, GPXTrackAnalysis analysis, ColorizationType type, ColorPalette palette, float maxProfileSpeed) {
        if (!gpxFile.hasTrkPt()) {
            LOG.warn((Object)"GPX file is not consist of track points");
            return;
        }
        ArrayList<Double> latList = new ArrayList<Double>();
        ArrayList<Double> lonList = new ArrayList<Double>();
        ArrayList<Double> valList = new ArrayList<Double>();
        int wptIdx = 0;
        if (analysis == null) {
            long time = Algorithms.isEmpty(gpxFile.path) ? System.currentTimeMillis() : gpxFile.modifiedTime;
            analysis = gpxFile.getAnalysis(time);
        }
        for (GPXUtilities.Track t : gpxFile.tracks) {
            for (GPXUtilities.TrkSegment ts : t.segments) {
                if (ts.generalSegment || ts.points.size() < 2) continue;
                for (GPXUtilities.WptPt p : ts.points) {
                    latList.add(p.lat);
                    lonList.add(p.lon);
                    if (type == ColorizationType.SPEED) {
                        valList.add(Double.valueOf(analysis.pointAttributes.get((int)wptIdx).speed));
                    } else {
                        valList.add(Double.valueOf(analysis.pointAttributes.get((int)wptIdx).elevation));
                    }
                    ++wptIdx;
                }
            }
        }
        this.colorizationType = type;
        this.latitudes = this.listToArray(latList);
        this.longitudes = this.listToArray(lonList);
        this.values = type == ColorizationType.SLOPE ? this.calculateSlopesByElevations(this.latitudes, this.longitudes, this.listToArray(valList), SLOPE_RANGE) : this.listToArray(valList);
        this.calculateMinMaxValue(analysis, maxProfileSpeed);
        this.palette = type == ColorizationType.SLOPE ? (this.isValidPalette(palette) ? palette : ColorPalette.SLOPE_PALETTE) : new ColorPalette(this.isValidPalette(palette) ? palette : ColorPalette.MIN_MAX_PALETTE, this.minValue, this.maxValue);
    }

    private boolean isValidPalette(ColorPalette palette) {
        return palette != null && palette.getColors().size() >= 2;
    }

    public double[] calculateSlopesByElevations(double[] latitudes, double[] longitudes, double[] elevations, double slopeRange) {
        int i;
        double totalDistance;
        this.correctElevations(latitudes, longitudes, elevations);
        double[] newElevations = elevations;
        int i2 = 2;
        while (i2 < elevations.length - 2) {
            newElevations[i2] = elevations[i2 - 2] + elevations[i2 - 1] + elevations[i2] + elevations[i2 + 1] + elevations[i2 + 2];
            int n = i2++;
            newElevations[n] = newElevations[n] / 5.0;
        }
        elevations = newElevations;
        double[] slopes = new double[elevations.length];
        if (latitudes.length != longitudes.length || latitudes.length != elevations.length) {
            LOG.warn((Object)"Sizes of arrays latitudes, longitudes and values are not match");
            return slopes;
        }
        double[] distances = new double[elevations.length];
        distances[0] = totalDistance = 0.0;
        for (i = 0; i < elevations.length - 1; ++i) {
            distances[i + 1] = totalDistance += MapUtils.getDistance(latitudes[i], longitudes[i], latitudes[i + 1], longitudes[i + 1]);
        }
        for (i = 0; i < elevations.length; ++i) {
            double[] arg;
            slopes[i] = distances[i] < slopeRange / 2.0 || distances[i] > totalDistance - slopeRange / 2.0 ? Double.NaN : ((arg = this.findDerivativeArguments(distances, elevations, i, slopeRange)).length >= 4 ? (arg[1] - arg[0]) / (arg[3] - arg[2]) : Double.NaN);
        }
        return slopes;
    }

    private void correctElevations(double[] latitudes, double[] longitudes, double[] elevations) {
        block0: for (int i = 0; i < elevations.length; ++i) {
            int right;
            double dist;
            if (!Double.isNaN(elevations[i])) continue;
            double leftDist = MAX_CORRECT_ELEVATION_DISTANCE;
            double rightDist = MAX_CORRECT_ELEVATION_DISTANCE;
            double leftElevation = Double.NaN;
            double rightElevation = Double.NaN;
            for (int left = i - 1; left > 0 && leftDist <= MAX_CORRECT_ELEVATION_DISTANCE; --left) {
                if (Double.isNaN(elevations[left])) continue;
                dist = MapUtils.getDistance(latitudes[left], longitudes[left], latitudes[i], longitudes[i]);
                if (!(dist < leftDist)) break;
                leftDist = dist;
                leftElevation = elevations[left];
            }
            for (right = i + 1; right < elevations.length && rightDist <= MAX_CORRECT_ELEVATION_DISTANCE; ++right) {
                if (Double.isNaN(elevations[right])) continue;
                dist = MapUtils.getDistance(latitudes[right], longitudes[right], latitudes[i], longitudes[i]);
                if (!(dist < rightDist)) break;
                rightElevation = elevations[right];
                rightDist = dist;
            }
            if (!Double.isNaN(leftElevation) && !Double.isNaN(rightElevation)) {
                elevations[i] = (leftElevation + rightElevation) / 2.0;
                continue;
            }
            if (Double.isNaN(leftElevation) && !Double.isNaN(rightElevation)) {
                elevations[i] = rightElevation;
                continue;
            }
            if (!Double.isNaN(leftElevation) && Double.isNaN(rightElevation)) {
                elevations[i] = leftElevation;
                continue;
            }
            for (right = i + 1; right < elevations.length; ++right) {
                if (Double.isNaN(elevations[right])) continue;
                elevations[i] = elevations[right];
                continue block0;
            }
        }
    }

    public List<RouteColorizationPoint> getResult() {
        ArrayList<RouteColorizationPoint> result = new ArrayList<RouteColorizationPoint>();
        for (int i = 0; i < this.latitudes.length; ++i) {
            result.add(new RouteColorizationPoint(i, this.latitudes[i], this.longitudes[i], this.values[i]));
        }
        this.setColorsToPoints(result);
        return result;
    }

    public List<RouteColorizationPoint> getSimplifiedResult(int simplificationZoom) {
        List<RouteColorizationPoint> simplifiedResult = this.simplify(simplificationZoom);
        this.setColorsToPoints(simplifiedResult);
        return simplifiedResult;
    }

    private void setColorsToPoints(List<RouteColorizationPoint> points) {
        for (RouteColorizationPoint point : points) {
            point.primaryColor = this.palette.getColorByValue(point.val);
        }
    }

    public void setPalette(ColorPalette palette) {
        if (palette != null) {
            this.palette = palette;
        }
    }

    public List<RouteColorizationPoint> simplify(int simplificationZoom) {
        if (this.dataList == null) {
            this.dataList = new ArrayList<RouteColorizationPoint>();
            for (int i = 0; i < this.latitudes.length; ++i) {
                this.dataList.add(new RouteColorizationPoint(i, this.latitudes[i], this.longitudes[i], this.values[i]));
            }
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<Node> result = new ArrayList<Node>();
        for (RouteColorizationPoint data : this.dataList) {
            nodes.add(new Node(data.lat, data.lon, data.id));
        }
        double epsilon = Math.pow(2.0, 17.2f - (float)simplificationZoom);
        result.add((Node)nodes.get(0));
        OsmMapUtils.simplifyDouglasPeucker(nodes, 0, nodes.size() - 1, result, epsilon);
        ArrayList<RouteColorizationPoint> simplified = new ArrayList<RouteColorizationPoint>();
        for (int i = 1; i < result.size(); ++i) {
            int prevId = (int)((Node)result.get(i - 1)).getId();
            int currentId = (int)((Node)result.get(i)).getId();
            List<RouteColorizationPoint> sublist = this.dataList.subList(prevId, currentId);
            simplified.addAll(this.getExtremums(sublist));
        }
        Node lastSurvivedPoint = (Node)result.get(result.size() - 1);
        simplified.add(this.dataList.get((int)lastSurvivedPoint.getId()));
        return simplified;
    }

    private List<RouteColorizationPoint> getExtremums(List<RouteColorizationPoint> subDataList) {
        double max;
        if (subDataList.size() <= 2) {
            return subDataList;
        }
        ArrayList<RouteColorizationPoint> result = new ArrayList<RouteColorizationPoint>();
        double min = max = subDataList.get((int)0).val;
        for (RouteColorizationPoint pt : subDataList) {
            if (min > pt.val) {
                min = pt.val;
            }
            if (!(max < pt.val)) continue;
            max = pt.val;
        }
        double diff = max - min;
        result.add(subDataList.get(0));
        for (int i = 1; i < subDataList.size() - 1; ++i) {
            double prev = subDataList.get((int)(i - 1)).val;
            double current = subDataList.get((int)i).val;
            double next = subDataList.get((int)(i + 1)).val;
            RouteColorizationPoint currentData = subDataList.get(i);
            if (!(current > prev && current > next || current < prev && current < next || current < prev && current == next || current == prev && current < next || current > prev && current == next) && (current != prev || !(current > next))) continue;
            if (result.size() > 0) {
                RouteColorizationPoint prevInResult = (RouteColorizationPoint)result.get(0);
                if (!(prevInResult.val / diff > 0.05)) continue;
                result.add(currentData);
                continue;
            }
            result.add(currentData);
        }
        result.add(subDataList.get(subDataList.size() - 1));
        return result;
    }

    private double[] findDerivativeArguments(double[] distances, double[] elevations, int index, double slopeRange) {
        double coef;
        int i;
        double[] result = new double[4];
        double minDist = distances[index] - slopeRange / 2.0;
        double maxDist = distances[index] + slopeRange / 2.0;
        result[0] = Double.NaN;
        result[1] = Double.NaN;
        result[2] = minDist;
        result[3] = maxDist;
        int closestMaxIndex = -1;
        int closestMinIndex = -1;
        for (i = index; i < distances.length; ++i) {
            if (distances[i] == maxDist) {
                result[1] = elevations[i];
                break;
            }
            if (!(distances[i] > maxDist)) continue;
            closestMaxIndex = i;
            break;
        }
        for (i = index; i >= 0; --i) {
            if (distances[i] == minDist) {
                result[0] = elevations[i];
                break;
            }
            if (!(distances[i] < minDist)) continue;
            closestMinIndex = i;
            break;
        }
        if (closestMaxIndex > 0) {
            double diff = distances[closestMaxIndex] - distances[closestMaxIndex - 1];
            coef = (maxDist - distances[closestMaxIndex - 1]) / diff;
            if (coef > 1.0 || coef < 0.0) {
                LOG.warn((Object)("Coefficient fo max must be 0..1 , coef=" + coef));
            }
            result[1] = (1.0 - coef) * elevations[closestMaxIndex - 1] + coef * elevations[closestMaxIndex];
        }
        if (closestMinIndex >= 0) {
            double diff = distances[closestMinIndex + 1] - distances[closestMinIndex];
            coef = (minDist - distances[closestMinIndex]) / diff;
            if (coef > 1.0 || coef < 0.0) {
                LOG.warn((Object)("Coefficient for min must be 0..1 , coef=" + coef));
            }
            result[0] = (1.0 - coef) * elevations[closestMinIndex] + coef * elevations[closestMinIndex + 1];
        }
        if (Double.isNaN(result[0]) || Double.isNaN(result[1])) {
            LOG.warn((Object)"Elevations wasn't calculated");
        }
        return result;
    }

    public static double getMinValue(ColorizationType type, GPXTrackAnalysis analysis) {
        switch (type) {
            case SPEED: {
                return 0.0;
            }
            case ELEVATION: {
                return analysis.getMinElevation();
            }
            case SLOPE: {
                return -1.0;
            }
        }
        return -1.0;
    }

    public static double getMaxValue(ColorizationType type, GPXTrackAnalysis analysis, double minValue, double maxProfileSpeed) {
        switch (type) {
            case SPEED: {
                return Math.max((double)analysis.getMaxSpeed(), maxProfileSpeed);
            }
            case ELEVATION: {
                return Math.max(analysis.getMaxElevation(), minValue + 50.0);
            }
            case SLOPE: {
                return 1.0;
            }
        }
        return -1.0;
    }

    private void calculateMinMaxValue() {
        if (this.values.length == 0) {
            return;
        }
        this.maxValue = Double.NaN;
        this.minValue = Double.NaN;
        for (double value : this.values) {
            if ((Double.isNaN(this.maxValue) || Double.isNaN(this.minValue)) && !Double.isNaN(value)) {
                this.maxValue = this.minValue = value;
            }
            if (this.minValue > value) {
                this.minValue = value;
            }
            if (!(this.maxValue < value)) continue;
            this.maxValue = value;
        }
    }

    private void calculateMinMaxValue(GPXTrackAnalysis analysis, float maxProfileSpeed) {
        this.calculateMinMaxValue();
        this.maxValue = RouteColorize.getMaxValue(this.colorizationType, analysis, this.minValue, maxProfileSpeed);
    }

    private double[] listToArray(List<Double> doubleList) {
        double[] result = new double[doubleList.size()];
        for (int i = 0; i < doubleList.size(); ++i) {
            result[i] = doubleList.get(i);
        }
        return result;
    }

    public static ColorPalette getDefaultPalette(ColorizationType colorizationType) {
        if (colorizationType == ColorizationType.SLOPE) {
            return ColorPalette.SLOPE_PALETTE;
        }
        return ColorPalette.MIN_MAX_PALETTE;
    }

    public static enum ColorizationType {
        ELEVATION,
        SPEED,
        SLOPE,
        NONE;

    }

    public static class RouteColorizationPoint {
        public final int id;
        public final double lat;
        public final double lon;
        public final double val;
        public int primaryColor;
        public int secondaryColor;

        public RouteColorizationPoint(int id, double lat, double lon, double val) {
            this.id = id;
            this.lat = lat;
            this.lon = lon;
            this.val = val;
        }
    }
}

