/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimodel.confluence;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.Deque;
import org.xwiki.rendering.wikimodel.CompositeListener;
import org.xwiki.rendering.wikimodel.IWemListener;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.WikiParserException;
import org.xwiki.rendering.wikimodel.confluence.ConfluenceWikiParser;

public class ConfluenceExtendedWikiParser
extends ConfluenceWikiParser {
    @Override
    public void parse(Reader reader, IWemListener listener) throws WikiParserException {
        EnhancedListener composite = new EnhancedListener(listener);
        super.parse(reader, composite);
    }

    public static class EnhancedListener
    extends CompositeListener {
        private Deque<Boolean> fSkipDocument = new ArrayDeque<Boolean>();

        public EnhancedListener(IWemListener ... listeners) {
            super(listeners);
        }

        @Override
        public void beginDocument(WikiParameters params) {
            if (!this.skipDocument()) {
                super.beginDocument(params);
            }
        }

        @Override
        public void beginSection(int docLevel, int headerLevel, WikiParameters params) {
            if (!this.skipDocument()) {
                super.beginSection(docLevel, headerLevel, params);
            }
        }

        @Override
        public void beginSectionContent(int docLevel, int headerLevel, WikiParameters params) {
            if (!this.skipDocument()) {
                super.beginSectionContent(docLevel, headerLevel, params);
            }
            this.push(false);
        }

        @Override
        public void endDocument(WikiParameters params) {
            if (!this.skipDocument()) {
                super.endDocument(params);
            }
        }

        @Override
        public void endSection(int docLevel, int headerLevel, WikiParameters params) {
            if (!this.skipDocument()) {
                super.endSection(docLevel, headerLevel, params);
            }
        }

        @Override
        public void endSectionContent(int docLevel, int headerLevel, WikiParameters params) {
            this.pop();
            if (!this.skipDocument()) {
                super.endSectionContent(docLevel, headerLevel, params);
            }
        }

        @Override
        public void onMacroBlock(String macroName, WikiParameters params, String content) {
            String type = null;
            if ("note".equals(macroName)) {
                type = "N";
            } else if ("tip".equals(macroName)) {
                type = "T";
            }
            if (type != null) {
                this.beginInfoBlock(type, params);
                this.parseContent(content);
                this.endInfoBlock(type, params);
            } else {
                super.onMacroBlock(macroName, params, content);
            }
        }

        private void parseContent(String content) {
            try {
                this.push(true);
                StringReader reader = new StringReader(content);
                ConfluenceWikiParser parser = new ConfluenceWikiParser();
                parser.parse(reader, this);
                this.pop();
            }
            catch (WikiParserException e) {
                throw new RuntimeException(e);
            }
        }

        private void pop() {
            this.fSkipDocument.pop();
        }

        private void push(boolean b) {
            this.fSkipDocument.push(b);
        }

        private boolean skipDocument() {
            if (this.fSkipDocument.isEmpty()) {
                return false;
            }
            Boolean peek = this.fSkipDocument.peek();
            return peek;
        }
    }
}

