/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.registry;

import it.geosolutions.imageio.registry.SubTypeRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ImageIOEXTRegistry {
    private Map<Class<?>, SubTypeRegistry> subTypesMap = new HashMap();

    private void checkSubType(SubTypeRegistry reg) {
        if (reg == null) {
            throw new IllegalArgumentException("subtype not found!");
        }
    }

    void ensureNotNull(Object object, String name) {
        if (object == null) {
            throw new IllegalArgumentException(name + " == null!");
        }
    }

    private <T> void checkSpis(T firstSpi, T secondSpi) {
        if (firstSpi == null || secondSpi == null) {
            throw new IllegalArgumentException("spi is null!");
        }
        if (firstSpi == secondSpi) {
            throw new IllegalArgumentException("spis are the same!");
        }
    }

    public ImageIOEXTRegistry(Iterator<Class<?>> subTypes) {
        this.ensureNotNull(subTypes, "subTypes");
        while (subTypes.hasNext()) {
            Class<?> subType = subTypes.next();
            SubTypeRegistry reg = new SubTypeRegistry(this, subType);
            this.subTypesMap.put(subType, reg);
        }
    }

    public void registerSPI(Object spi) {
        this.ensureNotNull(spi, "spi");
        Iterator<SubTypeRegistry> regs = this.getSubRegistries(spi);
        while (regs.hasNext()) {
            SubTypeRegistry reg = regs.next();
            reg.registerSPI(spi);
        }
    }

    public boolean isRegistered(Object spi) {
        SubTypeRegistry reg;
        this.ensureNotNull(spi, "spi");
        Iterator<SubTypeRegistry> regs = this.getSubRegistries(spi);
        do {
            if (regs.hasNext()) continue;
            return false;
        } while (!(reg = regs.next()).isRegistered(spi));
        return true;
    }

    public <T> Iterator<T> getSPIs(Class<T> subtype, boolean sorting) {
        SubTypeRegistry reg = this.subTypesMap.get(subtype);
        this.checkSubType(reg);
        return reg.getSPIs(sorting);
    }

    public <T> boolean setOrder(Class<T> subtype, T firstSpi, T secondSpi) {
        this.checkSpis(firstSpi, secondSpi);
        SubTypeRegistry reg = this.subTypesMap.get(subtype);
        this.checkSubType(reg);
        return reg.isRegistered(firstSpi) && reg.isRegistered(secondSpi) ? reg.setOrder(firstSpi, secondSpi) : false;
    }

    public <T> boolean unsetOrder(Class<T> subtype, T firstSpi, T secondSpi) {
        this.checkSpis(firstSpi, secondSpi);
        SubTypeRegistry reg = this.subTypesMap.get(subtype);
        this.checkSubType(reg);
        return reg.isRegistered(firstSpi) && reg.isRegistered(secondSpi) ? reg.unsetOrder(firstSpi, secondSpi) : false;
    }

    public void deregisterSPI(Object spi) {
        this.ensureNotNull(spi, "spi");
        Iterator<SubTypeRegistry> regs = this.getSubRegistries(spi);
        while (regs.hasNext()) {
            SubTypeRegistry reg = regs.next();
            reg.deregisterSPI(spi);
        }
    }

    public void deregisterAll(Class<?> subtype) {
        SubTypeRegistry reg = this.subTypesMap.get(subtype);
        this.checkSubType(reg);
        reg.clear();
    }

    public void deregisterAll() {
        for (SubTypeRegistry reg : this.subTypesMap.values()) {
            reg.clear();
        }
    }

    public Iterator<Class<?>> getSubTypes() {
        return this.subTypesMap.keySet().iterator();
    }

    private Iterator<SubTypeRegistry> getSubRegistries(Object spi) {
        ArrayList<SubTypeRegistry> l = new ArrayList<SubTypeRegistry>();
        Iterator<Class<?>> iter = this.getSubTypes();
        while (iter.hasNext()) {
            Class<?> c = iter.next();
            if (!c.isAssignableFrom(spi.getClass())) continue;
            l.add(this.subTypesMap.get(c));
        }
        return l.iterator();
    }

    public void finalize() throws Throwable {
        this.deregisterAll();
        super.finalize();
    }
}

