/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.osmand.PlatformUtil;
import net.osmand.ResultMatcher;
import net.osmand.binary.BinaryMapDataObject;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.render.RenderingRuleProperty;
import net.osmand.render.RenderingRuleSearchRequest;
import net.osmand.render.RenderingRulesStorage;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class IconVisibility {
    public static final int ICON = 0;
    public static final int TEXT = 1;
    public static final int ALL = 2;
    public static final int TEST_FILE = 0;
    public static final int RENDER_FILE = 1;
    public static final String[] defArgs = new String[]{"src/test/resources/Synthetic_test_rendering.obf", "default.render.xml"};
    public static final String helpMessage = "use --test-obf=file.obf [--render=file.render.xml] for compare icon visibility in the file.obf map on the file.render.xml style\n\t if --render is omitted used default.render.xml";
    Map<Integer, List<VisibleObject>> mapObjectMap = new LinkedHashMap<Integer, List<VisibleObject>>();
    Map<Integer, Integer> maxIconOrderInZoom = new LinkedHashMap<Integer, Integer>();
    Map<Integer, Integer> maxTextOrderInZoom = new LinkedHashMap<Integer, Integer>();
    private final StringBuilder outMessage = new StringBuilder();

    public static void main(String[] args) throws IOException {
        if (args == null || args.length < 1) {
            System.out.println(helpMessage);
            return;
        }
        boolean validArgs = false;
        for (String arg : args) {
            if (arg.startsWith("--test-obf=")) {
                IconVisibility.defArgs[0] = arg.substring("--test-obf=".length());
                validArgs = true;
                continue;
            }
            if (!arg.startsWith("--render=")) continue;
            IconVisibility.defArgs[1] = arg.substring("--render=".length());
        }
        if (!validArgs) {
            System.out.println(helpMessage);
            return;
        }
        IconVisibility iconComparator = new IconVisibility();
        iconComparator.compare(defArgs[0], defArgs[1]);
    }

    public String compare(String filePath, String renderFilePath) throws IOException {
        File file = new File(filePath);
        RandomAccessFile raf = new RandomAccessFile(file.getAbsolutePath(), "r");
        BinaryMapIndexReader reader = new BinaryMapIndexReader(raf, file);
        RenderingRulesStorage storage = this.getRenderingStorage(renderFilePath);
        RenderingRuleSearchRequest request = new RenderingRuleSearchRequest(storage);
        this.initCustomRules(storage, request);
        this.loadMapObject(reader, request);
        return this.compareOrder();
    }

    private void loadMapObject(BinaryMapIndexReader reader, final RenderingRuleSearchRequest request) throws IOException {
        for (final BinaryMapIndexReader.MapIndex mapIndex : reader.getMapIndexes()) {
            for (BinaryMapIndexReader.MapRoot root : mapIndex.getRoots()) {
                for (int zoom = root.getMaxZoom(); zoom >= root.getMinZoom(); --zoom) {
                    final int[] maxOrder = new int[]{0, 0};
                    final int[] statCounts = new int[]{0, 0, 0};
                    final int finalZoom = zoom;
                    BinaryMapIndexReader.SearchRequest req = BinaryMapIndexReader.buildSearchRequest((int)0, (int)Integer.MAX_VALUE, (int)0, (int)Integer.MAX_VALUE, (int)zoom, (types, index) -> true, (ResultMatcher)new ResultMatcher<BinaryMapDataObject>(){

                        public boolean publish(BinaryMapDataObject obj) {
                            statCounts[2] = statCounts[2] + 1;
                            for (int j = 0; j < obj.getTypes().length; ++j) {
                                int wholeType = obj.getTypes()[j];
                                BinaryMapIndexReader.TagValuePair pair = mapIndex.decodeType(wholeType);
                                request.setInitialTagValueZoom(pair.tag, pair.value, finalZoom, obj);
                                request.search(4);
                                int textOrder = -1;
                                if (textOrder > 0) {
                                    if (textOrder > maxOrder[1]) {
                                        maxOrder[1] = textOrder;
                                    }
                                    statCounts[1] = statCounts[1] + 1;
                                }
                                request.setInitialTagValueZoom(pair.tag, pair.value, finalZoom, obj);
                                request.search(1);
                                int iconOrder = request.getIntPropertyValue(request.ALL.R_ICON_ORDER);
                                if (iconOrder > 0) {
                                    if (iconOrder > maxOrder[0]) {
                                        maxOrder[0] = iconOrder;
                                    }
                                    statCounts[0] = statCounts[0] + 1;
                                }
                                if (textOrder <= 0 && iconOrder <= 0) continue;
                                VisibleObject vo = new VisibleObject();
                                vo.mapDataObject = obj;
                                vo.icon = request.getStringPropertyValue(request.ALL.R_ICON);
                                vo.iconOrder = iconOrder;
                                vo.textOrder = textOrder;
                                List voList = IconVisibility.this.mapObjectMap.computeIfAbsent(finalZoom, k -> new ArrayList());
                                voList.add(vo);
                            }
                            return false;
                        }

                        public boolean isCancelled() {
                            return false;
                        }
                    });
                    reader.searchMapIndex(req, mapIndex);
                    this.outMessage.append(String.format("zoom %d total objects: %d ", zoom, statCounts[2]));
                    if (maxOrder[0] != 0) {
                        this.maxIconOrderInZoom.put(zoom, maxOrder[0]);
                        this.outMessage.append(String.format("icon: %d , maxIconOrder %d", statCounts[0], maxOrder[0]));
                    }
                    if (maxOrder[1] != 0) {
                        this.maxIconOrderInZoom.put(zoom, maxOrder[1]);
                        this.outMessage.append(String.format("text: %d , maxTextOrder %d ", statCounts[1], maxOrder[1]));
                    }
                    this.outMessage.append("\n");
                }
            }
        }
    }

    private String compareOrder() {
        ArrayList<VisibleObject> visibleObjects = new ArrayList<VisibleObject>();
        ArrayList<Integer> selectedZooms = new ArrayList<Integer>(this.maxIconOrderInZoom.keySet());
        Object testMessage = "";
        if (selectedZooms.isEmpty()) {
            System.out.println("Icons not found");
            return "Icons not found";
        }
        Collections.sort(selectedZooms);
        int maxIconOrderZoom = 0;
        int maxTextOrderZoom = 0;
        boolean test = true;
        ArrayList<Long> checkedObject = new ArrayList<Long>();
        for (int zoom = ((Integer)selectedZooms.get(0)).intValue(); zoom < (Integer)selectedZooms.get(selectedZooms.size() - 1); ++zoom) {
            this.outMessage.append(String.format("zoom: %d (min icon order %d) -> %d%n", zoom, maxIconOrderZoom, zoom + 1));
            List<VisibleObject> zoomList = this.mapObjectMap.get(zoom);
            List<VisibleObject> zoomNextList = this.mapObjectMap.get(zoom + 1);
            visibleObjects.clear();
            block1: for (VisibleObject objectNextZoom : zoomNextList) {
                for (VisibleObject object : zoomList) {
                    if (object.mapDataObject.getId() != objectNextZoom.mapDataObject.getId() || checkedObject.contains(objectNextZoom.mapDataObject.getId())) continue;
                    visibleObjects.add(objectNextZoom);
                    continue block1;
                }
            }
            for (VisibleObject object : visibleObjects) {
                if (object.iconOrder <= maxIconOrderZoom) {
                    checkedObject.add(object.mapDataObject.getId());
                    this.outMessage.append(String.format("!!!ZOOM %d: id %-10d max order for %d zoom %d >= ", zoom, object.mapDataObject.getId() >> 7, zoom - 1, maxIconOrderZoom)).append(object.toStringWithZoom(zoom)).append("\n");
                    if (!test) continue;
                    testMessage = String.format("ZOOM %d: id %-10d max order for %d zoom %d >= ", zoom, object.mapDataObject.getId() >> 7, zoom - 1, maxIconOrderZoom) + object.toStringWithZoom(zoom);
                    test = false;
                    continue;
                }
                this.outMessage.append(String.format("ZOOM %d: id %-10d order ", zoom, object.mapDataObject.getId() >> 7)).append(object.toStringWithZoom(zoom)).append("\n");
            }
            if (this.maxIconOrderInZoom.containsKey(zoom)) {
                maxIconOrderZoom = this.maxIconOrderInZoom.get(zoom);
            }
            if (!this.maxTextOrderInZoom.containsKey(zoom)) continue;
            maxTextOrderZoom = this.maxTextOrderInZoom.get(zoom);
        }
        if (!test) {
            System.out.println(this.outMessage);
        }
        return testMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RenderingRulesStorage getRenderingStorage(String renderFilePath) throws IOException {
        LinkedHashMap<String, String> renderingConstants = new LinkedHashMap<String, String>();
        try (InputStream is = this.getInputStream(renderFilePath);){
            int tok;
            XmlPullParser parser = PlatformUtil.newXMLPullParser();
            parser.setInput(is, "UTF-8");
            while ((tok = parser.next()) != 1) {
                String tagName;
                if (tok != 2 || !(tagName = parser.getName()).equals("renderingConstant") || renderingConstants.containsKey(parser.getAttributeValue("", "name"))) continue;
                renderingConstants.put(parser.getAttributeValue("", "name"), parser.getAttributeValue("", "value"));
            }
        }
        RenderingRulesStorage storage = new RenderingRulesStorage("default", renderingConstants);
        is = this.getInputStream(renderFilePath);
        RenderingRulesStorage.RenderingRulesStorageResolver resolver = (name, ref) -> {
            RenderingRulesStorage depends = new RenderingRulesStorage(name, renderingConstants);
            depends.parseRulesFromXmlInputStream(RenderingRulesStorage.class.getResourceAsStream(name + ".render.xml"), ref, false);
            return depends;
        };
        try {
            storage.parseRulesFromXmlInputStream(is, resolver, false);
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        finally {
            is.close();
        }
        return storage;
    }

    private InputStream getInputStream(String renderFilePath) throws FileNotFoundException {
        InputStream is = renderFilePath.equals("default.render.xml") ? RenderingRulesStorage.class.getResourceAsStream(renderFilePath) : new FileInputStream(renderFilePath);
        return is;
    }

    private void initCustomRules(RenderingRulesStorage storage, RenderingRuleSearchRequest request) {
        for (RenderingRuleProperty customProp : storage.PROPS.getCustomRules()) {
            if (customProp.isString()) {
                request.setStringFilter(customProp, "");
                continue;
            }
            if (customProp.isBoolean()) {
                request.setBooleanFilter(customProp, false);
                continue;
            }
            request.setIntFilter(customProp, -1);
        }
        request.saveState();
    }

    static class VisibleObject {
        BinaryMapDataObject mapDataObject;
        int textOrder;
        int iconOrder;
        String icon;

        VisibleObject() {
        }

        public String toStringWithZoom(int zoom) {
            BinaryMapIndexReader.TagValuePair tagValuePair;
            int at;
            StringBuilder result = new StringBuilder(String.format("%d : icon %s tags[", this.iconOrder, this.icon));
            for (at = 0; at < this.mapDataObject.getTypes().length; ++at) {
                tagValuePair = this.mapDataObject.getMapIndex().decodeType(this.mapDataObject.getTypes()[at]);
                result.append(String.format("\"%s\" ", tagValuePair.tag + "=" + tagValuePair.value));
            }
            for (at = 0; at < this.mapDataObject.getAdditionalTypes().length; ++at) {
                tagValuePair = this.mapDataObject.getMapIndex().decodeType(this.mapDataObject.getAdditionalTypes()[at]);
                result.append(String.format("\"%s\" ", tagValuePair.tag + "=" + tagValuePair.value));
            }
            result.append(String.format("]", new Object[0]));
            return result.toString();
        }
    }
}

