/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pinyin4j;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import net.sourceforge.pinyin4j.ResourceHelper;

class ChineseToPinyinResource {
    private Properties unicodeToHanyuPinyinTable = null;

    private void setUnicodeToHanyuPinyinTable(Properties unicodeToHanyuPinyinTable) {
        this.unicodeToHanyuPinyinTable = unicodeToHanyuPinyinTable;
    }

    private Properties getUnicodeToHanyuPinyinTable() {
        return this.unicodeToHanyuPinyinTable;
    }

    private ChineseToPinyinResource() {
        this.initializeResource();
    }

    private void initializeResource() {
        try {
            String resourceName = "/pinyindb/unicode_to_hanyu_pinyin.txt";
            this.setUnicodeToHanyuPinyinTable(new Properties());
            this.getUnicodeToHanyuPinyinTable().load(ResourceHelper.getResourceInputStream("/pinyindb/unicode_to_hanyu_pinyin.txt"));
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    String[] getHanyuPinyinStringArray(char ch) {
        String pinyinRecord = this.getHanyuPinyinRecordFromChar(ch);
        if (null != pinyinRecord) {
            int indexOfLeftBracket = pinyinRecord.indexOf("(");
            int indexOfRightBracket = pinyinRecord.lastIndexOf(")");
            String stripedString = pinyinRecord.substring(indexOfLeftBracket + "(".length(), indexOfRightBracket);
            return stripedString.split(",");
        }
        return null;
    }

    private boolean isValidRecord(String record) {
        String noneStr = "(none0)";
        return null != record && !record.equals("(none0)") && record.startsWith("(") && record.endsWith(")");
    }

    private String getHanyuPinyinRecordFromChar(char ch) {
        char codePointOfChar = ch;
        String codepointHexStr = Integer.toHexString(codePointOfChar).toUpperCase();
        String foundRecord = this.getUnicodeToHanyuPinyinTable().getProperty(codepointHexStr);
        return this.isValidRecord(foundRecord) ? foundRecord : null;
    }

    static ChineseToPinyinResource getInstance() {
        return ChineseToPinyinResourceHolder.theInstance;
    }

    class Field {
        static final String LEFT_BRACKET = "(";
        static final String RIGHT_BRACKET = ")";
        static final String COMMA = ",";

        Field() {
        }
    }

    private static class ChineseToPinyinResourceHolder {
        static final ChineseToPinyinResource theInstance = new ChineseToPinyinResource();

        private ChineseToPinyinResourceHolder() {
        }
    }
}

