/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import net.osmand.router.MissingMapsCalculationResult;

public class RouteCalculationProgress
implements Serializable {
    private static final long serialVersionUID = 1L;
    public int segmentNotFound = -1;
    public float distanceFromBegin;
    public float directDistance;
    public int directSegmentQueueSize;
    public float distanceFromEnd;
    public int reverseSegmentQueueSize;
    public float reverseDistance;
    public float totalEstimatedDistance = 0.0f;
    public float totalApproximateDistance = 0.0f;
    public float approximatedDistance;
    public float routingCalculatedTime = 0.0f;
    public int visitedSegments = 0;
    public int visitedDirectSegments = 0;
    public int visitedOppositeSegments = 0;
    public int directQueueSize = 0;
    public int oppositeQueueSize = 0;
    public int finalSegmentsFound = 0;
    public int totalIterations = 1;
    public int iteration = -1;
    public long timeNanoToCalcDeviation = 0L;
    public long timeToLoad = 0L;
    public long timeToLoadHeaders = 0L;
    public long timeToFindInitialSegments = 0L;
    public long timeToCalculate = 0L;
    public int distinctLoadedTiles = 0;
    public int maxLoadedTiles = 0;
    public int loadedPrevUnloadedTiles = 0;
    public int unloadedTiles = 0;
    public int loadedTiles = 0;
    public boolean isCancelled;
    public boolean requestPrivateAccessRouting;
    public long routeCalculationStartTime;
    public MissingMapsCalculationResult missingMapsCalculationResult;
    private int hhIterationStep = HHIteration.HH_NOT_STARTED.ordinal();
    private int hhTargetsDone;
    private int hhTargetsTotal;
    private double hhCurrentStepProgress;
    private int hhCalcCounter;
    private static final float INITIAL_PROGRESS = 0.05f;
    private static final float FIRST_ITERATION = 0.72f;

    public static RouteCalculationProgress capture(RouteCalculationProgress cp) {
        RouteCalculationProgress p = new RouteCalculationProgress();
        p.timeNanoToCalcDeviation = cp.timeNanoToCalcDeviation;
        p.timeToCalculate = cp.timeToCalculate;
        p.timeToLoadHeaders = cp.timeToLoadHeaders;
        p.timeToFindInitialSegments = cp.timeToFindInitialSegments;
        p.timeToLoad = cp.timeToLoad;
        p.visitedSegments = cp.visitedSegments;
        p.directQueueSize = cp.directQueueSize;
        p.reverseSegmentQueueSize = cp.reverseSegmentQueueSize;
        p.visitedDirectSegments = cp.visitedDirectSegments;
        p.visitedOppositeSegments = cp.visitedOppositeSegments;
        p.finalSegmentsFound = cp.finalSegmentsFound;
        p.loadedTiles = cp.loadedTiles;
        p.distinctLoadedTiles = cp.distinctLoadedTiles;
        p.maxLoadedTiles = cp.maxLoadedTiles;
        p.loadedPrevUnloadedTiles = cp.loadedPrevUnloadedTiles;
        cp.maxLoadedTiles = 0;
        return p;
    }

    public Map<String, Object> getInfo(RouteCalculationProgress firstPhase) {
        float pureTime;
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        TreeMap<String, Integer> tiles = new TreeMap<String, Integer>();
        if (firstPhase == null) {
            firstPhase = new RouteCalculationProgress();
        }
        map.put("tiles", tiles);
        tiles.put("loadedTiles", this.loadedTiles - firstPhase.loadedTiles);
        tiles.put("loadedTilesDistinct", this.distinctLoadedTiles - firstPhase.distinctLoadedTiles);
        tiles.put("loadedTilesPrevUnloaded", this.loadedPrevUnloadedTiles - firstPhase.loadedPrevUnloadedTiles);
        tiles.put("loadedTilesMax", Math.max(this.maxLoadedTiles, this.distinctLoadedTiles));
        tiles.put("unloadedTiles", this.unloadedTiles - firstPhase.unloadedTiles);
        LinkedHashMap<String, Integer> segms = new LinkedHashMap<String, Integer>();
        map.put("segments", segms);
        segms.put("visited", this.visitedSegments - firstPhase.visitedSegments);
        segms.put("queueDirectSize", this.directQueueSize - firstPhase.directQueueSize);
        segms.put("queueOppositeSize", this.reverseSegmentQueueSize - firstPhase.reverseSegmentQueueSize);
        segms.put("visitedDirectPoints", this.visitedDirectSegments - firstPhase.visitedDirectSegments);
        segms.put("visitedOppositePoints", this.visitedOppositeSegments - firstPhase.visitedOppositeSegments);
        segms.put("finalSegmentsFound", this.finalSegmentsFound - firstPhase.finalSegmentsFound);
        LinkedHashMap<String, Float> time = new LinkedHashMap<String, Float>();
        map.put("time", time);
        float timeToCalc = (float)((double)(this.timeToCalculate - firstPhase.timeToCalculate) / 1.0E9);
        time.put("timeToCalculate", Float.valueOf(timeToCalc));
        float timeToLoad = (float)((double)(this.timeToLoad - firstPhase.timeToLoad) / 1.0E9);
        time.put("timeToLoad", Float.valueOf(timeToLoad));
        float timeToLoadHeaders = (float)((double)(this.timeToLoadHeaders - firstPhase.timeToLoadHeaders) / 1.0E9);
        time.put("timeToLoadHeaders", Float.valueOf(timeToLoadHeaders));
        float timeToFindInitialSegments = (float)((double)(this.timeToFindInitialSegments - firstPhase.timeToFindInitialSegments) / 1.0E9);
        time.put("timeToFindInitialSegments", Float.valueOf(timeToFindInitialSegments));
        float timeExtra = (float)((double)(this.timeNanoToCalcDeviation - firstPhase.timeNanoToCalcDeviation) / 1.0E9);
        time.put("timeExtra", Float.valueOf(timeExtra));
        LinkedHashMap<String, Float> metrics = new LinkedHashMap<String, Float>();
        map.put("metrics", metrics);
        if (timeToLoad + timeToLoadHeaders > 0.0f) {
            metrics.put("tilesPerSec", Float.valueOf((float)(this.loadedTiles - firstPhase.loadedTiles) / (timeToLoad + timeToLoadHeaders)));
        }
        if ((pureTime = timeToCalc - (timeToLoad + timeToLoadHeaders + timeToFindInitialSegments)) > 0.0f) {
            metrics.put("segmentsPerSec", Float.valueOf((float)(this.visitedSegments - firstPhase.visitedSegments) / pureTime));
        } else {
            metrics.put("segmentsPerSec", Float.valueOf(0.0f));
        }
        return map;
    }

    public float getLinearProgressHH() {
        float progress = 0.0f;
        for (HHIteration i : HHIteration.values()) {
            if (i.ordinal() == this.hhIterationStep) {
                progress = (float)((double)progress + this.hhCurrentStepProgress * (double)i.approxStepPercent);
                break;
            }
            progress += (float)i.approxStepPercent;
        }
        if (this.hhTargetsTotal > 0) {
            progress = (100.0f * (float)this.hhTargetsDone + progress) / (float)this.hhTargetsTotal;
        }
        return Math.min(progress, 99.0f);
    }

    public float getLinearProgress() {
        if (this.hhIterationStep != HHIteration.HH_NOT_STARTED.ordinal()) {
            return this.getLinearProgressHH();
        }
        float p = Math.max(this.distanceFromBegin, this.distanceFromEnd);
        float all = this.totalEstimatedDistance * 1.35f;
        float pr = 0.0f;
        if (all > 0.0f) {
            pr = Math.min(p * p / (all * all), 1.0f);
        }
        float progress = 0.05f;
        progress = this.totalIterations <= 1 ? 0.05f + pr * 0.95f : (this.totalIterations <= 2 ? (this.iteration < 1 ? pr * 0.72f + 0.05f : 0.77000004f + pr * 0.22999997f) : (float)(((double)this.iteration + Math.min((double)pr, 0.7)) / (double)this.totalIterations));
        return Math.min(progress * 100.0f, 99.0f);
    }

    public float getApproximationProgress() {
        float progress = 0.0f;
        if (this.totalApproximateDistance > 0.0f) {
            progress = this.approximatedDistance / this.totalApproximateDistance;
        }
        progress = 0.05f + progress * 0.95f;
        return Math.min(progress * 100.0f, 99.0f);
    }

    public void nextIteration() {
        ++this.iteration;
        this.totalEstimatedDistance = 0.0f;
    }

    public void hhIteration(HHIteration step) {
        this.hhIterationStep = step.ordinal();
        this.hhCurrentStepProgress = 0.0;
    }

    public void hhIterationProgress(double k) {
        if (k >= 0.0 && k <= 1.0 && k > this.hhCurrentStepProgress) {
            this.hhCurrentStepProgress = k;
        }
    }

    public void hhTargetsProgress(int done, int total) {
        this.hhTargetsDone = done;
        this.hhTargetsTotal = total;
    }

    public void hhUpdateCalcCounter(int counter) {
        this.hhCalcCounter = counter;
    }

    public int hhGetCalcCounter() {
        return this.hhCalcCounter;
    }

    public static enum HHIteration {
        HH_NOT_STARTED(0),
        SELECT_REGIONS(5),
        LOAD_POINTS(5),
        START_END_POINT(15),
        ROUTING(15),
        DETAILED(50),
        RECALCULATION(10),
        ALTERNATIVES(0),
        DONE(0);

        public final int approxStepPercent;

        private HHIteration(int approximate) {
            this.approxStepPercent = approximate;
        }
    }
}

