/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.PriorityQueue;
import net.osmand.PlatformUtil;
import net.osmand.binary.ObfConstants;
import net.osmand.data.LatLon;
import net.osmand.data.QuadRect;
import net.osmand.data.TransportRoute;
import net.osmand.data.TransportSchedule;
import net.osmand.data.TransportStop;
import net.osmand.data.TransportStopExit;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.Way;
import net.osmand.router.NativeTransportRoute;
import net.osmand.router.NativeTransportRouteResultSegment;
import net.osmand.router.NativeTransportRoutingResult;
import net.osmand.router.NativeTransportStop;
import net.osmand.router.TransportRouteResult;
import net.osmand.router.TransportRoutingConfiguration;
import net.osmand.router.TransportRoutingContext;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

public class TransportRoutePlanner {
    private static final boolean MEASURE_TIME = false;
    private static final int MIN_DIST_STOP_TO_GEOMETRY = 150;
    public static final long GEOMETRY_WAY_ID = -1L;
    public static final long STOPS_WAY_ID = -2L;
    static long TRACE_ONBOARD_ID = 0L;
    static long TRACE_CHANGE_ID = 0L;
    private static final Log LOG = PlatformUtil.getLog(TransportRoutePlanner.class);

    public List<TransportRouteResult> buildRoute(TransportRoutingContext ctx, LatLon start, LatLon end) throws IOException, InterruptedException {
        long nonce = 0L;
        ctx.startCalcTime = System.currentTimeMillis();
        double totalDistance = MapUtils.getDistance(start, end);
        List<TransportRouteSegment> startStops = ctx.getTransportStops(start);
        List<TransportRouteSegment> endStops = ctx.getTransportStops(end);
        TLongObjectHashMap endSegments = new TLongObjectHashMap();
        for (TransportRouteSegment transportRouteSegment : endStops) {
            endSegments.put(transportRouteSegment.getId(), (Object)transportRouteSegment);
        }
        if (startStops.size() == 0) {
            LOG.info((Object)"Public transport. Start stop is empty");
            return Collections.emptyList();
        }
        PriorityQueue<TransportRouteSegment> queue = new PriorityQueue<TransportRouteSegment>(startStops.size(), new SegmentsComparator());
        for (TransportRouteSegment r : startStops) {
            long id;
            r.walkDist = (float)MapUtils.getDistance(r.getLocation(), start);
            r.distFromStart = r.walkDist / (double)ctx.cfg.walkSpeed;
            if (TRACE_ONBOARD_ID != 0L && (id = ObfConstants.getOsmIdFromBinaryMapObjectId(r.road.getId())) == TRACE_ONBOARD_ID) {
                System.out.println(r.distFromStart + " " + id + " " + String.valueOf(r));
            }
            ++nonce;
            r.nonce = r.nonce;
            queue.add(r);
        }
        double d = ctx.cfg.maxRouteTime;
        if (totalDistance > (double)ctx.cfg.maxRouteDistance && ctx.cfg.maxRouteIncreaseSpeed > 0) {
            int increaseTime = (int)((totalDistance - (double)ctx.cfg.maxRouteDistance) * 3.6 / (double)ctx.cfg.maxRouteIncreaseSpeed);
            d += (double)increaseTime;
        }
        double maxTravelTimeCmpToWalk = totalDistance / (double)ctx.cfg.walkSpeed;
        ArrayList<TransportRouteSegment> results = new ArrayList<TransportRouteSegment>();
        this.initProgressBar(ctx, start, end);
        while (!queue.isEmpty()) {
            long id;
            long beginMs = 0L;
            if (ctx.calculationProgress != null && ctx.calculationProgress.isCancelled) {
                return null;
            }
            TransportRouteSegment segment = queue.poll();
            long segIdWithParent = this.segmentWithParentId(segment, segment.parentRoute);
            TransportRouteSegment ex = (TransportRouteSegment)ctx.visitedSegments.get(segIdWithParent);
            if (ex != null) {
                if (!(ex.distFromStart > segment.distFromStart)) continue;
                System.err.println(String.format("%.1f (%s) > %.1f (%s)", ex.distFromStart, ex, segment.distFromStart, segment));
                continue;
            }
            ++ctx.visitedRoutesCount;
            ctx.visitedSegments.put(segIdWithParent, (Object)segment);
            if (segment.distFromStart > d * ctx.cfg.increaseForAlternativesRoutes || segment.distFromStart > maxTravelTimeCmpToWalk) break;
            TransportRouteSegment finish = null;
            double minDist = 0.0;
            double travelDist = 0.0;
            int seconds = segment.road.calcIntervalInSeconds();
            double travelTime = seconds > 0 ? (double)seconds / 2.0 : (double)ctx.cfg.getBoardingTime(segment.road.getType());
            float routeTravelSpeed = ctx.cfg.getSpeedByRouteType(segment.road.getType());
            if (routeTravelSpeed == 0.0f) continue;
            TransportStop prevStop = segment.getStop(segment.segStart);
            List<TransportRouteSegment> sgms = new ArrayList<TransportRouteSegment>();
            if (TRACE_ONBOARD_ID != 0L && (id = ObfConstants.getOsmIdFromBinaryMapObjectId(segment.road.getId())) == TRACE_ONBOARD_ID) {
                System.out.printf("-> %d (%d) %.2f (parent %s) \n", id, segment.segStart, segment.distFromStart, segment.parentRoute);
            }
            for (int ind = 1 + segment.segStart; ind < segment.getLength(); ++ind) {
                double walkTime;
                if (ctx.calculationProgress != null && ctx.calculationProgress.isCancelled) {
                    return null;
                }
                ctx.visitedSegments.put(++segIdWithParent, (Object)segment);
                TransportStop stop = segment.getStop(ind);
                double segmentDist = MapUtils.getDistance(prevStop.getLocation(), stop.getLocation());
                travelDist += segmentDist;
                if (ctx.cfg.useSchedule) {
                    TransportSchedule sc = segment.road.getSchedule();
                    int interval = sc.avgStopIntervals.get(ind - 1);
                    travelTime += (double)(interval * 10);
                } else {
                    int stopTime = ctx.cfg.getStopTime(segment.road.getType());
                    travelTime += (double)stopTime + segmentDist / (double)routeTravelSpeed;
                }
                if (segment.distFromStart + travelTime > d * ctx.cfg.increaseForAlternativesRoutes) break;
                sgms.clear();
                if (segment.getDepth() < ctx.cfg.maxNumberOfChanges + 1) {
                    sgms = ctx.getTransportStops(stop.x31, stop.y31, true, sgms);
                    ++ctx.visitedStops;
                    for (TransportRouteSegment sgm : sgms) {
                        if (ctx.calculationProgress != null && ctx.calculationProgress.isCancelled) {
                            return null;
                        }
                        if (segment.wasVisited(sgm) || ctx.visitedSegments.containsKey(this.segmentWithParentId(sgm, segment))) continue;
                        TransportRouteSegment nextSegment = new TransportRouteSegment(sgm);
                        nextSegment.parentRoute = segment;
                        nextSegment.parentStop = ind;
                        nextSegment.walkDist = MapUtils.getDistance(nextSegment.getLocation(), stop.getLocation());
                        nextSegment.parentTravelTime = travelTime;
                        nextSegment.parentTravelDist = travelDist;
                        walkTime = nextSegment.walkDist / (double)ctx.cfg.walkSpeed + (double)ctx.cfg.getChangeTime(segment.road.getType(), sgm.road.getType());
                        nextSegment.distFromStart = segment.distFromStart + travelTime + walkTime;
                        ++nonce;
                        nextSegment.nonce = nextSegment.nonce;
                        if (ctx.cfg.useSchedule) {
                            int tm = (sgm.departureTime - ctx.cfg.scheduleTimeOfDay) * 10;
                            if ((double)tm >= nextSegment.distFromStart) {
                                nextSegment.distFromStart = tm;
                                queue.add(nextSegment);
                            }
                        } else {
                            queue.add(nextSegment);
                        }
                        if (TRACE_CHANGE_ID == 0L) continue;
                        long from = ObfConstants.getOsmIdFromBinaryMapObjectId(segment.road.getId());
                        long to = ObfConstants.getOsmIdFromBinaryMapObjectId(sgm.road.getId());
                        System.out.printf("? Change %d (%d) -> %d (%d) %.3f\n", from, ind, to, sgm.segStart, nextSegment.distFromStart);
                    }
                }
                TransportRouteSegment finalSegment = (TransportRouteSegment)endSegments.get(segment.getId() + (long)ind - (long)segment.segStart);
                double distToEnd = MapUtils.getDistance(stop.getLocation(), end);
                if (finalSegment != null && distToEnd < (double)ctx.cfg.walkRadius && (finish == null || minDist > distToEnd)) {
                    minDist = distToEnd;
                    finish = new TransportRouteSegment(finalSegment);
                    finish.parentRoute = segment;
                    finish.parentStop = ind;
                    finish.walkDist = distToEnd;
                    finish.parentTravelTime = travelTime;
                    finish.parentTravelDist = travelDist;
                    walkTime = distToEnd / (double)ctx.cfg.walkSpeed;
                    finish.distFromStart = segment.distFromStart + travelTime + walkTime;
                    ++nonce;
                    finish.nonce = finish.nonce;
                }
                prevStop = stop;
            }
            if (finish != null) {
                if (d > finish.distFromStart) {
                    d = finish.distFromStart;
                }
                if (finish.distFromStart < d * ctx.cfg.increaseForAlternativesRoutes && (finish.distFromStart < maxTravelTimeCmpToWalk || results.size() == 0)) {
                    results.add(finish);
                    int optimalLimitOfResults = 25 * ctx.cfg.ptLimitResultsByNumber * ctx.cfg.maxNumberOfChanges;
                    if (results.size() > Math.min(Math.max(1000, optimalLimitOfResults), 5000)) break;
                }
            }
            if (ctx.calculationProgress != null && ctx.calculationProgress.isCancelled) {
                throw new InterruptedException("Route calculation interrupted");
            }
            this.updateCalculationProgress(ctx, queue);
        }
        return this.prepareResults(ctx, results);
    }

    private long segmentWithParentId(TransportRouteSegment segment, TransportRouteSegment parent) {
        return ((parent != null ? ObfConstants.getOsmIdFromBinaryMapObjectId(parent.road.getId()) : 0L) << 30) + segment.getId();
    }

    private void initProgressBar(TransportRoutingContext ctx, LatLon start, LatLon end) {
        if (ctx.calculationProgress != null) {
            ctx.calculationProgress.distanceFromEnd = 0.0f;
            ctx.calculationProgress.reverseSegmentQueueSize = 0;
            ctx.calculationProgress.directSegmentQueueSize = 0;
            float speed = ctx.cfg.defaultTravelSpeed + 1.0f;
            ctx.calculationProgress.totalEstimatedDistance = (float)(MapUtils.getDistance(start, end) / (double)speed);
        }
    }

    private void updateCalculationProgress(TransportRoutingContext ctx, PriorityQueue<TransportRouteSegment> queue) {
        if (ctx.calculationProgress != null) {
            ctx.calculationProgress.directSegmentQueueSize = queue.size();
            if (queue.size() > 0) {
                TransportRouteSegment peek = queue.peek();
                ctx.calculationProgress.distanceFromBegin = (float)Math.max(peek.distFromStart, (double)ctx.calculationProgress.distanceFromBegin);
            }
        }
    }

    private List<TransportRouteResult> prepareResults(TransportRoutingContext ctx, List<TransportRouteSegment> results) {
        Collections.sort(results, new SegmentsComparator());
        ArrayList<TransportRouteResult> lst = new ArrayList<TransportRouteResult>();
        System.out.println(String.format(Locale.US, "Calculated %.1f seconds, found %d results, visited %d routes / %d stops, loaded %d tiles (%d ms read, %d ms total), loaded ways %d (%d wrong)", (double)(System.currentTimeMillis() - ctx.startCalcTime) / 1000.0, results.size(), ctx.visitedRoutesCount, ctx.visitedStops, ctx.quadTree.size(), ctx.readTime / 1000000L, ctx.loadTime / 1000000L, ctx.loadedWays, ctx.wrongLoadedWays));
        for (TransportRouteSegment res : results) {
            if (ctx.calculationProgress != null && ctx.calculationProgress.isCancelled) {
                return null;
            }
            TransportRouteResult route = new TransportRouteResult(ctx);
            route.routeTime = res.distFromStart;
            route.finishWalkDist = res.walkDist;
            TransportRouteSegment p = res;
            while (p != null) {
                if (ctx.calculationProgress != null && ctx.calculationProgress.isCancelled) {
                    return null;
                }
                if (p.parentRoute != null) {
                    TransportRouteResultSegment sg = new TransportRouteResultSegment();
                    sg.route = p.parentRoute.road;
                    sg.start = p.parentRoute.segStart;
                    sg.end = p.parentStop;
                    sg.walkDist = p.parentRoute.walkDist;
                    sg.walkTime = sg.walkDist / (double)ctx.cfg.walkSpeed;
                    sg.depTime = p.departureTime;
                    sg.travelDistApproximate = p.parentTravelDist;
                    sg.travelTime = p.parentTravelTime;
                    route.segments.add(0, sg);
                }
                p = p.parentRoute;
            }
            boolean exclude = false;
            for (TransportRouteResult s : lst) {
                if (ctx.calculationProgress != null && ctx.calculationProgress.isCancelled) {
                    return null;
                }
                if (!this.excludeRoute(ctx, s, route)) continue;
                exclude = true;
                break;
            }
            if (!exclude) {
                for (TransportRouteResult s : lst) {
                    if (ctx.calculationProgress != null && ctx.calculationProgress.isCancelled) {
                        return null;
                    }
                    if (!this.checkAlternative(ctx, s, route)) continue;
                    System.out.println("ALT " + String.valueOf(s.getSegments().get((int)0).route) + " " + route.toString());
                    exclude = true;
                    break;
                }
            }
            if (exclude) continue;
            int limitByNumber = ctx.cfg.ptLimitResultsByNumber;
            if (limitByNumber > 0 && lst.size() >= limitByNumber) {
                System.out.printf("ptLimitResultsByNumber (%d) reached\n", limitByNumber);
                break;
            }
            System.out.println(route);
            lst.add(route);
        }
        for (TransportRouteResult r : lst) {
            for (int i = 0; i < r.getSegments().size(); ++i) {
                String mainRef = r.getSegments().get((int)i).route.getRef();
                LinkedHashMap<String, TransportRouteResultSegment> alts = new LinkedHashMap<String, TransportRouteResultSegment>();
                for (TransportRouteResult alt : r.alternativeRoutes) {
                    TransportRouteResultSegment rs = alt.getSegments().get(i);
                    String altRef = rs.route.getRef();
                    if (Algorithms.isEmpty(altRef) || altRef.equals(mainRef)) continue;
                    alts.putIfAbsent(altRef, rs);
                }
                r.getSegments().get((int)i).alternatives.addAll(alts.values());
            }
        }
        return lst;
    }

    private boolean excludeRoute(TransportRoutingContext ctx, TransportRouteResult fastRoute, TransportRouteResult testRoute) {
        if (this.sameRouteWithExtraSegments(fastRoute, testRoute)) {
            return true;
        }
        double fastRouteWalkDist = Math.max(fastRoute.getWalkDist(), (double)ctx.cfg.combineAltRoutesDiffStops * ctx.cfg.increaseForAltRoutesWalking);
        if (fastRouteWalkDist * ctx.cfg.increaseForAltRoutesWalking < testRoute.getWalkDist()) {
            return true;
        }
        for (TransportRouteResult alt : fastRoute.getAlternativeRoutes()) {
            if (!this.sameRouteWithExtraSegments(alt, testRoute)) continue;
            return true;
        }
        return false;
    }

    private boolean checkAlternative(TransportRoutingContext ctx, TransportRouteResult fastRoute, TransportRouteResult testRoute) {
        boolean alternativeRoute = false;
        if (testRoute.segments.size() == fastRoute.segments.size()) {
            double sumDiffs = 0.0;
            alternativeRoute = true;
            for (int i = 0; i < fastRoute.segments.size(); ++i) {
                TransportRouteResultSegment seg1 = fastRoute.segments.get(i);
                TransportRouteResultSegment seg2 = testRoute.segments.get(i);
                double startDiff = MapUtils.getDistance(seg1.getStart().getLocation(), seg2.getStart().getLocation());
                double endDiff = MapUtils.getDistance(seg1.getEnd().getLocation(), seg2.getEnd().getLocation());
                sumDiffs += startDiff;
                sumDiffs += endDiff;
                if (!(startDiff > (double)ctx.cfg.combineAltRoutesDiffStops) && !(endDiff > (double)ctx.cfg.combineAltRoutesDiffStops)) continue;
                alternativeRoute = false;
                break;
            }
            if (alternativeRoute && sumDiffs < (double)ctx.cfg.combineAltRoutesSumDiffStops) {
                fastRoute.alternativeRoutes.add(testRoute);
            }
        }
        return alternativeRoute;
    }

    private boolean sameRouteWithExtraSegments(TransportRouteResult fastRoute, TransportRouteResult testRoute) {
        if (testRoute.segments.size() < fastRoute.segments.size()) {
            return false;
        }
        int j = 0;
        boolean sameRouteWithExtraSegments = true;
        int i = 0;
        while (i < fastRoute.segments.size()) {
            TransportRouteResultSegment fs = fastRoute.segments.get(i);
            while (j < testRoute.segments.size()) {
                TransportRouteResultSegment ts = testRoute.segments.get(j);
                if (fs.route.getId().longValue() == ts.route.getId().longValue()) break;
                ++j;
            }
            if (j >= testRoute.segments.size()) {
                sameRouteWithExtraSegments = false;
                break;
            }
            ++i;
            ++j;
        }
        return sameRouteWithExtraSegments;
    }

    public static String formatTransportTime(int i) {
        int h = i / 60 / 6;
        int mh = i - h * 60 * 6;
        int m = mh / 6;
        int s = (mh - m * 6) * 10;
        return String.format(Locale.US, "%02d:%02d:%02d ", h, m, s);
    }

    public static List<TransportRouteResult> convertToTransportRoutingResult(NativeTransportRoutingResult[] res, TransportRoutingConfiguration cfg) {
        TLongObjectHashMap convertedRoutesCache = new TLongObjectHashMap();
        TLongObjectHashMap convertedStopsCache = new TLongObjectHashMap();
        if (res.length == 0) {
            LOG.info((Object)"Public transport. No route found");
            return new ArrayList<TransportRouteResult>();
        }
        ArrayList<TransportRouteResult> convertedRes = new ArrayList<TransportRouteResult>();
        for (NativeTransportRoutingResult ntrr : res) {
            TransportRouteResult trr = new TransportRouteResult(cfg);
            trr.setFinishWalkDist(ntrr.finishWalkDist);
            trr.setRouteTime(ntrr.routeTime);
            trr.getSegments().addAll(TransportRoutePlanner.convertToTransportRouteResultSegment(ntrr.segments, (TLongObjectHashMap<TransportRoute>)convertedRoutesCache, (TLongObjectHashMap<TransportStop>)convertedStopsCache));
            if (ntrr.alternativeRoutes != null && ntrr.alternativeRoutes.length > 0) {
                trr.alternativeRoutes = TransportRoutePlanner.convertToTransportRoutingResult(ntrr.alternativeRoutes, cfg);
            }
            convertedRes.add(trr);
        }
        convertedStopsCache.clear();
        convertedRoutesCache.clear();
        return convertedRes;
    }

    private static List<TransportRouteResultSegment> convertToTransportRouteResultSegment(NativeTransportRouteResultSegment[] nativeSegments, TLongObjectHashMap<TransportRoute> convertedRoutesCache, TLongObjectHashMap<TransportStop> convertedStopsCache) {
        ArrayList<TransportRouteResultSegment> results = new ArrayList<TransportRouteResultSegment>();
        if (nativeSegments != null) {
            for (NativeTransportRouteResultSegment ntrs : nativeSegments) {
                TransportRouteResultSegment trs = new TransportRouteResultSegment();
                trs.route = TransportRoutePlanner.convertTransportRoute(ntrs.route, convertedRoutesCache, convertedStopsCache);
                trs.walkTime = ntrs.walkTime;
                trs.travelDistApproximate = ntrs.travelDistApproximate;
                trs.travelTime = ntrs.travelTime;
                trs.start = ntrs.start;
                trs.end = ntrs.end;
                trs.walkDist = ntrs.walkDist;
                trs.depTime = ntrs.depTime;
                if (ntrs.alternatives != null && ntrs.alternatives.length > 0) {
                    trs.alternatives = TransportRoutePlanner.convertToTransportRouteResultSegment(ntrs.alternatives, convertedRoutesCache, convertedStopsCache);
                }
                results.add(trs);
            }
        }
        return results;
    }

    private static TransportRoute convertTransportRoute(NativeTransportRoute nr, TLongObjectHashMap<TransportRoute> convertedRoutesCache, TLongObjectHashMap<TransportStop> convertedStopsCache) {
        int i;
        TransportRoute r = new TransportRoute();
        r.setId(nr.id);
        r.setLocation(nr.routeLat, nr.routeLon);
        r.setName(nr.name);
        r.setEnName(nr.enName);
        if (nr.namesLng.length > 0 && nr.namesLng.length == nr.namesNames.length) {
            for (i = 0; i < nr.namesLng.length; ++i) {
                r.setName(nr.namesLng[i], nr.namesNames[i]);
            }
        }
        r.setFileOffset(nr.fileOffset);
        r.setForwardStops(TransportRoutePlanner.convertTransportStops(nr.forwardStops, convertedStopsCache));
        r.setRef(nr.ref);
        r.setOperator(nr.routeOperator);
        r.setType(nr.type);
        r.setDist(nr.dist);
        r.setColor(nr.color);
        if (nr.intervals != null && nr.intervals.length > 0 && nr.avgStopIntervals != null && nr.avgStopIntervals.length > 0 && nr.avgWaitIntervals != null && nr.avgWaitIntervals.length > 0) {
            r.setSchedule(new TransportSchedule(new TIntArrayList(nr.intervals), new TIntArrayList(nr.avgStopIntervals), new TIntArrayList(nr.avgWaitIntervals)));
        }
        for (i = 0; i < nr.waysIds.length; ++i) {
            ArrayList<Node> wnodes = new ArrayList<Node>();
            for (int j = 0; j < nr.waysNodesLats[i].length; ++j) {
                wnodes.add(new Node(nr.waysNodesLats[i][j], nr.waysNodesLons[i][j], -1L));
            }
            r.addWay(new Way(nr.waysIds[i], wnodes));
        }
        if (convertedRoutesCache.get(r.getId().longValue()) == null) {
            convertedRoutesCache.put(r.getId().longValue(), (Object)r);
        }
        return r;
    }

    private static List<TransportStop> convertTransportStops(NativeTransportStop[] nstops, TLongObjectHashMap<TransportStop> convertedStopsCache) {
        ArrayList<TransportStop> stops = new ArrayList<TransportStop>();
        for (NativeTransportStop ns : nstops) {
            int i;
            if (convertedStopsCache != null && convertedStopsCache.get(ns.id) != null) {
                stops.add((TransportStop)convertedStopsCache.get(ns.id));
                continue;
            }
            TransportStop s = new TransportStop();
            s.setId(ns.id);
            s.setLocation(ns.stopLat, ns.stopLon);
            s.setName(ns.name);
            s.setEnName(ns.enName);
            if (ns.namesLng.length > 0 && ns.namesLng.length == ns.namesNames.length) {
                for (i = 0; i < ns.namesLng.length; ++i) {
                    s.setName(ns.namesLng[i], ns.namesNames[i]);
                }
            }
            s.setFileOffset(ns.fileOffset);
            if (ns.referencesToRoutes != null) {
                long[] r = new long[ns.referencesToRoutes.length];
                for (int k = 0; k < r.length; ++k) {
                    r[k] = ns.referencesToRoutes[k];
                }
                s.setReferencesToRoutes(r);
            }
            s.setDeletedRoutesIds(ns.deletedRoutesIds);
            s.setRoutesIds(ns.routesIds);
            s.distance = ns.distance;
            s.x31 = ns.x31;
            s.y31 = ns.y31;
            if (ns.pTStopExit_refs != null && ns.pTStopExit_refs.length > 0) {
                for (i = 0; i < ns.pTStopExit_refs.length; ++i) {
                    s.addExit(new TransportStopExit(ns.pTStopExit_x31s[i], ns.pTStopExit_y31s[i], ns.pTStopExit_refs[i]));
                }
            }
            if (convertedStopsCache == null) {
                convertedStopsCache = new TLongObjectHashMap();
            }
            if (convertedStopsCache.get(s.getId().longValue()) == null) {
                convertedStopsCache.put(s.getId().longValue(), (Object)s);
            }
            stops.add(s);
        }
        return stops;
    }

    public static class TransportRouteSegment {
        long nonce;
        final int segStart;
        final TransportRoute road;
        final int departureTime;
        private static final int SHIFT = 10;
        private static final int SHIFT_DEPTIME = 14;
        TransportRouteSegment parentRoute = null;
        int parentStop;
        double parentTravelTime;
        double parentTravelDist;
        double walkDist = 0.0;
        double distFromStart = 0.0;

        public TransportRouteSegment(TransportRoute road, int stopIndex) {
            this.road = road;
            this.segStart = (short)stopIndex;
            this.departureTime = -1;
        }

        public TransportRouteSegment(TransportRoute road, int stopIndex, int depTime) {
            this.road = road;
            this.segStart = (short)stopIndex;
            this.departureTime = depTime;
        }

        public TransportRouteSegment(TransportRouteSegment c) {
            this.road = c.road;
            this.segStart = c.segStart;
            this.departureTime = c.departureTime;
        }

        public boolean wasVisited(TransportRouteSegment rrs) {
            if (rrs.road.getId().longValue() == this.road.getId().longValue() && rrs.departureTime == this.departureTime) {
                return true;
            }
            if (this.parentRoute != null) {
                return this.parentRoute.wasVisited(rrs);
            }
            return false;
        }

        public TransportStop getStop(int i) {
            return this.road.getForwardStops().get(i);
        }

        public LatLon getLocation() {
            return this.road.getForwardStops().get(this.segStart).getLocation();
        }

        public int getLength() {
            return this.road.getForwardStops().size();
        }

        public long getId() {
            long l = this.road.getId();
            l <<= 14;
            if (this.departureTime >= 16384) {
                throw new IllegalStateException("too long dep time" + this.departureTime);
            }
            l += (long)(this.departureTime + 1);
            l <<= 10;
            if (this.segStart >= 1024) {
                throw new IllegalStateException("too many stops " + this.road.getId() + " " + this.segStart);
            }
            if ((l += (long)this.segStart) < 0L) {
                throw new IllegalStateException("too long id " + this.road.getId());
            }
            return l;
        }

        public int getDepth() {
            if (this.parentRoute != null) {
                return this.parentRoute.getDepth() + 1;
            }
            return 1;
        }

        public String toString() {
            return String.format("Route: %s, stop: %s %s", this.road.getName(), this.road.getForwardStops().get(this.segStart).getName(), this.departureTime == -1 ? "" : TransportRoutePlanner.formatTransportTime(this.departureTime));
        }
    }

    private static class SegmentsComparator
    implements Comparator<TransportRouteSegment> {
        @Override
        public int compare(TransportRouteSegment o1, TransportRouteSegment o2) {
            int cmpDist = Double.compare(o1.distFromStart, o2.distFromStart);
            return cmpDist == 0 ? Long.compare(o1.getId() + o1.nonce, o2.getId() + o2.nonce) : cmpDist;
        }
    }

    public static class TransportRouteResultSegment {
        private static final boolean DISPLAY_FULL_SEGMENT_ROUTE = false;
        private static final int DISPLAY_SEGMENT_IND = 0;
        public TransportRoute route;
        public double walkTime;
        public double travelDistApproximate;
        public double travelTime;
        public int start;
        public int end;
        public double walkDist;
        public int depTime;
        public List<TransportRouteResultSegment> alternatives = new ArrayList<TransportRouteResultSegment>();

        public int getArrivalTime() {
            if (this.route.getSchedule() != null && this.depTime != -1) {
                int tm = this.depTime;
                TIntArrayList intervals = this.route.getSchedule().avgStopIntervals;
                for (int i = this.start; i <= this.end; ++i) {
                    if (i == this.end) {
                        return tm;
                    }
                    if (intervals.size() <= i) break;
                    tm += intervals.get(i);
                }
            }
            return -1;
        }

        public double getTravelTime() {
            return this.travelTime;
        }

        public TransportStop getStart() {
            return this.route.getForwardStops().get(this.start);
        }

        public TransportStop getEnd() {
            return this.route.getForwardStops().get(this.end);
        }

        public List<TransportStop> getTravelStops() {
            return this.route.getForwardStops().subList(this.start, this.end + 1);
        }

        public QuadRect getSegmentRect() {
            double left = 0.0;
            double right = 0.0;
            double top = 0.0;
            double bottom = 0.0;
            for (Node n : this.getNodes()) {
                if (left == 0.0 && right == 0.0) {
                    left = n.getLongitude();
                    right = n.getLongitude();
                    top = n.getLatitude();
                    bottom = n.getLatitude();
                    continue;
                }
                left = Math.min(left, n.getLongitude());
                right = Math.max(right, n.getLongitude());
                top = Math.max(top, n.getLatitude());
                bottom = Math.min(bottom, n.getLatitude());
            }
            return left == 0.0 && right == 0.0 ? null : new QuadRect(left, top, right, bottom);
        }

        public List<Node> getNodes() {
            ArrayList<Node> nodes = new ArrayList<Node>();
            List<Way> ways = this.getGeometry();
            for (Way way : ways) {
                nodes.addAll(way.getNodes());
            }
            return nodes;
        }

        public List<Way> getGeometry() {
            boolean validContinuation;
            boolean validOneWay;
            this.route.mergeForwardWays();
            List<Way> ways = this.route.getForwardWays();
            LatLon startLoc = this.getStart().getLocation();
            LatLon endLoc = this.getEnd().getLocation();
            SearchNodeInd startInd = new SearchNodeInd();
            SearchNodeInd endInd = new SearchNodeInd();
            for (int i = 0; i < ways.size(); ++i) {
                List<Node> nodes = ways.get(i).getNodes();
                for (int j = 0; j < nodes.size(); ++j) {
                    Node n = nodes.get(j);
                    if (MapUtils.getDistance(startLoc, n.getLatitude(), n.getLongitude()) < startInd.dist) {
                        startInd.dist = MapUtils.getDistance(startLoc, n.getLatitude(), n.getLongitude());
                        startInd.ind = j;
                        startInd.way = ways.get(i);
                    }
                    if (!(MapUtils.getDistance(endLoc, n.getLatitude(), n.getLongitude()) < endInd.dist)) continue;
                    endInd.dist = MapUtils.getDistance(endLoc, n.getLatitude(), n.getLongitude());
                    endInd.ind = j;
                    endInd.way = ways.get(i);
                }
            }
            boolean bl = validOneWay = startInd.way != null && startInd.way == endInd.way && startInd.ind <= endInd.ind;
            if (validOneWay) {
                Way way = new Way(-1L);
                for (int k = startInd.ind; k <= endInd.ind; ++k) {
                    way.addNode(startInd.way.getNodes().get(k));
                }
                return Collections.singletonList(way);
            }
            boolean bl2 = validContinuation = startInd.way != null && endInd.way != null && startInd.way != endInd.way;
            if (validContinuation) {
                Node ln = startInd.way.getLastNode();
                Node fn = endInd.way.getFirstNode();
                validContinuation = ln != null && fn != null && MapUtils.getDistance(ln.getLatLon(), fn.getLatLon()) < 50000.0;
            }
            if (validContinuation) {
                int k;
                ArrayList<Way> two = new ArrayList<Way>();
                Way way = new Way(-1L);
                for (k = startInd.ind; k < startInd.way.getNodes().size(); ++k) {
                    way.addNode(startInd.way.getNodes().get(k));
                }
                two.add(way);
                way = new Way(-1L);
                for (k = 0; k <= endInd.ind; ++k) {
                    way.addNode(endInd.way.getNodes().get(k));
                }
                two.add(way);
                return two;
            }
            Way way = new Way(-2L);
            for (int i = this.start; i <= this.end; ++i) {
                LatLon l = this.getStop(i).getLocation();
                Node n = new Node(l.getLatitude(), l.getLongitude(), -1L);
                way.addNode(n);
            }
            return Collections.singletonList(way);
        }

        public double getTravelDist() {
            double d = 0.0;
            for (int k = this.start; k < this.end; ++k) {
                d += MapUtils.getDistance(this.route.getForwardStops().get(k).getLocation(), this.route.getForwardStops().get(k + 1).getLocation());
            }
            return d;
        }

        public TransportStop getStop(int i) {
            return this.route.getForwardStops().get(i);
        }

        private static class SearchNodeInd {
            int ind = -1;
            Way way = null;
            double dist = 150.0;

            private SearchNodeInd() {
            }
        }
    }
}

